/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateAddInterval$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0015+\u0001^B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002C2\u0001\u0005#\u0005\u000b\u0011B+\t\u0011\u0011\u0004!Q3A\u0005\u0002\u0015D\u0001\"\u001b\u0001\u0003\u0012\u0003\u0006IA\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006c\u0002!\t\u0005\u0014\u0005\u0006e\u0002!\t\u0005\u0014\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006_\u0001!\t%\u001e\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\tI\u0002\u0001C!\u00037Aq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002F\u0001!\t%a\u0012\t\u0013\u0005-\u0003!!A\u0005\u0002\u00055\u0003\"CA,\u0001E\u0005I\u0011AA-\u0011%\ty\u0007AI\u0001\n\u0003\tI\u0006C\u0005\u0002r\u0001\t\n\u0011\"\u0001\u0002t!I\u0011q\u000f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003{\u0002\u0011\u0011!C!\u0003\u007fB\u0011\"a$\u0001\u0003\u0003%\t!!%\t\u0013\u0005e\u0005!!A\u0005\u0002\u0005m\u0005\"CAQ\u0001\u0005\u0005I\u0011IAR\u0011%\t\t\fAA\u0001\n\u0003\t\u0019\fC\u0005\u00028\u0002\t\t\u0011\"\u0011\u0002:\u001eI\u0011Q\u0018\u0016\u0002\u0002#\u0005\u0011q\u0018\u0004\tS)\n\t\u0011#\u0001\u0002B\"1!n\bC\u0001\u0003\u001fD\u0001b]\u0010\u0002\u0002\u0013\u0015\u0013\u0011\u001b\u0005\n\u0003'|\u0012\u0011!CA\u0003+D\u0011\"a8 #\u0003%\t!a\u001d\t\u0013\u0005\u0005x$%A\u0005\u0002\u0005e\u0004\"CAr?\u0005\u0005I\u0011QAs\u0011%\t\u0019pHI\u0001\n\u0003\t\u0019\bC\u0005\u0002v~\t\n\u0011\"\u0001\u0002z!I\u0011q_\u0010\u0002\u0002\u0013%\u0011\u0011 \u0002\u0010\t\u0006$X-\u00113e\u0013:$XM\u001d<bY*\u00111\u0006L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002.]\u0005A1-\u0019;bYf\u001cHO\u0003\u00020a\u0005\u00191/\u001d7\u000b\u0005E\u0012\u0014!B:qCJ\\'BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001qqz$\t\u0013\t\u0003sij\u0011AK\u0005\u0003w)\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ej\u0014B\u0001 +\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003s\u0001K!!\u0011\u0016\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0007&K!A\u0013#\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bM$\u0018M\u001d;\u0016\u00035\u0003\"!\u000f(\n\u0005=S#AC#yaJ,7o]5p]\u000611\u000f^1si\u0002\n\u0001\"\u001b8uKJ4\u0018\r\\\u0001\nS:$XM\u001d<bY\u0002\n!\u0002^5nKj{g.Z%e+\u0005)\u0006cA\"W1&\u0011q\u000b\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005e\u0003gB\u0001._!\tYF)D\u0001]\u0015\tif'\u0001\u0004=e>|GOP\u0005\u0003?\u0012\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q\fR\u0001\fi&lWMW8oK&#\u0007%A\u0006b]NLWI\\1cY\u0016$W#\u00014\u0011\u0005\r;\u0017B\u00015E\u0005\u001d\u0011un\u001c7fC:\fA\"\u00198tS\u0016s\u0017M\u00197fI\u0002\na\u0001P5oSRtD#\u00027n]>\u0004\bCA\u001d\u0001\u0011\u0015Y\u0015\u00021\u0001N\u0011\u0015\t\u0016\u00021\u0001N\u0011\u001d\u0019\u0016\u0002%AA\u0002UCq\u0001Z\u0005\u0011\u0002\u0003\u0007a-\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003a+\u0012\u0001W\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001=\u0011\tet\u00181\u0001\b\u0003urt!aW>\n\u0003\u0015K!! #\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0007M+\u0017O\u0003\u0002~\tB!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n9\nQ\u0001^=qKNLA!!\u0004\u0002\b\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\u0003\t\u0005\u0003\u000b\t)\"\u0003\u0003\u0002\u0018\u0005\u001d!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005u\u00111EA\u0013!\r\u0019\u0015qD\u0005\u0004\u0003C!%aA!os\"11\n\u0005a\u0001\u0003;Aa!\u0015\tA\u0002\u0005u\u0011!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tY#a\u000e\u0002BA!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022)\nqaY8eK\u001e,g.\u0003\u0003\u00026\u0005=\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005e\u0012\u00031\u0001\u0002<\u0005\u00191\r\u001e=\u0011\t\u00055\u0012QH\u0005\u0005\u0003\u007f\tyC\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\r\u0013\u00031\u0001\u0002,\u0005\u0011QM^\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004\u007f\u0005%\u0003\"B*\u0013\u0001\u0004A\u0016\u0001B2paf$\u0012\u0002\\A(\u0003#\n\u0019&!\u0016\t\u000f-\u001b\u0002\u0013!a\u0001\u001b\"9\u0011k\u0005I\u0001\u0002\u0004i\u0005bB*\u0014!\u0003\u0005\r!\u0016\u0005\bIN\u0001\n\u00111\u0001g\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0017+\u00075\u000bif\u000b\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!C;oG\",7m[3e\u0015\r\tI\u0007R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002v)\u001aQ+!\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0010\u0016\u0004M\u0006u\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015\u0001\u00027b]\u001eT!!a#\u0002\t)\fg/Y\u0005\u0004C\u0006\u0015\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAJ!\r\u0019\u0015QS\u0005\u0004\u0003/#%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000f\u0003;C\u0011\"a(\u001b\u0003\u0003\u0005\r!a%\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u000b\u0005\u0004\u0002(\u00065\u0016QD\u0007\u0003\u0003SS1!a+E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000bIK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u00026\"I\u0011q\u0014\u000f\u0002\u0002\u0003\u0007\u0011QD\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0019\fY\fC\u0005\u0002 v\t\t\u00111\u0001\u0002\u001e\u0005yA)\u0019;f\u0003\u0012$\u0017J\u001c;feZ\fG\u000e\u0005\u0002:?M!q$a1I!%\t)-a3N\u001bV3G.\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a#\u0002\u000fI,h\u000e^5nK&!\u0011QZAd\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0003\u007f#\"!!!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00131\f9.!7\u0002\\\u0006u\u0007\"B&#\u0001\u0004i\u0005\"B)#\u0001\u0004i\u0005bB*#!\u0003\u0005\r!\u0016\u0005\bI\n\u0002\n\u00111\u0001g\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u0011q]Ax!\u0011\u0019e+!;\u0011\u000f\r\u000bY/T'VM&\u0019\u0011Q\u001e#\u0003\rQ+\b\u000f\\35\u0011!\t\t0JA\u0001\u0002\u0004a\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a?\u0011\t\u0005\r\u0015Q`\u0005\u0005\u0003\u007f\f)I\u0001\u0004PE*,7\r\u001e")
public class DateAddInterval
extends BinaryExpression
implements ExpectsInputTypes,
TimeZoneAwareExpression,
scala.Serializable {
    private final Expression start;
    private final Expression interval;
    private final Option<String> timeZoneId;
    private final boolean ansiEnabled;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$4() {
        return DateAddInterval$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return DateAddInterval$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(DateAddInterval dateAddInterval) {
        return DateAddInterval$.MODULE$.unapply(dateAddInterval);
    }

    public static boolean apply$default$4() {
        return DateAddInterval$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return DateAddInterval$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, DateAddInterval> tupled() {
        return DateAddInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, DateAddInterval>>>> curried() {
        return DateAddInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        DateAddInterval dateAddInterval = this;
        synchronized (dateAddInterval) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        DateAddInterval dateAddInterval = this;
        synchronized (dateAddInterval) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression start() {
        return this.start;
    }

    public Expression interval() {
        return this.interval;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean ansiEnabled() {
        return this.ansiEnabled;
    }

    @Override
    public Expression left() {
        return this.start();
    }

    @Override
    public Expression right() {
        return this.interval();
    }

    @Override
    public String toString() {
        return new StringBuilder(3).append(this.left()).append(" + ").append(this.right()).toString();
    }

    @Override
    public String sql() {
        return new StringBuilder(3).append(this.left().sql()).append(" + ").append(this.right().sql()).toString();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DateType$.MODULE$, CalendarIntervalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object start, Object interval) {
        Integer n;
        CalendarInterval itvl = (CalendarInterval)interval;
        if (this.ansiEnabled() || itvl.microseconds == 0L) {
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(BoxesRunTime.unboxToInt((Object)start), itvl));
        } else {
            long startTs = DateTimeUtils$.MODULE$.epochDaysToMicros(BoxesRunTime.unboxToInt((Object)start), this.zoneId());
            long resultTs = DateTimeUtils$.MODULE$.timestampAddInterval(startTs, itvl.months, itvl.days, itvl.microseconds, this.zoneId());
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToEpochDays(resultTs, this.zoneId()));
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, i) -> {
            String string;
            if (this.ansiEnabled()) {
                string = new StringBuilder(24).append(ev.value()).append(" = ").append(dtu).append(".dateAddInterval(").append((String)sd).append(", ").append((String)i).append(");").toString();
            } else {
                String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
                String startTs = ctx.freshName("startTs");
                String resultTs = ctx.freshName("resultTs");
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(290).append("\n         |if (").append((String)i).append(".microseconds == 0) {\n         |  ").append(ev.value()).append(" = ").append(dtu).append(".dateAddInterval(").append((String)sd).append(", ").append((String)i).append(");\n         |} else {\n         |  long ").append(startTs).append(" = ").append(dtu).append(".epochDaysToMicros(").append((String)sd).append(", ").append(zid).append(");\n         |  long ").append(resultTs).append(" =\n         |    ").append(dtu).append(".timestampAddInterval(").append(startTs).append(", ").append((String)i).append(".months, ").append((String)i).append(".days, ").append((String)i).append(".microseconds, ").append(zid).append(");\n         |  ").append(ev.value()).append(" = ").append(dtu).append(".microsToEpochDays(").append(resultTs).append(", ").append(zid).append(");\n         |}\n         |").toString())).stripMargin();
            }
            return string;
        });
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    public DateAddInterval copy(Expression start, Expression interval, Option<String> timeZoneId, boolean ansiEnabled) {
        return new DateAddInterval(start, interval, timeZoneId, ansiEnabled);
    }

    public Expression copy$default$1() {
        return this.start();
    }

    public Expression copy$default$2() {
        return this.interval();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.ansiEnabled();
    }

    @Override
    public String productPrefix() {
        return "DateAddInterval";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.start();
                break;
            }
            case 1: {
                object = this.interval();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ansiEnabled());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateAddInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateAddInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateAddInterval dateAddInterval = (DateAddInterval)x$1;
        Expression expression = this.start();
        Expression expression2 = dateAddInterval.start();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.interval();
        Expression expression4 = dateAddInterval.interval();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateAddInterval.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.ansiEnabled() != dateAddInterval.ansiEnabled()) return false;
        if (!dateAddInterval.canEqual(this)) return false;
        return true;
    }

    public DateAddInterval(Expression start, Expression interval, Option<String> timeZoneId, boolean ansiEnabled) {
        this.start = start;
        this.interval = interval;
        this.timeZoneId = timeZoneId;
        this.ansiEnabled = ansiEnabled;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }
}

