/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!B\u000e\u001d\u0001\tB\u0003\u0002C\u001b\u0001\u0005\u000b\u0007I\u0011A\u001c\t\u0011q\u0002!\u0011!Q\u0001\naB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\n\u0001B\u0001B\u0003%\u0001\u000bC\u0003e\u0001\u0011\u0005Q\rC\u0004l\u0001\t\u0007I\u0011\u00027\t\r=\u0004\u0001\u0015!\u0003n\u0011!\u0001\b\u0001#b\u0001\n\u0013\t\b\u0002C;\u0001\u0011\u000b\u0007I\u0011\u00027\t\u000fY\u0004\u0001\u0019!C\u0005Y\"9q\u000f\u0001a\u0001\n\u0013A\bB\u0002@\u0001A\u0003&Q\u000e\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAY\u0001\u0011%\u00111W\u0004\b\u0003oc\u0002\u0012BA]\r\u0019YB\u0004#\u0003\u0002<\"1Am\u0006C\u0001\u0003{C\u0011\"a0\u0018\u0005\u0004%\t!!1\t\u0011\u0005\rw\u0003)A\u0005\u0003W\u0013A$\u0012=fGV$xN\u001d)pINd\u0015NZ3ds\u000edW-T1oC\u001e,'O\u0003\u0002\u001e=\u0005\u00191\u000eO:\u000b\u0005}\u0001\u0013aB2mkN$XM\u001d\u0006\u0003C\t\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c2\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gM\u0007\u0002c)\u0011!GI\u0001\tS:$XM\u001d8bY&\u0011A'\r\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001U\t\u0001\b\u0005\u0002:u5\t!%\u0003\u0002<E\tI1\u000b]1sW\u000e{gNZ\u0001\u0006G>tg\rI\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\"a\u0010%\u000e\u0003\u0001S!!\u0011\"\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019E)\u0001\u0006lk\n,'O\\3uKNT!!\u0012$\u0002\u000f\u0019\f'M]5dq)\tq)\u0001\u0002j_&\u0011\u0011\n\u0011\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fab\u001d8baNDw\u000e^:Ti>\u0014X\r\u0005\u0002M\u001b6\tA$\u0003\u0002O9\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006)\"/Z7pm\u0016$W\t_3dkR|'o]\"bG\",\u0007\u0003B)[9rk\u0011A\u0015\u0006\u0003'R\u000bQaY1dQ\u0016T!!\u0016,\u0002\r\r|W.\\8o\u0015\t9\u0006,\u0001\u0004h_><G.\u001a\u0006\u00023\u0006\u00191m\\7\n\u0005m\u0013&!B\"bG\",\u0007CA/c\u001b\u0005q&BA0a\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0006M\u001eD\u0017N\u001b\t\u0003\u0019\u0002AQ!\u000e\u0004A\u0002aBQ!\u0010\u0004A\u0002yBQA\u0013\u0004A\u0002-CQa\u0014\u0004A\u0002A\u000bq#\u001a<f]R\u0004&o\\2fgNLgnZ%oi\u0016\u0014h/\u00197\u0016\u00035\u0004\"A\u000b8\n\u0005\r\\\u0013\u0001G3wK:$\bK]8dKN\u001c\u0018N\\4J]R,'O^1mA\u0005)2\u000f[8vY\u0012$U\r\\3uK\u0016CXmY;u_J\u001cX#\u0001:\u0011\u0005)\u001a\u0018B\u0001;,\u0005\u001d\u0011un\u001c7fC:\fQ#\\5tg&tw\rU8e\t\u0016$Xm\u0019;EK2$\u0018-\u0001\nmCN$h)\u001e7m':\f\u0007o\u001d5piR\u001b\u0018A\u00067bgR4U\u000f\u001c7T]\u0006\u00048\u000f[8u)N|F%Z9\u0015\u0005ed\bC\u0001\u0016{\u0013\tY8F\u0001\u0003V]&$\bbB?\r\u0003\u0003\u0005\r!\\\u0001\u0004q\u0012\n\u0014a\u00057bgR4U\u000f\u001c7T]\u0006\u00048\u000f[8u)N\u0004\u0013!B:uCJ$HcA=\u0002\u0004!9\u0011Q\u0001\bA\u0002\u0005\u001d\u0011\u0001E:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\ra\u0015\u0011B\u0005\u0004\u0003\u0017a\"!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017AD8o\u001d\u0016<8K\\1qg\"|Go\u001d\u000b\u0006s\u0006E\u00111\u0003\u0005\b\u0003\u000by\u0001\u0019AA\u0004\u0011\u001d\t)b\u0004a\u0001\u0003/\t\u0011b\u001d8baNDw\u000e^:\u0011\r\u0005e\u0011\u0011FA\u0018\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t7\u0003\u0019a$o\\8u}%\tA&C\u0002\u0002(-\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"aA*fc*\u0019\u0011qE\u0016\u0011\u00071\u000b\t$C\u0002\u00024q\u0011A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\u0018AF8o\r&t\u0017\r\u001c(p]\u0012+G.\u001a;fIN#\u0018\r^3\u0015\u0013e\fI$a\u0011\u0002H\u0005%\u0003bBA\u001e!\u0001\u0007\u0011QH\u0001\ta>$7\u000b^1uKB\u0019A*a\u0010\n\u0007\u0005\u0005CDA\u0007GS:\fG\u000eU8e'R\fG/\u001a\u0005\u0007\u0003\u000b\u0002\u0002\u0019A7\u0002\r\u0015DXmY%e\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000fAq!a\u0013\u0011\u0001\u0004\ti%A\u000bfq\u0016\u001c\u0017\nZ:SK6|g/\u001a3J]J{WO\u001c3\u0011\u000b\u0005=\u0013\u0011L7\u000e\u0005\u0005E#\u0002BA*\u0003+\nq!\\;uC\ndWMC\u0002\u0002X-\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY&!\u0015\u0003\u0007M+G/A\u000bsK6|g/Z#yK\u000e,Ho\u001c:Ge>l7\nO:\u0015\u0007e\f\t\u0007C\u0004\u0002dE\u0001\r!!\u001a\u0002\u0015U\u0004H-\u0019;fIB{G\r\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u000b5|G-\u001a7\u000b\u0007\u0005=$)A\u0002ba&LA!a\u001d\u0002j\t\u0019\u0001k\u001c3\u0002/I,Wn\u001c<f\u000bb,7-\u001e;pe\u001a\u0013x.\\*qCJ\\GcB=\u0002z\u0005m\u0014Q\u0010\u0005\b\u0003\u000b\u0011\u0002\u0019AA\u0004\u0011\u001d\tYD\u0005a\u0001\u0003{Aa!!\u0012\u0013\u0001\u0004i\u0017A\u00044j]\u0012,\u00050\u001b;SK\u0006\u001cxN\u001c\u000b\u0007\u0003\u0007\u000bY)!$\u0011\t\u0005\u0015\u0015qQ\u0007\u0002A%\u0019\u0011\u0011\u0012\u0011\u0003\u001d\u0015CXmY;u_J,\u00050\u001b;fI\"9\u00111H\nA\u0002\u0005u\u0002BBA#'\u0001\u0007Q.A\tfq&$(+Z1t_:lUm]:bO\u0016$\u0002\"a%\u0002$\u0006\u0015\u0016q\u0015\t\u0005\u0003+\u000biJ\u0004\u0003\u0002\u0018\u0006e\u0005cAA\u000fW%\u0019\u00111T\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\ty*!)\u0003\rM#(/\u001b8h\u0015\r\tYj\u000b\u0005\b\u0003w!\u0002\u0019AA\u001f\u0011\u0019\t)\u0005\u0006a\u0001[\"9\u0011\u0011\u0016\u000bA\u0002\u0005-\u0016\u0001C3ySR\u001cu\u000eZ3\u0011\u0007)\ni+C\u0002\u00020.\u00121!\u00138u\u000311\u0017N\u001c3Fq&$8i\u001c3f)\u0011\tY+!.\t\u000f\u0005mR\u00031\u0001\u0002>\u0005aR\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u0014\bC\u0001'\u0018'\t9\u0012\u0006\u0006\u0002\u0002:\u0006\tRKT&O\u001f^su,\u0012-J)~\u001bu\nR#\u0016\u0005\u0005-\u0016AE+O\u0017:{uKT0F1&#vlQ(E\u000b\u0002\u0002")
public class ExecutorPodsLifecycleManager
implements Logging {
    private boolean shouldDeleteExecutors;
    private long missingPodDetectDelta;
    private final SparkConf conf;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Cache<Long, Long> removedExecutorsCache;
    private final long eventProcessingInterval;
    private long lastFullSnapshotTs;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    private long eventProcessingInterval() {
        return this.eventProcessingInterval;
    }

    private boolean shouldDeleteExecutors$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldDeleteExecutors;
    }

    private boolean shouldDeleteExecutors() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldDeleteExecutors$lzycompute() : this.shouldDeleteExecutors;
    }

    private long missingPodDetectDelta$lzycompute() {
        ExecutorPodsLifecycleManager executorPodsLifecycleManager = this;
        synchronized (executorPodsLifecycleManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.missingPodDetectDelta = BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.missingPodDetectDelta;
    }

    private long missingPodDetectDelta() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.missingPodDetectDelta$lzycompute() : this.missingPodDetectDelta;
    }

    private long lastFullSnapshotTs() {
        return this.lastFullSnapshotTs;
    }

    private void lastFullSnapshotTs_$eq(long x$1) {
        this.lastFullSnapshotTs = x$1;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        this.snapshotsStore.addSubscriber(this.eventProcessingInterval(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        block0: {
            HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
            snapshots.foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$1(this, schedulerBackend, execIdsRemovedInThisRound, snapshot);
                return BoxedUnit.UNIT;
            });
            if (!snapshots.nonEmpty() || this.lastFullSnapshotTs() == ((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs()) break block0;
            this.lastFullSnapshotTs_$eq(((ExecutorPodsSnapshot)snapshots.last()).fullSnapshotTs());
            Map lostExecutorsWithRegistrationTs = (Map)((Subtractable)schedulerBackend.getExecutorsWithRegistrationTs().map((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcJJ.sp(new StringOps(Predef$.MODULE$.augmentString((String)t._1())).toLong(), t._2$mcJ$sp()), Map$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)((ExecutorPodsSnapshot)snapshots.last()).executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound);
            lostExecutorsWithRegistrationTs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsLifecycleManager.$anonfun$onNewSnapshots$8(this, schedulerBackend, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, Set<Object> execIdsRemovedInRound) {
        this.removeExecutorFromSpark(schedulerBackend, podState, execId);
        if (this.shouldDeleteExecutors()) {
            this.removeExecutorFromK8s(podState.pod());
        }
        execIdsRemovedInRound.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
    }

    private void removeExecutorFromK8s(Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)$this.kubernetesClient.pods().withName(updatedPod.getMetadata().getName())).delete());
    }

    private void removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        block0: {
            if (this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) != null) break block0;
            this.removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
        }
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(61).append("The executor with id ").append(execId).append(" was deleted by a user or the framework.").toString());
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean exitCausedByApp = tuple22._1$mcZ$sp();
        String exitMessage = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
        Tuple2 tuple24 = tuple23;
        boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
        String exitMessage2 = (String)tuple24._2();
        return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        Option reason = Option$.MODULE$.apply((Object)pod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)pod.getStatus().getMessage());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n       |The executor with id ").append(execId).append(" exited with exit code ").append(exitCode).append(".\n       |The API gave the following brief reason: ").append(reason.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following message: ").append(message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).append("\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(pod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable & scala.Serializable)containerStatus -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsLifecycleManager.$anonfun$findExitCode$1(containerStatus))).map((Function1 & Serializable & scala.Serializable)terminatedContainer -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE()));
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$1(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, HashSet execIdsRemovedInThisRound$1, ExecutorPodsSnapshot snapshot) {
        snapshot.executorPods().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                ExecutorPodState state = (ExecutorPodState)tuple2._2();
                ExecutorPodState executorPodState = state;
                if (executorPodState instanceof PodDeleted) {
                    PodDeleted podDeleted = (PodDeleted)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Snapshot reported deleted executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    $this.removeExecutorFromSpark(schedulerBackend$2, podDeleted, execId);
                    boxedUnit = execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                } else if (executorPodState instanceof PodFailed) {
                    PodFailed podFailed = (PodFailed)executorPodState;
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Snapshot reported failed executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).toString());
                    $this.onFinalNonDeletedState(podFailed, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (executorPodState instanceof PodSucceeded) {
                    PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                    if (schedulerBackend$2.isExecutorActive(((Object)BoxesRunTime.boxToLong((long)execId)).toString())) {
                        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Snapshot reported succeeded executor with id ").append(execId).append(", ").append("even though the application has not requested for it to be removed.").toString());
                    } else {
                        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Snapshot reported succeeded executor with id ").append(execId).append(",").append(" pod name ").append(state.pod().getMetadata().getName()).append(".").toString());
                    }
                    $this.onFinalNonDeletedState(podSucceeded, execId, schedulerBackend$2, (Set<Object>)execIdsRemovedInThisRound$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$8(ExecutorPodsLifecycleManager $this, KubernetesClusterSchedulerBackend schedulerBackend$2, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long lostExecId = tuple2._1$mcJ$sp();
            long lostExecRegistrationTs = tuple2._2$mcJ$sp();
            if ($this.removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)lostExecId)) == null && $this.lastFullSnapshotTs() - lostExecRegistrationTs > $this.missingPodDetectDelta()) {
                String exitReasonMessage = new StringBuilder(276).append("The executor with ID ").append(lostExecId).append(" (registered at ").append(lostExecRegistrationTs).append(" ms) was not found in the cluster at the polling time ").append("(").append($this.lastFullSnapshotTs()).append(" ms) which is after the accepted detect delta time ").append("(").append($this.missingPodDetectDelta()).append(" ms) configured by ").append("`").append(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA().key()).append("`. ").append("The executor may have been deleted but the driver missed the deletion event. ").append("Marking this executor as failed.").toString();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> exitReasonMessage);
                ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage);
                schedulerBackend$2.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)lostExecId)).toString(), (ExecutorLossReason)exitReason);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$findExitCode$1(ContainerStatus containerStatus) {
        return containerStatus.getState().getTerminated() != null;
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.conf = conf;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.removedExecutorsCache = removedExecutorsCache;
        Logging.$init$((Logging)this);
        this.eventProcessingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
        this.lastFullSnapshotTs = 0L;
    }
}

