/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5a!\u0002\u0016,\u0001E:\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011)\u0003!\u0011!Q\u0001\n-C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u001d!\bA1A\u0005\nUDq!a\u0001\u0001A\u0003%a\u000fC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011q\u0002\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111\u0004\u0001!\u0002\u0013\t)\u0002C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002 !A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0003C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002 !A\u00111\u0006\u0001!\u0002\u0013\t\t\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011q\t\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002L!A\u00111\u000b\u0001!\u0002\u0013\ti\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011q\f\u0001!\u0002\u0013\tI\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u0011q\u000f\u0001!\u0002\u0013\t)\u0007C\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002|!A\u0011Q\u0012\u0001!\u0002\u0013\ti\bC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0003\u0002X!A\u0011\u0011\u0013\u0001!\u0002\u0013\tI\u0006C\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u0011Q\u0014\u0001!\u0002\u0013\t9\nC\u0005\u0002 \u0002\u0001\r\u0011\"\u0003\u0002\"\"I\u0011\u0011\u0016\u0001A\u0002\u0013%\u00111\u0016\u0005\t\u0003o\u0003\u0001\u0015)\u0003\u0002$\"I\u0011\u0011\u0018\u0001A\u0002\u0013%\u00111\u0018\u0005\n\u0003\u0013\u0004\u0001\u0019!C\u0005\u0003\u0017D\u0001\"a4\u0001A\u0003&\u0011Q\u0018\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!!;\u0001\t\u0003\tY\u000fC\u0004\u0002r\u0002!I!a=\u0003+\u0015CXmY;u_J\u0004v\u000eZ:BY2|7-\u0019;pe*\u0011A&L\u0001\u0004Wb\u001a(B\u0001\u00180\u0003\u001d\u0019G.^:uKJT!\u0001M\u0019\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0014\u0007\u0001Ad\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003F\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0007\u0002\u0013q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u000f\"k\u0011!M\u0005\u0003\u0013F\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\rM,7-T4s!\t9E*\u0003\u0002Nc\ty1+Z2ve&$\u00180T1oC\u001e,'/A\bfq\u0016\u001cW\u000f^8s\u0005VLG\u000eZ3s!\t\u0001\u0016+D\u0001,\u0013\t\u00116FA\rLk\n,'O\\3uKN,\u00050Z2vi>\u0014()^5mI\u0016\u0014\u0018\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t)f,D\u0001W\u0015\t9\u0006,\u0001\u0004dY&,g\u000e\u001e\u0006\u00033j\u000b!b[;cKJtW\r^3t\u0015\tYF,A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003u\u000b!![8\n\u0005}3&\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016\u0004\"\u0001\u00152\n\u0005\r\\#AG#yK\u000e,Ho\u001c:Q_\u0012\u001c8K\\1qg\"|Go]*u_J,\u0017!B2m_\u000e\\\u0007C\u00014j\u001b\u00059'B\u000152\u0003\u0011)H/\u001b7\n\u0005)<'!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\bF\u0004n]>\u0004\u0018O]:\u0011\u0005A\u0003\u0001\"\u0002#\b\u0001\u00041\u0005\"\u0002&\b\u0001\u0004Y\u0005\"\u0002(\b\u0001\u0004y\u0005\"B*\b\u0001\u0004!\u0006\"\u00021\b\u0001\u0004\t\u0007\"\u00023\b\u0001\u0004)\u0017aE#Y\u000b\u000e+Fk\u0014*`\u0013\u0012{6iT+O)\u0016\u0013V#\u0001<\u0011\u0005]|X\"\u0001=\u000b\u0005eT\u0018AB1u_6L7M\u0003\u0002|y\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005!l(\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003A(AC!u_6L7\rT8oO\u0006!R\tW#D+R{%kX%E?\u000e{UK\u0014+F%\u0002\na\u0003^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o]\u000b\u0003\u0003\u0013\u00012a^A\u0006\u0013\r\ti\u0001\u001f\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002/Q|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN\u0004\u0013!\u00059pI\u0006cGn\\2bi&|gnU5{KV\u0011\u0011Q\u0003\t\u0004s\u0005]\u0011bAA\ru\t\u0019\u0011J\u001c;\u0002%A|G-\u00117m_\u000e\fG/[8o'&TX\rI\u0001\u0013a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u00170\u0006\u0002\u0002\"A\u0019\u0011(a\t\n\u0007\u0005\u0015\"H\u0001\u0003M_:<\u0017a\u00059pI\u0006cGn\\2bi&|g\u000eR3mCf\u0004\u0013A\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\f1\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003\u0003rA!!\u000e\u0002>A\u0019\u0011q\u0007\u001e\u000e\u0005\u0005e\"bAA\u001e\u000b\u00061AH]8pizJ1!a\u0010;\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\u0019\u0019FO]5oO*\u0019\u0011q\b\u001e\u0002\u00159\fW.Z:qC\u000e,\u0007%A\flk\n,'O\\3uKN$%/\u001b<feB{GMT1nKV\u0011\u0011Q\n\t\u0006s\u0005=\u0013\u0011G\u0005\u0004\u0003#R$AB(qi&|g.\u0001\rlk\n,'O\\3uKN$%/\u001b<feB{GMT1nK\u0002\nQc\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148/\u0006\u0002\u0002ZA\u0019\u0011(a\u0017\n\u0007\u0005u#HA\u0004C_>dW-\u00198\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0005\u0005\u0015\u0004#B\u001d\u0002P\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003cB\u0016aA1qS&!\u0011QOA6\u0005\r\u0001v\u000eZ\u0001\u000bIJLg/\u001a:Q_\u0012\u0004\u0013!\u00068fo2L8I]3bi\u0016$W\t_3dkR|'o]\u000b\u0003\u0003{\u0002\u0002\"a \u0002\n\u0006\u0005\u0012\u0011E\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u00069Q.\u001e;bE2,'bAADu\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0015\u0011\u0011\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0002-9,w\u000f\\=De\u0016\fG/\u001a3Fq\u0016\u001cW\u000f^8sg\u0002\n\u0001\u0004Z=oC6L7-\u00117m_\u000e\fG/[8o\u000b:\f'\r\\3e\u0003e!\u0017P\\1nS\u000e\fE\u000e\\8dCRLwN\\#oC\ndW\r\u001a\u0011\u0002\u001d!\f7\u000fU3oI&tw\rU8egV\u0011\u0011q\u0013\t\u0004o\u0006e\u0015bAANq\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq\u0002[1t!\u0016tG-\u001b8h!>$7\u000fI\u0001\rY\u0006\u001cHo\u00158baNDw\u000e^\u000b\u0003\u0003G\u00032\u0001UAS\u0013\r\t9k\u000b\u0002\u0015\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;\u0002!1\f7\u000f^*oCB\u001c\bn\u001c;`I\u0015\fH\u0003BAW\u0003g\u00032!OAX\u0013\r\t\tL\u000f\u0002\u0005+:LG\u000fC\u0005\u00026\u0006\n\t\u00111\u0001\u0002$\u0006\u0019\u0001\u0010J\u0019\u0002\u001b1\f7\u000f^*oCB\u001c\bn\u001c;!\u0003I!W\r\\3uK\u0012,\u00050Z2vi>\u0014\u0018\nZ:\u0016\u0005\u0005u\u0006CBA`\u0003\u000b\f\t#\u0004\u0002\u0002B*!\u00111YAC\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002H\u0006\u0005'aA*fi\u00061B-\u001a7fi\u0016$W\t_3dkR|'/\u00133t?\u0012*\u0017\u000f\u0006\u0003\u0002.\u00065\u0007\"CA[I\u0005\u0005\t\u0019AA_\u0003M!W\r\\3uK\u0012,\u00050Z2vi>\u0014\u0018\nZ:!Q\r)\u00131\u001b\t\u0004s\u0005U\u0017bAAlu\tAao\u001c7bi&dW-A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002.\u0006u\u0007bBApM\u0001\u0007\u0011\u0011G\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u00023M,G\u000fV8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d\u000b\u0005\u0003[\u000b)\u000fC\u0004\u0002h\u001e\u0002\r!!\u0006\u0002\u000bQ|G/\u00197\u0002\u0013%\u001cH)\u001a7fi\u0016$G\u0003BA-\u0003[Dq!a<)\u0001\u0004\t\t$\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\fab\u001c8OK^\u001cf.\u00199tQ>$8\u000f\u0006\u0004\u0002.\u0006U\u0018q\u001f\u0005\b\u0003?L\u0003\u0019AA\u0019\u0011\u001d\tI0\u000ba\u0001\u0003w\f\u0011b\u001d8baNDw\u000e^:\u0011\r\u0005u(qAAR\u001d\u0011\tyPa\u0001\u000f\t\u0005]\"\u0011A\u0005\u0002w%\u0019!Q\u0001\u001e\u0002\u000fA\f7m[1hK&!!\u0011\u0002B\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u000bQ\u0004")
public class ExecutorPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicLong EXECUTOR_ID_COUNTER;
    private final AtomicInteger totalExpectedExecutors;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final long podCreationTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Object> newlyCreatedExecutors;
    private final boolean dynamicAllocationEnabled;
    private final AtomicBoolean hasPendingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private volatile Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicLong EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private AtomicInteger totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private Option<Pod> driverPod() {
        return this.driverPod;
    }

    private LinkedHashMap<Object, Object> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    private AtomicBoolean hasPendingPods() {
        return this.hasPendingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    private Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    private void deletedExecutorIds_$eq(Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    public void start(String applicationId) {
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setTotalExpectedExecutors(int total) {
        block0: {
            this.totalExpectedExecutors().set(total);
            if (this.hasPendingPods().get()) break block0;
            this.snapshotsStore.notifySubscribers();
        }
    }

    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    private synchronized void onNewSnapshots(String applicationId, Seq<ExecutorPodsSnapshot> snapshots) {
        block9: {
            IntRef knownPendingCount;
            block8: {
                this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom()));
                long currentTime = this.clock.getTimeMillis();
                scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iterable iterable;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        long execId = tuple2._1$mcJ$sp();
                        long timeCreated = tuple2._2$mcJ$sp();
                        if (currentTime - timeCreated > this.podCreationTimeout()) {
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                        } else {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Iterable iterable2 = iterable;
                    return iterable2;
                }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
                if (timedOut.nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
                    this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
                    if (this.shouldDeleteExecutors()) {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$6(BoxesRunTime.unboxToLong((Object)x$3)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
                    }
                }
                if (snapshots.nonEmpty()) {
                    this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
                }
                int currentRunningCount = this.lastSnapshot().executorPods().values().count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$7(x0$2)));
                scala.collection.immutable.Iterable currentPendingExecutors = (scala.collection.immutable.Iterable)((TraversableLike)this.lastSnapshot().executorPods().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$8(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$9(x0$4)), Iterable$.MODULE$.canBuildFrom());
                Set _deletedExecutorIds = this.deletedExecutorIds();
                if (snapshots.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutors.size()).append(" pending, ").append(this.newlyCreatedExecutors().size()).append(" unacknowledged.").toString());
                    Set existingExecs = this.lastSnapshot().executorPods().keySet();
                    _deletedExecutorIds = (Set)_deletedExecutorIds.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> existingExecs.contains((Object)BoxesRunTime.boxToLong((long)elem)));
                }
                int currentTotalExpectedExecutors = this.totalExpectedExecutors().get();
                knownPendingCount = IntRef.create((int)currentPendingExecutors.size());
                int knownPodCount = currentRunningCount + currentPendingExecutors.size() + this.newlyCreatedExecutors().size();
                if (knownPodCount > currentTotalExpectedExecutors) {
                    int excess = knownPodCount - currentTotalExpectedExecutors;
                    scala.collection.immutable.Iterable knownPendingToDelete = (scala.collection.immutable.Iterable)currentPendingExecutors.take(excess - this.newlyCreatedExecutors().size());
                    List toDelete = (List)((TraversableOnce)this.newlyCreatedExecutors().keys().take(excess)).toList().$plus$plus((GenTraversableOnce)knownPendingToDelete, List$.MODULE$.canBuildFrom());
                    if (toDelete.nonEmpty()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                        _deletedExecutorIds = (Set)_deletedExecutorIds.$plus$plus((GenTraversableOnce)toDelete);
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$14(BoxesRunTime.unboxToLong((Object)x$4)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)toDelete);
                            knownPendingCount$1.elem -= knownPendingToDelete.size();
                        });
                    }
                }
                if (this.newlyCreatedExecutors().isEmpty() && currentPendingExecutors.isEmpty() && currentRunningCount < currentTotalExpectedExecutors) {
                    int numExecutorsToAllocate = package$.MODULE$.min(currentTotalExpectedExecutors - currentRunningCount, this.podAllocationSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes.").toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                        long newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                        KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, ((Object)BoxesRunTime.boxToLong((long)newExecutorId)).toString(), applicationId, this.driverPod());
                        SparkPod executorPod = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient);
                        Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                        $this.kubernetesClient.pods().create((Object)podWithAttachedContainer);
                        this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)BoxesRunTime.boxToLong((long)$this.clock.getTimeMillis()));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                    });
                }
                this.deletedExecutorIds_$eq((Set<Object>)_deletedExecutorIds);
                this.hasPendingPods().set(knownPendingCount.elem + this.newlyCreatedExecutors().size() > 0);
                if (!this.log().isDebugEnabled() || snapshots.isEmpty()) {
                    return;
                }
                if (currentRunningCount < currentTotalExpectedExecutors || this.dynamicAllocationEnabled()) break block8;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Current number of running executors is equal to the number of requested executors. Not scaling up further.");
                break block9;
            }
            int outstanding = knownPendingCount.elem + this.newlyCreatedExecutors().size();
            if (outstanding <= 0) break block9;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Still waiting for ").append(outstanding).append(" executors before requesting more.").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$6(long x$3) {
        return ((Object)BoxesRunTime.boxToLong((long)x$3)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$7(ExecutorPodState x0$2) {
        ExecutorPodState executorPodState = x0$2;
        boolean bl = executorPodState instanceof PodRunning;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$8(Tuple2 x0$3) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$3;
        boolean bl = tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$9(Tuple2 x0$4) {
        long id;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = id = tuple2._1$mcJ$sp();
        return l;
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$14(long x$4) {
        return ((Object)BoxesRunTime.boxToLong((long)x$4)).toString();
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicLong(0L);
        this.totalExpectedExecutors = new AtomicInteger(0);
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, 60000L);
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append(this.kubernetesDriverPodName()).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.hasPendingPods = new AtomicBoolean();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

