% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\name{column_misc_functions}
\alias{column_misc_functions}
\alias{crc32,Column-method}
\alias{crc32}
\alias{hash,Column-method}
\alias{hash}
\alias{xxhash64,Column-method}
\alias{xxhash64}
\alias{md5,Column-method}
\alias{md5}
\alias{sha1,Column-method}
\alias{sha1}
\alias{sha2,Column,numeric-method}
\alias{sha2}
\title{Miscellaneous functions for Column operations}
\usage{
crc32(x)

hash(x, ...)

md5(x)

sha1(x)

sha2(y, x)

xxhash64(x, ...)

\S4method{crc32}{Column}(x)

\S4method{hash}{Column}(x, ...)

\S4method{xxhash64}{Column}(x, ...)

\S4method{md5}{Column}(x)

\S4method{sha1}{Column}(x)

\S4method{sha2}{Column,numeric}(y, x)
}
\arguments{
\item{x}{Column to compute on. In \code{sha2}, it is one of 224, 256, 384, or 512.}

\item{...}{additional Columns.}

\item{y}{Column to compute on.}
}
\description{
Miscellaneous functions defined for \code{Column}.
}
\details{
\code{crc32}: Calculates the cyclic redundancy check value  (CRC32) of a binary column
and returns the value as a bigint.

\code{hash}: Calculates the hash code of given columns, and returns the result
as an int column.

\code{xxhash64}: Calculates the hash code of given columns using the 64-bit
variant of the xxHash algorithm, and returns the result as a long
column.

\code{md5}: Calculates the MD5 digest of a binary column and returns the value
as a 32 character hex string.

\code{sha1}: Calculates the SHA-1 digest of a binary column and returns the value
as a 40 character hex string.

\code{sha2}: Calculates the SHA-2 family of hash functions of a binary column and
returns the value as a hex string. The second argument \code{x} specifies the number
of bits, and is one of 224, 256, 384, or 512.
}
\note{
crc32 since 1.5.0

hash since 2.0.0

xxhash64 since 3.0.0

md5 since 1.5.0

sha1 since 1.5.0

sha2 since 1.5.0
}
\examples{
\dontrun{
# Dataframe used throughout this doc
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars)[, 1:2])
tmp <- mutate(df, v1 = crc32(df$model), v2 = hash(df$model),
                  v3 = hash(df$model, df$mpg), v4 = md5(df$model),
                  v5 = sha1(df$model), v6 = sha2(df$model, 256))
head(tmp)}
}
\concept{misc functions}
