/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0001\t1\u0011ADR5mK\n\u000b7/\u001a3Xe&$X-\u00115fC\u0012dunZ,sSR,'O\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bU\u0001\"AD\n\u000e\u0003=Q!\u0001E\t\u0002\t1\fgn\u001a\u0006\u0002%\u0005!!.\u0019<b\u0013\t!rB\u0001\u0004PE*,7\r\u001e\t\u0003-ei\u0011a\u0006\u0006\u00031E\t!![8\n\u0005i9\"!C\"m_N,\u0017M\u00197f\u0011!a\u0002A!A!\u0002\u0013q\u0012\u0001\u00029bi\"\u001c\u0001\u0001\u0005\u0002 K9\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!\u0013\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nAaY8oM*\u0011q\u0006C\u0001\u0007Q\u0006$wn\u001c9\n\u0005Eb#!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0004k]B\u0004C\u0001\u001c\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f3\u0001\u0004q\u0002\"B\u00153\u0001\u0004Q\u0003\u0002\u0003\u001e\u0001\u0011\u000b\u0007I\u0011B\u001e\u0002\rM$(/Z1n+\u0005a\u0004CA\u001fA\u001b\u0005q$BA /\u0003\t17/\u0003\u0002B}\t\u0011bi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011!\u0019\u0005\u0001#A!B\u0013a\u0014aB:ue\u0016\fW\u000e\t\u0005\b\u000b\u0002\u0001\r\u0011\"\u0003G\u0003)qW\r\u001f;PM\u001a\u001cX\r^\u000b\u0002\u000fB\u0011\u0001\u0005S\u0005\u0003\u0013\u0006\u0012A\u0001T8oO\"91\n\u0001a\u0001\n\u0013a\u0015A\u00048fqR|eMZ:fi~#S-\u001d\u000b\u0003\u001bB\u0003\"\u0001\t(\n\u0005=\u000b#\u0001B+oSRDq!\u0015&\u0002\u0002\u0003\u0007q)A\u0002yIEBaa\u0015\u0001!B\u00139\u0015a\u00038fqR|eMZ:fi\u0002Bq!\u0016\u0001A\u0002\u0013%a+\u0001\u0004dY>\u001cX\rZ\u000b\u0002/B\u0011\u0001\u0005W\u0005\u00033\u0006\u0012qAQ8pY\u0016\fg\u000eC\u0004\\\u0001\u0001\u0007I\u0011\u0002/\u0002\u0015\rdwn]3e?\u0012*\u0017\u000f\u0006\u0002N;\"9\u0011KWA\u0001\u0002\u00049\u0006BB0\u0001A\u0003&q+A\u0004dY>\u001cX\r\u001a\u0011\t\u000b\u0005\u0004A\u0011\u00012\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005\r4\u0007C\u0001\u001ce\u0013\t)'AA\u000fGS2,')Y:fI^\u0013\u0018\u000e^3BQ\u0016\fG\rT8h'\u0016<W.\u001a8u\u0011\u00159\u0007\r1\u0001i\u0003\u0011!\u0017\r^1\u0011\u0005%dW\"\u00016\u000b\u0005-\f\u0012a\u00018j_&\u0011QN\u001b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B8\u0001\t\u0003\u0002\u0018!B2m_N,G#A'\t\u000bI\u0004A\u0011\u00029\u0002\u000b\u0019dWo\u001d5\t\u000bQ\u0004A\u0011\u00029\u0002\u0015\u0005\u001c8/\u001a:u\u001fB,g\u000e")
public class FileBasedWriteAheadLogWriter
implements Closeable {
    private final String path;
    private final Configuration hadoopConf;
    private FSDataOutputStream stream;
    private long nextOffset;
    private boolean closed;
    private volatile boolean bitmap$0;

    private FSDataOutputStream stream$lzycompute() {
        FileBasedWriteAheadLogWriter fileBasedWriteAheadLogWriter = this;
        synchronized (fileBasedWriteAheadLogWriter) {
            if (!this.bitmap$0) {
                this.stream = HdfsUtils$.MODULE$.getOutputStream(this.path, this.hadoopConf);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.hadoopConf = null;
            return this.stream;
        }
    }

    private FSDataOutputStream stream() {
        return this.bitmap$0 ? this.stream : this.stream$lzycompute();
    }

    private long nextOffset() {
        return this.nextOffset;
    }

    private void nextOffset_$eq(long x$1) {
        this.nextOffset = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized FileBasedWriteAheadLogSegment write(ByteBuffer data) {
        void var3_3;
        this.assertOpen();
        data.rewind();
        int lengthToWrite = data.remaining();
        FileBasedWriteAheadLogSegment segment = new FileBasedWriteAheadLogSegment(this.path, this.nextOffset(), lengthToWrite);
        this.stream().writeInt(lengthToWrite);
        Utils$.MODULE$.writeByteBuffer(data, (OutputStream)this.stream());
        this.flush();
        this.nextOffset_$eq(this.stream().getPos());
        return var3_3;
    }

    @Override
    public synchronized void close() {
        this.closed_$eq(true);
        this.stream().close();
    }

    private void flush() {
        this.stream().hflush();
        this.stream().getWrappedStream().flush();
    }

    private void assertOpen() {
        HdfsUtils$.MODULE$.checkState(!this.closed(), (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stream is closed. Create a new Writer to write to file.";
            }
        });
    }

    public FileBasedWriteAheadLogWriter(String path, Configuration hadoopConf) {
        this.path = path;
        this.hadoopConf = hadoopConf;
        this.nextOffset = this.stream().getPos();
        this.closed = false;
    }
}

