/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class StateStore$
implements Logging {
    public static final StateStore$ MODULE$;
    private final String MAINTENANCE_INTERVAL_CONFIG;
    private final int MAINTENANCE_INTERVAL_DEFAULT_SECS;
    @GuardedBy(value="loadedProviders")
    private final HashMap<StateStoreProviderId, StateStoreProvider> org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders;
    @GuardedBy(value="loadedProviders")
    private StateStore.MaintenanceTask maintenanceTask;
    @GuardedBy(value="loadedProviders")
    private StateStoreCoordinatorRef org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StateStore$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String MAINTENANCE_INTERVAL_CONFIG() {
        return this.MAINTENANCE_INTERVAL_CONFIG;
    }

    public int MAINTENANCE_INTERVAL_DEFAULT_SECS() {
        return this.MAINTENANCE_INTERVAL_DEFAULT_SECS;
    }

    public HashMap<StateStoreProviderId, StateStoreProvider> org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders;
    }

    private StateStore.MaintenanceTask maintenanceTask() {
        return this.maintenanceTask;
    }

    private void maintenanceTask_$eq(StateStore.MaintenanceTask x$1) {
        this.maintenanceTask = x$1;
    }

    public StateStoreCoordinatorRef org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef;
    }

    private void org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef_$eq(StateStoreCoordinatorRef x$1) {
        this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef = x$1;
    }

    public StateStore get(StateStoreProviderId storeProviderId, StructType keySchema, StructType valueSchema, Option<Object> indexOrdinal, long version, StateStoreConf storeConf, Configuration hadoopConf) {
        Predef$.MODULE$.require(version >= 0L);
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            this.startMaintenanceIfNeeded();
            StateStoreProvider provider = (StateStoreProvider)this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().getOrElseUpdate((Object)storeProviderId, (Function0)new Serializable(storeProviderId, keySchema, valueSchema, indexOrdinal, storeConf, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final StateStoreProviderId storeProviderId$1;
                private final StructType keySchema$1;
                private final StructType valueSchema$1;
                private final Option indexOrdinal$1;
                private final StateStoreConf storeConf$1;
                private final Configuration hadoopConf$1;

                public final StateStoreProvider apply() {
                    return StateStoreProvider$.MODULE$.createAndInit(this.storeProviderId$1.storeId(), this.keySchema$1, this.valueSchema$1, (Option<Object>)this.indexOrdinal$1, this.storeConf$1, this.hadoopConf$1);
                }
                {
                    this.storeProviderId$1 = storeProviderId$1;
                    this.keySchema$1 = keySchema$1;
                    this.valueSchema$1 = valueSchema$1;
                    this.indexOrdinal$1 = indexOrdinal$1;
                    this.storeConf$1 = storeConf$1;
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
            this.reportActiveStoreInstance(storeProviderId);
            StateStoreProvider stateStoreProvider = provider;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var10_8
            StateStoreProvider storeProvider = stateStoreProvider;
            return storeProvider.getStore(version);
        }
    }

    public void unload(StateStoreProviderId storeProviderId) {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().remove((Object)storeProviderId).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(StateStoreProvider x$7) {
                    x$7.close();
                }
            });
            return;
        }
    }

    public boolean isLoaded(StateStoreProviderId storeProviderId) {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().contains((Object)storeProviderId));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean isMaintenanceRunning() {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.maintenanceTask() != null && this.maintenanceTask().isRunning() ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void stop() {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().keySet().foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(StateStoreProviderId key) {
                    StateStore$.MODULE$.unload(key);
                }
            });
            this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().clear();
            this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef_$eq(null);
            if (this.maintenanceTask() != null) {
                this.maintenanceTask().stop();
                this.maintenanceTask_$eq(null);
            }
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "StateStore stopped";
                }
            });
            return;
        }
    }

    private void startMaintenanceIfNeeded() {
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            BoxedUnit boxedUnit;
            SparkEnv env = SparkEnv$.MODULE$.get();
            if (env == null || this.isMaintenanceRunning()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                long periodMs = env.conf().getTimeAsMs(this.MAINTENANCE_INTERVAL_CONFIG(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.MAINTENANCE_INTERVAL_DEFAULT_SECS())})));
                this.maintenanceTask_$eq(new StateStore.MaintenanceTask(periodMs, (Function0<BoxedUnit>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        StateStore$.MODULE$.org$apache$spark$sql$execution$streaming$state$StateStore$$doMaintenance();
                    }
                }, (Function0<BoxedUnit>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = StateStore$.MODULE$.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
                        synchronized (hashMap) {
                            StateStore$.MODULE$.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().clear();
                            return;
                        }
                    }
                }));
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "State Store maintenance task started";
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$sql$execution$streaming$state$StateStore$$doMaintenance() {
        Seq seq;
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Doing maintenance";
            }
        });
        if (SparkEnv$.MODULE$.get() == null) {
            throw new IllegalStateException("SparkEnv not active, cannot do maintenance on StateStores");
        }
        HashMap<StateStoreProviderId, StateStoreProvider> hashMap = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (hashMap) {
            seq = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders().toSeq();
        }
        ((IterableLike)seq).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<StateStoreProviderId, StateStoreProvider> x0$1) {
                BoxedUnit boxedUnit;
                block4: {
                    Tuple2<StateStoreProviderId, StateStoreProvider> tuple2 = x0$1;
                    if (tuple2 == null) throw new MatchError(tuple2);
                    StateStoreProviderId id = (StateStoreProviderId)tuple2._1();
                    StateStoreProvider provider = (StateStoreProvider)tuple2._2();
                    try {
                        if (StateStore$.MODULE$.org$apache$spark$sql$execution$streaming$state$StateStore$$verifyIfStoreInstanceActive(id)) {
                            provider.doMaintenance();
                            boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        StateStore$.MODULE$.unload(id);
                        StateStore$.MODULE$.logInfo((Function0<String>)new Serializable(this, provider){
                            public static final long serialVersionUID = 0L;
                            private final StateStoreProvider provider$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unloaded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provider$1}));
                            }
                            {
                                this.provider$1 = provider$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        StateStore$.MODULE$.logWarning((Function0<String>)new Serializable(this, provider){
                            public static final long serialVersionUID = 0L;
                            private final StateStoreProvider provider$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error managing ", ", stopping management thread"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provider$1}));
                            }
                            {
                                this.provider$1 = provider$1;
                            }
                        });
                        throw e;
                    }
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        });
    }

    private void reportActiveStoreInstance(StateStoreProviderId storeProviderId) {
        if (SparkEnv$.MODULE$.get() != null) {
            String host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
            String executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
            this.coordinatorRef().foreach((Function1)new Serializable(storeProviderId, host, executorId){
                public static final long serialVersionUID = 0L;
                private final StateStoreProviderId storeProviderId$2;
                private final String host$1;
                private final String executorId$1;

                public final void apply(StateStoreCoordinatorRef x$8) {
                    x$8.reportActiveInstance(this.storeProviderId$2, this.host$1, this.executorId$1);
                }
                {
                    this.storeProviderId$2 = storeProviderId$2;
                    this.host$1 = host$1;
                    this.executorId$1 = executorId$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(storeProviderId){
                public static final long serialVersionUID = 0L;
                private final StateStoreProviderId storeProviderId$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reported that the loaded instance ", " is active"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeProviderId$2}));
                }
                {
                    this.storeProviderId$2 = storeProviderId$2;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean org$apache$spark$sql$execution$streaming$state$StateStore$$verifyIfStoreInstanceActive(StateStoreProviderId storeProviderId) {
        boolean bl;
        if (SparkEnv$.MODULE$.get() == null) {
            bl = false;
        } else {
            void var3_3;
            String executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
            boolean verified = BoxesRunTime.unboxToBoolean((Object)this.coordinatorRef().map((Function1)new Serializable(storeProviderId, executorId){
                public static final long serialVersionUID = 0L;
                private final StateStoreProviderId storeProviderId$3;
                private final String executorId$2;

                public final boolean apply(StateStoreCoordinatorRef x$9) {
                    return x$9.verifyIfInstanceActive(this.storeProviderId$3, this.executorId$2);
                }
                {
                    this.storeProviderId$3 = storeProviderId$3;
                    this.executorId$2 = executorId$2;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            this.logDebug((Function0<String>)new Serializable(storeProviderId, verified){
                public static final long serialVersionUID = 0L;
                private final StateStoreProviderId storeProviderId$3;
                private final boolean verified$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Verified whether the loaded instance ", " is active: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeProviderId$3, BoxesRunTime.boxToBoolean((boolean)this.verified$1)}));
                }
                {
                    this.storeProviderId$3 = storeProviderId$3;
                    this.verified$1 = verified$1;
                }
            });
            bl = var3_3;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private Option<StateStoreCoordinatorRef> coordinatorRef() {
        var1_1 = this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders();
        synchronized (var1_1) {
            block7: {
                block6: {
                    env = SparkEnv$.MODULE$.get();
                    if (env != null) break block6;
                    this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef_$eq(null);
                    v0 = None$.MODULE$;
                    break block7;
                }
                v1 = env.executorId();
                var5_3 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                if (!(v1 == null ? var5_3 != null : v1.equals(var5_3) == false)) ** GOTO lbl-1000
                v2 = env.executorId();
                var6_4 = SparkContext$.MODULE$.LEGACY_DRIVER_IDENTIFIER();
                if (!(v2 != null ? v2.equals(var6_4) == false : var6_4 != null)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = isDriver = false;
                }
                if (isDriver || this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef() == null) {
                    this.logDebug((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Getting StateStoreCoordinatorRef";
                        }
                    });
                    this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef_$eq(StateStoreCoordinatorRef$.MODULE$.forExecutor(env));
                }
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieved reference to StateStoreCoordinator: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{StateStore$.MODULE$.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef()}));
                    }
                });
                v0 = new Some((Object)this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef());
            }
            var2_6 = v0;
            return (Option)var2_6;
        }
    }

    private StateStore$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.MAINTENANCE_INTERVAL_CONFIG = "spark.sql.streaming.stateStore.maintenanceInterval";
        this.MAINTENANCE_INTERVAL_DEFAULT_SECS = 60;
        this.org$apache$spark$sql$execution$streaming$state$StateStore$$loadedProviders = new HashMap();
        this.maintenanceTask = null;
        this.org$apache$spark$sql$execution$streaming$state$StateStore$$_coordRef = null;
    }
}

