/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.RichDouble$;

public final class ChiSqSelectorExample$ {
    public static final ChiSqSelectorExample$ MODULE$;

    static {
        new ChiSqSelectorExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("ChiSqSelectorExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD discretizedData = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(LabeledPoint lp) {
                return new LabeledPoint(lp.label(), Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(lp.features().toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(x / (double)16));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        ChiSqSelector selector = new ChiSqSelector(50);
        ChiSqSelectorModel transformer = selector.fit(discretizedData);
        RDD filteredData = discretizedData.map((Function1)new Serializable(transformer){
            public static final long serialVersionUID = 0L;
            private final ChiSqSelectorModel transformer$1;

            public final LabeledPoint apply(LabeledPoint lp) {
                return new LabeledPoint(lp.label(), this.transformer$1.transform(lp.features()));
            }
            {
                this.transformer$1 = transformer$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        Predef$.MODULE$.println((Object)"filtered data: ");
        Predef$.MODULE$.refArrayOps((Object[])filteredData.collect()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LabeledPoint x) {
                Predef$.MODULE$.println((Object)x);
            }
        });
        sc.stop();
    }

    private ChiSqSelectorExample$() {
        MODULE$ = this;
    }
}

