/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.graphx;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.GraphLoader$;
import org.apache.spark.graphx.GraphXUtils$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.PartitionStrategy$;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class Analytics$ {
    public static final Analytics$ MODULE$;

    static {
        new Analytics$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        if (args.length < 2) {
            String usage = new StringOps(Predef$.MODULE$.augmentString("Usage: Analytics <taskType> <file> --numEPart=<num_edge_partitions>\n      |[other options] Supported 'taskType' as follows:\n      |pagerank    Compute PageRank\n      |cc          Compute the connected components of vertices\n      |triangles   Count the number of triangles")).stripMargin();
            System.err.println(usage);
            System.exit(1);
        }
        String taskType = args[0];
        String fname = args[1];
        Tuple2[] optionsList = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])args).drop(2)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String arg) {
                String[] stringArray = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(arg)).dropWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$1) {
                        return x$1 == '-';
                    }
                }))).split('=');
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String opt = (String)((SeqLike)option.get()).apply(0);
                    String v = (String)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opt), (Object)v);
                    return tuple2;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid argument: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg})));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Map options = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])optionsList));
        SparkConf conf = new SparkConf();
        GraphXUtils$.MODULE$.registerKryoClasses(conf);
        int numEPart = BoxesRunTime.unboxToInt((Object)options.remove((Object)"numEPart").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                Predef$.MODULE$.println((Object)"Set the number of edge partitions using --numEPart.");
                return package$.MODULE$.exit(1);
            }
        }));
        Option partitionStrategy = options.remove((Object)"partStrategy").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PartitionStrategy apply(String x$3) {
                return PartitionStrategy$.MODULE$.fromString(x$3);
            }
        });
        StorageLevel edgeStorageLevel = (StorageLevel)options.remove((Object)"edgeStorageLevel").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply(String x$4) {
                return StorageLevel$.MODULE$.fromString(x$4);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply() {
                return StorageLevel$.MODULE$.MEMORY_ONLY();
            }
        });
        StorageLevel vertexStorageLevel = (StorageLevel)options.remove((Object)"vertexStorageLevel").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply(String x$5) {
                return StorageLevel$.MODULE$.fromString(x$5);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply() {
                return StorageLevel$.MODULE$.MEMORY_ONLY();
            }
        });
        String string = taskType;
        if ("pagerank".equals(string)) {
            Graph graph;
            SparkContext sc;
            float tol = BoxesRunTime.unboxToFloat((Object)options.remove((Object)"tol").map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(String x$6) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$6)).toFloat();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return 0.001f;
                }
            }));
            String outFname = (String)options.remove((Object)"output").getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            Option numIterOpt = options.remove((Object)"numIter").map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$7) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
                }
            });
            options.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String opt = (String)tuple2._1();
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid option: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt})));
                    }
                    throw new MatchError(tuple2);
                }
            });
            Predef$.MODULE$.println((Object)"======================================");
            Predef$.MODULE$.println((Object)"|             PageRank               |");
            Predef$.MODULE$.println((Object)"======================================");
            SparkContext x$17 = sc = new SparkContext(conf.setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PageRank(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fname}))));
            String x$18 = fname;
            int x$19 = numEPart;
            StorageLevel x$20 = edgeStorageLevel;
            StorageLevel x$21 = vertexStorageLevel;
            boolean x$22 = GraphLoader$.MODULE$.edgeListFile$default$3();
            Graph unpartitionedGraph = GraphLoader$.MODULE$.edgeListFile(x$17, x$18, x$22, x$19, x$20, x$21).cache();
            Graph graph2 = (Graph)Option$.MODULE$.option2Iterable(partitionStrategy).foldLeft((Object)unpartitionedGraph, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Graph<Object, Object> apply(Graph<Object, Object> x$8, PartitionStrategy x$9) {
                    return x$8.partitionBy(x$9);
                }
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GRAPHX: Number of vertices ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)graph2.vertices().count())})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GRAPHX: Number of edges ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)graph2.edges().count())})));
            Option option = numIterOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                int numIter = BoxesRunTime.unboxToInt((Object)some.x());
                graph = PageRank$.MODULE$.run(graph2, numIter, PageRank$.MODULE$.run$default$3(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                graph = PageRank$.MODULE$.runUntilConvergence(graph2, (double)tol, PageRank$.MODULE$.runUntilConvergence$default$3(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            }
            VertexRDD pr = (VertexRDD)graph.vertices().cache();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GRAPHX: Total rank: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pr.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$10) {
                    return x$10._2$mcD$sp();
                }
            }, ClassTag$.MODULE$.Double()).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double x$11, double x$12) {
                    return this.apply$mcDDD$sp(x$11, x$12);
                }

                public double apply$mcDDD$sp(double x$11, double x$12) {
                    return x$11 + x$12;
                }
            })})));
            if (!outFname.isEmpty()) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving pageranks of pages to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outFname})));
                pr.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            long id = tuple2._1$mcJ$sp();
                            double r = tuple2._2$mcD$sp();
                            String string = new StringBuilder().append(id).append((Object)"\t").append((Object)BoxesRunTime.boxToDouble((double)r)).toString();
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outFname);
            }
            sc.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if ("cc".equals(string)) {
            SparkContext sc;
            options.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Tuple2<String, String> x0$3) {
                    Tuple2<String, String> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String opt = (String)tuple2._1();
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid option: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt})));
                    }
                    throw new MatchError(tuple2);
                }
            });
            Predef$.MODULE$.println((Object)"======================================");
            Predef$.MODULE$.println((Object)"|      Connected Components          |");
            Predef$.MODULE$.println((Object)"======================================");
            SparkContext x$23 = sc = new SparkContext(conf.setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ConnectedComponents(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fname}))));
            String x$24 = fname;
            int x$25 = numEPart;
            StorageLevel x$26 = edgeStorageLevel;
            StorageLevel x$27 = vertexStorageLevel;
            boolean x$28 = GraphLoader$.MODULE$.edgeListFile$default$3();
            Graph unpartitionedGraph = GraphLoader$.MODULE$.edgeListFile(x$23, x$24, x$28, x$25, x$26, x$27).cache();
            Graph graph = (Graph)Option$.MODULE$.option2Iterable(partitionStrategy).foldLeft((Object)unpartitionedGraph, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Graph<Object, Object> apply(Graph<Object, Object> x$13, PartitionStrategy x$14) {
                    return x$13.partitionBy(x$14);
                }
            });
            Graph cc = ConnectedComponents$.MODULE$.run(graph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Components: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cc.vertices().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> x0$4) {
                    Tuple2<Object, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        long data;
                        long l = data = tuple2._2$mcJ$sp();
                        return l;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(Long.TYPE)).distinct()})));
            sc.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if ("triangles".equals(string)) {
            options.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Tuple2<String, String> x0$5) {
                    Tuple2<String, String> tuple2 = x0$5;
                    if (tuple2 != null) {
                        String opt = (String)tuple2._1();
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid option: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt})));
                    }
                    throw new MatchError(tuple2);
                }
            });
            Predef$.MODULE$.println((Object)"======================================");
            Predef$.MODULE$.println((Object)"|      Triangle Count                |");
            Predef$.MODULE$.println((Object)"======================================");
            SparkContext sc = new SparkContext(conf.setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TriangleCount(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fname}))));
            Graph graph = GraphLoader$.MODULE$.edgeListFile(sc, fname, true, numEPart, edgeStorageLevel, vertexStorageLevel).partitionBy((PartitionStrategy)partitionStrategy.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final PartitionStrategy.RandomVertexCut$ apply() {
                    return PartitionStrategy.RandomVertexCut$.MODULE$;
                }
            })).cache();
            Graph triangles = TriangleCount$.MODULE$.run(graph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            long triangleTypes = BoxesRunTime.unboxToLong((Object)triangles.vertices().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> x0$6) {
                    Tuple2<Object, Object> tuple2 = x0$6;
                    if (tuple2 != null) {
                        int data = tuple2._2$mcI$sp();
                        long l = data;
                        return l;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.Long()).reduce((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(long x$15, long x$16) {
                    return this.apply$mcJJJ$sp(x$15, x$16);
                }

                public long apply$mcJJJ$sp(long x$15, long x$16) {
                    return x$15 + x$16;
                }
            })) / 3L;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Triangles: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)triangleTypes)})));
            sc.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            Predef$.MODULE$.println((Object)"Invalid task type.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Analytics$() {
        MODULE$ = this;
    }
}

