/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import java.util.Random;
import org.apache.spark.examples.LocalLR;
import org.apache.spark.examples.LocalLR$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class LocalLR$ {
    public static final LocalLR$ MODULE$;
    private final int N;
    private final int D;
    private final double R;
    private final int ITERATIONS;
    private final Random rand;

    static {
        new LocalLR$();
    }

    public int N() {
        return this.N;
    }

    public int D() {
        return this.D;
    }

    public double R() {
        return this.R;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public Random rand() {
        return this.rand;
    }

    public LocalLR.DataPoint[] generateData() {
        return (LocalLR.DataPoint[])Array$.MODULE$.tabulate(this.N(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LocalLR.DataPoint apply(int i) {
                return LocalLR$.MODULE$.org$apache$spark$examples$LocalLR$$generatePoint$1(i);
            }
        }, ClassTag$.MODULE$.apply(LocalLR.DataPoint.class));
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of Logistic Regression and is given as an example!\n        |Please use org.apache.spark.ml.classification.LogisticRegression\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        this.showWarning();
        LocalLR.DataPoint[] data = this.generateData();
        DenseVector w = (DenseVector)DenseVector$.MODULE$.fill(this.D(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return (double)2 * LocalLR$.MODULE$.rand().nextDouble() - 1.0;
            }
        }, ClassTag$.MODULE$.Double());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial w: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{w})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach((Function1)new Serializable(data, w){
            public static final long serialVersionUID = 0L;
            private final LocalLR.DataPoint[] data$1;
            public final DenseVector w$1;

            public final DenseVector<Object> apply(int i) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"On iteration ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                DenseVector gradient = DenseVector$.MODULE$.zeros$mDc$sp(LocalLR$.MODULE$.D(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Predef$.MODULE$.refArrayOps((Object[])this.data$1).foreach((Function1)new Serializable(this, gradient){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;
                    private final DenseVector gradient$1;

                    public final DenseVector<Object> apply(LocalLR.DataPoint p) {
                        double scale = (1.0 / (1.0 + package$.MODULE$.exp(-p.y() * BoxesRunTime.unboxToDouble((Object)this.$outer.w$1.dot(p.x(), DenseVector$.MODULE$.canDot_DV_V_Double())))) - 1.0) * p.y();
                        return (DenseVector)this.gradient$1.$plus$eq(p.x().$times((Object)BoxesRunTime.boxToDouble((double)scale), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.gradient$1 = gradient$1;
                    }
                });
                return (DenseVector)this.w$1.$minus$eq((Object)gradient, DenseVector$.MODULE$.canSubIntoD());
            }
            {
                this.data$1 = data$1;
                this.w$1 = w$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final w: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{w})));
    }

    public final LocalLR.DataPoint org$apache$spark$examples$LocalLR$$generatePoint$1(int i) {
        int y = i % 2 == 0 ? -1 : 1;
        DenseVector x = (DenseVector)DenseVector$.MODULE$.fill(this.D(), (Function0)new Serializable(y){
            public static final long serialVersionUID = 0L;
            private final int y$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return LocalLR$.MODULE$.rand().nextGaussian() + (double)this.y$1 * LocalLR$.MODULE$.R();
            }
            {
                this.y$1 = y$1;
            }
        }, ClassTag$.MODULE$.Double());
        return new LocalLR.DataPoint((Vector<Object>)x, y);
    }

    private LocalLR$() {
        MODULE$ = this;
        this.N = 10000;
        this.D = 10;
        this.R = 0.7;
        this.ITERATIONS = 5;
        this.rand = new Random(42L);
    }
}

