/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.LongAdder;
import org.spark_project.jetty.client.HttpClient;
import org.spark_project.jetty.client.HttpExchange;
import org.spark_project.jetty.client.HttpReceiver;
import org.spark_project.jetty.client.HttpResponse;
import org.spark_project.jetty.client.HttpResponseException;
import org.spark_project.jetty.client.http.HttpChannelOverHTTP;
import org.spark_project.jetty.client.http.HttpClientTransportOverHTTP;
import org.spark_project.jetty.client.http.HttpConnectionOverHTTP;
import org.spark_project.jetty.http.BadMessageException;
import org.spark_project.jetty.http.HttpField;
import org.spark_project.jetty.http.HttpMethod;
import org.spark_project.jetty.http.HttpParser;
import org.spark_project.jetty.http.HttpVersion;
import org.spark_project.jetty.io.ByteBufferPool;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.io.RetainableByteBuffer;
import org.spark_project.jetty.util.BufferUtil;
import org.spark_project.jetty.util.Callback;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private final LongAdder inMessages = new LongAdder();
    private final HttpParser parser;
    private RetainableByteBuffer networkBuffer;
    private boolean shutdown;
    private boolean complete;
    private boolean unsolicited;
    private int status;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        this.parser = new HttpParser((HttpParser.ResponseHandler)this, -1, channel.getHttpDestination().getHttpClient().getHttpCompliance());
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected ByteBuffer getResponseBuffer() {
        return this.networkBuffer == null ? null : this.networkBuffer.getBuffer();
    }

    @Override
    public void receive() {
        if (this.networkBuffer == null) {
            this.acquireNetworkBuffer();
        }
        this.process();
    }

    private void acquireNetworkBuffer() {
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired {}", this.networkBuffer);
        }
    }

    private void reacquireNetworkBuffer() {
        RetainableByteBuffer currentBuffer = this.networkBuffer;
        if (currentBuffer == null) {
            throw new IllegalStateException();
        }
        if (currentBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        currentBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reacquired {} <- {}", currentBuffer, this.networkBuffer);
        }
    }

    private RetainableByteBuffer newNetworkBuffer() {
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        return new RetainableByteBuffer(bufferPool, client.getResponseBufferSize(), true);
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", this.networkBuffer);
        }
        this.networkBuffer = null;
    }

    protected ByteBuffer onUpgradeFrom() {
        ByteBuffer upgradeBuffer = null;
        if (this.networkBuffer.hasRemaining()) {
            upgradeBuffer = BufferUtil.allocate(this.networkBuffer.remaining());
            BufferUtil.clearToFill(upgradeBuffer);
            BufferUtil.put(this.networkBuffer.getBuffer(), upgradeBuffer);
            BufferUtil.flipToFlush(upgradeBuffer, 0);
        }
        this.releaseNetworkBuffer();
        return upgradeBuffer;
    }

    private void process() {
        try {
            int read2;
            HttpConnectionOverHTTP connection = this.getHttpConnection();
            EndPoint endPoint = connection.getEndPoint();
            while (true) {
                if (this.parse()) {
                    return;
                }
                if (connection.isClosed()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closed {}", connection);
                    }
                    this.releaseNetworkBuffer();
                    return;
                }
                if (this.networkBuffer.getReferences() > 1) {
                    this.reacquireNetworkBuffer();
                }
                read2 = endPoint.fill(this.networkBuffer.getBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes in {} from {}", read2, this.networkBuffer, endPoint);
                }
                if (read2 <= 0) break;
                connection.addBytesIn(read2);
            }
            if (read2 == 0) {
                this.releaseNetworkBuffer();
                this.fillInterested();
                return;
            }
            this.releaseNetworkBuffer();
            this.shutdown();
            return;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            this.releaseNetworkBuffer();
            this.failAndClose(x);
            return;
        }
    }

    private boolean parse() {
        boolean complete;
        do {
            boolean handle = this.parser.parseNext(this.networkBuffer.getBuffer());
            boolean failed = this.isFailed();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse result={}, failed={}", handle, failed);
            }
            if (failed) {
                this.parser.close();
            }
            if (handle) {
                return !failed;
            }
            complete = this.complete;
            this.complete = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse complete={}, remaining {} {}", complete, this.networkBuffer.remaining(), this.parser);
            }
            if (complete) {
                int status = this.status;
                this.status = 0;
                if (status == 101) {
                    return true;
                }
            }
            if (!this.networkBuffer.isEmpty()) continue;
            return false;
        } while (!complete);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding unexpected content after response: {}", this.networkBuffer);
        }
        this.networkBuffer.clear();
        return false;
    }

    protected void fillInterested() {
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public int getHeaderCacheSize() {
        HttpClientTransportOverHTTP transport = (HttpClientTransportOverHTTP)this.getHttpDestination().getHttpClient().getTransport();
        return transport.getHeaderCacheSize();
    }

    @Override
    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        boolean bl = this.unsolicited = exchange == null;
        if (exchange == null) {
            return false;
        }
        this.status = status;
        String method = exchange.getRequest().getMethod();
        this.parser.setHeadResponse(HttpMethod.HEAD.is(method) || HttpMethod.CONNECT.is(method) && status == 200);
        exchange.getResponse().version(version).status(status).reason(reason);
        return !this.responseBegin(exchange);
    }

    @Override
    public void parsedHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return;
        }
        this.responseHeader(exchange, field);
    }

    @Override
    public boolean headerComplete() {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return false;
        }
        return !this.responseHeaders(exchange);
    }

    @Override
    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return false;
        }
        RetainableByteBuffer networkBuffer = this.networkBuffer;
        networkBuffer.retain();
        return !this.responseContent(exchange, buffer, Callback.from(networkBuffer::release, failure -> {
            networkBuffer.release();
            this.failAndClose((Throwable)failure);
        }));
    }

    @Override
    public boolean contentComplete() {
        return false;
    }

    @Override
    public void parsedTrailer(HttpField trailer) {
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return;
        }
        exchange.getResponse().trailer(trailer);
    }

    @Override
    public boolean messageComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null || this.unsolicited) {
            this.getHttpConnection().close();
            return false;
        }
        int status = exchange.getResponse().getStatus();
        if (status != 100) {
            this.inMessages.increment();
            this.complete = true;
        }
        return !this.responseSuccess(exchange);
    }

    @Override
    public void earlyEOF() {
        HttpExchange exchange = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (exchange == null || this.unsolicited) {
            connection.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(connection)));
        }
    }

    @Override
    public void badMessage(BadMessageException failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null || this.unsolicited) {
            this.getHttpConnection().close();
        } else {
            HttpResponse response = exchange.getResponse();
            response.status(failure.getCode()).reason(failure.getReason());
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + this.getHttpConnection(), response, failure));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            this.getHttpConnection().close(failure);
        }
    }

    long getMessagesIn() {
        return this.inMessages.longValue();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }
}

