/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapFluentImpl;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Properties;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.util.control.Breaks$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0001!q!AB\"mS\u0016tGO\u0003\u0002\u0004\t\u000511/\u001e2nSRT!!\u0002\u0004\u0002\u0007-D4O\u0003\u0002\b\u0011\u00051A-\u001a9m_fT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001b/\t9Aj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u000f\t,\u0018\u000e\u001c3fe\u000e\u0001\u0001CA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u0005]YUOY3s]\u0016$Xm\u001d#sSZ,'OQ;jY\u0012,'\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u00042!\n\u0014)\u001b\u0005!\u0011BA\u0014\u0005\u00059YUOY3s]\u0016$Xm]\"p]\u001a\u0004\"!J\u0015\n\u0005)\"!\u0001H&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s'B,7-\u001b4jG\u000e{gN\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e\u001e\t\u0003]]j\u0011a\f\u0006\u0003aE\naa\u00197jK:$(B\u0001\u001a4\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003iU\nqAZ1ce&\u001c\u0007HC\u00017\u0003\tIw.\u0003\u00029_\t\u00012*\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005!r/Y5u\r>\u0014\u0018\t\u001d9D_6\u0004H.\u001a;j_:\u0004\"\u0001\u0005\u001f\n\u0005u\n\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u00069\u0011\r\u001d9OC6,\u0007CA!E\u001d\t\u0001\")\u0003\u0002D#\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019\u0015\u0003\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003\u001d9\u0018\r^2iKJ\u0004\"a\b&\n\u0005-\u0013!a\u0006'pO\u001eLgn\u001a)pIN#\u0018\r^;t/\u0006$8\r[3s\u0011!i\u0005A!A!\u0002\u0013\u0001\u0015\u0001H6vE\u0016\u0014h.\u001a;fgJ+7o\\;sG\u0016t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011E\u00136\u000bV+W/b\u0003\"a\b\u0001\t\u000bqq\u0005\u0019\u0001\u0010\t\u000b\rr\u0005\u0019\u0001\u0013\t\u000b1r\u0005\u0019A\u0017\t\u000bir\u0005\u0019A\u001e\t\u000b}r\u0005\u0019\u0001!\t\u000b!s\u0005\u0019A%\t\u000b5s\u0005\u0019\u0001!\t\u000bi\u0003A\u0011A.\u0002\u0007I,h\u000eF\u0001]!\t\u0001R,\u0003\u0002_#\t!QK\\5u\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0003]\tG\r\u001a#sSZ,'oT<oKJ\u0014VMZ3sK:\u001cW\rF\u0002]E2DQaY0A\u0002\u0011\f\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017!B7pI\u0016d'BA52\u0003\r\t\u0007/[\u0005\u0003W\u001a\u00141\u0001U8e\u0011\u0015iw\f1\u0001o\u0003%\u0011Xm]8ve\u000e,7\u000fE\u0002pojt!\u0001];\u000f\u0005E$X\"\u0001:\u000b\u0005Ml\u0012A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t1\u0018#A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(aA*fc*\u0011a/\u0005\t\u0003KnL!\u0001 4\u0003\u0017!\u000b7/T3uC\u0012\fG/\u0019\u0005\u0006}\u0002!Ia`\u0001\u000fEVLG\u000eZ\"p]\u001aLw-T1q)\u0019\t\t!a\u0002\u0002\fA\u0019Q-a\u0001\n\u0007\u0005\u0015aMA\u0005D_:4\u0017nZ'ba\"1\u0011\u0011B?A\u0002\u0001\u000bQbY8oM&<W*\u00199OC6,\u0007bBA\u0007{\u0002\u0007\u0011qB\u0001\u0005G>tg\rE\u0003B\u0003#\u0001\u0005)C\u0002\u0002\u0014\u0019\u00131!T1q\u0001")
public class Client
implements Logging {
    private final KubernetesDriverBuilder builder;
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;
    public final KubernetesClient org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient;
    public final LoggingPodStatusWatcher org$apache$spark$deploy$k8s$submit$Client$$watcher;
    private final String kubernetesResourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        KubernetesDriverSpec resolvedDriverSpec = this.builder.buildFromFeatures(this.kubernetesConf);
        String configMapName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-driver-conf-map"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kubernetesResourceNamePrefix}));
        ConfigMap configMap = this.buildConfigMap(configMapName, resolvedDriverSpec.systemProperties());
        Container resolvedDriverContainer = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(resolvedDriverSpec.pod().container()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        Pod resolvedDriverPod = ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(resolvedDriverSpec.pod().pod()).editSpec().addToContainers(new Container[]{resolvedDriverContainer}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME()).withNewConfigMap().withName(configMapName)).endConfigMap()).endVolume()).endSpec()).build();
        String driverPodName = resolvedDriverPod.getMetadata().getName();
        ObjectRef watch = ObjectRef.create(null);
        Pod createdDriverPod = (Pod)this.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.pods().create((Object[])new Pod[]{resolvedDriverPod});
        try {
            Seq otherKubernetesResources = (Seq)resolvedDriverSpec.driverKubernetesResources().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigMap[]{configMap})), Seq$.MODULE$.canBuildFrom());
            this.addDriverOwnerReference(createdDriverPod, (Seq<HasMetadata>)otherKubernetesResources);
            this.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.resourceList((HasMetadata[])otherKubernetesResources.toArray(ClassTag$.MODULE$.apply(HasMetadata.class))).createOrReplace();
        }
        catch (Throwable throwable) {
            void var8_8;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.pods().delete((Object[])new Pod[]{var8_8});
            throw e;
        }
        String sId = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kubernetesConf.namespace(), driverPodName}))).mkString(":");
        Breaks$.MODULE$.breakable((Function0)new Serializable(this, driverPodName, watch, sId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Client $outer;
            private final String driverPodName$1;
            private final ObjectRef watch$1;
            private final String sId$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                do {
                    PodResource podWithName = (PodResource)this.$outer.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient.pods().withName(this.driverPodName$1);
                    this.$outer.org$apache$spark$deploy$k8s$submit$Client$$watcher.reset();
                    this.watch$1.elem = (Watch)podWithName.watch((Object)this.$outer.org$apache$spark$deploy$k8s$submit$Client$$watcher);
                    this.$outer.org$apache$spark$deploy$k8s$submit$Client$$watcher.eventReceived(Watcher.Action.MODIFIED, podWithName.get());
                } while (!this.$outer.org$apache$spark$deploy$k8s$submit$Client$$watcher.watchOrStop(this.sId$1));
                ((Watch)this.watch$1.elem).close();
                throw Breaks$.MODULE$.break();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverPodName$1 = driverPodName$1;
                this.watch$1 = watch$1;
                this.sId$1 = sId$1;
            }
        });
    }

    private void addDriverOwnerReference(Pod driverPod, Seq<HasMetadata> resources) {
        OwnerReference driverPodOwnerReference = ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withName(driverPod.getMetadata().getName())).withApiVersion(driverPod.getApiVersion())).withUid(driverPod.getMetadata().getUid())).withKind(driverPod.getKind())).withController(Predef$.MODULE$.boolean2Boolean(true))).build();
        resources.foreach((Function1)new Serializable(this, driverPodOwnerReference){
            public static final long serialVersionUID = 0L;
            private final OwnerReference driverPodOwnerReference$1;

            public final void apply(HasMetadata resource) {
                ObjectMeta originalMetadata = resource.getMetadata();
                originalMetadata.setOwnerReferences(Collections.singletonList(this.driverPodOwnerReference$1));
            }
            {
                this.driverPodOwnerReference$1 = driverPodOwnerReference$1;
            }
        });
    }

    private ConfigMap buildConfigMap(String configMapName, Map<String, String> conf) {
        Properties properties = new Properties();
        conf.foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.properties$1.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        StringWriter propertiesWriter = new StringWriter();
        properties.store(propertiesWriter, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Java properties built from Kubernetes config map with name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configMapName})));
        return ((ConfigMapBuilder)((ConfigMapFluentImpl)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), propertiesWriter.toString())).build();
    }

    public Client(KubernetesDriverBuilder builder, KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf, KubernetesClient kubernetesClient, boolean waitForAppCompletion, String appName, LoggingPodStatusWatcher watcher, String kubernetesResourceNamePrefix) {
        this.builder = builder;
        this.kubernetesConf = kubernetesConf;
        this.org$apache$spark$deploy$k8s$submit$Client$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$deploy$k8s$submit$Client$$watcher = watcher;
        this.kubernetesResourceNamePrefix = kubernetesResourceNamePrefix;
        Logging.class.$init$((Logging)this);
    }
}

