/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLoss$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionParams$class;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019IB\u0004\u0005\u0003\u0010!IAR\"\u0001\u0002\n\u0005E\u0011!a\u0004*fOJ,7o]5p]6{G-\u001a7\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u00027j]\u0006dw-\u0003\u0002\u0018)\t1a+Z2u_J\u0004\"a\u0004\u0001\u0011\u0005=Q\u0012BA\u000e\u0003\u0005Ya\u0015N\\3beJ+wM]3tg&|g\u000eU1sC6\u001c\bCA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"!E$f]\u0016\u0014\u0018\r\\'M/JLG/\u00192mK\"A1\u0005\u0001BC\u0002\u0013\u0005C%A\u0002vS\u0012,\u0012!\n\t\u0003M1r!a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\na\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111\u0006\u000b\u0015\u0004EA2\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003kI\u0012QaU5oG\u0016\f\u0013aN\u0001\u0006c9\"d\u0006\r\u0005\ts\u0001\u0011\t\u0011)A\u0005K\u0005!Q/\u001b3!Q\rA\u0004G\u000e\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005a1m\\3gM&\u001c\u0017.\u001a8ugV\t!\u0003K\u0002<a}\n\u0013\u0001Q\u0001\u0006e9\u0002d\u0006\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005%\u0005i1m\\3gM&\u001c\u0017.\u001a8ug\u0002B3!\u0011\u0019@\u0011!)\u0005A!b\u0001\n\u00031\u0015!C5oi\u0016\u00148-\u001a9u+\u00059\u0005CA\u0014I\u0013\tI\u0005F\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\tBZ\u0015%\u0001'\u0002\u000bEr3G\f\u0019\t\u00119\u0003!\u0011!Q\u0001\n\u001d\u000b!\"\u001b8uKJ\u001cW\r\u001d;!Q\ri\u0005g\u0013\u0005\t#\u0002\u0011)\u0019!C\u0001\r\u0006)1oY1mK\"\u001a\u0001\u000bM*\"\u0003Q\u000bQA\r\u00184]AB\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IaR\u0001\u0007g\u000e\fG.\u001a\u0011)\u0007U\u00034\u000b\u0003\u0004Z\u0001\u0011\u0005AAW\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baYVlX1\t\u000b\rB\u0006\u0019A\u0013)\u0007m\u0003d\u0007C\u0003=1\u0002\u0007!\u0003K\u0002^a}BQ!\u0012-A\u0002\u001dC3a\u0018\u0019L\u0011\u0015\t\u0006\f1\u0001HQ\r\t\u0007g\u0015\u0005\u00073\u0002!\t\u0001\u00023\u0015\ta)gm\u001a\u0005\u0006G\r\u0004\r!\n\u0005\u0006y\r\u0004\rA\u0005\u0005\u0006\u000b\u000e\u0004\ra\u0012\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003=!(/Y5oS:<7+^7nCJLX#A6\u0011\u0007\u001dbg.\u0003\u0002nQ\t1q\n\u001d;j_:\u0004\"aD8\n\u0005A\u0014!a\b'j]\u0016\f'OU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\"9!\u000f\u0001a\u0001\n\u0013\u0019\u0018a\u0005;sC&t\u0017N\\4Tk6l\u0017M]=`I\u0015\fHC\u0001;x!\t9S/\u0003\u0002wQ\t!QK\\5u\u0011\u001dA\u0018/!AA\u0002-\f1\u0001\u001f\u00132\u0011\u0019Q\b\u0001)Q\u0005W\u0006\u0001BO]1j]&twmU;n[\u0006\u0014\u0018\u0010\t\u0005\by\u0002\u0011\r\u0011\"\u0011~\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003y\u0004\"aJ@\n\u0007\u0005\u0005\u0001FA\u0002J]RDq!!\u0002\u0001A\u0003%a0\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005C\u0004\u0002\n\u0001!\t!a\u0003\u0002\u000fM,X.\\1ssV\ta\u000eK\u0003\u0002\bA\ny!\t\u0002\u0002\u0012\u0005)\u0011GL\u001b/a!A\u0011Q\u0003\u0001\u0005\u0002\t\t9\"\u0001\u0006tKR\u001cV/\\7bef$B!!\u0007\u0002\u001c5\t\u0001\u0001C\u0004\u0002\n\u0005M\u0001\u0019A6\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005Q\u0001.Y:Tk6l\u0017M]=\u0016\u0005\u0005\r\u0002cA\u0014\u0002&%\u0019\u0011q\u0005\u0015\u0003\u000f\t{w\u000e\\3b]\"*\u0011Q\u0004\u0019\u0002\u0010!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012\u0001C3wC2,\u0018\r^3\u0015\t\u0005E\u0012q\u0007\t\u0004\u001f\u0005M\u0012bAA\u001b\u0005\t9B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\t\u0003s\tY\u00031\u0001\u0002<\u00059A-\u0019;bg\u0016$\b\u0007BA\u001f\u0003\u001b\u0002b!a\u0010\u0002F\u0005%SBAA!\u0015\r\t\u0019EB\u0001\u0004gFd\u0017\u0002BA$\u0003\u0003\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002L\u00055C\u0002\u0001\u0003\r\u0003\u001f\n9$!A\u0001\u0002\u000b\u0005\u0011\u0011\u000b\u0002\u0004?\u0012\u0012\u0014\u0003BA*\u00033\u00022aJA+\u0013\r\t9\u0006\u000b\u0002\b\u001d>$\b.\u001b8h!\r9\u00131L\u0005\u0004\u0003;B#aA!os\"\"\u00111\u0006\u0019@\u0011!\t\u0019\u0007\u0001C\u0001\u0005\u0005\u0015\u0014\u0001\t4j]\u0012\u001cV/\\7beflu\u000eZ3m\u0003:$\u0007K]3eS\u000e$\u0018n\u001c8D_2$\"!a\u001a\u0011\u000b\u001d\nI\u0007G\u0013\n\u0007\u0005-\u0004F\u0001\u0004UkBdWM\r\u0005\b\u0003_\u0002A\u0011IA9\u0003\u001d\u0001(/\u001a3jGR$2aRA:\u0011\u001d\t)(!\u001cA\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\b\u0003s\u0002A\u0011IA>\u0003\u0011\u0019w\u000e]=\u0015\u0007a\ti\b\u0003\u0005\u0002\u0000\u0005]\u0004\u0019AAA\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD\t\u0005)\u0001/\u0019:b[&!\u00111RAC\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BA<aYBq!!%\u0001\t\u0003\n\u0019*A\u0003xe&$X-\u0006\u0002\u0002\u0016B\u0019Q$a&\n\u0007\u0005eeDA\bHK:,'/\u00197N\u0019^\u0013\u0018\u000e^3sQ\u0015\ty\tMAOC\t\ty*A\u00032]Yr\u0003\u0007K\u0002\u0001a-;q!!*\u0003\u0011\u0003\t9+A\u000bMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u0011\u0007=\tIK\u0002\u0004\u0002\u0005!\u0005\u00111V\n\t\u0003S\u000bi+a-\u0002:B\u0019q%a,\n\u0007\u0005E\u0006F\u0001\u0004B]f\u0014VM\u001a\t\u0005;\u0005U\u0006$C\u0002\u00028z\u0011!\"\u0014'SK\u0006$\u0017M\u00197f!\r9\u00131X\u0005\u0004\u0003{C#\u0001D*fe&\fG.\u001b>bE2,\u0007bB-\u0002*\u0012\u0005\u0011\u0011\u0019\u000b\u0003\u0003OC\u0001\"!2\u0002*\u0012\u0005\u0013qY\u0001\u0005e\u0016\fG-\u0006\u0002\u0002JB!Q$a3\u0019\u0013\r\tiM\b\u0002\t\u001b2\u0013V-\u00193fe\"*\u00111\u0019\u0019\u0002\u001e\"A\u00111[AU\t\u0003\n).\u0001\u0003m_\u0006$Gc\u0001\r\u0002X\"9\u0011\u0011\\Ai\u0001\u0004)\u0013\u0001\u00029bi\"DS!!51\u0003;3q!a8\u0002*\u0012\t\tOA\u000eMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0005\u0003;\fI\rC\u0004Z\u0003;$\t!!:\u0015\u0005\u0005\u001d\b\u0003BAu\u0003;l!!!+\t\u0015\u00055\u0018Q\u001cb\u0001\n\u0013\ty/A\u0005dY\u0006\u001c8OT1nKV\u0011\u0011\u0011\u001f\t\u0005\u0003g\fi0\u0004\u0002\u0002v*!\u0011q_A}\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0018\u0001\u00026bm\u0006L1!LA{\u0011%\u0011\t!!8!\u0002\u0013\t\t0\u0001\u0006dY\u0006\u001c8OT1nK\u0002B\u0001\"a5\u0002^\u0012\u0005#Q\u0001\u000b\u00041\t\u001d\u0001bBAm\u0005\u0007\u0001\r!\n\u0005\u000b\u0005\u0017\tI+!A\u0005\n\t5\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0004\u0011\t\u0005M(\u0011C\u0005\u0005\u0005'\t)P\u0001\u0004PE*,7\r\u001e\u0015\u0006\u0003S\u0003\u0014Q\u0014\u0015\u0006\u0003G\u0003\u0014Q\u0014")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
GeneralMLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> solver;
    private final Param<String> loss;
    private final DoubleParam epsilon;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LinearRegressionModel load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams$class.getEpsilon(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param x$1) {
    }

    @Override
    public final String getLoss() {
        return HasLoss$class.getLoss(this);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearRegressionTrainingSummary summary() {
        return (LinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this LinearRegressionModel");
            }
        });
    }

    public LinearRegressionModel setSummary(Option<LinearRegressionTrainingSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 != null) {
            Tuple2 tuple22;
            LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
            String predictionColName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
            LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
            String predictionColName2 = (String)tuple23._2();
            return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, new double[]{0.0});
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        Tuple2 tuple2;
        String string = this.$(this.predictionCol());
        if ("".equals(string)) {
            String predictionColName = new StringBuilder().append((Object)"prediction_").append((Object)UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (LinearRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    public LinearRegressionModel(String uid, Vector coefficients2, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        this.scale = scale;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        HasLoss$class.$init$(this);
        LinearRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients2.size();
    }

    public LinearRegressionModel(String uid, Vector coefficients2, double intercept) {
        this(uid, coefficients2, intercept, 1.0);
    }

    public static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            Tuple2 tuple2;
            block2: {
                Row row;
                block6: {
                    LinearRegressionModel linearRegressionModel;
                    DefaultParamsReader.Metadata metadata;
                    block5: {
                        Tuple3 tuple3;
                        Dataset data;
                        block3: {
                            Row row2;
                            block4: {
                                Tuple2 tuple22;
                                Tuple2.mcII.sp sp2;
                                metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                String dataPath = new Path(path, "data").toString();
                                data = this.sparkSession().read().format("parquet").load(dataPath);
                                tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                if (tuple2 == null) break block2;
                                int majorVersion = tuple2._1$mcI$sp();
                                int minorVersion = tuple2._2$mcI$sp();
                                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(majorVersion, minorVersion);
                                int majorVersion2 = sp3._1$mcI$sp();
                                int minorVersion2 = sp3._2$mcI$sp();
                                if (majorVersion2 >= 2 && (majorVersion2 != 2 || minorVersion2 > 2)) break block3;
                                row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
                                Some some = Row$.MODULE$.unapplySeq(row2);
                                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block4;
                                Object intercept = ((SeqLike)some.get()).apply(0);
                                Object coefficients2 = ((SeqLike)some.get()).apply(1);
                                if (!(intercept instanceof Double)) break block4;
                                double d = BoxesRunTime.unboxToDouble((Object)intercept);
                                if (!(coefficients2 instanceof Vector)) break block4;
                                Vector vector = (Vector)coefficients2;
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                                double intercept2 = tuple23._1$mcD$sp();
                                Vector coefficients3 = (Vector)tuple23._2();
                                linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients3, intercept2);
                                break block5;
                            }
                            throw new MatchError((Object)row2);
                        }
                        row = (Row)data.select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients", "scale"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block6;
                        Object intercept = ((SeqLike)some.get()).apply(0);
                        Object coefficients4 = ((SeqLike)some.get()).apply(1);
                        Object scale = ((SeqLike)some.get()).apply(2);
                        if (!(intercept instanceof Double)) break block6;
                        double d = BoxesRunTime.unboxToDouble((Object)intercept);
                        if (!(coefficients4 instanceof Vector)) break block6;
                        Vector vector = (Vector)coefficients4;
                        if (!(scale instanceof Double)) break block6;
                        double d2 = BoxesRunTime.unboxToDouble((Object)scale);
                        Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector, (Object)BoxesRunTime.boxToDouble((double)d2));
                        double intercept3 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                        Vector coefficients5 = (Vector)tuple32._2();
                        double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                        linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients5, intercept3, scale2);
                    }
                    LinearRegressionModel model = linearRegressionModel;
                    metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
                    return model;
                }
                throw new MatchError((Object)row);
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

