/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression$class;
import org.apache.spark.sql.catalyst.expressions.Concat$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(col1, col2, ..., colN) - Returns the concatenation of col1, col2, ..., colN.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 'SQL');\n       SparkSQL\n      > SELECT _FUNC_(array(1, 2, 3), array(4, 5), array(6));\n       [1,2,3,4,5,6]\n  ", note="Concat logic for arrays is available since 2.4.0.")
@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0001\u0003\u0001>\u0011aaQ8oG\u0006$(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!AC#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011AdQ8na2,\u0007\u0010V=qK6+'oZ5oO\u0016C\bO]3tg&|g\u000e\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001C2iS2$'/\u001a8\u0016\u0003\r\u00022\u0001\n\u0017\u0011\u001d\t)#F\u0004\u0002'S5\tqE\u0003\u0002)\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003We\tq\u0001]1dW\u0006<W-\u0003\u0002.]\t\u00191+Z9\u000b\u0005-J\u0002\u0002\u0003\u0019\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\b\u0006\u00025kA\u0011\u0011\u0003\u0001\u0005\u0006CE\u0002\ra\t\u0005\u0006o\u0001!I\u0001O\u0001\rC2dwn^3e)f\u0004Xm]\u000b\u0002sA\u0019A\u0005\f\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011!\u0002;za\u0016\u001c\u0018BA =\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003B\u0001\u0011\u0005#)A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001D!\t!u)D\u0001F\u0015\t1E!\u0001\u0005b]\u0006d\u0017p]5t\u0013\tAUIA\bUsB,7\t[3dWJ+7/\u001e7u\u0011!Q\u0005\u0001#b\u0001\n\u0003Z\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00031\u0003\"aO'\n\u00059c$\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u0011A\u0003\u0001\u0012!Q!\n1\u000b\u0011\u0002Z1uCRK\b/\u001a\u0011)\u0005=\u0013\u0006C\u0001\rT\u0013\t!\u0016DA\u0005ue\u0006t7/[3oi\")a\u000b\u0001C\u0005/\u0006A!.\u0019<b)f\u0004X-F\u0001Y!\tIFL\u0004\u0002\u00195&\u00111,G\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\3!)\u0001\r\u0001C!C\u0006Aa.\u001e7mC\ndW-F\u0001c!\tA2-\u0003\u0002e3\t9!i\\8mK\u0006t\u0007\"\u00024\u0001\t\u0003\n\u0017\u0001\u00034pY\u0012\f'\r\\3\t\u000b!\u0004A\u0011I5\u0002\t\u00154\u0018\r\u001c\u000b\u0003U6\u0004\"\u0001G6\n\u00051L\"aA!os\"9an\u001aI\u0001\u0002\u0004y\u0017!B5oaV$\bC\u00019r\u001b\u0005!\u0011B\u0001:\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u0011Q\u0004\u0001R1A\u0005\nU\f\u0001\u0002Z8D_:\u001c\u0017\r^\u000b\u0002mB!\u0001d^8k\u0013\tA\u0018DA\u0005Gk:\u001cG/[8oc!A!\u0010\u0001E\u0001B\u0003&a/A\u0005e_\u000e{gnY1uA!\u0012\u0011P\u0015\u0005\u0006{\u0002!\tF`\u0001\nI><UM\\\"pI\u0016$Ra`A\u0006\u0003+\u0001B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0011\u0011aB2pI\u0016<WM\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\ti\u0001 a\u0001\u0003\u001f\t1a\u0019;y!\u0011\t\t!!\u0005\n\t\u0005M\u00111\u0001\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\t9\u0002 a\u0001\u007f\u0006\u0011QM\u001e\u0005\b\u00037\u0001A\u0011BA\u000f\u0003i9WM\\\"pI\u00164uN\u001d(v[\n,'o\u00144FY\u0016lWM\u001c;t)\u0011\ty\"!\n\u0011\u000ba\t\t\u0003\u0017-\n\u0007\u0005\r\u0012D\u0001\u0004UkBdWM\r\u0005\t\u0003\u001b\tI\u00021\u0001\u0002\u0010!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012\u0001E4f]\u000e{G-\u001a$pe\u0006\u0013(/Y=t)\u001dA\u0016QFA\u0018\u0003gA\u0001\"!\u0004\u0002(\u0001\u0007\u0011q\u0002\u0005\b\u0003c\t9\u00031\u0001M\u0003-)G.Z7f]R$\u0016\u0010]3\t\u000f\u0005U\u0012q\u0005a\u0001E\u0006a1\r[3dW\u001a{'OT;mY\"9\u0011\u0011\b\u0001\u0005B\u0005m\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003aCQa\u0002\u0001\u0005B]C\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\t\r|\u0007/\u001f\u000b\u0004i\u0005\u0015\u0003\u0002C\u0011\u0002@A\u0005\t\u0019A\u0012\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bR3aIA(W\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA.3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA2\u0001\u0005\u0005I\u0011IA3\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0014\u0001\u00026bm\u0006L1!XA6\u0011%\t9\bAA\u0001\n\u0003\tI(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002|A\u0019\u0001$! \n\u0007\u0005}\u0014DA\u0002J]RD\u0011\"a!\u0001\u0003\u0003%\t!!\"\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!.a\"\t\u0015\u0005%\u0015\u0011QA\u0001\u0002\u0004\tY(A\u0002yIEB\u0011\"!$\u0001\u0003\u0003%\t%a$\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!%\u0011\u000b\u0005M\u0015\u0011\u00146\u000e\u0005\u0005U%bAAL3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0011\u0011U\u0001\tG\u0006tW)];bYR\u0019!-a)\t\u0013\u0005%\u0015QTA\u0001\u0002\u0004Q\u0007\"CAT\u0001\u0005\u0005I\u0011IAU\u0003\u0019)\u0017/^1mgR\u0019!-a+\t\u0013\u0005%\u0015QUA\u0001\u0002\u0004Q\u0007f\u0004\u0001\u00020\u0006U\u0016qWA^\u0003{\u000b\t-a1\u0011\u0007E\t\t,C\u0002\u00024\n\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002:\u0006\u0019vLR+O\u0007~C3m\u001c72Y\u0001\u001aw\u000e\u001c\u001a-A9rc\u0006\f\u0011d_2t\u0015\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI2p]\u000e\fG/\u001a8bi&|g\u000eI8gA\r|G.\r\u0017!G>d'\u0007\f\u0011/]9b\u0003eY8m\u001d:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\u000b\u0011q\u0007\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6(Y\u0001:3+\u0015'(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sWN\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-A\u0005\u0014(/Y=)i1\u0002S'\u000b\u0017!CJ\u0014\u0018-\u001f\u00157S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-e1\u001aD\u0006\u000e\u00176YYj&\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003\u000b\f\u0011gQ8oG\u0006$\b\u0005\\8hS\u000e\u0004cm\u001c:!CJ\u0014\u0018-_:!SN\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011tS:\u001cW\r\t\u001a/i9\u0002dfB\u0005\u0002J\n\t\t\u0011#\u0001\u0002L\u000611i\u001c8dCR\u00042!EAg\r!\t!!!A\t\u0002\u0005=7#BAg\u0003#l\u0002CBAj\u00033\u001cC'\u0004\u0002\u0002V*\u0019\u0011q[\r\u0002\u000fI,h\u000e^5nK&!\u00111\\Ak\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\be\u00055G\u0011AAp)\t\tY\r\u0003\u0006\u0002:\u00055\u0017\u0011!C#\u0003G$\"!a\u001a\t\u0015\u0005\u001d\u0018QZA\u0001\n\u0003\u000bI/A\u0003baBd\u0017\u0010F\u00025\u0003WDa!IAs\u0001\u0004\u0019\u0003BCAx\u0003\u001b\f\t\u0011\"!\u0002r\u00069QO\\1qa2LH\u0003BAz\u0003s\u0004B\u0001GA{G%\u0019\u0011q_\r\u0003\r=\u0003H/[8o\u0011%\tY0!<\u0002\u0002\u0003\u0007A'A\u0002yIAB!\"a@\u0002N\u0006\u0005I\u0011\u0002B\u0001\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0001\u0003BA5\u0005\u000bIAAa\u0002\u0002l\t1qJ\u00196fGR\u0004")
public class Concat
extends Expression
implements ComplexTypeMergingExpression,
Serializable {
    private final Seq<Expression> children;
    private transient DataType dataType;
    private transient Function1<InternalRow, Object> doConcat;
    private final transient Seq<DataType> inputTypesForMerging;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(Concat concat) {
        return Concat$.MODULE$.unapply(concat);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Concat, A> function1) {
        return Concat$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Concat> compose(Function1<A, Seq<Expression>> function1) {
        return Concat$.MODULE$.compose(function1);
    }

    private DataType dataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.children().isEmpty() ? StringType$.MODULE$ : ComplexTypeMergingExpression$class.dataType(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.dataType;
        }
    }

    private Function1 doConcat$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Object object;
                DataType dataType2 = this.dataType();
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Concat $outer;

                        public final byte[] apply(InternalRow input) {
                            Seq inputs = (Seq)this.$outer.children().map((Function1)new Serializable(this, input){
                                public static final long serialVersionUID = 0L;
                                private final InternalRow input$5;

                                public final byte[] apply(Expression x$47) {
                                    return (byte[])x$47.eval(this.input$5);
                                }
                                {
                                    this.input$5 = input$5;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            return ByteArray.concat((byte[][])((byte[][])inputs.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                } else if (StringType$.MODULE$.equals(dataType2)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Concat $outer;

                        public final UTF8String apply(InternalRow input) {
                            Seq inputs = (Seq)this.$outer.children().map((Function1)new Serializable(this, input){
                                public static final long serialVersionUID = 0L;
                                private final InternalRow input$6;

                                public final UTF8String apply(Expression x$48) {
                                    return (UTF8String)x$48.eval(this.input$6);
                                }
                                {
                                    this.input$6 = input$6;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            return UTF8String.concat((UTF8String[])((UTF8String[])inputs.toArray(ClassTag$.MODULE$.apply(UTF8String.class))));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    };
                } else {
                    if (!(dataType2 instanceof ArrayType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType elementType = arrayType2.elementType();
                    object = new Serializable(this, elementType){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Concat $outer;
                        public final DataType elementType$2;

                        public final Object apply(InternalRow input) {
                            GenericArrayData genericArrayData;
                            Stream inputs = (Stream)this.$outer.children().toStream().map((Function1)new Serializable(this, input){
                                public static final long serialVersionUID = 0L;
                                private final InternalRow input$7;

                                public final Object apply(Expression x$49) {
                                    return x$49.eval(this.input$7);
                                }
                                {
                                    this.input$7 = input$7;
                                }
                            }, Stream$.MODULE$.canBuildFrom());
                            if (inputs.contains(null)) {
                                genericArrayData = null;
                            } else {
                                Stream arrayData = (Stream)inputs.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ArrayData apply(Object x$50) {
                                        return (ArrayData)x$50;
                                    }
                                }, Stream$.MODULE$.canBuildFrom());
                                long numberOfElements = BoxesRunTime.unboxToLong((Object)arrayData.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final long apply(long sum, ArrayData ad) {
                                        return sum + (long)ad.numElements();
                                    }
                                }));
                                if (numberOfElements > (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                                    throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsuccessful try to concat arrays with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numberOfElements)}))).append((Object)" elements due to exceeding the array size limit ").append((Object)BoxesRunTime.boxToInteger((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH)).append((Object)".").toString());
                                }
                                Object[] finalData = new Object[(int)numberOfElements];
                                IntRef position2 = IntRef.create((int)0);
                                arrayData.foreach((Function1)new Serializable(this, finalData, position2){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$doConcat$3 $outer;
                                    private final Object[] finalData$1;
                                    private final IntRef position$2;

                                    public final void apply(ArrayData ad) {
                                        Object[] arr = ad.toObjectArray(this.$outer.elementType$2);
                                        Array$.MODULE$.copy((Object)arr, 0, (Object)this.finalData$1, this.position$2.elem, arr.length);
                                        this.position$2.elem += arr.length;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.finalData$1 = finalData$1;
                                        this.position$2 = position$2;
                                    }
                                });
                                genericArrayData = new GenericArrayData((Object)finalData);
                            }
                            return genericArrayData;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.elementType$2 = elementType$2;
                        }
                    };
                }
                this.doConcat = object;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.doConcat;
        }
    }

    private Seq inputTypesForMerging$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression$class.inputTypesForMerging(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.inputTypesForMerging;
        }
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression$class.dataTypeCheck(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public Seq<AbstractDataType> org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (this.children().isEmpty()) {
            typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        } else {
            Seq childTypes = (Seq)this.children().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DataType apply(Expression x$42) {
                    return x$42.dataType();
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (childTypes.exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Concat $outer;

                public final boolean apply(DataType tpe) {
                    return !this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1)new Serializable(this, tpe){
                        public static final long serialVersionUID = 0L;
                        private final DataType tpe$1;

                        public final boolean apply(AbstractDataType x$43) {
                            return x$43.acceptsType(this.tpe$1);
                        }
                        {
                            this.tpe$1 = tpe$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input to function ", " should have been ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName(), StringType$.MODULE$.simpleString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " or ", ", but it's "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BinaryType$.MODULE$.simpleString(), ArrayType$.MODULE$.simpleString()}))).append((Object)((TraversableOnce)childTypes.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(DataType x$44) {
                        return x$44.catalogString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString());
            }
            typeCheckResult = TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)childTypes, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
        }
        return typeCheckResult;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private String javaType() {
        return CodeGenerator$.MODULE$.javaType(this.dataType());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$45) {
                return x$45.nullable();
            }
        });
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$46) {
                return x$46.foldable();
            }
        });
    }

    @Override
    public Object eval(InternalRow input) {
        return this.doConcat().apply((Object)input);
    }

    private Function1<InternalRow, Object> doConcat() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.doConcat$lzycompute() : this.doConcat;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType2;
        block7: {
            Tuple2 tuple2;
            String codes;
            String hasNull;
            String args;
            block5: {
                Seq evals;
                block6: {
                    block4: {
                        evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
                            public static final long serialVersionUID = 0L;
                            private final CodegenContext ctx$13;

                            public final ExprCode apply(Expression x$51) {
                                return x$51.genCode(this.ctx$13);
                            }
                            {
                                this.ctx$13 = ctx$13;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        args = ctx.freshName("args");
                        hasNull = ctx.freshName("hasNull");
                        Seq inputs = (Seq)((TraversableLike)((IterableLike)evals.zip((GenIterable)this.children().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Expression x$52) {
                                return x$52.nullable();
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, args, hasNull){
                            public static final long serialVersionUID = 0L;
                            private final String args$1;
                            private final String hasNull$4;

                            public final String apply(Tuple2<Tuple2<ExprCode, Object>, Object> x0$6) {
                                Tuple2<Tuple2<ExprCode, Object>, Object> tuple2;
                                block4: {
                                    String string;
                                    block3: {
                                        block2: {
                                            tuple2 = x0$6;
                                            if (tuple2 == null) break block2;
                                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                                            int index = tuple2._2$mcI$sp();
                                            if (tuple22 == null) break block2;
                                            ExprCode eval2 = (ExprCode)tuple22._1();
                                            boolean bl = tuple22._2$mcZ$sp();
                                            if (!bl) break block2;
                                            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |if (!", ") {\n           |  ", "\n           |  if (!", ") {\n           |    ", "[", "] = ", ";\n           |  } else {\n           |    ", " = true;\n           |  }\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hasNull$4, eval2.code(), eval2.isNull(), this.args$1, BoxesRunTime.boxToInteger((int)index), eval2.value(), this.hasNull$4})))).stripMargin();
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        Tuple2 tuple23 = (Tuple2)tuple2._1();
                                        int index = tuple2._2$mcI$sp();
                                        if (tuple23 == null) break block4;
                                        ExprCode eval3 = (ExprCode)tuple23._1();
                                        boolean bl = tuple23._2$mcZ$sp();
                                        if (bl) break block4;
                                        string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |if (!", ") {\n           |  ", "\n           |  ", "[", "] = ", ";\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hasNull$4, eval3.code(), this.args$1, BoxesRunTime.boxToInteger((int)index), eval3.value()})))).stripMargin();
                                    }
                                    return string;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.args$1 = args$1;
                                this.hasNull$4 = hasNull$4;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.javaType()})), (Object)args);
                        Tuple2 tuple23 = new Tuple2((Object)"boolean", (Object)hasNull);
                        codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)inputs, "valueConcat", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22), "boolean", (Function1<String, String>)new Serializable(this, hasNull){
                            public static final long serialVersionUID = 0L;
                            private final String hasNull$4;

                            public final String apply(String body) {
                                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |return ", ";\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{body, this.hasNull$4})))).stripMargin();
                            }
                            {
                                this.hasNull$4 = hasNull$4;
                            }
                        }, (Function1<Seq<String>, String>)new Serializable(this, hasNull){
                            public static final long serialVersionUID = 0L;
                            public final String hasNull$4;

                            public final String apply(Seq<String> x$55) {
                                return ((TraversableOnce)x$55.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$38 $outer;

                                    public final String apply(String funcCall) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.hasNull$4, funcCall}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
                            }
                            {
                                this.hasNull$4 = hasNull$4;
                            }
                        });
                        dataType2 = this.dataType();
                        if (!BinaryType$.MODULE$.equals(dataType2)) break block4;
                        tuple2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".concat"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteArray.class.getName()})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"byte[][] ", " = new byte[", "][];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args, BoxesRunTime.boxToInteger((int)evals.length())})));
                        break block5;
                    }
                    if (!StringType$.MODULE$.equals(dataType2)) break block6;
                    tuple2 = new Tuple2((Object)"UTF8String.concat", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UTF8String[] ", " = new UTF8String[", "];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args, BoxesRunTime.boxToInteger((int)evals.length())})));
                    break block5;
                }
                if (!(dataType2 instanceof ArrayType)) break block7;
                ArrayType arrayType2 = (ArrayType)dataType2;
                DataType elementType = arrayType2.elementType();
                boolean containsNull = arrayType2.containsNull();
                String concat = this.genCodeForArrays(ctx, elementType, containsNull);
                tuple2 = new Tuple2((Object)concat, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ArrayData[] ", " = new ArrayData[", "];"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args, BoxesRunTime.boxToInteger((int)evals.length())})));
            }
            Tuple2 tuple24 = tuple2;
            if (tuple24 != null) {
                Tuple2 tuple25;
                String concat = (String)tuple24._1();
                String initCode = (String)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)concat, (Object)initCode);
                String concat2 = (String)tuple26._1();
                String initCode2 = (String)tuple26._2();
                return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " = null;\n         |if (!", ") {\n         |  ", " = ", "(", ");\n         |}\n         |boolean ", " = ", " == null;\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hasNull, initCode2, codes, this.javaType(), ev.value(), hasNull, ev.value(), concat2, args, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)dataType2);
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx) {
        String numElements = ctx.freshName("numElements");
        String z = ctx.freshName("z");
        String code2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |long ", " = 0L;\n        |for (int ", " = 0; ", " < ", "; ", "++) {\n        |  ", " += args[", "].numElements();\n        |}\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numElements, z, z, BoxesRunTime.boxToInteger((int)this.children().length()), z, numElements, z})))).stripMargin();
        return new Tuple2((Object)code2, (Object)numElements);
    }

    private String genCodeForArrays(CodegenContext ctx, DataType elementType, boolean checkForNull) {
        String counter = ctx.freshName("counter");
        String arrayData = ctx.freshName("arrayData");
        String y = ctx.freshName("y");
        String z = ctx.freshName("z");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String numElemCode = (String)tuple2._1();
            String numElemName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
            String numElemCode2 = (String)tuple23._1();
            String numElemName2 = (String)tuple23._2();
            String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElemName2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"args[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{y})), counter, z, ((ArrayType)this.dataType()).containsNull());
            String concat = ctx.freshName("concat");
            String concatDef = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |private ArrayData ", "(ArrayData[] args) {\n         |  ", "\n         |  ", "\n         |  int ", " = 0;\n         |  for (int ", " = 0; ", " < ", "; ", "++) {\n         |    for (int ", " = 0; ", " < args[", "].numElements(); ", "++) {\n         |      ", "\n         |      ", "++;\n         |    }\n         |  }\n         |  return ", ";\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{concat, numElemCode2, initialization, counter, y, y, BoxesRunTime.boxToInteger((int)this.children().length()), y, z, z, y, z, assignment, counter, arrayData})))).stripMargin();
            return ctx.addNewFunction(concat, concatDef, ctx.addNewFunction$default$3());
        }
        throw new MatchError(tuple2);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"concat(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.children().mkString(", ")}));
    }

    @Override
    public String sql() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"concat(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.children().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$58) {
                return x$58.sql();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}));
    }

    public Concat copy(Seq<Expression> children2) {
        return new Concat(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Concat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Concat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Concat)) return false;
        boolean bl = true;
        if (!bl) return false;
        Concat concat = (Concat)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = concat.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!concat.canEqual(this)) return false;
        return true;
    }

    public Concat(Seq<Expression> children2) {
        this.children = children2;
        ComplexTypeMergingExpression$class.$init$(this);
    }
}

