/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.repl.ConstructorCleaner;
import org.apache.spark.util.ParentClassLoader;
import org.apache.xbean.asm6.ClassReader;
import org.apache.xbean.asm6.ClassVisitor;
import org.apache.xbean.asm6.ClassWriter;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003(\u0011!i\u0005A!A!\u0002\u0013q\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B/\t\u000f\u0011\u0004!\u0019!C\u0001K\"1\u0001\u000e\u0001Q\u0001\n\u0019Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004r\u0001\u0001\u0006Ia\u001b\u0005\te\u0002\u0001\r\u0011\"\u0001\u001eg\"Aq\u000f\u0001a\u0001\n\u0003i\u0002\u0010\u0003\u0004\u007f\u0001\u0001\u0006K\u0001\u001e\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011Q\u0003\u0001!\u0002\u0013\t\u0019\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA\u001e\u0001\u0011%\u0011Q\b\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u0011q\u0017\u0001\u0005\u0002\u0005e&aE#yK\u000e,Ho\u001c:DY\u0006\u001c8\u000fT8bI\u0016\u0014(B\u0001\u0010 \u0003\u0011\u0011X\r\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001O=\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013FA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a \u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001b2\u0005\u001daunZ4j]\u001e\fAaY8oMB\u0011q\u0007O\u0007\u0002?%\u0011\u0011h\b\u0002\n'B\f'o[\"p]\u001a\f1!\u001a8w!\t9D(\u0003\u0002>?\tA1\u000b]1sW\u0016sg/\u0001\u0005dY\u0006\u001c8/\u0016:j!\t\u0001\u0015J\u0004\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\u0011A)J\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011\u0016\u000ba\u0001]1sK:$\u0018AE;tKJ\u001cE.Y:t!\u0006$\bNR5sgR\u0004\"a\u0014)\u000e\u0003\u0015K!!U#\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"b\u0001\u0016,X1fS\u0006CA+\u0001\u001b\u0005i\u0002\"B\u001b\u0007\u0001\u00041\u0004\"\u0002\u001e\u0007\u0001\u0004Y\u0004\"\u0002 \u0007\u0001\u0004y\u0004\"\u0002'\u0007\u0001\u00049\u0003\"B'\u0007\u0001\u0004q\u0015aA;sSV\tQ\f\u0005\u0002_C6\tqL\u0003\u0002aW\u0005\u0019a.\u001a;\n\u0005\t|&aA+S\u0013\u0006!QO]5!\u0003%!\u0017N]3di>\u0014\u00180F\u0001g!\tAs-\u0003\u0002KS\u0005QA-\u001b:fGR|'/\u001f\u0011\u0002\u0019A\f'/\u001a8u\u0019>\fG-\u001a:\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\\\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003a6\u0014\u0011\u0003U1sK:$8\t\\1tg2{\u0017\rZ3s\u00035\u0001\u0018M]3oi2{\u0017\rZ3sA\u0005q\u0002\u000e\u001e;q+Jd7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;NS2d\u0017n]\u000b\u0002iB\u0011q*^\u0005\u0003m\u0016\u00131!\u00138u\u0003\tBG\u000f\u001e9Ve2\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^'jY2L7o\u0018\u0013fcR\u0011\u0011\u0010 \t\u0003\u001fjL!a_#\u0003\tUs\u0017\u000e\u001e\u0005\b{:\t\t\u00111\u0001u\u0003\rAH%M\u0001 QR$\b/\u0016:m\u0007>tg.Z2uS>tG+[7f_V$X*\u001b7mSN\u0004\u0013a\u00024fi\u000eDgI\\\u000b\u0003\u0003\u0007\u0001baTA\u0003\u007f\u0005%\u0011bAA\u0004\u000b\nIa)\u001e8di&|g.\r\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB\u0016\u0002\u0005%|\u0017\u0002BA\n\u0003\u001b\u00111\"\u00138qkR\u001cFO]3b[\u0006Aa-\u001a;dQ\u001as\u0007%A\u0006hKR\u0014Vm]8ve\u000e,G\u0003BA\u000e\u0003C\u00012AXA\u000f\u0013\r\tyb\u0018\u0002\u0004+Jc\u0005BBA\u0012%\u0001\u0007q(\u0001\u0003oC6,\u0017\u0001D4fiJ+7o\\;sG\u0016\u001cH\u0003BA\u0015\u0003g\u0001b!a\u000b\u00020\u0005mQBAA\u0017\u0015\tq7&\u0003\u0003\u00022\u00055\"aC#ok6,'/\u0019;j_:Da!a\t\u0014\u0001\u0004y\u0014aE4fiJ+7o\\;sG\u0016\f5o\u0015;sK\u0006lG\u0003BA\u0005\u0003sAa!a\t\u0015\u0001\u0004y\u0014aH4fi\u000ec\u0017m]:SKN|WO]2f\u0003N\u001cFO]3b[2{7-\u00197msR!\u0011\u0011BA \u0011\u0019\t\u0019#\u0006a\u0001\u007f\u0005Ia-\u001b8e\u00072\f7o\u001d\u000b\u0005\u0003\u000b\n\u0019\u0007\r\u0003\u0002H\u0005E\u0003#\u0002!\u0002J\u00055\u0013bAA&\u0017\n)1\t\\1tgB!\u0011qJA)\u0019\u0001!1\"a\u0015\u0017\u0003\u0003\u0005\tQ!\u0001\u0002V\t\u0019q\fJ\u0019\u0012\t\u0005]\u0013Q\f\t\u0004\u001f\u0006e\u0013bAA.\u000b\n9aj\u001c;iS:<\u0007cA(\u0002`%\u0019\u0011\u0011M#\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002$Y\u0001\raP\u0001$O\u0016$8\t\\1tg\u001aKG.Z%oaV$8\u000b\u001e:fC64%o\\7Ta\u0006\u00148N\u0015)D)\u0011\tI!!\u001b\t\r\u0005-t\u00031\u0001@\u0003\u0011\u0001\u0018\r\u001e5\u0002K\u001d,Go\u00117bgN4\u0015\u000e\\3J]B,Ho\u0015;sK\u0006lgI]8n\r&dWmU=ti\u0016lG\u0003BA9\u0003o\"B!!\u0003\u0002t!1\u0011Q\u000f\rA\u0002}\nq\u0002]1uQ&sG)\u001b:fGR|'/\u001f\u0005\b\u0003sB\u0002\u0019AA>\u0003)1\u0017\u000e\\3TsN$X-\u001c\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003\t17OC\u0002\u0002\u0006\u0006\na\u0001[1e_>\u0004\u0018\u0002BAE\u0003\u007f\u0012!BR5mKNK8\u000f^3n\u0003A1\u0017N\u001c3DY\u0006\u001c8\u000fT8dC2d\u0017\u0010\u0006\u0003\u0002\u0010\u0006}\u0005#B(\u0002\u0012\u0006U\u0015bAAJ\u000b\n1q\n\u001d;j_:\u0004D!a&\u0002\u001cB)\u0001)!\u0013\u0002\u001aB!\u0011qJAN\t-\ti*GA\u0001\u0002\u0003\u0015\t!!\u0016\u0003\u0007}##\u0007\u0003\u0004\u0002$e\u0001\raP\u0001\u0016e\u0016\fG-\u00118e)J\fgn\u001d4pe6\u001cE.Y:t)\u0019\t)+!-\u00024B)q*a*\u0002,&\u0019\u0011\u0011V#\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u000bi+C\u0002\u00020\u0016\u0013AAQ=uK\"1\u00111\u0005\u000eA\u0002}Bq!!.\u001b\u0001\u0004\tI!\u0001\u0002j]\u0006IQO\u001d7F]\u000e|G-\u001a\u000b\u0004\u007f\u0005m\u0006BBA_7\u0001\u0007q(A\u0002tiJ\u0004")
public class ExecutorClassLoader
extends ClassLoader
implements Logging {
    private final SparkEnv env;
    private final String classUri;
    private final boolean userClassPathFirst;
    private final URI uri;
    private final String directory;
    private final ParentClassLoader parentLoader;
    private int httpUrlConnectionTimeoutMillis;
    private final Function1<String, InputStream> fetchFn;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public URI uri() {
        return this.uri;
    }

    public String directory() {
        return this.directory;
    }

    public ParentClassLoader parentLoader() {
        return this.parentLoader;
    }

    public int httpUrlConnectionTimeoutMillis() {
        return this.httpUrlConnectionTimeoutMillis;
    }

    public void httpUrlConnectionTimeoutMillis_$eq(int x$1) {
        this.httpUrlConnectionTimeoutMillis = x$1;
    }

    private Function1<String, InputStream> fetchFn() {
        return this.fetchFn;
    }

    @Override
    public URL getResource(String name) {
        return this.parentLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.parentLoader().getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream res;
        InputStream res2;
        InputStream inputStream = this.userClassPathFirst ? ((res2 = this.getClassResourceAsStreamLocally(name)) != null ? res2 : this.parentLoader().getResourceAsStream(name)) : ((res = this.parentLoader().getResourceAsStream(name)) != null ? res : this.getClassResourceAsStreamLocally(name));
        return inputStream;
    }

    private InputStream getClassResourceAsStreamLocally(String name) {
        InputStream inputStream;
        block3: {
            try {
                if (name.endsWith(".class")) {
                    inputStream = (InputStream)this.fetchFn().apply((Object)name);
                    break block3;
                }
                inputStream = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                inputStream = null;
            }
        }
        return inputStream;
    }

    @Override
    public Class<?> findClass(String name) {
        Class clazz;
        if (this.userClassPathFirst) {
            clazz = (Class)this.findClassLocally(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.parentLoader().loadClass(name));
        } else {
            try {
                clazz = this.parentLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                Class a;
                Option<Class<?>> classOption;
                Option<Class<?>> option = classOption = this.findClassLocally(name);
                if (None$.MODULE$.equals(option)) {
                    throw new ClassNotFoundException(name, e);
                }
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                Class clazz2 = a = (Class)some.value();
                clazz = clazz2;
            }
        }
        return clazz;
    }

    private InputStream getClassFileInputStreamFromSparkRPC(String path) {
        ReadableByteChannel channel = this.env.rpcEnv().openChannel(new StringBuilder(1).append(this.classUri).append("/").append(path).toString());
        return new FilterInputStream(null, channel, path){
            private final String path$1;

            private /* synthetic */ int super$read() {
                return super.read();
            }

            private /* synthetic */ int super$read(byte[] x$1) {
                return super.read(x$1);
            }

            private /* synthetic */ int super$read(byte[] x$1, int x$2, int x$3) {
                return super.read(x$1, x$2, x$3);
            }

            public int read() {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read());
            }

            public int read(byte[] b) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read(b));
            }

            public int read(byte[] b, int offset, int len) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read(b, offset, len));
            }

            private int toClassNotFound(Function0<Object> fn) {
                int n;
                try {
                    n = fn.apply$mcI$sp();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(this.path$1, e);
                }
                return n;
            }
            {
                this.path$1 = path$1;
                super(Channels.newInputStream(channel$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(org.apache.spark.repl.ExecutorClassLoader$$anon$1 ), $anonfun$read$2(org.apache.spark.repl.ExecutorClassLoader$$anon$1 byte[] ), $anonfun$read$3(org.apache.spark.repl.ExecutorClassLoader$$anon$1 byte[] int int )}, serializedLambda);
            }
        };
    }

    private InputStream getClassFileInputStreamFromFileSystem(FileSystem fileSystem, String pathInDirectory) {
        FSDataInputStream fSDataInputStream;
        Path path = new Path(this.directory(), pathInDirectory);
        try {
            fSDataInputStream = fileSystem.open(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException(new StringBuilder(29).append("Class file not found at path ").append(path).toString());
        }
        return fSDataInputStream;
    }

    public Option<Class<?>> findClassLocally(String name) {
        None$ none$;
        block10: {
            None$ none$2;
            String pathInDirectory = new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = (InputStream)this.fetchFn().apply((Object)pathInDirectory);
                    byte[] bytes = this.readAndTransformClass(name, inputStream);
                    none$2 = new Some(this.defineClass(name, bytes, 0, bytes.length));
                }
                catch (ClassNotFoundException e) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Did not load class ").append(name).append(" from REPL class server at ").append(this.uri()).toString(), e);
                    none$2 = None$.MODULE$;
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Failed to check existence of class ").append(name).append(" on REPL class server at ").append(this.uri()).toString(), e);
                    none$2 = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing inputStream", e);
                    }
                }
                throw throwable;
            }
            none$ = none$2;
            if (inputStream == null) break block10;
            try {
                inputStream.close();
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing inputStream", e);
            }
        }
        return none$;
    }

    public byte[] readAndTransformClass(String name, InputStream in) {
        if (name.startsWith("line") && name.endsWith("$iw$")) {
            ClassReader cr = new ClassReader(in);
            ClassWriter cw = new ClassWriter(3);
            ConstructorCleaner cleaner = new ConstructorCleaner(name, (ClassVisitor)cw);
            cr.accept((ClassVisitor)cleaner, 0);
            return cw.toByteArray();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        boolean done = false;
        while (!done) {
            int num = in.read(bytes);
            if (num >= 0) {
                bos.write(bytes, 0, num);
                continue;
            }
            done = true;
        }
        return bos.toByteArray();
    }

    public String urlEncode(String str) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split('/'))).map((Function1 & Serializable & scala.Serializable)part -> URLEncoder.encode(part, "UTF-8"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/");
    }

    public ExecutorClassLoader(SparkConf conf, SparkEnv env, String classUri, ClassLoader parent, boolean userClassPathFirst) {
        Function1 & Serializable & scala.Serializable intersect;
        this.env = env;
        this.classUri = classUri;
        this.userClassPathFirst = userClassPathFirst;
        super(null);
        Logging.$init$((Logging)this);
        this.uri = new URI(classUri);
        this.directory = this.uri().getPath();
        this.parentLoader = new ParentClassLoader(parent);
        this.httpUrlConnectionTimeoutMillis = -1;
        String string = this.uri().getScheme();
        if ("spark".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)path -> this.getClassFileInputStreamFromSparkRPC((String)path);
        } else {
            FileSystem fileSystem = FileSystem.get((URI)this.uri(), (Configuration)SparkHadoopUtil$.MODULE$.get().newConfiguration(conf));
            intersect = (Function1 & Serializable & scala.Serializable)pathInDirectory -> this.getClassFileInputStreamFromFileSystem(fileSystem, (String)pathInDirectory);
        }
        this.fetchFn = intersect;
    }
}

