/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppStatusUtils$;
import org.apache.spark.status.api.v1.AccumulableInfo;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskMetrics;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.ExecutorTable;
import org.apache.spark.ui.jobs.StagesTab;
import org.apache.spark.ui.jobs.TaskDetailsClassNames$;
import org.apache.spark.ui.jobs.TaskPagedTable;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001u4Qa\u0003\u0007\u0001\u001dYA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tC\u0001\u0011\t\u0011)A\u0005E!)\u0001\u0006\u0001C\u0001S!9Q\u0006\u0001b\u0001\n\u0013q\u0003BB\u001c\u0001A\u0003%q\u0006C\u00049\u0001\t\u0007I\u0011B\u001d\t\ry\u0002\u0001\u0015!\u0003;\u0011\u0015y\u0004\u0001\"\u0003A\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015q\u0007\u0001\"\u0001p\u0005%\u0019F/Y4f!\u0006<WM\u0003\u0002\u000e\u001d\u0005!!n\u001c2t\u0015\ty\u0001#\u0001\u0002vS*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0005\u0002\u0001/A\u0011\u0001$G\u0007\u0002\u001d%\u0011!D\u0004\u0002\n/\u0016\u0014W+\u0013)bO\u0016\fa\u0001]1sK:$8\u0001\u0001\t\u0003=}i\u0011\u0001D\u0005\u0003A1\u0011\u0011b\u0015;bO\u0016\u001cH+\u00192\u0002\u000bM$xN]3\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0002\u0012AB:uCR,8/\u0003\u0002(I\tq\u0011\t\u001d9Ti\u0006$Xo]*u_J,\u0017A\u0002\u001fj]&$h\bF\u0002+W1\u0002\"A\b\u0001\t\u000bm\u0019\u0001\u0019A\u000f\t\u000b\u0005\u001a\u0001\u0019\u0001\u0012\u0002\u001fQKU*\u0012'J\u001d\u0016{F*R$F\u001d\u0012+\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\n1\u0001_7m\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c2\u0005\u0011)E.Z7\u0002!QKU*\u0012'J\u001d\u0016{F*R$F\u001d\u0012\u0003\u0013AE'B1~#\u0016*T#M\u0013:+u\fV!T\u0017N+\u0012A\u000f\t\u0003wqj\u0011aM\u0005\u0003{M\u00121!\u00138u\u0003Mi\u0015\tW0U\u00136+E*\u0013(F?R\u000b5kS*!\u0003a9W\r\u001e'pG\u0006d\u0017\u000e^=Tk6l\u0017M]=TiJLgn\u001a\u000b\u0003\u00032\u0003\"AQ%\u000f\u0005\r;\u0005C\u0001#4\u001b\u0005)%B\u0001$\u001d\u0003\u0019a$o\\8u}%\u0011\u0001jM\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002Ig!)Q\n\u0003a\u0001\u001d\u0006yAn\\2bY&$\u0018pU;n[\u0006\u0014\u0018\u0010\u0005\u0003C\u001f\u0006\u000b\u0016B\u0001)L\u0005\ri\u0015\r\u001d\t\u0003wIK!aU\u001a\u0003\t1{gnZ\u0001\u0007e\u0016tG-\u001a:\u0015\u0005Y\u0013\u0007cA,]?:\u0011\u0001L\u0017\b\u0003\tfK\u0011\u0001N\u0005\u00037N\nq\u0001]1dW\u0006<W-\u0003\u0002^=\n\u00191+Z9\u000b\u0005m\u001b\u0004C\u0001\u0019a\u0013\t\t\u0017G\u0001\u0003O_\u0012,\u0007\"B2\n\u0001\u0004!\u0017a\u0002:fcV,7\u000f\u001e\t\u0003K2l\u0011A\u001a\u0006\u0003O\"\fA\u0001\u001b;ua*\u0011\u0011N[\u0001\bg\u0016\u0014h\u000f\\3u\u0015\u0005Y\u0017!\u00026bm\u0006D\u0018BA7g\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\u0002\u00195\f7.\u001a+j[\u0016d\u0017N\\3\u0015\u0007Y\u00038\u0010C\u0003r\u0015\u0001\u0007!/A\u0003uCN\\7\u000fE\u0002X9N\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0005Y\f$B\u0001=%\u0003\r\t\u0007/[\u0005\u0003uV\u0014\u0001\u0002V1tW\u0012\u000bG/\u0019\u0005\u0006y*\u0001\r!U\u0001\fGV\u0014(/\u001a8u)&lW\r")
public class StagePage
extends WebUIPage {
    private final StagesTab parent;
    private final AppStatusStore store;
    private final Elem TIMELINE_LEGEND;
    private final int MAX_TIMELINE_TASKS;

    private Elem TIMELINE_LEGEND() {
        return this.TIMELINE_LEGEND;
    }

    private int MAX_TIMELINE_TASKS() {
        return this.MAX_TIMELINE_TASKS;
    }

    private String getLocalitySummaryString(Map<String, Object> localitySummary) {
        Map names = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.PROCESS_LOCAL().toString()), (Object)"Process local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.NODE_LOCAL().toString()), (Object)"Node local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.RACK_LOCAL().toString()), (Object)"Rack local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.ANY().toString()), (Object)"Any")}));
        Seq localityNamesAndCounts = ((TraversableOnce)names.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String name = (String)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(localitySummary.get((Object)key).map((Function1 & Serializable & scala.Serializable)count -> StagePage.$anonfun$getLocalitySummaryString$2(name, BoxesRunTime.unboxToLong((Object)count))));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ((TraversableOnce)localityNamesAndCounts.sorted((Ordering)Ordering.String$.MODULE$)).mkString("; ");
    }

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        Seq<Node> seq;
        Object object = new Object();
        try {
            Seq seq2;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            String parameterId = UIUtils$.MODULE$.stripXSS(request.getParameter("id"));
            Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing id parameter");
            String parameterAttempt = UIUtils$.MODULE$.stripXSS(request.getParameter("attempt"));
            Predef$.MODULE$.require(parameterAttempt != null && new StringOps(Predef$.MODULE$.augmentString(parameterAttempt)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing attempt parameter");
            String parameterTaskPage = UIUtils$.MODULE$.stripXSS(request.getParameter("task.page"));
            String parameterTaskSortColumn = UIUtils$.MODULE$.stripXSS(request.getParameter("task.sort"));
            String parameterTaskSortDesc = UIUtils$.MODULE$.stripXSS(request.getParameter("task.desc"));
            String parameterTaskPageSize = UIUtils$.MODULE$.stripXSS(request.getParameter("task.pageSize"));
            String parameterTaskPrevPageSize = UIUtils$.MODULE$.stripXSS(request.getParameter("task.prevPageSize"));
            int taskPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterTaskPage).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StagePage.$anonfun$render$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            String taskSortColumn = (String)Option$.MODULE$.apply((Object)parameterTaskSortColumn).map((Function1 & Serializable & scala.Serializable)sortColumn -> UIUtils$.MODULE$.decodeURLParameter((String)sortColumn)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "Index");
            boolean taskSortDesc = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)parameterTaskSortDesc).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StagePage.$anonfun$render$7(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            int taskPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterTaskPageSize).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StagePage.$anonfun$render$9(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
            int taskPrevPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterTaskPrevPageSize).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StagePage.$anonfun$render$11(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> taskPageSize));
            int stageId = new StringOps(Predef$.MODULE$.augmentString(parameterId)).toInt();
            int stageAttemptId = new StringOps(Predef$.MODULE$.augmentString(parameterAttempt)).toInt();
            String stageHeader = new StringBuilder(29).append("Details for Stage ").append(stageId).append(" (Attempt ").append(stageAttemptId).append(")").toString();
            StageData stageData = (StageData)this.parent.store().asOption((Function0 & Serializable & scala.Serializable)() -> $this.parent.store().stageAttempt(stageId, stageAttemptId, false)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("No information to display for Stage "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageId));
                $buf2.$amp$plus((Object)new Text(" (Attempt "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageAttemptId));
                $buf2.$amp$plus((Object)new Text(")"));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem content = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                throw new NonLocalReturnControl(object, UIUtils$.MODULE$.headerSparkPage(request, stageHeader, (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, $this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8()));
            });
            Map<String, Object> localitySummary = this.store.localitySummary(stageData.stageId(), stageData.attemptId());
            int totalTasks = stageData.numActiveTasks() + stageData.numCompleteTasks() + stageData.numFailedTasks() + stageData.numKilledTasks();
            if (totalTasks == 0) {
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("Summary Metrics"));
                $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text(" No tasks have started yet\n          "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("Tasks"));
                $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text(" No tasks have started yet\n        "));
                Elem content = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                return UIUtils$.MODULE$.headerSparkPage(request, stageHeader, (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8());
            }
            long storedTasks = this.store.taskCount(stageData.stageId(), stageData.attemptId());
            int numCompleted = stageData.numCompleteTasks();
            String totalTasksNumStr = (long)totalTasks == storedTasks ? String.valueOf(BoxesRunTime.boxToInteger((int)totalTasks)) : new StringBuilder(10).append(totalTasks).append(", showing ").append(storedTasks).toString();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Total Time Across All Tasks: "));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDuration(stageData.executorRunTime()));
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Locality Level Summary: "));
            $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)this.getLocalitySummaryString(localitySummary));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasInput(stageData)) {
                NodeBuffer $buf9 = new NodeBuffer();
                $buf9.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf10 = new NodeBuffer();
                $buf10.$amp$plus((Object)new Text("Input Size / Records: "));
                $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
                $buf9.$amp$plus((Object)new Text("\n              "));
                $buf9.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData.inputBytes())).append(" / ").append(stageData.inputRecords()).toString());
                $buf9.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9);
                boxedUnit6 = elem;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit6);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasOutput(stageData)) {
                NodeBuffer $buf11 = new NodeBuffer();
                $buf11.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf12 = new NodeBuffer();
                $buf12.$amp$plus((Object)new Text("Output: "));
                $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
                $buf11.$amp$plus((Object)new Text("\n              "));
                $buf11.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData.outputBytes())).append(" / ").append(stageData.outputRecords()).toString());
                $buf11.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11);
                boxedUnit5 = elem;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit5);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasShuffleRead(stageData)) {
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf14 = new NodeBuffer();
                $buf14.$amp$plus((Object)new Text("Shuffle Read: "));
                $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
                $buf13.$amp$plus((Object)new Text("\n              "));
                $buf13.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData.shuffleReadBytes())).append(" / ").append(stageData.shuffleReadRecords()).toString());
                $buf13.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13);
                boxedUnit4 = elem;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit4);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasShuffleWrite(stageData)) {
                NodeBuffer $buf15 = new NodeBuffer();
                $buf15.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf16 = new NodeBuffer();
                $buf16.$amp$plus((Object)new Text("Shuffle Write: "));
                $buf15.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
                $buf15.$amp$plus((Object)new Text("\n               "));
                $buf15.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString(stageData.shuffleWriteBytes())).append(" / ").append(stageData.shuffleWriteRecords()).toString());
                $buf15.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15);
                boxedUnit3 = elem;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit3);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasBytesSpilled(stageData)) {
                NodeBuffer $buf17 = new NodeBuffer();
                NodeBuffer $buf18 = new NodeBuffer();
                $buf18.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf19 = new NodeBuffer();
                $buf19.$amp$plus((Object)new Text("Shuffle Spill (Memory): "));
                $buf18.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19));
                $buf18.$amp$plus((Object)new Text("\n              "));
                $buf18.$amp$plus((Object)Utils$.MODULE$.bytesToString(stageData.memoryBytesSpilled()));
                $buf18.$amp$plus((Object)new Text("\n            "));
                $buf17.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
                NodeBuffer $buf20 = new NodeBuffer();
                $buf20.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf21 = new NodeBuffer();
                $buf21.$amp$plus((Object)new Text("Shuffle Spill (Disk): "));
                $buf20.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
                $buf20.$amp$plus((Object)new Text("\n              "));
                $buf20.$amp$plus((Object)Utils$.MODULE$.bytesToString(stageData.diskBytesSpilled()));
                $buf20.$amp$plus((Object)new Text("\n            "));
                $buf17.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
                boxedUnit2 = $buf17;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit2);
            $buf4.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("\n        "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-additional-metrics"), (MetaData)$md2);
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n          "));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", (Seq)new Text("expand-additional-metrics-arrow arrow-closed"), (MetaData)$md3);
            $buf23.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf23.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("Show Additional Metrics"));
            $buf23.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24));
            $buf23.$amp$plus((Object)new Text("\n        "));
            $buf22.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
            $buf22.$amp$plus((Object)new Text("\n        "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("class", (Seq)new Text("additional-metrics collapsed"), (MetaData)$md4);
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("\n                "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("id", (Seq)new Text("select-all-metrics"), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md5);
            $buf27.$amp$plus((Object)new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf27.$amp$plus((Object)new Text("\n                "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md6);
            NodeBuffer $buf28 = new NodeBuffer();
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("(De)select All"));
            $buf28.$amp$plus((Object)new Elem(null, "em", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29));
            $buf27.$amp$plus((Object)new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28));
            $buf27.$amp$plus((Object)new Text("\n            "));
            $buf26.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27));
            $buf26.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("\n              "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md7);
            $md7 = new UnprefixedAttribute("title", ToolTips$.MODULE$.SCHEDULER_DELAY(), (MetaData)$md7);
            $md7 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md7);
            NodeBuffer $buf31 = new NodeBuffer();
            $buf31.$amp$plus((Object)new Text("\n                "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.SCHEDULER_DELAY(), (MetaData)$md8);
            $md8 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md8);
            $buf31.$amp$plus((Object)new Elem(null, "input", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf31.$amp$plus((Object)new Text("\n                "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md9);
            NodeBuffer $buf32 = new NodeBuffer();
            $buf32.$amp$plus((Object)new Text("Scheduler Delay"));
            $buf31.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf32));
            $buf31.$amp$plus((Object)new Text("\n              "));
            $buf30.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf31));
            $buf30.$amp$plus((Object)new Text("\n            "));
            $buf26.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf30));
            $buf26.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf33 = new NodeBuffer();
            $buf33.$amp$plus((Object)new Text("\n              "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md10);
            $md10 = new UnprefixedAttribute("title", ToolTips$.MODULE$.TASK_DESERIALIZATION_TIME(), (MetaData)$md10);
            $md10 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md10);
            NodeBuffer $buf34 = new NodeBuffer();
            $buf34.$amp$plus((Object)new Text("\n                "));
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.TASK_DESERIALIZATION_TIME(), (MetaData)$md11);
            $md11 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md11);
            $buf34.$amp$plus((Object)new Elem(null, "input", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf34.$amp$plus((Object)new Text("\n                "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md12);
            NodeBuffer $buf35 = new NodeBuffer();
            $buf35.$amp$plus((Object)new Text("Task Deserialization Time"));
            $buf34.$amp$plus((Object)new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf35));
            $buf34.$amp$plus((Object)new Text("\n              "));
            $buf33.$amp$plus((Object)new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf34));
            $buf33.$amp$plus((Object)new Text("\n            "));
            $buf26.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf33));
            $buf26.$amp$plus((Object)new Text("\n            "));
            if (stageData.shuffleReadBytes() > 0L) {
                NodeBuffer $buf36 = new NodeBuffer();
                NodeBuffer $buf37 = new NodeBuffer();
                $buf37.$amp$plus((Object)new Text("\n                "));
                Null$ $md13 = Null$.MODULE$;
                $md13 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md13);
                $md13 = new UnprefixedAttribute("title", ToolTips$.MODULE$.SHUFFLE_READ_BLOCKED_TIME(), (MetaData)$md13);
                $md13 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md13);
                NodeBuffer $buf38 = new NodeBuffer();
                $buf38.$amp$plus((Object)new Text("\n                  "));
                Null$ $md14 = Null$.MODULE$;
                $md14 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.SHUFFLE_READ_BLOCKED_TIME(), (MetaData)$md14);
                $md14 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md14);
                $buf38.$amp$plus((Object)new Elem(null, "input", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf38.$amp$plus((Object)new Text("\n                  "));
                Null$ $md15 = Null$.MODULE$;
                $md15 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md15);
                NodeBuffer $buf39 = new NodeBuffer();
                $buf39.$amp$plus((Object)new Text("Shuffle Read Blocked Time"));
                $buf38.$amp$plus((Object)new Elem(null, "span", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf39));
                $buf38.$amp$plus((Object)new Text("\n                "));
                $buf37.$amp$plus((Object)new Elem(null, "span", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf38));
                $buf37.$amp$plus((Object)new Text("\n              "));
                $buf36.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf37));
                NodeBuffer $buf40 = new NodeBuffer();
                $buf40.$amp$plus((Object)new Text("\n                "));
                Null$ $md16 = Null$.MODULE$;
                $md16 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md16);
                $md16 = new UnprefixedAttribute("title", ToolTips$.MODULE$.SHUFFLE_READ_REMOTE_SIZE(), (MetaData)$md16);
                $md16 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md16);
                NodeBuffer $buf41 = new NodeBuffer();
                $buf41.$amp$plus((Object)new Text("\n                  "));
                Null$ $md17 = Null$.MODULE$;
                $md17 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.SHUFFLE_READ_REMOTE_SIZE(), (MetaData)$md17);
                $md17 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md17);
                $buf41.$amp$plus((Object)new Elem(null, "input", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf41.$amp$plus((Object)new Text("\n                  "));
                Null$ $md18 = Null$.MODULE$;
                $md18 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md18);
                NodeBuffer $buf42 = new NodeBuffer();
                $buf42.$amp$plus((Object)new Text("Shuffle Remote Reads"));
                $buf41.$amp$plus((Object)new Elem(null, "span", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf42));
                $buf41.$amp$plus((Object)new Text("\n                "));
                $buf40.$amp$plus((Object)new Elem(null, "span", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf41));
                $buf40.$amp$plus((Object)new Text("\n              "));
                $buf36.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf40));
                boxedUnit = $buf36;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf26.$amp$plus((Object)boxedUnit);
            $buf26.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf43 = new NodeBuffer();
            $buf43.$amp$plus((Object)new Text("\n              "));
            Null$ $md19 = Null$.MODULE$;
            $md19 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md19);
            $md19 = new UnprefixedAttribute("title", ToolTips$.MODULE$.RESULT_SERIALIZATION_TIME(), (MetaData)$md19);
            $md19 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md19);
            NodeBuffer $buf44 = new NodeBuffer();
            $buf44.$amp$plus((Object)new Text("\n                "));
            Null$ $md20 = Null$.MODULE$;
            $md20 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.RESULT_SERIALIZATION_TIME(), (MetaData)$md20);
            $md20 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md20);
            $buf44.$amp$plus((Object)new Elem(null, "input", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf44.$amp$plus((Object)new Text("\n                "));
            Null$ $md21 = Null$.MODULE$;
            $md21 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md21);
            NodeBuffer $buf45 = new NodeBuffer();
            $buf45.$amp$plus((Object)new Text("Result Serialization Time"));
            $buf44.$amp$plus((Object)new Elem(null, "span", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf45));
            $buf44.$amp$plus((Object)new Text("\n              "));
            $buf43.$amp$plus((Object)new Elem(null, "span", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf44));
            $buf43.$amp$plus((Object)new Text("\n            "));
            $buf26.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf43));
            $buf26.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf46 = new NodeBuffer();
            $buf46.$amp$plus((Object)new Text("\n              "));
            Null$ $md22 = Null$.MODULE$;
            $md22 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md22);
            $md22 = new UnprefixedAttribute("title", ToolTips$.MODULE$.GETTING_RESULT_TIME(), (MetaData)$md22);
            $md22 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md22);
            NodeBuffer $buf47 = new NodeBuffer();
            $buf47.$amp$plus((Object)new Text("\n                "));
            Null$ $md23 = Null$.MODULE$;
            $md23 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.GETTING_RESULT_TIME(), (MetaData)$md23);
            $md23 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md23);
            $buf47.$amp$plus((Object)new Elem(null, "input", (MetaData)$md23, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf47.$amp$plus((Object)new Text("\n                "));
            Null$ $md24 = Null$.MODULE$;
            $md24 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md24);
            NodeBuffer $buf48 = new NodeBuffer();
            $buf48.$amp$plus((Object)new Text("Getting Result Time"));
            $buf47.$amp$plus((Object)new Elem(null, "span", (MetaData)$md24, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf48));
            $buf47.$amp$plus((Object)new Text("\n              "));
            $buf46.$amp$plus((Object)new Elem(null, "span", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf47));
            $buf46.$amp$plus((Object)new Text("\n            "));
            $buf26.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf46));
            $buf26.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf49 = new NodeBuffer();
            $buf49.$amp$plus((Object)new Text("\n              "));
            Null$ $md25 = Null$.MODULE$;
            $md25 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md25);
            $md25 = new UnprefixedAttribute("title", ToolTips$.MODULE$.PEAK_EXECUTION_MEMORY(), (MetaData)$md25);
            $md25 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md25);
            NodeBuffer $buf50 = new NodeBuffer();
            $buf50.$amp$plus((Object)new Text("\n                "));
            Null$ $md26 = Null$.MODULE$;
            $md26 = new UnprefixedAttribute("name", TaskDetailsClassNames$.MODULE$.PEAK_EXECUTION_MEMORY(), (MetaData)$md26);
            $md26 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md26);
            $buf50.$amp$plus((Object)new Elem(null, "input", (MetaData)$md26, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf50.$amp$plus((Object)new Text("\n                "));
            Null$ $md27 = Null$.MODULE$;
            $md27 = new UnprefixedAttribute("class", (Seq)new Text("additional-metric-title"), (MetaData)$md27);
            NodeBuffer $buf51 = new NodeBuffer();
            $buf51.$amp$plus((Object)new Text("Peak Execution Memory"));
            $buf50.$amp$plus((Object)new Elem(null, "span", (MetaData)$md27, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf51));
            $buf50.$amp$plus((Object)new Text("\n              "));
            $buf49.$amp$plus((Object)new Elem(null, "span", (MetaData)$md25, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf50));
            $buf49.$amp$plus((Object)new Text("\n            "));
            $buf26.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf49));
            $buf26.$amp$plus((Object)new Text("\n          "));
            $buf25.$amp$plus((Object)new Elem(null, "ul", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26));
            $buf25.$amp$plus((Object)new Text("\n        "));
            $buf22.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25));
            $buf22.$amp$plus((Object)new Text("\n      "));
            Elem showAdditionalMetrics = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22);
            Option stageGraph = this.parent.store().asOption((Function0 & Serializable & scala.Serializable)() -> $this.parent.store().operationGraphForStage(stageId));
            Seq<Node> dagViz = UIUtils$.MODULE$.showDagVizForStage(stageId, stageGraph);
            Seq accumulableHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accumulable", "Value"}));
            Seq<Node> accumulableTable = UIUtils$.MODULE$.listingTable((Seq<String>)accumulableHeaders, (Function1 & Serializable & scala.Serializable)acc -> StagePage.accumulableRow$1(acc), stageData.accumulatorUpdates().toSeq(), UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8());
            int page = taskPageSize <= taskPrevPageSize ? taskPage : 1;
            long currentTime = System.currentTimeMillis();
            Tuple2 tuple2 = this.liftedTree1$1(stageData, request, stageId, stageAttemptId, currentTime, taskPageSize, taskSortColumn, taskSortDesc, page);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TaskPagedTable taskTable = (TaskPagedTable)tuple2._1();
            Seq taskTableHTML = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)taskTable, (Object)taskTableHTML);
            Tuple2 tuple23 = tuple22;
            TaskPagedTable taskTable2 = (TaskPagedTable)tuple23._1();
            Seq taskTableHTML2 = (Seq)tuple23._2();
            NodeBuffer $buf52 = new NodeBuffer();
            $buf52.$amp$plus((Object)new Text("\n        "));
            $buf52.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("\n            |$(function() {\n            |  if (/.*&task.sort=.*$/.test(location.search)) {\n            |    var topOffset = $(\"#tasks-section\").offset().top;\n            |    $(\"html,body\").animate({scrollTop: topOffset}, 200);\n            |  }\n            |});\n          ")).stripMargin()));
            $buf52.$amp$plus((Object)new Text("\n      "));
            Elem jsForScrollingDownToTaskTable = new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf52);
            Option<TaskMetricDistributions> metricsSummary = this.store.taskSummary(stageData.stageId(), stageData.attemptId(), new double[]{0.0, 0.25, 0.5, 0.75, 1.0});
            Option summaryTable = metricsSummary.map((Function1 & Serializable & scala.Serializable)metrics -> {
                Seq quantileHeaders;
                Nil$ nil$;
                Nil$ nil$2;
                Nil$ nil$3;
                Nil$ nil$4;
                Nil$ nil$5;
                Nil$ nil$6;
                Seq deserializationQuantiles = (Seq)StagePage.titleCell$1("Task Deserialization Time", ToolTips$.MODULE$.TASK_DESERIALIZATION_TIME()).$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics.executorDeserializeTime()), Seq$.MODULE$.canBuildFrom());
                Seq serviceQuantiles = (Seq)StagePage.simpleTitleCell$1("Duration").$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics.executorRunTime()), Seq$.MODULE$.canBuildFrom());
                Seq gcQuantiles = (Seq)StagePage.titleCell$1("GC Time", ToolTips$.MODULE$.GC_TIME()).$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics.jvmGcTime()), Seq$.MODULE$.canBuildFrom());
                Seq serializationQuantiles = (Seq)StagePage.titleCell$1("Result Serialization Time", ToolTips$.MODULE$.RESULT_SERIALIZATION_TIME()).$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics.resultSerializationTime()), Seq$.MODULE$.canBuildFrom());
                Seq gettingResultQuantiles = (Seq)StagePage.titleCell$1("Getting Result Time", ToolTips$.MODULE$.GETTING_RESULT_TIME()).$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics.gettingResultTime()), Seq$.MODULE$.canBuildFrom());
                Seq peakExecutionMemoryQuantiles = (Seq)StagePage.titleCell$1("Peak Execution Memory", ToolTips$.MODULE$.PEAK_EXECUTION_MEMORY()).$plus$plus((GenTraversableOnce)StagePage.sizeQuantiles$1(metrics.peakExecutionMemory()), Seq$.MODULE$.canBuildFrom());
                Seq schedulerDelayQuantiles = (Seq)StagePage.titleCell$1("Scheduler Delay", ToolTips$.MODULE$.SCHEDULER_DELAY()).$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics.schedulerDelay()), Seq$.MODULE$.canBuildFrom());
                Seq[] seqArray = new Seq[12];
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)serviceQuantiles);
                seqArray[0] = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.SCHEDULER_DELAY(), (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)schedulerDelayQuantiles);
                seqArray[1] = new Elem(null, "tr", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2);
                NodeBuffer $buf3 = new NodeBuffer();
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.TASK_DESERIALIZATION_TIME(), (MetaData)$md2);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("\n          "));
                $buf4.$amp$plus((Object)deserializationQuantiles);
                $buf4.$amp$plus((Object)new Text("\n        "));
                $buf3.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)gcQuantiles);
                $buf3.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
                seqArray[2] = $buf3;
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.RESULT_SERIALIZATION_TIME(), (MetaData)$md3);
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)new Text("\n          "));
                $buf6.$amp$plus((Object)serializationQuantiles);
                $buf6.$amp$plus((Object)new Text("\n        "));
                seqArray[3] = new Elem(null, "tr", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6);
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.GETTING_RESULT_TIME(), (MetaData)$md4);
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)gettingResultQuantiles);
                seqArray[4] = new Elem(null, "tr", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7);
                Null$ $md5 = Null$.MODULE$;
                $md5 = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.PEAK_EXECUTION_MEMORY(), (MetaData)$md5);
                NodeBuffer $buf8 = new NodeBuffer();
                $buf8.$amp$plus((Object)new Text("\n          "));
                $buf8.$amp$plus((Object)peakExecutionMemoryQuantiles);
                $buf8.$amp$plus((Object)new Text("\n        "));
                seqArray[5] = new Elem(null, "tr", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8);
                if (ApiHelper$.MODULE$.hasInput(stageData)) {
                    NodeBuffer $buf9 = new NodeBuffer();
                    $buf9.$amp$plus((Object)StagePage.inputQuantiles$1(metrics));
                    Elem elem = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9);
                    nil$6 = elem;
                } else {
                    nil$6 = seqArray[6] = Nil$.MODULE$;
                }
                if (ApiHelper$.MODULE$.hasOutput(stageData)) {
                    NodeBuffer $buf10 = new NodeBuffer();
                    $buf10.$amp$plus((Object)StagePage.outputQuantiles$1(metrics));
                    Elem elem = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10);
                    nil$5 = elem;
                } else {
                    nil$5 = seqArray[7] = Nil$.MODULE$;
                }
                if (ApiHelper$.MODULE$.hasShuffleRead(stageData)) {
                    NodeBuffer $buf11 = new NodeBuffer();
                    Null$ $md6 = Null$.MODULE$;
                    $md6 = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.SHUFFLE_READ_BLOCKED_TIME(), (MetaData)$md6);
                    NodeBuffer $buf12 = new NodeBuffer();
                    $buf12.$amp$plus((Object)new Text("\n            "));
                    $buf12.$amp$plus((Object)StagePage.shuffleReadBlockedQuantiles$1(metrics));
                    $buf12.$amp$plus((Object)new Text("\n          "));
                    $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
                    NodeBuffer $buf13 = new NodeBuffer();
                    $buf13.$amp$plus((Object)StagePage.shuffleReadTotalQuantiles$1(metrics));
                    $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
                    Null$ $md7 = Null$.MODULE$;
                    $md7 = new UnprefixedAttribute("class", TaskDetailsClassNames$.MODULE$.SHUFFLE_READ_REMOTE_SIZE(), (MetaData)$md7);
                    NodeBuffer $buf14 = new NodeBuffer();
                    $buf14.$amp$plus((Object)new Text("\n            "));
                    $buf14.$amp$plus((Object)StagePage.shuffleReadRemoteQuantiles$1(metrics));
                    $buf14.$amp$plus((Object)new Text("\n          "));
                    $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
                    nil$4 = $buf11;
                } else {
                    nil$4 = seqArray[8] = Nil$.MODULE$;
                }
                if (ApiHelper$.MODULE$.hasShuffleWrite(stageData)) {
                    NodeBuffer $buf15 = new NodeBuffer();
                    $buf15.$amp$plus((Object)StagePage.shuffleWriteQuantiles$1(metrics));
                    Elem elem = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15);
                    nil$3 = elem;
                } else {
                    nil$3 = seqArray[9] = Nil$.MODULE$;
                }
                if (ApiHelper$.MODULE$.hasBytesSpilled(stageData)) {
                    NodeBuffer $buf16 = new NodeBuffer();
                    $buf16.$amp$plus((Object)StagePage.memoryBytesSpilledQuantiles$1(metrics));
                    Elem elem = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16);
                    nil$2 = elem;
                } else {
                    nil$2 = seqArray[10] = Nil$.MODULE$;
                }
                if (ApiHelper$.MODULE$.hasBytesSpilled(stageData)) {
                    NodeBuffer $buf17 = new NodeBuffer();
                    $buf17.$amp$plus((Object)StagePage.diskBytesSpilledQuantiles$1(metrics));
                    Elem elem = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17);
                    nil$ = elem;
                } else {
                    nil$ = Nil$.MODULE$;
                }
                seqArray[11] = nil$;
                Seq listings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])seqArray));
                Seq x$1 = quantileHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric", "Min", "25th percentile", "Median", "75th percentile", "Max"}));
                Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)x -> (Seq)Predef$.MODULE$.identity(x);
                Seq x$3 = listings;
                boolean x$4 = true;
                Some x$5 = new Some((Object)"task-summary-table");
                boolean x$6 = false;
                Seq<String> x$7 = UIUtils$.MODULE$.listingTable$default$6();
                boolean x$8 = UIUtils$.MODULE$.listingTable$default$8();
                return UIUtils$.MODULE$.listingTable((Seq<String>)x$1, x$2, x$3, x$4, (Option<String>)x$5, x$7, x$6, x$8);
            });
            ExecutorTable executorTable = new ExecutorTable(stageData, this.parent.store());
            if (ApiHelper$.MODULE$.hasAccumulators(stageData)) {
                NodeBuffer $buf53 = new NodeBuffer();
                $buf53.$amp$plus((Object)new Text("Accumulators"));
                seq2 = (Seq)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf53).$plus$plus(accumulableTable, NodeSeq$.MODULE$.canBuildFrom());
            } else {
                seq2 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            Seq maybeAccumulableTable = seq2;
            NodeBuffer $buf54 = new NodeBuffer();
            Null$ $md28 = Null$.MODULE$;
            $md28 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-metrics','aggregated-metrics')"), (MetaData)$md28);
            $md28 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-metrics collapse-table"), (MetaData)$md28);
            NodeBuffer $buf55 = new NodeBuffer();
            $buf55.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf56 = new NodeBuffer();
            $buf56.$amp$plus((Object)new Text("\n          "));
            Null$ $md29 = Null$.MODULE$;
            $md29 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md29);
            $buf56.$amp$plus((Object)new Elem(null, "span", (MetaData)$md29, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf56.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf57 = new NodeBuffer();
            $buf57.$amp$plus((Object)new Text("Aggregated Metrics by Executor"));
            $buf56.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf57));
            $buf56.$amp$plus((Object)new Text("\n        "));
            $buf55.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf56));
            $buf55.$amp$plus((Object)new Text("\n      "));
            $buf54.$amp$plus((Object)new Elem(null, "span", (MetaData)$md28, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf55));
            Null$ $md30 = Null$.MODULE$;
            $md30 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-metrics collapsible-table"), (MetaData)$md30);
            NodeBuffer $buf58 = new NodeBuffer();
            $buf58.$amp$plus((Object)new Text("\n        "));
            $buf58.$amp$plus(executorTable.toNodeSeq());
            $buf58.$amp$plus((Object)new Text("\n      "));
            $buf54.$amp$plus((Object)new Elem(null, "div", (MetaData)$md30, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf58));
            NodeBuffer aggMetrics = $buf54;
            TraversableLike traversableLike = (TraversableLike)((TraversableLike)((TraversableLike)summary.$plus$plus(dagViz, NodeSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)showAdditionalMetrics, NodeSeq$.MODULE$.canBuildFrom())).$plus$plus(this.makeTimeline((Seq<TaskData>)((Seq)Option$.MODULE$.apply((Object)taskTable2).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.dataSource().tasks()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), currentTime), NodeSeq$.MODULE$.canBuildFrom());
            NodeBuffer $buf59 = new NodeBuffer();
            $buf59.$amp$plus((Object)new Text("Summary Metrics for "));
            Null$ $md31 = Null$.MODULE$;
            $md31 = new UnprefixedAttribute("href", (Seq)new Text("#tasks-section"), (MetaData)$md31);
            NodeBuffer $buf60 = new NodeBuffer();
            $buf60.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numCompleted));
            $buf60.$amp$plus((Object)new Text(" Completed Tasks"));
            $buf59.$amp$plus((Object)new Elem(null, "a", (MetaData)$md31, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf60));
            TraversableLike traversableLike2 = (TraversableLike)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf59), NodeSeq$.MODULE$.canBuildFrom());
            NodeBuffer $buf61 = new NodeBuffer();
            $buf61.$amp$plus(summaryTable.getOrElse((Function0 & Serializable & scala.Serializable)() -> "No tasks have reported metrics yet."));
            TraversableLike traversableLike3 = (TraversableLike)((TraversableLike)((TraversableLike)traversableLike2.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf61), NodeSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)aggMetrics, NodeSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)maybeAccumulableTable, NodeSeq$.MODULE$.canBuildFrom());
            Null$ $md32 = Null$.MODULE$;
            $md32 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-tasks','aggregated-tasks')"), (MetaData)$md32);
            $md32 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-tasks collapse-table"), (MetaData)$md32);
            $md32 = new UnprefixedAttribute("id", (Seq)new Text("tasks-section"), (MetaData)$md32);
            NodeBuffer $buf62 = new NodeBuffer();
            $buf62.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf63 = new NodeBuffer();
            $buf63.$amp$plus((Object)new Text("\n          "));
            Null$ $md33 = Null$.MODULE$;
            $md33 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md33);
            $buf63.$amp$plus((Object)new Elem(null, "span", (MetaData)$md33, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf63.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf64 = new NodeBuffer();
            $buf64.$amp$plus((Object)new Text("Tasks ("));
            $buf64.$amp$plus((Object)totalTasksNumStr);
            $buf64.$amp$plus((Object)new Text(")"));
            $buf63.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf64));
            $buf63.$amp$plus((Object)new Text("\n        "));
            $buf62.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf63));
            $buf62.$amp$plus((Object)new Text("\n      "));
            TraversableLike traversableLike4 = (TraversableLike)traversableLike3.$plus$plus((GenTraversableOnce)new Elem(null, "span", (MetaData)$md32, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf62), NodeSeq$.MODULE$.canBuildFrom());
            Null$ $md34 = Null$.MODULE$;
            $md34 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-tasks collapsible-table"), (MetaData)$md34);
            NodeBuffer $buf65 = new NodeBuffer();
            $buf65.$amp$plus((Object)new Text("\n        "));
            $buf65.$amp$plus(taskTableHTML2.$plus$plus((GenTraversableOnce)jsForScrollingDownToTaskTable, Seq$.MODULE$.canBuildFrom()));
            $buf65.$amp$plus((Object)new Text("\n      "));
            NodeSeq content = (NodeSeq)traversableLike4.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md34, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf65), NodeSeq$.MODULE$.canBuildFrom());
            HttpServletRequest x$9 = request;
            String x$10 = stageHeader;
            Function0 & Serializable & scala.Serializable x$11 = (Function0 & Serializable & scala.Serializable)() -> content;
            StagesTab x$12 = this.parent;
            boolean x$13 = true;
            Option<Object> x$14 = UIUtils$.MODULE$.headerSparkPage$default$5();
            Option<String> x$15 = UIUtils$.MODULE$.headerSparkPage$default$6();
            boolean x$16 = UIUtils$.MODULE$.headerSparkPage$default$8();
            seq = UIUtils$.MODULE$.headerSparkPage(x$9, x$10, (Function0<Seq<Node>>)x$11, x$12, x$14, x$15, x$13, x$16);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq<Node>)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public Seq<Node> makeTimeline(Seq<TaskData> tasks, long currentTime) {
        Elem elem;
        HashSet executorsSet = new HashSet();
        LongRef minLaunchTime = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxFinishTime = LongRef.create((long)Long.MIN_VALUE);
        String executorsArrayStr = ((TraversableOnce)((TraversableLike)((IterableLike)tasks.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$1(x$7)), (Ordering)Ordering.Long$.MODULE$)).take(this.MAX_TIMELINE_TASKS())).map((Function1 & Serializable & scala.Serializable)taskInfo -> {
            String executorId = taskInfo.executorId();
            String host = taskInfo.host();
            executorsSet.$plus$eq((Object)new Tuple2((Object)executorId, (Object)host));
            long launchTime = taskInfo.launchTime().getTime();
            long finishTime = BoxesRunTime.unboxToLong((Object)taskInfo.duration().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$8 -> taskInfo.launchTime().getTime() + x$8).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentTime));
            long totalExecutionTime = finishTime - launchTime;
            minLaunchTime$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(launchTime), minLaunchTime$1.elem);
            maxFinishTime$1.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(finishTime), maxFinishTime$1.elem);
            Option<TaskMetrics> metricsOpt = taskInfo.taskMetrics();
            long shuffleReadTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$5(x$9))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            double shuffleReadTimeProportion = StagePage.toProportion$1(shuffleReadTime, totalExecutionTime);
            long shuffleWriteTime = (long)((double)BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$7(x$10))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) / 1000000.0);
            double shuffleWriteTimeProportion = StagePage.toProportion$1(shuffleWriteTime, totalExecutionTime);
            long serializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.resultSerializationTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            double serializationTimeProportion = StagePage.toProportion$1(serializationTime, totalExecutionTime);
            long deserializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.executorDeserializeTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            double deserializationTimeProportion = StagePage.toProportion$1(deserializationTime, totalExecutionTime);
            long gettingResultTime = AppStatusUtils$.MODULE$.gettingResultTime((TaskData)taskInfo);
            double gettingResultTimeProportion = StagePage.toProportion$1(gettingResultTime, totalExecutionTime);
            long schedulerDelay = AppStatusUtils$.MODULE$.schedulerDelay((TaskData)taskInfo);
            double schedulerDelayProportion = StagePage.toProportion$1(schedulerDelay, totalExecutionTime);
            long executorOverhead = serializationTime + deserializationTime;
            long executorRunTime = taskInfo.duration().isDefined() ? package$.MODULE$.max(totalExecutionTime - executorOverhead - gettingResultTime - schedulerDelay, 0L) : BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.executorRunTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max(totalExecutionTime - executorOverhead - gettingResultTime - schedulerDelay, 0L)));
            long executorComputingTime = executorRunTime - shuffleReadTime - shuffleWriteTime;
            double executorComputingTimeProportion = package$.MODULE$.max((double)100 - schedulerDelayProportion - shuffleReadTimeProportion - shuffleWriteTimeProportion - serializationTimeProportion - deserializationTimeProportion - gettingResultTimeProportion, 0.0);
            int schedulerDelayProportionPos = 0;
            double deserializationTimeProportionPos = (double)schedulerDelayProportionPos + schedulerDelayProportion;
            double shuffleReadTimeProportionPos = deserializationTimeProportionPos + deserializationTimeProportion;
            double executorRuntimeProportionPos = shuffleReadTimeProportionPos + shuffleReadTimeProportion;
            double shuffleWriteTimeProportionPos = executorRuntimeProportionPos + executorComputingTimeProportion;
            double serializationTimeProportionPos = shuffleWriteTimeProportionPos + shuffleWriteTimeProportion;
            double gettingResultTimeProportionPos = serializationTimeProportionPos + serializationTimeProportion;
            int index = taskInfo.index();
            int attempt = taskInfo.attempt();
            String svgTag = totalExecutionTime == 0L ? "<svg class=\"task-assignment-timeline-duration-bar\"></svg>" : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1090).append("<svg class=\"task-assignment-timeline-duration-bar\">\n                 |<rect class=\"scheduler-delay-proportion\"\n                   |x=\"").append(schedulerDelayProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(schedulerDelayProportion).append("%\"></rect>\n                 |<rect class=\"deserialization-time-proportion\"\n                   |x=\"").append(deserializationTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(deserializationTimeProportion).append("%\"></rect>\n                 |<rect class=\"shuffle-read-time-proportion\"\n                   |x=\"").append(shuffleReadTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(shuffleReadTimeProportion).append("%\"></rect>\n                 |<rect class=\"executor-runtime-proportion\"\n                   |x=\"").append(executorRuntimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(executorComputingTimeProportion).append("%\"></rect>\n                 |<rect class=\"shuffle-write-time-proportion\"\n                   |x=\"").append(shuffleWriteTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(shuffleWriteTimeProportion).append("%\"></rect>\n                 |<rect class=\"serialization-time-proportion\"\n                   |x=\"").append(serializationTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(serializationTimeProportion).append("%\"></rect>\n                 |<rect class=\"getting-result-time-proportion\"\n                   |x=\"").append(gettingResultTimeProportionPos).append("%\" y=\"0px\" height=\"26px\"\n                   |width=\"").append(gettingResultTimeProportion).append("%\"></rect></svg>").toString())).stripMargin();
            String timelineObject = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(882).append("\n             |{\n               |'className': 'task task-assignment-timeline-object',\n               |'group': '").append(executorId).append("',\n               |'content': '<div class=\"task-assignment-timeline-content\"\n                 |data-toggle=\"tooltip\" data-placement=\"top\"\n                 |data-html=\"true\" data-container=\"body\"\n                 |data-title=\"").append("Task ").append(index).append(" (attempt ").append(attempt).append(")").append("<br>\n                 |Status: ").append(taskInfo.status()).append("<br>\n                 |Launch Time: ").append(UIUtils$.MODULE$.formatDate(new Date(launchTime))).append("\n                 |").append((Object)(!taskInfo.duration().isDefined() ? new StringBuilder(17).append("<br>Finish Time: ").append(UIUtils$.MODULE$.formatDate(new Date(finishTime))).toString() : "")).append("\n                 |<br>Scheduler Delay: ").append(schedulerDelay).append(" ms\n                 |<br>Task Deserialization Time: ").append(UIUtils$.MODULE$.formatDuration(deserializationTime)).append("\n                 |<br>Shuffle Read Time: ").append(UIUtils$.MODULE$.formatDuration(shuffleReadTime)).append("\n                 |<br>Executor Computing Time: ").append(UIUtils$.MODULE$.formatDuration(executorComputingTime)).append("\n                 |<br>Shuffle Write Time: ").append(UIUtils$.MODULE$.formatDuration(shuffleWriteTime)).append("\n                 |<br>Result Serialization Time: ").append(UIUtils$.MODULE$.formatDuration(serializationTime)).append("\n                 |<br>Getting Result Time: ").append(UIUtils$.MODULE$.formatDuration(gettingResultTime)).append("\">\n                 |").append(svgTag).append("',\n               |'start': new Date(").append(launchTime).append("),\n               |'end': new Date(").append(finishTime).append(")\n             |}\n           |").toString())).stripMargin().replaceAll("[\\r\\n]+", " ");
            return timelineObject;
        }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        String groupArrayStr = ((TraversableOnce)executorsSet.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String executorId = (String)tuple2._1();
            String host = (String)tuple2._2();
            String string = new StringBuilder(95).append("\n            {\n              'id': '").append(executorId).append("',\n              'content': '").append(executorId).append(" / ").append(host).append("',\n            }\n          ").toString();
            return string;
        }, HashSet$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-task-assignment-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-task-assignment-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Event Timeline"));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem2 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("task-assignment-timeline"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_TASKS() < tasks.size()) {
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            This page has more than the maximum number of tasks that can be shown in the\n            visualization! Only the most recent "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_TASKS()));
            $buf4.$amp$plus((Object)new Text(" tasks\n            (of "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)tasks.size()));
            $buf4.$amp$plus((Object)new Text(" total) are shown.\n          "));
            Elem elem3 = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4);
            elem = elem3;
        } else {
            elem = Seq$.MODULE$.empty();
        }
        $buf3.$amp$plus((Object)elem);
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("task-assignment-timeline-zoom-lock"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md6);
        $buf6.$amp$plus((Object)new Elem(null, "input", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Enable zooming"));
        $buf6.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)this.TIMELINE_LEGEND());
        $buf3.$amp$plus((Object)new Text("\n    "));
        TraversableLike traversableLike = (TraversableLike)elem2.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3), NodeSeq$.MODULE$.canBuildFrom());
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md7);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf8.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(36).append("drawTaskAssignmentTimeline(").append(groupArrayStr).append(", ").append(executorsArrayStr).append(", ").append(minLaunchTime.elem).append(", ").append(maxFinishTime.elem).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(")").toString()));
        $buf8.$amp$plus((Object)new Text("\n    "));
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8), NodeSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ String $anonfun$getLocalitySummaryString$2(String name$1, long count) {
        return new StringBuilder(2).append(name$1).append(": ").append(count).toString();
    }

    public static final /* synthetic */ int $anonfun$render$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$render$7(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$render$9(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ int $anonfun$render$11(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq accumulableRow$1(AccumulableInfo acc) {
        Nil$ nil$;
        if (acc.name() != null && acc.value() != null) {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)acc.name());
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)acc.value());
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
            nil$ = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private final Tuple2 liftedTree1$1(StageData stageData$1, HttpServletRequest request$1, int stageId$1, int stageAttemptId$1, long currentTime$1, int taskPageSize$1, String taskSortColumn$1, boolean taskSortDesc$1, int page$1) {
        Tuple2 tuple2;
        try {
            TaskPagedTable _taskTable = new TaskPagedTable(stageData$1, new StringBuilder(27).append(UIUtils$.MODULE$.prependBaseUri(request$1, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3())).append("/stages/stage/?id=").append(stageId$1).append("&attempt=").append(stageAttemptId$1).toString(), currentTime$1, taskPageSize$1, taskSortColumn$1, taskSortDesc$1, this.parent.store());
            tuple2 = new Tuple2((Object)_taskTable, _taskTable.table(page$1));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException;
            if (!bl) {
                throw throwable;
            }
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("Error while rendering stage table:"));
            $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n              "));
            $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf.$amp$plus((Object)new Text("\n          "));
            Elem errorMessage = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Tuple2 tuple22 = new Tuple2(null, (Object)errorMessage);
            tuple2 = tuple22;
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$render$20(double millis) {
        void var2_1;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)UIUtils$.MODULE$.formatDuration((long)millis));
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_1);
    }

    private static final Seq timeQuantiles$1(IndexedSeq data) {
        return (Seq)data.map((Function1 & Serializable & scala.Serializable)millis -> StagePage.$anonfun$render$20(BoxesRunTime.unboxToDouble((Object)millis)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Elem $anonfun$render$21(double size) {
        void var2_1;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)Utils$.MODULE$.bytesToString((long)size));
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_1);
    }

    private static final Seq sizeQuantiles$1(IndexedSeq data) {
        return (Seq)data.map((Function1 & Serializable & scala.Serializable)size -> StagePage.$anonfun$render$21(BoxesRunTime.unboxToDouble((Object)size)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private static final Seq sizeQuantilesWithRecords$1(IndexedSeq data, IndexedSeq records) {
        return (Seq)((TraversableLike)data.zip((GenIterable)records, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double d = tuple2._1$mcD$sp();
            double r = tuple2._2$mcD$sp();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new StringBuilder(3).append(Utils$.MODULE$.bytesToString((long)d)).append(" / ").append((long)r).toString());
            Elem elem = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            return elem;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq titleCell$1(String title, String tooltip) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n          "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md);
        $md = new UnprefixedAttribute("title", tooltip, (MetaData)$md);
        $md = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n            "));
        $buf2.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Text("\n          "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq simpleTitleCell$1(String title) {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)title);
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var1_1);
    }

    private static final Seq inputQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.simpleTitleCell$1("Input Size / Records").$plus$plus((GenTraversableOnce)StagePage.sizeQuantilesWithRecords$1(metrics$1.inputMetrics().bytesRead(), metrics$1.inputMetrics().recordsRead()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq outputQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.simpleTitleCell$1("Output Size / Records").$plus$plus((GenTraversableOnce)StagePage.sizeQuantilesWithRecords$1(metrics$1.outputMetrics().bytesWritten(), metrics$1.outputMetrics().recordsWritten()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq shuffleReadBlockedQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.titleCell$1("Shuffle Read Blocked Time", ToolTips$.MODULE$.SHUFFLE_READ_BLOCKED_TIME()).$plus$plus((GenTraversableOnce)StagePage.timeQuantiles$1(metrics$1.shuffleReadMetrics().fetchWaitTime()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq shuffleReadTotalQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.titleCell$1("Shuffle Read Size / Records", ToolTips$.MODULE$.SHUFFLE_READ()).$plus$plus((GenTraversableOnce)StagePage.sizeQuantilesWithRecords$1(metrics$1.shuffleReadMetrics().readBytes(), metrics$1.shuffleReadMetrics().readRecords()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq shuffleReadRemoteQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.titleCell$1("Shuffle Remote Reads", ToolTips$.MODULE$.SHUFFLE_READ_REMOTE_SIZE()).$plus$plus((GenTraversableOnce)StagePage.sizeQuantiles$1(metrics$1.shuffleReadMetrics().remoteBytesRead()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq shuffleWriteQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.simpleTitleCell$1("Shuffle Write Size / Records").$plus$plus((GenTraversableOnce)StagePage.sizeQuantilesWithRecords$1(metrics$1.shuffleWriteMetrics().writeBytes(), metrics$1.shuffleWriteMetrics().writeRecords()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq memoryBytesSpilledQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.simpleTitleCell$1("Shuffle spill (memory)").$plus$plus((GenTraversableOnce)StagePage.sizeQuantiles$1(metrics$1.memoryBytesSpilled()), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq diskBytesSpilledQuantiles$1(TaskMetricDistributions metrics$1) {
        return (Seq)StagePage.simpleTitleCell$1("Shuffle spill (disk)").$plus$plus((GenTraversableOnce)StagePage.sizeQuantiles$1(metrics$1.diskBytesSpilled()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$1(TaskData x$7) {
        return -x$7.launchTime().getTime();
    }

    private static final double toProportion$1(long time, long totalExecutionTime$1) {
        return (double)time / (double)totalExecutionTime$1 * (double)100;
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$5(TaskMetrics x$9) {
        return x$9.shuffleReadMetrics().fetchWaitTime();
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$7(TaskMetrics x$10) {
        return x$10.shuffleWriteMetrics().writeTime();
    }

    public StagePage(StagesTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("stage");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        .colon.colon legendPairs = new .colon.colon((Object)new Tuple2((Object)"scheduler-delay-proportion", (Object)"Scheduler Delay"), (List)new .colon.colon((Object)new Tuple2((Object)"deserialization-time-proportion", (Object)"Task Deserialization Time"), (List)new .colon.colon((Object)new Tuple2((Object)"shuffle-read-time-proportion", (Object)"Shuffle Read Time"), (List)new .colon.colon((Object)new Tuple2((Object)"executor-runtime-proportion", (Object)"Executor Computing Time"), (List)new .colon.colon((Object)new Tuple2((Object)"shuffle-write-time-proportion", (Object)"Shuffle Write Time"), (List)new .colon.colon((Object)new Tuple2((Object)"serialization-time-proportion", (Object)"Result Serialization Time"), (List)new .colon.colon((Object)new Tuple2((Object)"getting-result-time-proportion", (Object)"Getting Result Time"), (List)Nil$.MODULE$)))))));
        $buf2.$amp$plus(((List)legendPairs.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int index;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    index = tuple22._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String classAttr = (String)tuple2._1();
            String name = (String)tuple2._2();
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", classAttr, (MetaData)$md);
            $md = new UnprefixedAttribute("height", (Seq)new Text("10px"), (MetaData)$md);
            $md = new UnprefixedAttribute("width", (Seq)new Text("10px"), (MetaData)$md);
            $md = new UnprefixedAttribute("y", new StringBuilder(2).append(10 + index % 3 * 15).append("px").toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("x", new StringBuilder(2).append(5 + index / 3 * 210).append("px").toString(), (MetaData)$md);
            $buf.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("y", new StringBuilder(2).append(20 + index % 3 * 15).append("px").toString(), (MetaData)$md2);
            $md2 = new UnprefixedAttribute("x", new StringBuilder(2).append(25 + index / 3 * 210).append("px").toString(), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)name);
            $buf.$amp$plus((Object)new Elem(null, "text", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            NodeBuffer nodeBuffer = $buf;
            return nodeBuffer;
        }, List$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        this.TIMELINE_LEGEND = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        this.MAX_TIMELINE_TASKS = parent.conf().getInt("spark.ui.timeline.tasks.maximum", 1000);
    }
}

