/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.WebUITab;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.ui.scope.RDDOperationGraph$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.xml.Attribute$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;
import scala.xml.transform.RewriteRule;
import scala.xml.transform.RuleTransformer;

public final class UIUtils$
implements Logging {
    public static UIUtils$ MODULE$;
    private final String TABLE_CLASS_NOT_STRIPED;
    private final String TABLE_CLASS_STRIPED;
    private final String TABLE_CLASS_STRIPED_SORTABLE;
    private final Regex NEWLINE_AND_SINGLE_QUOTE_REGEX;
    private final ThreadLocal<SimpleDateFormat> dateFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new UIUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String TABLE_CLASS_NOT_STRIPED() {
        return this.TABLE_CLASS_NOT_STRIPED;
    }

    public String TABLE_CLASS_STRIPED() {
        return this.TABLE_CLASS_STRIPED;
    }

    public String TABLE_CLASS_STRIPED_SORTABLE() {
        return this.TABLE_CLASS_STRIPED_SORTABLE;
    }

    private Regex NEWLINE_AND_SINGLE_QUOTE_REGEX() {
        return this.NEWLINE_AND_SINGLE_QUOTE_REGEX;
    }

    private ThreadLocal<SimpleDateFormat> dateFormat() {
        return this.dateFormat;
    }

    public String formatDate(Date date) {
        return ((DateFormat)this.dateFormat().get()).format(date);
    }

    public String formatDate(long timestamp) {
        return ((DateFormat)this.dateFormat().get()).format(new Date(timestamp));
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return new StringOps(Predef$.MODULE$.augmentString("%.1f h")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatDurationVerbose(long ms) {
        Object object = new Object();
        try {
            try {
                long second = 1000L;
                long minute = 60L * second;
                long hour = 60L * minute;
                long day = 24L * hour;
                long week = 7L * day;
                long year = 365L * day;
                String millisecondsString = ms >= second && ms % second == 0L ? "" : new StringBuilder(3).append(ms % second).append(" ms").toString();
                String secondString = UIUtils$.toString$1(ms % minute / second, "second");
                String minuteString = UIUtils$.toString$1(ms % hour / minute, "minute");
                String hourString = UIUtils$.toString$1(ms % day / hour, "hour");
                String dayString = UIUtils$.toString$1(ms % week / day, "day");
                String weekString = UIUtils$.toString$1(ms % year / week, "week");
                String yearString = UIUtils$.toString$1(ms / year, "year");
                ((IterableLike)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)second)), (Object)millisecondsString), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)minute)), (Object)new StringBuilder(1).append(secondString).append(" ").append(millisecondsString).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)hour)), (Object)new StringBuilder(1).append(minuteString).append(" ").append(secondString).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)day)), (Object)new StringBuilder(2).append(hourString).append(" ").append(minuteString).append(" ").append(secondString).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)week)), (Object)new StringBuilder(2).append(dayString).append(" ").append(hourString).append(" ").append(minuteString).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)year)), (Object)new StringBuilder(2).append(weekString).append(" ").append(dayString).append(" ").append(hourString).toString())}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    UIUtils$.$anonfun$formatDurationVerbose$1(ms, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return new StringBuilder(2).append(yearString).append(" ").append(weekString).append(" ").append(dayString).toString();
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error converting time to string", e);
                return "";
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String)ex.value();
        }
    }

    public String formatNumber(double records) {
        Tuple2 tuple2;
        double trillion = 1.0E12;
        double billion = 1.0E9;
        double million = 1000000.0;
        double thousand = 1000.0;
        Tuple2 tuple22 = records >= (double)2 * trillion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / trillion)), (Object)" T") : (records >= (double)2 * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / billion)), (Object)" B") : (records >= (double)2 * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / million)), (Object)" M") : (tuple2 = records >= (double)2 * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(records / thousand)), (Object)" K") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)records), (Object)""))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double value = tuple2._1$mcD$sp();
        String unit = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit);
        Tuple2 tuple24 = tuple23;
        double value2 = tuple24._1$mcD$sp();
        String unit2 = (String)tuple24._2();
        return unit2.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString("%d")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value2))})) : new StringOps(Predef$.MODULE$.augmentString("%.1f%s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value2), unit2}));
    }

    public String uiRoot(HttpServletRequest request) {
        Option knoxBasePath = Option$.MODULE$.apply((Object)request.getHeader("X-Forwarded-Context"));
        return (String)scala.sys.package$.MODULE$.props().get("spark.ui.proxyBase").orElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"APPLICATION_WEB_PROXY_BASE")).orElse((Function0 & Serializable & scala.Serializable)() -> knoxBasePath).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public String prependBaseUri(HttpServletRequest request, String basePath, String resource) {
        return new StringBuilder(0).append(this.uiRoot(request)).append(basePath).append(resource).toString();
    }

    public String prependBaseUri$default$2() {
        return "";
    }

    public String prependBaseUri$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> commonHeaderNodes(HttpServletRequest request) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-type"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/bootstrap.min.css", this.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/vis-timeline-graph2d.min.css", this.prependBaseUri$default$3()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/webui.css", this.prependBaseUri$default$3()), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/timeline-view.css", this.prependBaseUri$default$3()), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/sorttable.js", this.prependBaseUri$default$3()), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery-1.12.4.min.js", this.prependBaseUri$default$3()), (MetaData)$md7);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/vis-timeline-graph2d.min.js", this.prependBaseUri$default$3()), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/bootstrap-tooltip.js", this.prependBaseUri$default$3()), (MetaData)$md9);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/initialize-tooltips.js", this.prependBaseUri$default$3()), (MetaData)$md10);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/table.js", this.prependBaseUri$default$3()), (MetaData)$md11);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/additional-metrics.js", this.prependBaseUri$default$3()), (MetaData)$md12);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/timeline-view.js", this.prependBaseUri$default$3()), (MetaData)$md13);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/log-view.js", this.prependBaseUri$default$3()), (MetaData)$md14);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/webui.js", this.prependBaseUri$default$3()), (MetaData)$md15);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("setUIRoot('"));
        $buf2.$amp$plus((Object)this.uiRoot(request));
        $buf2.$amp$plus((Object)new Text("')"));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> vizHeaderNodes(HttpServletRequest request) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/spark-dag-viz.css", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/d3.min.js", this.prependBaseUri$default$3()), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/dagre-d3.min.js", this.prependBaseUri$default$3()), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/graphlib-dot.min.js", this.prependBaseUri$default$3()), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/spark-dag-viz.js", this.prependBaseUri$default$3()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> dataTablesHeaderNodes(HttpServletRequest request) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md);
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/jquery.dataTables.1.10.18.min.css", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/dataTables.bootstrap.css", this.prependBaseUri$default$3()), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/jsonFormatter.min.css", this.prependBaseUri$default$3()), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/webui-dataTables.css", this.prependBaseUri$default$3()), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.dataTables.1.10.18.min.js", this.prependBaseUri$default$3()), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.cookies.2.2.0.min.js", this.prependBaseUri$default$3()), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.blockUI.min.js", this.prependBaseUri$default$3()), (MetaData)$md7);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/dataTables.bootstrap.min.js", this.prependBaseUri$default$3()), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jsonFormatter.min.js", this.prependBaseUri$default$3()), (MetaData)$md9);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/jquery.mustache.js", this.prependBaseUri$default$3()), (MetaData)$md10);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        return var2_2;
    }

    public Seq<Node> headerSparkPage(HttpServletRequest request, String title, Function0<Seq<Node>> content, SparkUITab activeTab, Option<Object> refreshInterval, Option<String> helpText, boolean showVisualization, boolean useDataTables) {
        String appName = activeTab.appName();
        String shortAppName = appName.length() < 36 ? appName : new StringBuilder(3).append((String)new StringOps(Predef$.MODULE$.augmentString(appName)).take(32)).append("...").toString();
        Seq header = (Seq)activeTab.headerTabs().map((Function1 & Serializable & scala.Serializable)tab -> {
            Null$ $md = Null$.MODULE$;
            WebUITab webUITab = tab;
            SparkUITab sparkUITab = activeTab;
            $md = new UnprefixedAttribute("class", !(webUITab != null ? !webUITab.equals(sparkUITab) : sparkUITab != null) ? "active" : "", (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("href", MODULE$.prependBaseUri(request, activeTab.basePath(), new StringBuilder(2).append("/").append(tab.prefix()).append("/").toString()), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)tab.name());
            $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "li", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        Seq helpButton = (Seq)helpText.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.tooltip((String)x$2, "bottom")).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.empty());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.commonHeaderNodes(request));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("setAppBasePath('"));
        $buf3.$amp$plus((Object)activeTab.basePath());
        $buf3.$amp$plus((Object)new Text("')"));
        $buf2.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(showVisualization ? this.vizHeaderNodes(request) : scala.collection.Seq$.MODULE$.empty());
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(useDataTables ? this.dataTablesHeaderNodes(request) : scala.collection.Seq$.MODULE$.empty());
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("shortcut icon"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)appName);
        $buf4.$amp$plus((Object)new Text(" - "));
        $buf4.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("navbar navbar-static-top"), (MetaData)$md2);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("navbar-inner"), (MetaData)$md3);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("brand"), (MetaData)$md4);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("brand"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/", this.prependBaseUri$default$3()), (MetaData)$md5);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md6);
        $buf9.$amp$plus((Object)new Elem(null, "img", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n                "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("version"), (MetaData)$md7);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)activeTab.appSparkVersion());
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n              "));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("navbar-text pull-right"), (MetaData)$md8);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n              "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("title", appName, (MetaData)$md9);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)shortAppName);
        $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf11.$amp$plus((Object)new Text(" application UI\n            "));
        $buf7.$amp$plus((Object)new Elem(null, "p", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("nav"), (MetaData)$md10);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)header);
        $buf7.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("container-fluid"), (MetaData)$md11);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n          "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md12);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n            "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md13);
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n              "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: bottom; display: inline-block;"), (MetaData)$md14);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n                "));
        $buf17.$amp$plus((Object)title);
        $buf17.$amp$plus((Object)new Text("\n                "));
        $buf17.$amp$plus((Object)helpButton);
        $buf17.$amp$plus((Object)new Text("\n              "));
        $buf16.$amp$plus((Object)new Elem(null, "h3", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
        $buf16.$amp$plus((Object)new Text("\n            "));
        $buf15.$amp$plus((Object)new Elem(null, "div", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16));
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf14.$amp$plus((Object)new Elem(null, "div", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
        $buf14.$amp$plus((Object)new Text("\n          "));
        $buf14.$amp$plus(content.apply());
        $buf14.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Option<Object> headerSparkPage$default$5() {
        return None$.MODULE$;
    }

    public Option<String> headerSparkPage$default$6() {
        return None$.MODULE$;
    }

    public boolean headerSparkPage$default$7() {
        return false;
    }

    public boolean headerSparkPage$default$8() {
        return false;
    }

    public Seq<Node> basicSparkPage(HttpServletRequest request, Function0<Seq<Node>> content, String title, boolean useDataTables) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.commonHeaderNodes(request));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(useDataTables ? this.dataTablesHeaderNodes(request) : scala.collection.Seq$.MODULE$.empty());
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md);
        $md = new UnprefixedAttribute("rel", (Seq)new Text("shortcut icon"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "link", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)title);
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("container-fluid"), (MetaData)$md2);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("row-fluid"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("span12"), (MetaData)$md4);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("vertical-align: middle; display: inline-block;"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("href", this.prependBaseUri(request, "/", this.prependBaseUri$default$3()), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("style", (Seq)new Text("text-decoration: none"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                  "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", this.prependBaseUri(request, "/static/spark-logo-77x50px-hd.png", this.prependBaseUri$default$3()), (MetaData)$md7);
        $buf9.$amp$plus((Object)new Elem(null, "img", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf9.$amp$plus((Object)new Text("\n                  "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("style", (Seq)new Text("margin-right: 15px;"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("version"), (MetaData)$md8);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)package$.MODULE$.SPARK_VERSION());
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n                "));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf8.$amp$plus((Object)new Text("\n                "));
        $buf8.$amp$plus((Object)title);
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "h3", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus(content.apply());
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public boolean basicSparkPage$default$4() {
        return false;
    }

    public <T> Seq<Node> listingTable(Seq<String> headers, Function1<T, Seq<Node>> generateDataRow, Iterable<T> data2, boolean fixedWidth, Option<String> id, Seq<String> headerClasses, boolean stripeRowsWithCss, boolean sortable) {
        String _tableClass = stripeRowsWithCss ? this.TABLE_CLASS_STRIPED() : this.TABLE_CLASS_NOT_STRIPED();
        String listingTableClass = sortable ? new StringBuilder(9).append(_tableClass).append(" sortable").toString() : _tableClass;
        double colWidth = (double)100 / (double)headers.size();
        String colWidthAttr = fixedWidth ? new StringBuilder(1).append(colWidth).append("%").toString() : "";
        boolean newlinesInHeader = headers.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("\n")));
        Seq headerRow = (Seq)((TraversableViewLike)headers.view().zipWithIndex(SeqView$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", UIUtils$.getClass$1(x._2$mcI$sp(), headerClasses), (MetaData)$md);
            $md = new UnprefixedAttribute("width", colWidthAttr, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)UIUtils$.getHeaderContent$1((String)x._1(), newlinesInHeader));
            return new Elem(null, "th", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        }, SeqView$.MODULE$.canBuildFrom());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", id.map((Function1 & Serializable & scala.Serializable)data -> Text$.MODULE$.apply(data)), (MetaData)$md);
        $md = new UnprefixedAttribute("class", listingTableClass, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)headerRow);
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(data2.map((Function1 & Serializable & scala.Serializable)r -> (Seq)generateDataRow.apply(r), Iterable$.MODULE$.canBuildFrom()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public <T> boolean listingTable$default$4() {
        return false;
    }

    public <T> Option<String> listingTable$default$5() {
        return None$.MODULE$;
    }

    public <T> Seq<String> listingTable$default$6() {
        return (Seq)scala.collection.Seq$.MODULE$.empty();
    }

    public <T> boolean listingTable$default$7() {
        return true;
    }

    public <T> boolean listingTable$default$8() {
        return true;
    }

    public Seq<Node> makeProgressBar(int started, int completed, int failed, int skipped, Map<String, Object> reasonToNumKilled, int total) {
        String completeWidth = new StringOps(Predef$.MODULE$.augmentString("width: %s%%")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)completed / (double)total * (double)100))}));
        int boundedStarted = scala.math.package$.MODULE$.min(started, total - completed);
        String startWidth = new StringOps(Predef$.MODULE$.augmentString("width: %s%%")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)boundedStarted / (double)total * (double)100))}));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("progress"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("style", (Seq)new Text("text-align:center; position:absolute; width:100%; left:0;"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completed));
        $buf2.$amp$plus((Object)new Text("/"));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)total));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(failed == 0 && skipped == 0 && started > 0 ? new StringBuilder(10).append("(").append(started).append(" running)").toString() : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(failed > 0 ? new StringBuilder(9).append("(").append(failed).append(" failed)").toString() : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)(skipped > 0 ? new StringBuilder(10).append("(").append(skipped).append(" skipped)").toString() : BoxedUnit.UNIT));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(((TraversableLike)reasonToNumKilled.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)UIUtils$.$anonfun$makeProgressBar$1(x$4)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String reason = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            String string = new StringBuilder(11).append("(").append(count).append(" killed: ").append(reason).append(")").toString();
            return string;
        }, scala.collection.Seq$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", completeWidth, (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("bar bar-completed"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", startWidth, (MetaData)$md4);
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("bar bar-running"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Seq<Node> showDagVizForStage(int stageId, Option<RDDOperationGraph> graph) {
        return this.showDagViz((Seq<RDDOperationGraph>)Option$.MODULE$.option2Iterable(graph).toSeq(), false);
    }

    public Seq<Node> showDagVizForJob(int jobId, Seq<RDDOperationGraph> graphs) {
        return this.showDagViz(graphs, true);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> showDagViz(Seq<RDDOperationGraph> graphs, boolean forJob) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onclick", new StringBuilder(15).append("toggleDagViz(").append(forJob).append(");").toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-dag-viz"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", forJob ? "job-dag-viz" : "stage-dag-viz", (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-dag-viz-arrow arrow-closed"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", forJob ? ToolTips$.MODULE$.JOB_DAG() : ToolTips$.MODULE$.STAGE_DAG(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          DAG Visualization\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("dag-viz-graph"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", (Seq)new Text("display:none"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("dag-viz-metadata"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(graphs.map((Function1 & Serializable & scala.Serializable)g -> {
            String stageId = g.rootCluster().id().replaceAll(RDDOperationGraph$.MODULE$.STAGE_CLUSTER_PREFIX(), "");
            String skipped = ((Object)BoxesRunTime.boxToBoolean((boolean)g.rootCluster().name().contains("skipped"))).toString();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("skipped", skipped, (MetaData)$md);
            $md = new UnprefixedAttribute("stage-id", stageId, (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("stage-metadata"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("class", (Seq)new Text("dot-file"), (MetaData)$md2);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)RDDOperationGraph$.MODULE$.makeDotFile((RDDOperationGraph)g));
            $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus(g.incomingEdges().map((Function1 & Serializable & scala.Serializable)e -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("incoming-edge"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.fromId()));
                $buf.$amp$plus((Object)new Text(","));
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.toId()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
            }, scala.collection.Seq$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus(g.outgoingEdges().map((Function1 & Serializable & scala.Serializable)e -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("outgoing-edge"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.fromId()));
                $buf.$amp$plus((Object)new Text(","));
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)e.toId()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
            }, scala.collection.Seq$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus(g.rootCluster().getCachedNodes().map((Function1 & Serializable & scala.Serializable)n -> {
                void var2_2;
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("cached-rdd"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)n.id()));
                return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
            }, scala.collection.Seq$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        }, scala.collection.Seq$.MODULE$.canBuildFrom()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> tooltip(String text, String position) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      ("));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("title", text, (MetaData)$md);
        $md = new UnprefixedAttribute("data-placement", position, (MetaData)$md);
        $md = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("?"));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text(")\n    "));
        return new Elem(null, "sup", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public NodeSeq makeDescription(String desc, String basePathUri, boolean plainText) {
        Text text;
        try {
            Elem xml = (Elem)XML$.MODULE$.loadString(new StringBuilder(39).append("<span class=\"description-input\">").append(desc).append("</span>").toString());
            Set allowedNodeLabels = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "span", "br"}));
            NodeSeq illegalNodes = (NodeSeq)xml.$bslash$bslash("_").filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UIUtils$.$anonfun$makeDescription$1(allowedNodeLabels, x0$1)));
            if (illegalNodes.nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Only HTML anchors allowed in job descriptions\n").append(((TraversableOnce)illegalNodes.map((Function1 & Serializable & scala.Serializable)n -> new StringBuilder(4).append(n.label()).append(" in ").append(n).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n\t")).toString());
            }
            scala.collection.immutable.Seq allLinks = (scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)xml.$bslash$bslash("a").flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.attributes(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UIUtils$.$anonfun$makeDescription$4(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.value().toString(), Seq$.MODULE$.canBuildFrom());
            if (allLinks.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UIUtils$.$anonfun$makeDescription$6(x$8)))) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Links in job descriptions must be root-relative:\n").append(allLinks.mkString("\n\t")).toString());
            }
            RewriteRule rule = plainText ? new RewriteRule(){

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public Seq<Node> transform(Node n2) {
                    void var2_8;
                    boolean bl = false;
                    Elem elem = null;
                    Node node = n2;
                    if (node instanceof Elem) {
                        bl = true;
                        elem = (Elem)node;
                        if (elem.child().isEmpty()) {
                            Text text = Text$.MODULE$.apply(elem.text());
                            return var2_8;
                        }
                    }
                    if (bl && elem.child().nonEmpty()) {
                        Text text = Text$.MODULE$.apply(NodeSeq$.MODULE$.seqToNodeSeq((Seq)elem.child().flatMap((Function1 & Serializable & scala.Serializable)n -> this.transform((Node)n), scala.collection.Seq$.MODULE$.canBuildFrom())).text());
                        return var2_8;
                    }
                    Node node2 = n2;
                    return var2_8;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$transform$1(org.apache.spark.ui.UIUtils$$anon$2 scala.xml.Node )}, serializedLambda);
                }
            } : new RewriteRule(basePathUri){
                private final String basePathUri$1;

                public Seq<Node> transform(Node n) {
                    Node node;
                    Elem elem;
                    Node node2 = n;
                    if (node2 instanceof Elem && (elem = (Elem)node2).$bslash("@href").nonEmpty()) {
                        String relativePath = ((SeqLike)elem.attribute("href").get()).toString();
                        String fullUri = new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.basePathUri$1)).stripSuffix("/")).append("/").append(new StringOps(Predef$.MODULE$.augmentString(relativePath)).stripPrefix("/")).toString();
                        node = elem.$percent((MetaData)Attribute$.MODULE$.apply(null, "href", fullUri, (MetaData)Null$.MODULE$));
                    } else {
                        node = n;
                    }
                    return node;
                }
                {
                    this.basePathUri$1 = basePathUri$1;
                }
            };
            text = NodeSeq$.MODULE$.seqToNodeSeq(new RuleTransformer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RewriteRule[]{rule})).transform((Node)xml));
        }
        catch (Throwable throwable) {
            Text text2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                if (plainText) {
                    text2 = Text$.MODULE$.apply(desc);
                } else {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("description-input"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)desc);
                    Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                    text2 = elem;
                }
            } else {
                throw throwable;
            }
            Text text3 = text2;
            text = text3;
        }
        return text;
    }

    public boolean makeDescription$default$3() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String decodeURLParameter(String urlParam) {
        void var2_2;
        String param = urlParam;
        String decodedParam = URLDecoder.decode(param, "UTF-8");
        while (true) {
            String string = param;
            String string2 = decodedParam;
            if (!(string == null ? string2 != null : !string.equals(string2))) break;
            param = decodedParam;
            decodedParam = URLDecoder.decode(param, "UTF-8");
        }
        return var2_2;
    }

    public int getTimeZoneOffset() {
        return TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000 / 60;
    }

    public String makeHref(boolean proxy, String id, String origHref) {
        return proxy ? new StringBuilder(7).append("/proxy/").append(id).toString() : origHref;
    }

    public String stripXSS(String requestParameter) {
        return requestParameter == null ? null : StringEscapeUtils.escapeHtml4((String)this.NEWLINE_AND_SINGLE_QUOTE_REGEX().replaceAllIn((CharSequence)requestParameter, ""));
    }

    public Response buildErrorResponse(Response.Status status, String msg) {
        return Response.status((Response.Status)status).entity((Object)msg).type("text/plain").build();
    }

    private static final String toString$1(long num, String unit) {
        return num == 0L ? "" : (num == 1L ? new StringBuilder(1).append(num).append(" ").append(unit).toString() : new StringBuilder(2).append(num).append(" ").append(unit).append("s").toString());
    }

    public static final /* synthetic */ void $anonfun$formatDurationVerbose$1(long ms$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long durationLimit = tuple2._1$mcJ$sp();
            String durationString = (String)tuple2._2();
            if (ms$1 < durationLimit) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)durationString);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String getClass$1(int index, Seq headerClasses$1) {
        return index < headerClasses$1.size() ? (String)headerClasses$1.apply(index) : "";
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq getHeaderContent$1(String header, boolean newlinesInHeader$1) {
        Text text;
        if (newlinesInHeader$1) {
            void var3_3;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header.split("\n"))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var3_2;
                String string = x0$1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text(" "));
                $buf.$amp$plus((Object)string);
                $buf.$amp$plus((Object)new Text(" "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_2);
                return elem;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Elem.class))));
            $buf.$amp$plus((Object)new Text("\n        "));
            text = new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
        } else {
            text = Text$.MODULE$.apply(header);
        }
        return text;
    }

    public static final /* synthetic */ int $anonfun$makeProgressBar$1(Tuple2 x$4) {
        return -x$4._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$makeDescription$1(Set allowedNodeLabels$1, Node x0$1) {
        Node node = x0$1;
        if (node == null) {
            throw new MatchError((Object)node);
        }
        Node node2 = node;
        boolean bl = allowedNodeLabels$1.contains((Object)node2.label());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeDescription$4(MetaData x$6) {
        String string = x$6.key();
        String string2 = "href";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeDescription$6(String x$8) {
        return !x$8.startsWith("/");
    }

    private UIUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.TABLE_CLASS_NOT_STRIPED = "table table-bordered table-condensed";
        this.TABLE_CLASS_STRIPED = new StringBuilder(14).append(this.TABLE_CLASS_NOT_STRIPED()).append(" table-striped").toString();
        this.TABLE_CLASS_STRIPED_SORTABLE = new StringBuilder(9).append(this.TABLE_CLASS_STRIPED()).append(" sortable").toString();
        this.NEWLINE_AND_SINGLE_QUOTE_REGEX = new StringOps(Predef$.MODULE$.augmentString("(?i)(\\r\\n|\\n|\\r|%0D%0A|%0A|%0D|'|%27)")).r();
        this.dateFormat = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
            }
        };
    }
}

