/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import org.spark_project.guava.cache.LoadingCache;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0013'\u0001=B\u0001B\u0010\u0001\u0003\u0002\u0004%Ia\u0010\u0005\t\u001b\u0002\u0011\t\u0019!C\u0005\u001d\"AQ\u000b\u0001B\u0001B\u0003&\u0001\t\u0003\u0005W\u0001\t\u0005\r\u0011\"\u0003@\u0011!9\u0006A!a\u0001\n\u0013A\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0015\u0002!\t\u0011m\u0003!\u00111A\u0005\nqC\u0001\u0002\u0019\u0001\u0003\u0002\u0004%I!\u0019\u0005\tG\u0002\u0011\t\u0011)Q\u0005;\"AA\r\u0001BA\u0002\u0013%Q\r\u0003\u0005j\u0001\t\u0005\r\u0011\"\u0003k\u0011!a\u0007A!A!B\u00131\u0007\"B7\u0001\t\u0013q\u0007\"B7\u0001\t\u0013)\b\"\u0002<\u0001\t\u0003y\u0004\"B<\u0001\t\u0003y\u0004\"\u0002=\u0001\t\u0003y\u0004\"B=\u0001\t\u0003a\u0006\"\u0002>\u0001\t\u0003)\u0007\"B>\u0001\t\u0003a\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u001dA\u0011Q\u000b\u0014\t\u0002!\n9FB\u0004&M!\u0005\u0001&!\u0017\t\r5dB\u0011AA4\u0011\u001d\tI\u0007\bC\u0001\u0003WB\u0011\"a\u001e\u001d#\u0003%\t!!\u001f\t\u000f\u0005%D\u0004\"\u0001\u0002\u000e\"I\u0011\u0011\u0013\u000fC\u0002\u0013\u0005\u00111\u0013\u0005\t\u0003[c\u0002\u0015!\u0003\u0002\u0016\"9\u0011q\u0016\u000f\u0005\u0002\u0005E\u0006\"CA\u000f9\u0005\u0005I\u0011BA\u0010\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012T!a\n\u0015\u0002\u000fM$xN]1hK*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\u0004\b\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\r=\u0013'.Z2u!\tID(D\u0001;\u0015\tYD'\u0001\u0002j_&\u0011QH\u000f\u0002\u000f\u000bb$XM\u001d8bY&T\u0018M\u00197f\u0003-)\u00070Z2vi>\u0014\u0018\nZ0\u0016\u0003\u0001\u0003\"!\u0011&\u000f\u0005\tC\u0005CA\"G\u001b\u0005!%BA#/\u0003\u0019a$o\\8u})\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\u00061\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIe)A\bfq\u0016\u001cW\u000f^8s\u0013\u0012|v\fJ3r)\ty5\u000b\u0005\u0002Q#6\ta)\u0003\u0002S\r\n!QK\\5u\u0011\u001d!&!!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u00031)\u00070Z2vi>\u0014\u0018\nZ0!\u0003\u0015Awn\u001d;`\u0003%Awn\u001d;`?\u0012*\u0017\u000f\u0006\u0002P3\"9A+BA\u0001\u0002\u0004\u0001\u0015A\u00025pgR|\u0006%A\u0003q_J$x,F\u0001^!\t\u0001f,\u0003\u0002`\r\n\u0019\u0011J\u001c;\u0002\u0013A|'\u000f^0`I\u0015\fHCA(c\u0011\u001d!\u0006\"!AA\u0002u\u000ba\u0001]8si~\u0003\u0013!\u0004;pa>dwnZ=J]\u001a|w,F\u0001g!\r\u0001v\rQ\u0005\u0003Q\u001a\u0013aa\u00149uS>t\u0017!\u0005;pa>dwnZ=J]\u001a|wl\u0018\u0013fcR\u0011qj\u001b\u0005\b).\t\t\u00111\u0001g\u00039!x\u000e]8m_\u001eL\u0018J\u001c4p?\u0002\na\u0001P5oSRtD#B8reN$\bC\u00019\u0001\u001b\u00051\u0003\"\u0002 \u000e\u0001\u0004\u0001\u0005\"\u0002,\u000e\u0001\u0004\u0001\u0005\"B.\u000e\u0001\u0004i\u0006\"\u00023\u000e\u0001\u00041G#A8\u0002\u0015\u0015DXmY;u_JLE-\u0001\u0005i_N$\bk\u001c:u\u0003\u0011Awn\u001d;\u0002\tA|'\u000f^\u0001\ri>\u0004x\u000e\\8hs&sgm\\\u0001\tSN$%/\u001b<feV\tQ\u0010\u0005\u0002Q}&\u0011qP\u0012\u0002\b\u0005>|G.Z1o\u000359(/\u001b;f\u000bb$XM\u001d8bYR\u0019q*!\u0002\t\u000f\u0005\u001dQ\u00031\u0001\u0002\n\u0005\u0019q.\u001e;\u0011\u0007e\nY!C\u0002\u0002\u000ei\u0012Ab\u00142kK\u000e$x*\u001e;qkR\fAB]3bI\u0016CH/\u001a:oC2$2aTA\n\u0011\u001d\t)B\u0006a\u0001\u0003/\t!!\u001b8\u0011\u0007e\nI\"C\u0002\u0002\u001ci\u00121b\u00142kK\u000e$\u0018J\u001c9vi\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0001\u0004&B\f\u0002$\u0005=\u0002#\u0002)\u0002&\u0005%\u0012bAA\u0014\r\n1A\u000f\u001b:poN\u00042!OA\u0016\u0013\r\tiC\u000f\u0002\f\u0013>+\u0005pY3qi&|gn\t\u0002\u0002*\u0005AAo\\*ue&tw\rF\u0001A\u0003!A\u0017m\u001d5D_\u0012,G#A/\u0002\r\u0015\fX/\u00197t)\ri\u0018Q\b\u0005\b\u0003\u007fQ\u0002\u0019AA!\u0003\u0011!\b.\u0019;\u0011\u0007A\u000b\u0019%C\u0002\u0002F\u0019\u00131!\u00118zQ\r\u0001\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u00055#\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0017A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\t\u0003ar\u0019R\u0001HA.\u0003C\u00022\u0001UA/\u0013\r\tyF\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0007A\u000b\u0019'C\u0002\u0002f\u0019\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013=\fi'!\u001d\u0002t\u0005U\u0004BBA8=\u0001\u0007\u0001)\u0001\u0004fq\u0016\u001c\u0017\n\u001a\u0005\u0006qz\u0001\r\u0001\u0011\u0005\u0006sz\u0001\r!\u0018\u0005\buz\u0001\n\u00111\u0001g\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TCAA>U\r1\u0017QP\u0016\u0003\u0003\u007f\u0002B!!!\u0002\n6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0005v]\u000eDWmY6fI*\u0019\u0011q\n$\n\t\u0005-\u00151\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GcA8\u0002\u0010\"9\u0011Q\u0003\u0011A\u0002\u0005]\u0011a\u00052m_\u000e\\W*\u00198bO\u0016\u0014\u0018\nZ\"bG\",WCAAK!\u0019\t9*!+p_6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*A\u0003dC\u000eDWM\u0003\u0003\u0002 \u0006\u0005\u0016AB2p[6|gN\u0003\u0003\u0002$\u0006\u0015\u0016AB4p_\u001edWM\u0003\u0002\u0002(\u0006\u00191m\\7\n\t\u0005-\u0016\u0011\u0014\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.Z\u0001\u0015E2|7m['b]\u0006<WM]%e\u0007\u0006\u001c\u0007.\u001a\u0011\u0002/\u001d,GoQ1dQ\u0016$'\t\\8dW6\u000bg.Y4fe&#GcA8\u00024\"1\u0011QW\u0012A\u0002=\f!!\u001b3")
public class BlockManagerId
implements Externalizable {
    private String executorId_;
    private String host_;
    private int port_;
    private Option<String> topologyInfo_;

    public static BlockManagerId getCachedBlockManagerId(BlockManagerId blockManagerId) {
        return BlockManagerId$.MODULE$.getCachedBlockManagerId(blockManagerId);
    }

    public static LoadingCache<BlockManagerId, BlockManagerId> blockManagerIdCache() {
        return BlockManagerId$.MODULE$.blockManagerIdCache();
    }

    public static BlockManagerId apply(ObjectInput objectInput) {
        return BlockManagerId$.MODULE$.apply(objectInput);
    }

    public static Option<String> apply$default$4() {
        return BlockManagerId$.MODULE$.apply$default$4();
    }

    public static BlockManagerId apply(String string, String string2, int n, Option<String> option) {
        return BlockManagerId$.MODULE$.apply(string, string2, n, option);
    }

    private String executorId_() {
        return this.executorId_;
    }

    private void executorId__$eq(String x$1) {
        this.executorId_ = x$1;
    }

    private String host_() {
        return this.host_;
    }

    private void host__$eq(String x$1) {
        this.host_ = x$1;
    }

    private int port_() {
        return this.port_;
    }

    private void port__$eq(int x$1) {
        this.port_ = x$1;
    }

    private Option<String> topologyInfo_() {
        return this.topologyInfo_;
    }

    private void topologyInfo__$eq(Option<String> x$1) {
        this.topologyInfo_ = x$1;
    }

    public String executorId() {
        return this.executorId_();
    }

    public String hostPort() {
        Utils$.MODULE$.checkHost(this.host());
        Predef$.MODULE$.assert(this.port() > 0);
        return new StringBuilder(1).append(this.host()).append(":").append(this.port()).toString();
    }

    public String host() {
        return this.host_();
    }

    public int port() {
        return this.port_();
    }

    public Option<String> topologyInfo() {
        return this.topologyInfo_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDriver() {
        String string = this.executorId();
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.executorId();
        String string4 = SparkContext$.MODULE$.LEGACY_DRIVER_IDENTIFIER();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            out.writeUTF(this.executorId_());
            out.writeUTF(this.host_());
            out.writeInt(this.port_());
            out.writeBoolean(this.topologyInfo_().isDefined());
            this.topologyInfo().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                out.writeUTF(x$1);
                return BoxedUnit.UNIT;
            });
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.executorId__$eq(in.readUTF());
            this.host__$eq(in.readUTF());
            this.port__$eq(in.readInt());
            boolean isTopologyInfoAvailable = in.readBoolean();
            this.topologyInfo__$eq((Option<String>)(isTopologyInfoAvailable ? Option$.MODULE$.apply((Object)in.readUTF()) : None$.MODULE$));
        });
    }

    private Object readResolve() throws IOException {
        return BlockManagerId$.MODULE$.getCachedBlockManagerId(this);
    }

    public String toString() {
        return new StringBuilder(22).append("BlockManagerId(").append(this.executorId()).append(", ").append(this.host()).append(", ").append(this.port()).append(", ").append(this.topologyInfo()).append(")").toString();
    }

    public int hashCode() {
        return ((this.executorId().hashCode() * 41 + this.host().hashCode()) * 41 + this.port()) * 41 + this.topologyInfo().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof BlockManagerId)) return false;
        BlockManagerId blockManagerId = (BlockManagerId)object;
        String string = this.executorId();
        String string2 = blockManagerId.executorId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.port() != blockManagerId.port()) return false;
        String string3 = this.host();
        String string4 = blockManagerId.host();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<String> option = this.topologyInfo();
        Option<String> option2 = blockManagerId.topologyInfo();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public BlockManagerId(String executorId_, String host_, int port_, Option<String> topologyInfo_) {
        block0: {
            this.executorId_ = executorId_;
            this.host_ = host_;
            this.port_ = port_;
            this.topologyInfo_ = topologyInfo_;
            if (this.host_() == null) break block0;
            Utils$.MODULE$.checkHost(this.host_());
            Predef$.MODULE$.assert(this.port_() > 0);
        }
    }

    public BlockManagerId() {
        this(null, null, 0, (Option<String>)None$.MODULE$);
    }
}

