/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.BlockStoreShuffleReader;
import org.apache.spark.shuffle.BlockStoreShuffleReader$;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleHandle;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleWriter;
import org.apache.spark.shuffle.sort.SerializedShuffleHandle;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.shuffle.sort.SortShuffleWriter;
import org.apache.spark.shuffle.sort.SortShuffleWriter$;
import org.apache.spark.shuffle.sort.UnsafeShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\t\u0013\u0001Ya\u0002\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bM\u0002A\u0011\u0001\u001b\t\ra\u0002\u0001\u0015!\u0003:\u0011\u001d1\u0005A1A\u0005B\u001dCaa\u0013\u0001!\u0002\u0013A\u0005\"\u0002'\u0001\t\u0003j\u0005\"\u00027\u0001\t\u0003j\u0007bBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\tY\u0003\u0001C!\u0003[9\u0001\"!\u000e\u0013\u0011\u00031\u0012q\u0007\u0004\b#IA\tAFA\u001d\u0011\u0019\u0019D\u0002\"\u0001\u0002<!I\u0011Q\b\u0007C\u0002\u0013\u0005\u0011q\b\u0005\b\u0003\u0003b\u0001\u0015!\u0003D\u0011\u001d\t\u0019\u0005\u0004C\u0001\u0003\u000b\u0012!cU8siNCWO\u001a4mK6\u000bg.Y4fe*\u00111\u0003F\u0001\u0005g>\u0014HO\u0003\u0002\u0016-\u000591\u000f[;gM2,'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0014\t\u0001i2e\n\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"\u0001\u000b\n\u0005\u0019\"\"AD*ik\u001a4G.Z'b]\u0006<WM\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0003UY\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003aEj\u0011AF\u0005\u0003eY\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t)t\u0007\u0005\u00027\u00015\t!\u0003C\u0003.\u0005\u0001\u0007q&A\tok6l\u0015\r]:G_J\u001c\u0006.\u001e4gY\u0016\u0004BAO!D\u00076\t1H\u0003\u0002={\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002Cw\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005y!\u0015BA# \u0005\rIe\u000e^\u0001\u0015g\",hM\u001a7f\u00052|7m\u001b*fg>dg/\u001a:\u0016\u0003!\u0003\"\u0001J%\n\u0005)#\"!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\fQc\u001d5vM\u001adWM\u00117pG.\u0014Vm]8mm\u0016\u0014\b%A\bsK\u001eL7\u000f^3s'\",hM\u001a7f+\u0011qUl\u001a6\u0015\t=\u0013FK\u0016\t\u0003IAK!!\u0015\u000b\u0003\u001bMCWO\u001a4mK\"\u000bg\u000e\u001a7f\u0011\u0015\u0019f\u00011\u0001D\u0003%\u0019\b.\u001e4gY\u0016LE\rC\u0003V\r\u0001\u00071)A\u0004ok6l\u0015\r]:\t\u000b]3\u0001\u0019\u0001-\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010E\u000313n3\u0017.\u0003\u0002[-\t\t2\u000b[;gM2,G)\u001a9f]\u0012,gnY=\u0011\u0005qkF\u0002\u0001\u0003\u0006=\u001a\u0011\ra\u0018\u0002\u0002\u0017F\u0011\u0001m\u0019\t\u0003=\u0005L!AY\u0010\u0003\u000f9{G\u000f[5oOB\u0011a\u0004Z\u0005\u0003K~\u00111!\u00118z!\tav\rB\u0003i\r\t\u0007qLA\u0001W!\ta&\u000eB\u0003l\r\t\u0007qLA\u0001D\u0003%9W\r\u001e*fC\u0012,'/F\u0002ogV$Ra\u001c<yur\u0004B\u0001\n9si&\u0011\u0011\u000f\u0006\u0002\u000e'\",hM\u001a7f%\u0016\fG-\u001a:\u0011\u0005q\u001bH!\u00020\b\u0005\u0004y\u0006C\u0001/v\t\u0015YwA1\u0001`\u0011\u00159x\u00011\u0001P\u0003\u0019A\u0017M\u001c3mK\")\u0011p\u0002a\u0001\u0007\u0006q1\u000f^1siB\u000b'\u000f^5uS>t\u0007\"B>\b\u0001\u0004\u0019\u0015\u0001D3oIB\u000b'\u000f^5uS>t\u0007\"B?\b\u0001\u0004q\u0018aB2p]R,\u0007\u0010\u001e\t\u0003a}L1!!\u0001\u0017\u0005-!\u0016m]6D_:$X\r\u001f;\u0002\u0013\u001d,Go\u0016:ji\u0016\u0014XCBA\u0004\u0003#\t)\u0002\u0006\u0005\u0002\n\u0005]\u0011\u0011DA\u000f!\u001d!\u00131BA\b\u0003'I1!!\u0004\u0015\u00055\u0019\u0006.\u001e4gY\u0016<&/\u001b;feB\u0019A,!\u0005\u0005\u000byC!\u0019A0\u0011\u0007q\u000b)\u0002B\u0003i\u0011\t\u0007q\fC\u0003x\u0011\u0001\u0007q\n\u0003\u0004\u0002\u001c!\u0001\raQ\u0001\u0006[\u0006\u0004\u0018\n\u001a\u0005\u0006{\"\u0001\rA`\u0001\u0012k:\u0014XmZ5ti\u0016\u00148\u000b[;gM2,G\u0003BA\u0012\u0003S\u00012AHA\u0013\u0013\r\t9c\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019\u0016\u00021\u0001D\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005=\u0002c\u0001\u0010\u00022%\u0019\u00111G\u0010\u0003\tUs\u0017\u000e^\u0001\u0013'>\u0014Ho\u00155vM\u001adW-T1oC\u001e,'\u000f\u0005\u00027\u0019M\u0019A\"H\u0014\u0015\u0005\u0005]\u0012!M'B1~\u001b\u0006*\u0016$G\u0019\u0016{v*\u0016+Q+R{\u0006+\u0011*U\u0013RKuJT*`\r>\u0013vlU#S\u0013\u0006c\u0015JW#E?6{E)R\u000b\u0002\u0007\u0006\u0011T*\u0011-`'\"+fI\u0012'F?>+F\u000bU+U?B\u000b%\u000bV%U\u0013>s5k\u0018$P%~\u001bVIU%B\u0019&SV\tR0N\u001f\u0012+\u0005%A\fdC:,6/Z*fe&\fG.\u001b>fINCWO\u001a4mKR!\u00111EA$\u0011\u00199\u0006\u00031\u0001\u0002JAB\u00111JA(\u0003+\nY\u0006\u0005\u000513\u00065\u00131KA-!\ra\u0016q\n\u0003\f\u0003#\n9%!A\u0001\u0002\u000b\u0005qLA\u0002`IU\u00022\u0001XA+\t-\t9&a\u0012\u0002\u0002\u0003\u0005)\u0011A0\u0003\u0007}#c\u0007E\u0002]\u00037\"1\"!\u0018\u0002H\u0005\u0005\t\u0011!B\u0001?\n\u0019q\fJ\u001c")
public class SortShuffleManager
implements ShuffleManager,
Logging {
    private final SparkConf conf;
    private final ConcurrentHashMap<Object, Object> numMapsForShuffle;
    private final IndexShuffleBlockResolver shuffleBlockResolver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean canUseSerializedShuffle(ShuffleDependency<?, ?, ?> shuffleDependency) {
        return SortShuffleManager$.MODULE$.canUseSerializedShuffle(shuffleDependency);
    }

    public static int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE() {
        return SortShuffleManager$.MODULE$.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public IndexShuffleBlockResolver shuffleBlockResolver() {
        return this.shuffleBlockResolver;
    }

    @Override
    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        return SortShuffleWriter$.MODULE$.shouldBypassMergeSort(this.conf, dependency) ? new BypassMergeSortShuffleHandle<K, V>(shuffleId, numMaps, dependency) : (SortShuffleManager$.MODULE$.canUseSerializedShuffle(dependency) ? new SerializedShuffleHandle<K, V>(shuffleId, numMaps, dependency) : new BaseShuffleHandle<K, V, C>(shuffleId, numMaps, dependency));
    }

    @Override
    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        return new BlockStoreShuffleReader((BaseShuffleHandle)handle, startPartition, endPartition, context, BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$5(), BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$6(), BlockStoreShuffleReader$.MODULE$.$lessinit$greater$default$7());
    }

    @Override
    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        ShuffleWriter shuffleWriter;
        this.numMapsForShuffle.putIfAbsent(BoxesRunTime.boxToInteger((int)handle.shuffleId()), BoxesRunTime.boxToInteger((int)((BaseShuffleHandle)handle).numMaps()));
        SparkEnv env = SparkEnv$.MODULE$.get();
        ShuffleHandle shuffleHandle = handle;
        if (shuffleHandle instanceof SerializedShuffleHandle) {
            SerializedShuffleHandle serializedShuffleHandle = (SerializedShuffleHandle)shuffleHandle;
            shuffleWriter = new UnsafeShuffleWriter(env.blockManager(), this.shuffleBlockResolver(), context.taskMemoryManager(), serializedShuffleHandle, mapId, context, env.conf());
        } else if (shuffleHandle instanceof BypassMergeSortShuffleHandle) {
            BypassMergeSortShuffleHandle bypassMergeSortShuffleHandle = (BypassMergeSortShuffleHandle)shuffleHandle;
            shuffleWriter = new BypassMergeSortShuffleWriter(env.blockManager(), this.shuffleBlockResolver(), bypassMergeSortShuffleHandle, mapId, context, env.conf());
        } else if (shuffleHandle instanceof BaseShuffleHandle) {
            BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)shuffleHandle;
            shuffleWriter = new SortShuffleWriter(this.shuffleBlockResolver(), baseShuffleHandle, mapId, context);
        } else {
            throw new MatchError((Object)shuffleHandle);
        }
        return shuffleWriter;
    }

    @Override
    public boolean unregisterShuffle(int shuffleId) {
        Option$.MODULE$.apply(this.numMapsForShuffle.remove(BoxesRunTime.boxToInteger((int)shuffleId))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)numMaps -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMaps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)mapId -> this.shuffleBlockResolver().removeDataByMap(shuffleId, mapId)));
        return true;
    }

    @Override
    public void stop() {
        this.shuffleBlockResolver().stop();
    }

    public SortShuffleManager(SparkConf conf) {
        this.conf = conf;
        Logging.$init$(this);
        if (!conf.getBoolean("spark.shuffle.spill", true)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "spark.shuffle.spill was set to false, but this configuration is ignored as of Spark 1.6+. Shuffle will continue to spill to disk when necessary.");
        }
        this.numMapsForShuffle = new ConcurrentHashMap();
        this.shuffleBlockResolver = new IndexShuffleBlockResolver(conf, IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2());
    }
}

