/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.spark.SparkException;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.KryoDeserializationStream;
import org.apache.spark.serializer.KryoSerializationStream;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.ByteBufferInputStream;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\b\u0011\u0001IA\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u0011\t\u0002!\u0011!Q\u0001\n\rBQ!\u000b\u0001\u0005\u0002)BaA\f\u0001!B\u0013y\u0003B\u0002\"\u0001\t\u0003\u00012\t\u0003\u0004E\u0001\u0011\u0005\u0001#\u0012\u0005\t\u0015\u0002A)\u0019!C\u0005\u0017\"A!\u000b\u0001EC\u0002\u0013%1\u000bC\u0003X\u0001\u0011\u0005\u0003\fC\u0003y\u0001\u0011\u0005\u0013\u0010\u0003\u0004y\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0015\u0001\t\u0003\t)F\u0001\fLef|7+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0015\t\t\"#\u0001\u0006tKJL\u0017\r\\5{KJT!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003AI!\u0001\b\t\u0003%M+'/[1mSj,'/\u00138ti\u0006t7-Z\u0001\u0003WN\u001c\u0001\u0001\u0005\u0002\u001bA%\u0011\u0011\u0005\u0005\u0002\u000f\u0017JLxnU3sS\u0006d\u0017N_3s\u0003%)8/Z+og\u00064W\r\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\rYC&\f\t\u00035\u0001AQ!H\u0002A\u0002}AQAI\u0002A\u0002\r\n!bY1dQ\u0016$7J]=p!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0003lef|'B\u0001\u001b6\u0003A)7o\u001c;fe&\u001c7o\u001c4uo\u0006\u0014XMC\u00017\u0003\r\u0019w.\\\u0005\u0003qE\u0012Aa\u0013:z_\"\u0012AA\u000f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\n!\"\u00198o_R\fG/[8o\u0015\u0005y\u0014!\u00026bm\u0006D\u0018BA!=\u0005!qU\u000f\u001c7bE2,\u0017A\u00032peJ|wo\u0013:z_R\tq&A\u0006sK2,\u0017m]3Lef|GC\u0001$J!\t!s)\u0003\u0002IK\t!QK\\5u\u0011\u0015\u0011d\u00011\u00010\u0003\u0019yW\u000f\u001e9viV\tA\n\u0005\u0002N!6\taJ\u0003\u0002Pc\u0005\u0011\u0011n\\\u0005\u0003#:\u0013aaT;uaV$\u0018!B5oaV$X#\u0001+\u0011\u00055+\u0016B\u0001,O\u0005\u0015Ie\u000e];u\u0003%\u0019XM]5bY&TX-\u0006\u0002Z[R\u0011!L\u001e\u000b\u00037\u000e\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u00079LwNC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&A\u0003\"zi\u0016\u0014UO\u001a4fe\"9A-CA\u0001\u0002\b)\u0017AC3wS\u0012,gnY3%gA\u0019a-[6\u000e\u0003\u001dT!\u0001[\u0013\u0002\u000fI,g\r\\3di&\u0011!n\u001a\u0002\t\u00072\f7o\u001d+bOB\u0011A.\u001c\u0007\u0001\t\u0015q\u0017B1\u0001p\u0005\u0005!\u0016C\u00019t!\t!\u0013/\u0003\u0002sK\t9aj\u001c;iS:<\u0007C\u0001\u0013u\u0013\t)XEA\u0002B]fDQa^\u0005A\u0002-\f\u0011\u0001^\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0002{{R\u001910a\u0001\u0015\u0005qt\bC\u00017~\t\u0015q'B1\u0001p\u0011!y(\"!AA\u0004\u0005\u0005\u0011AC3wS\u0012,gnY3%iA\u0019a-\u001b?\t\r\u0005\u0015!\u00021\u0001\\\u0003\u0015\u0011\u0017\u0010^3t+\u0011\tI!a\u0004\u0015\r\u0005-\u0011qCA\r)\u0011\ti!!\u0005\u0011\u00071\fy\u0001B\u0003o\u0017\t\u0007q\u000eC\u0005\u0002\u0014-\t\t\u0011q\u0001\u0002\u0016\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\t\u0019L\u0017Q\u0002\u0005\u0007\u0003\u000bY\u0001\u0019A.\t\u000f\u0005m1\u00021\u0001\u0002\u001e\u00051An\\1eKJ\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003Gy\u0016\u0001\u00027b]\u001eLA!a\n\u0002\"\tY1\t\\1tg2{\u0017\rZ3s\u0003=\u0019XM]5bY&TXm\u0015;sK\u0006lG\u0003BA\u0017\u0003g\u00012AGA\u0018\u0013\r\t\t\u0004\u0005\u0002\u0014'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TiJ,\u0017-\u001c\u0005\b\u0003ka\u0001\u0019AA\u001c\u0003\u0005\u0019\b\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0005={\u0016\u0002BA \u0003w\u0011AbT;uaV$8\u000b\u001e:fC6\f\u0011\u0003Z3tKJL\u0017\r\\5{KN#(/Z1n)\u0011\t)%a\u0013\u0011\u0007i\t9%C\u0002\u0002JA\u0011Q\u0003R3tKJL\u0017\r\\5{CRLwN\\*ue\u0016\fW\u000eC\u0004\u000265\u0001\r!!\u0014\u0011\t\u0005e\u0012qJ\u0005\u0005\u0003#\nYDA\u0006J]B,Ho\u0015;sK\u0006l\u0017\u0001D4fi\u0006+Ho\u001c*fg\u0016$H#A\u0012")
public class KryoSerializerInstance
extends SerializerInstance {
    private Output output;
    private Input input;
    private final KryoSerializer ks;
    private final boolean useUnsafe;
    @Nullable
    private Kryo cachedKryo;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    public Kryo borrowKryo() {
        Kryo kryo;
        if (this.cachedKryo != null) {
            void var1_1;
            Kryo kryo2 = this.cachedKryo;
            kryo2.reset();
            this.cachedKryo = null;
            kryo = var1_1;
        } else {
            kryo = this.ks.newKryo();
        }
        return kryo;
    }

    public void releaseKryo(Kryo kryo) {
        block0: {
            if (this.cachedKryo != null) break block0;
            this.cachedKryo = kryo;
        }
    }

    private Output output$lzycompute() {
        KryoSerializerInstance kryoSerializerInstance = this;
        synchronized (kryoSerializerInstance) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.output = this.ks.newKryoOutput();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.output;
    }

    private Output output() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.output$lzycompute() : this.output;
    }

    private Input input$lzycompute() {
        KryoSerializerInstance kryoSerializerInstance = this;
        synchronized (kryoSerializerInstance) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.input = this.useUnsafe ? new UnsafeInput() : new Input();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.input;
    }

    private Input input() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.input$lzycompute() : this.input;
    }

    @Override
    public <T> ByteBuffer serialize(T t, ClassTag<T> evidence$3) {
        this.output().clear();
        Kryo kryo = this.borrowKryo();
        try {
            try {
                kryo.writeClassAndObject(this.output(), t);
            }
            catch (Throwable throwable) {
                KryoException kryoException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof KryoException && (kryoException = (KryoException)throwable2).getMessage().startsWith("Buffer overflow")) {
                    throw new SparkException(new StringBuilder(91).append("Kryo serialization failed: ").append(kryoException.getMessage()).append(". To avoid this, ").append("increase spark.kryoserializer.buffer.max value.").toString(), (Throwable)kryoException);
                }
                throw throwable;
            }
        }
        finally {
            this.releaseKryo(kryo);
        }
        return ByteBuffer.wrap(this.output().toBytes());
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassTag<T> evidence$4) {
        Object object;
        Kryo kryo = this.borrowKryo();
        try {
            if (bytes.hasArray()) {
                this.input().setBuffer(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            } else {
                this.input().setBuffer(new byte[4096]);
                this.input().setInputStream((InputStream)new ByteBufferInputStream(bytes));
            }
            object = kryo.readClassAndObject(this.input());
        }
        finally {
            this.releaseKryo(kryo);
        }
        return (T)object;
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassLoader loader, ClassTag<T> evidence$5) {
        Object object;
        Kryo kryo = this.borrowKryo();
        ClassLoader oldClassLoader = kryo.getClassLoader();
        try {
            kryo.setClassLoader(loader);
            if (bytes.hasArray()) {
                this.input().setBuffer(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            } else {
                this.input().setBuffer(new byte[4096]);
                this.input().setInputStream((InputStream)new ByteBufferInputStream(bytes));
            }
            object = kryo.readClassAndObject(this.input());
        }
        finally {
            kryo.setClassLoader(oldClassLoader);
            this.releaseKryo(kryo);
        }
        return (T)object;
    }

    @Override
    public SerializationStream serializeStream(OutputStream s) {
        return new KryoSerializationStream(this, s, this.useUnsafe);
    }

    @Override
    public DeserializationStream deserializeStream(InputStream s) {
        return new KryoDeserializationStream(this, s, this.useUnsafe);
    }

    public boolean getAutoReset() {
        boolean bl;
        Field field = Kryo.class.getDeclaredField("autoReset");
        field.setAccessible(true);
        Kryo kryo = this.borrowKryo();
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)field.get(kryo));
        }
        finally {
            this.releaseKryo(kryo);
        }
        return bl;
    }

    public KryoSerializerInstance(KryoSerializer ks, boolean useUnsafe) {
        this.ks = ks;
        this.useUnsafe = useUnsafe;
        this.cachedKryo = this.borrowKryo();
    }
}

