/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.ApplicationDescription$;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.client.StandaloneAppClient;
import org.apache.spark.deploy.client.StandaloneAppClientListener;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t5a!\u0002\u0015*\u00015\u001a\u0004\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006E\u0002!\ta\u0019\u0005\bw\u0001\u0001\r\u0011\"\u0003i\u0011\u001da\u0007\u00011A\u0005\n5Daa\u001d\u0001!B\u0013I\u0007b\u0002;\u0001\u0005\u0004%I!\u001e\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003w\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\u0006\u0011-\tI\u0002\u0001a\u0001\u0002\u0004%\t!a\u0007\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0005\u0005\f\u0003S\u0001\u0001\u0019!A!B\u0013\ti\u0002C\u0006\u00024\u0001\u0001\r\u00111A\u0005\n\u0005U\u0002bCA\u001c\u0001\u0001\u0007\t\u0019!C\u0005\u0003sA!\"!\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003X\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA#\u0011%\ty\u0005\u0001b\u0001\n\u0013\t\t\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA*\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA-\u0011\u001d\t9\u0007\u0001C!\u0003SBq!a\u001b\u0001\t\u0003\nI\u0007C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005M\u0004\u0001\"\u0011\u0002j!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!!/\u0001\t\u0003\nY\fC\u0004\u0002>\u0002!\t%a0\t\u000f\u0005\u0005\u0007\u0001\"\u0015\u0002D\"9\u00111\u001b\u0001\u0005R\u0005U\u0007bBAw\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003_\u0004A\u0011BA5\u0011\u001d\tY\u0007\u0001C\u0005\u0003cDaB!\u0002\u0001!\u0003\r\t\u0011!C\u0005\u0003\u007f\u00139A\u0001\u000eTi\u0006tG-\u00197p]\u0016\u001c6\r[3ek2,'OQ1dW\u0016tGM\u0003\u0002+W\u000591\r\\;ti\u0016\u0014(B\u0001\u0017.\u0003%\u00198\r[3ek2,'O\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h'\u0011\u0001A\u0007\u000f!\u0011\u0005U2T\"A\u0015\n\u0005]J#!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014AB2mS\u0016tGO\u0003\u0002>[\u00051A-\u001a9m_fL!a\u0010\u001e\u00037M#\u0018M\u001c3bY>tW-\u00119q\u00072LWM\u001c;MSN$XM\\3s!\t\tE)D\u0001C\u0015\t\u0019U&\u0001\u0005j]R,'O\\1m\u0013\t)%IA\u0004M_\u001e<\u0017N\\4\u0004\u0001A\u0011\u0001*S\u0007\u0002W%\u0011!j\u000b\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017AA:d!\tie*D\u0001.\u0013\tyUF\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0004nCN$XM]:\u0011\u0007I+v+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u0015\t%O]1z!\tAvL\u0004\u0002Z;B\u0011!lU\u0007\u00027*\u0011ALR\u0001\u0007yI|w\u000e\u001e \n\u0005y\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX*\u0002\rqJg.\u001b;?)\u0011!WMZ4\u0011\u0005U\u0002\u0001\"\u0002\u0017\u0005\u0001\u00049\u0005\"B&\u0005\u0001\u0004a\u0005\"\u0002)\u0005\u0001\u0004\tV#A5\u0011\u0005eR\u0017BA6;\u0005M\u0019F/\u00198eC2|g.Z!qa\u000ec\u0017.\u001a8u\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003]F\u0004\"AU8\n\u0005A\u001c&\u0001B+oSRDqA\u001d\u0004\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\nqa\u00197jK:$\b%\u0001\u0005ti>\u0004\b/\u001b8h+\u00051\bcA<\u0002\u00025\t\u0001P\u0003\u0002zu\u00061\u0011\r^8nS\u000eT!a\u001f?\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002~}\u0006!Q\u000f^5m\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001y\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006I1\u000f^8qa&tw\rI\u0001\u0010Y\u0006,hn\u00195fe\n\u000b7m[3oIV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0017\u0002\u00111\fWO\\2iKJLA!!\u0006\u0002\u0010\tyA*Y;oG\",'OQ1dW\u0016tG-\u0001\tmCVt7\r[3s\u0005\u0006\u001c7.\u001a8eA\u0005\u00012\u000f[;uI><hnQ1mY\n\f7m[\u000b\u0003\u0003;\u0001RAUA\u0010I:L1!!\tT\u0005%1UO\\2uS>t\u0017'\u0001\u000btQV$Hm\\<o\u0007\u0006dGNY1dW~#S-\u001d\u000b\u0004]\u0006\u001d\u0002\u0002\u0003:\u000e\u0003\u0003\u0005\r!!\b\u0002#MDW\u000f\u001e3po:\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0005K\u0002\u000f\u0003[\u00012AUA\u0018\u0013\r\t\td\u0015\u0002\tm>d\u0017\r^5mK\u0006)\u0011\r\u001d9JIV\tq+A\u0005baBLEm\u0018\u0013fcR\u0019a.a\u000f\t\u000fI\u0004\u0012\u0011!a\u0001/\u00061\u0011\r\u001d9JI\u0002B3!EA\u0017\u0003M\u0011XmZ5tiJ\fG/[8o\u0005\u0006\u0014(/[3s+\t\t)\u0005\u0005\u0003\u0002H\u0005%S\"\u0001>\n\u0007\u0005-#PA\u0005TK6\f\u0007\u000f[8sK\u0006!\"/Z4jgR\u0014\u0018\r^5p]\n\u000b'O]5fe\u0002\n\u0001\"\\1y\u0007>\u0014Xm]\u000b\u0003\u0003'\u0002RAUA+\u00033J1!a\u0016T\u0005\u0019y\u0005\u000f^5p]B\u0019!+a\u0017\n\u0007\u0005u3KA\u0002J]R\f\u0011\"\\1y\u0007>\u0014Xm\u001d\u0011\u0002%Q|G/\u00197FqB,7\r^3e\u0007>\u0014Xm]\u000b\u0003\u00033\n1\u0003^8uC2,\u0005\u0010]3di\u0016$7i\u001c:fg\u0002\nQa\u001d;beR$\u0012A\\\u0001\u0005gR|\u0007/A\u0005d_:tWm\u0019;fIR\u0019a.!\u001d\t\r\u0005M\"\u00041\u0001X\u00031!\u0017n]2p]:,7\r^3e\u0003\u0011!W-\u00193\u0015\u00079\fI\b\u0003\u0004\u0002|q\u0001\raV\u0001\u0007e\u0016\f7o\u001c8\u0002\u001b\u0015DXmY;u_J\fE\rZ3e)-q\u0017\u0011QAC\u0003\u0013\u000bi)!%\t\r\u0005\rU\u00041\u0001X\u0003\u00191W\u000f\u001c7JI\"1\u0011qQ\u000fA\u0002]\u000b\u0001b^8sW\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003\u0017k\u0002\u0019A,\u0002\u0011!|7\u000f\u001e)peRDq!a$\u001e\u0001\u0004\tI&A\u0003d_J,7\u000fC\u0004\u0002\u0014v\u0001\r!!\u0017\u0002\r5,Wn\u001c:z\u0003=)\u00070Z2vi>\u0014(+Z7pm\u0016$G#\u00038\u0002\u001a\u0006m\u0015qTAR\u0011\u0019\t\u0019I\ba\u0001/\"1\u0011Q\u0014\u0010A\u0002]\u000bq!\\3tg\u0006<W\rC\u0004\u0002\"z\u0001\r!a\u0015\u0002\u0015\u0015D\u0018\u000e^*uCR,8\u000fC\u0004\u0002&z\u0001\r!a*\u0002\u0015]|'o[3s\u0019>\u001cH\u000fE\u0002S\u0003SK1!a+T\u0005\u001d\u0011un\u001c7fC:\fQb^8sW\u0016\u0014(+Z7pm\u0016$Gc\u00028\u00022\u0006M\u0016q\u0017\u0005\u0007\u0003\u000f{\u0002\u0019A,\t\r\u0005Uv\u00041\u0001X\u0003\u0011Awn\u001d;\t\r\u0005uu\u00041\u0001X\u0003u\u0019XO\u001a4jG&,g\u000e\u001e*fg>,(oY3t%\u0016<\u0017n\u001d;fe\u0016$GCAAT\u00035\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8JIR\tq+A\fe_J+\u0017/^3tiR{G/\u00197Fq\u0016\u001cW\u000f^8sgR!\u0011QYAh!\u0019\t9-a3\u0002(6\u0011\u0011\u0011\u001a\u0006\u0003wNKA!!4\u0002J\n1a)\u001e;ve\u0016Dq!!5#\u0001\u0004\tI&\u0001\bsKF,Xm\u001d;fIR{G/\u00197\u0002\u001f\u0011|7*\u001b7m\u000bb,7-\u001e;peN$B!!2\u0002X\"9\u0011\u0011\\\u0012A\u0002\u0005m\u0017aC3yK\u000e,Ho\u001c:JIN\u0004R!!8\u0002h^sA!a8\u0002d:\u0019!,!9\n\u0003QK1!!:T\u0003\u001d\u0001\u0018mY6bO\u0016LA!!;\u0002l\n\u00191+Z9\u000b\u0007\u0005\u00158+A\nxC&$hi\u001c:SK\u001eL7\u000f\u001e:bi&|g.A\u0007o_RLg-_\"p]R,\u0007\u0010\u001e\u000b\u0004]\u0006M\bbBA{M\u0001\u0007\u0011q_\u0001\u000bM&t\u0017\r\\*uCR,\u0007\u0003BA}\u0003\u007ftA!!\u0004\u0002|&!\u0011Q`A\b\u00039\u0019\u0006/\u0019:l\u0003B\u0004\b*\u00198eY\u0016LAA!\u0001\u0003\u0004\t)1\u000b^1uK*!\u0011Q`A\b\u0003M\u0019X\u000f]3sI\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0013\u0011\tiL!\u0003\n\u0007\t-1F\u0001\tTG\",G-\u001e7fe\n\u000b7m[3oI\u0002")
public class StandaloneSchedulerBackend
extends CoarseGrainedSchedulerBackend
implements StandaloneAppClientListener {
    private final TaskSchedulerImpl scheduler;
    public final SparkContext org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc;
    private final String[] masters;
    private StandaloneAppClient client;
    private final AtomicBoolean stopping;
    private final LauncherBackend launcherBackend;
    private volatile Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback;
    private volatile String appId;
    private final Semaphore registrationBarrier;
    private final Option<Object> maxCores;
    private final int totalExpectedCores;

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$(this);
    }

    private StandaloneAppClient client() {
        return this.client;
    }

    private void client_$eq(StandaloneAppClient x$1) {
        this.client = x$1;
    }

    private AtomicBoolean stopping() {
        return this.stopping;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Function1<StandaloneSchedulerBackend, BoxedUnit> shutdownCallback() {
        return this.shutdownCallback;
    }

    public void shutdownCallback_$eq(Function1<StandaloneSchedulerBackend, BoxedUnit> x$1) {
        this.shutdownCallback = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private Semaphore registrationBarrier() {
        return this.registrationBarrier;
    }

    private Option<Object> maxCores() {
        return this.maxCores;
    }

    private int totalExpectedCores() {
        return this.totalExpectedCores;
    }

    @Override
    public void start() {
        super.start();
        String string = this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.deployMode();
        String string2 = "client";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.launcherBackend().connect();
        }
        String driverUrl = RpcEndpointAddress$.MODULE$.apply(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get("spark.driver.host"), new StringOps(Predef$.MODULE$.augmentString(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().get("spark.driver.port"))).toInt(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME()).toString();
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--driver-url", driverUrl, "--executor-id", "{{EXECUTOR_ID}}", "--hostname", "{{HOSTNAME}}", "--cores", "{{CORES}}", "--app-id", "{{APP_ID}}", "--worker-url", "{{WORKER_URL}}"}));
        Seq extraJavaOpts = (Seq)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().getOption("spark.executor.extraJavaOptions").map((Function1 & Serializable & scala.Serializable)s -> Utils$.MODULE$.splitCommandString((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Seq classPathEntries = (Seq)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().getOption("spark.executor.extraClassPath").map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split(File.pathSeparator))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq libraryPathEntries = (Seq)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf().getOption("spark.executor.extraLibraryPath").map((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split(File.pathSeparator))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Nil$ testingClassPath = package$.MODULE$.props().contains("spark.testing") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.props().apply((Object)"java.class.path")).split(File.pathSeparator))).toSeq() : Nil$.MODULE$;
        Seq<String> sparkJavaOpts = Utils$.MODULE$.sparkJavaOpts(this.conf(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        Seq javaOpts = (Seq)sparkJavaOpts.$plus$plus((GenTraversableOnce)extraJavaOpts, Seq$.MODULE$.canBuildFrom());
        Command command = new Command("org.apache.spark.executor.CoarseGrainedExecutorBackend", (Seq<String>)args, (Map<String, String>)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.executorEnvs(), (Seq<String>)((Seq)classPathEntries.$plus$plus((GenTraversableOnce)testingClassPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)libraryPathEntries, (Seq<String>)javaOpts);
        String webUrl = (String)this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.ui().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.webUrl()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option coresPerExecutor = this.conf().getOption("spark.executor.cores").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StandaloneSchedulerBackend.$anonfun$start$10(x$5)));
        None$ initialExecutorLimit = Utils$.MODULE$.isDynamicAllocationEnabled(this.conf()) ? new Some((Object)BoxesRunTime.boxToInteger((int)0)) : None$.MODULE$;
        ApplicationDescription appDesc = new ApplicationDescription(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.appName(), this.maxCores(), this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.executorMemory(), command, webUrl, this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.eventLogDir(), this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.eventLogCodec(), (Option<Object>)coresPerExecutor, (Option<Object>)initialExecutorLimit, ApplicationDescription$.MODULE$.apply$default$10());
        this.client_$eq(new StandaloneAppClient(this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.env().rpcEnv(), this.masters, appDesc, this, this.conf()));
        this.client().start();
        this.launcherBackend().setState(SparkAppHandle.State.SUBMITTED);
        this.waitForRegistration();
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public void stop() {
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void connected(String appId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Connected to Spark cluster with app ID ").append(appId).toString());
        this.appId_$eq(appId);
        this.notifyContext();
        this.launcherBackend().setAppId(appId);
    }

    @Override
    public void disconnected() {
        block0: {
            this.notifyContext();
            if (this.stopping().get()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disconnected from Spark cluster! Waiting for reconnection...");
        }
    }

    @Override
    public void dead(String reason) {
        this.notifyContext();
        if (!this.stopping().get()) {
            this.launcherBackend().setState(SparkAppHandle.State.KILLED);
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Application has been killed. Reason: ").append(reason).toString());
            try {
                this.scheduler.error(reason);
            }
            finally {
                this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.stopInNewThread();
            }
        }
    }

    @Override
    public void executorAdded(String fullId, String workerId, String hostPort, int cores, int memory) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Granted executor ID %s on hostPort %s with %d core(s), %s RAM")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId, hostPort, BoxesRunTime.boxToInteger((int)cores), Utils$.MODULE$.megabytesToString(memory)})));
    }

    @Override
    public void executorRemoved(String fullId, String message, Option<Object> exitStatus, boolean workerLost) {
        ExecutorLossReason executorLossReason;
        Option<Object> option = exitStatus;
        if (option instanceof Some) {
            Some some = (Some)option;
            int code = BoxesRunTime.unboxToInt((Object)some.value());
            executorLossReason = new ExecutorExited(code, true, message);
        } else if (None$.MODULE$.equals(option)) {
            executorLossReason = new SlaveLost(message, workerLost);
        } else {
            throw new MatchError(option);
        }
        SlaveLost reason = executorLossReason;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Executor %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullId, message})));
        this.removeExecutor(fullId.split("/")[1], reason);
    }

    @Override
    public void workerRemoved(String workerId, String host, String message) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Worker %s removed: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workerId, message})));
        this.removeWorker(workerId, host, message);
    }

    @Override
    public boolean sufficientResourcesRegistered() {
        return (double)this.totalCoreCount().get() >= (double)this.totalExpectedCores() * this.minRegisteredRatio();
    }

    @Override
    public String applicationId() {
        return (String)Option$.MODULE$.apply((Object)this.appId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    @Override
    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        Future future;
        Option option = Option$.MODULE$.apply((Object)this.client());
        if (option instanceof Some) {
            Some some = (Some)option;
            StandaloneAppClient c = (StandaloneAppClient)some.value();
            future = c.requestTotalExecutors(requestedTotal);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before driver fully initialized.");
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    @Override
    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        Future future;
        Option option = Option$.MODULE$.apply((Object)this.client());
        if (option instanceof Some) {
            Some some = (Some)option;
            StandaloneAppClient c = (StandaloneAppClient)some.value();
            future = c.killExecutors(executorIds);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before driver fully initialized.");
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private void waitForRegistration() {
        this.registrationBarrier().acquire();
    }

    private void notifyContext() {
        this.registrationBarrier().release();
    }

    public void org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State finalState) {
        if (this.stopping().compareAndSet(false, true)) {
            try {
                Function1<StandaloneSchedulerBackend, BoxedUnit> callback;
                super.stop();
                if (this.client() != null) {
                    this.client().stop();
                }
                if ((callback = this.shutdownCallback()) != null) {
                    callback.apply((Object)this);
                }
            }
            finally {
                this.launcherBackend().setState(finalState);
                this.launcherBackend().close();
            }
        }
    }

    public static final /* synthetic */ int $anonfun$maxCores$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$start$10(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public StandaloneSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, String[] masters) {
        this.scheduler = scheduler;
        this.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc = sc;
        this.masters = masters;
        super(scheduler, sc.env().rpcEnv());
        this.client = null;
        this.stopping = new AtomicBoolean(false);
        this.launcherBackend = new LauncherBackend(this){
            private final /* synthetic */ StandaloneSchedulerBackend $outer;

            public SparkConf conf() {
                return this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$sc.conf();
            }

            public void onStopRequest() {
                this.$outer.org$apache$spark$scheduler$cluster$StandaloneSchedulerBackend$$stop(SparkAppHandle.State.KILLED);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.registrationBarrier = new Semaphore(0);
        this.maxCores = this.conf().getOption("spark.cores.max").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StandaloneSchedulerBackend.$anonfun$maxCores$1(x$1)));
        this.totalExpectedCores = BoxesRunTime.unboxToInt((Object)this.maxCores().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }
}

