/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.ShuffleMapTask$;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f!B\u000f\u001f\u0001\u00012\u0003\"\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c=\u0011%i\u0004A!A!\u0002\u00131d\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002C)\u0001\u0005\u0003\u0007I\u0011\u0002*\t\u0011\t\u0004!\u00111A\u0005\n\rD\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006Ka\u0015\u0005\t]\u0002\u0011\t\u0011)A\u0005_\"Aq\u000f\u0001B\u0001B\u0003%a\tC\u0005y\u0001\t\u0005\t\u0015!\u0003zy\"QQ\u0010\u0001B\u0001B\u0003%a0a\u0004\t\u0017\u0005E\u0001A!A!\u0002\u0013q\u00181\u0003\u0005\r\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0011Q\u0004\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ty\u0002\u0001C\u0001\u0003wA\u0001\"!\u0011\u0001\u0005\u0004%IA\u0015\u0005\b\u0003\u0007\u0002\u0001\u0015!\u0003T\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Ba!!\u0016\u0001\t\u0003\u0012\u0006bBA,\u0001\u0011\u0005\u0013\u0011L\u0004\u000b\u00037r\u0012\u0011!E\u0001A\u0005uc!C\u000f\u001f\u0003\u0003E\t\u0001IA0\u0011\u001d\tyB\u0006C\u0001\u0003[B\u0011\"a\u001c\u0017#\u0003%\t!!\u001d\t\u0013\u0005\u001de#%A\u0005\u0002\u0005%\u0005\"CAG-E\u0005I\u0011AAE\u0011%\tyIFI\u0001\n\u0003\t\t\nC\u0005\u0002\u0016Z\t\t\u0011\"\u0003\u0002\u0018\nq1\u000b[;gM2,W*\u00199UCN\\'BA\u0010!\u0003%\u00198\r[3ek2,'O\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h'\r\u0001qE\f\t\u0004Q%ZS\"\u0001\u0010\n\u0005)r\"\u0001\u0002+bg.\u0004\"\u0001\u000b\u0017\n\u00055r\"!C'baN#\u0018\r^;t!\ty#'D\u00011\u0015\t\t\u0004%\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0004GA\u0004M_\u001e<\u0017N\\4\u0002\u000fM$\u0018mZ3JI\u000e\u0001\u0001CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$aA%oi&\u0011A'K\u0001\u000fgR\fw-Z!ui\u0016l\u0007\u000f^%e\u0013\ti\u0014&\u0001\u0006uCN\\')\u001b8bef\u00042!\u0011#G\u001b\u0005\u0011%BA\"!\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0002F\u0005\nI!I]8bI\u000e\f7\u000f\u001e\t\u0004o\u001dK\u0015B\u0001%9\u0005\u0015\t%O]1z!\t9$*\u0003\u0002Lq\t!!)\u001f;f\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002O\u001f6\t\u0001%\u0003\u0002QA\tI\u0001+\u0019:uSRLwN\\\u0001\u0005Y>\u001c7/F\u0001T!\r!Fl\u0018\b\u0003+js!AV-\u000e\u0003]S!\u0001W\u001b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014BA.9\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u00180\u0003\u0007M+\u0017O\u0003\u0002\\qA\u0011\u0001\u0006Y\u0005\u0003Cz\u0011A\u0002V1tW2{7-\u0019;j_:\f\u0001\u0002\\8dg~#S-\u001d\u000b\u0003I\u001e\u0004\"aN3\n\u0005\u0019D$\u0001B+oSRDq\u0001\u001b\u0004\u0002\u0002\u0003\u00071+A\u0002yIE\nQ\u0001\\8dg\u0002B#aB6\u0011\u0005]b\u0017BA79\u0005%!(/\u00198tS\u0016tG/A\bm_\u000e\fG\u000e\u0015:pa\u0016\u0014H/[3t!\t\u0001X/D\u0001r\u0015\t\u00118/\u0001\u0003vi&d'\"\u0001;\u0002\t)\fg/Y\u0005\u0003mF\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U\u0019XM]5bY&TX\r\u001a+bg.lU\r\u001e:jGN\fQA[8c\u0013\u0012\u00042a\u000e>7\u0013\tY\bH\u0001\u0004PaRLwN\\\u0005\u0003q&\nQ!\u00199q\u0013\u0012\u00042a\u000e>\u0000!\u0011\t\t!!\u0003\u000f\t\u0005\r\u0011Q\u0001\t\u0003-bJ1!a\u00029\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0001\u001d\n\u0005uL\u0013\u0001D1qa\u0006#H/Z7qi&#\u0017bAA\tS\u0005I\u0011n\u001d\"beJLWM\u001d\t\u0004o\u0005e\u0011bAA\u000eq\t9!i\\8mK\u0006t\u0017bAA\u000bS\u00051A(\u001b8jiz\"\u0002$a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d!\tA\u0003\u0001C\u00035\u001d\u0001\u0007a\u0007C\u0003>\u001d\u0001\u0007a\u0007C\u0003@\u001d\u0001\u0007\u0001\tC\u0003M\u001d\u0001\u0007Q\nC\u0003R\u001d\u0001\u00071\u000bC\u0003o\u001d\u0001\u0007q\u000eC\u0003x\u001d\u0001\u0007a\tC\u0004y\u001dA\u0005\t\u0019A=\t\u000fut\u0001\u0013!a\u0001}\"A\u0011\u0011\u0003\b\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002\u00169\u0001\n\u00111\u0001\u0002\u0018Q!\u00111EA\u001f\u0011\u0019\tyd\u0004a\u0001m\u0005Y\u0001/\u0019:uSRLwN\\%e\u00035\u0001(/\u001a4feJ,G\rT8dg\u0006q\u0001O]3gKJ\u0014X\r\u001a'pGN\u0004\u0003FA\tl\u0003\u001d\u0011XO\u001c+bg.$2aKA&\u0011\u001d\tiE\u0005a\u0001\u0003\u001f\nqaY8oi\u0016DH\u000fE\u0002O\u0003#J1!a\u0015!\u0005-!\u0016m]6D_:$X\r\u001f;\u0002%A\u0014XMZ3se\u0016$Gj\\2bi&|gn]\u0001\ti>\u001cFO]5oOR\tq0\u0001\bTQV4g\r\\3NCB$\u0016m]6\u0011\u0005!22#\u0002\f\u0002b\u0005\u001d\u0004cA\u001c\u0002d%\u0019\u0011Q\r\u001d\u0003\r\u0005s\u0017PU3g!\r9\u0014\u0011N\u0005\u0004\u0003WB$\u0001D*fe&\fG.\u001b>bE2,GCAA/\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011\u00111\u000f\u0016\u0004s\u0006U4FAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0005(\u0001\u0006b]:|G/\u0019;j_:LA!!\"\u0002|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\tYIK\u0002\u007f\u0003k\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0019\u0016\u0005\u0005M%\u0006BA\f\u0003k\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011qT:\u0002\t1\fgnZ\u0005\u0005\u0003G\u000biJ\u0001\u0004PE*,7\r\u001e")
public class ShuffleMapTask
extends Task<MapStatus>
implements Logging {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private transient Seq<TaskLocation> locs;
    private final transient Seq<TaskLocation> preferredLocs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$11() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<String> $lessinit$greater$default$10() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$10();
    }

    public static Option<String> $lessinit$greater$default$9() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<Object> $lessinit$greater$default$8() {
        return ShuffleMapTask$.MODULE$.$lessinit$greater$default$8();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<TaskLocation> locs() {
        return this.locs;
    }

    private void locs_$eq(Seq<TaskLocation> x$1) {
        this.locs = x$1;
    }

    private Seq<TaskLocation> preferredLocs() {
        return this.preferredLocs;
    }

    @Override
    public MapStatus runTask(TaskContext context) {
        MapStatus mapStatus;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long deserializeStartTime = System.currentTimeMillis();
        long deserializeStartCpuTime = threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() : 0L;
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RDD rdd = (RDD)tuple2._1();
        ShuffleDependency dep = (ShuffleDependency)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)rdd, (Object)dep);
        Tuple2 tuple23 = tuple22;
        RDD rdd2 = (RDD)tuple23._1();
        ShuffleDependency dep2 = (ShuffleDependency)tuple23._2();
        this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
        this._executorDeserializeCpuTime_$eq(threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() - deserializeStartCpuTime : 0L);
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep2.shuffleHandle(), this.partitionId(), context);
            writer.write(rdd2.iterator(this.partition, context));
            mapStatus = (MapStatus)writer.stop(true).get();
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer != null ? writer.stop(false) : BoxedUnit.UNIT;
            }
            catch (Exception e2) {
                this.log().debug("Could not stop writer", (Throwable)e2);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return mapStatus;
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("ShuffleMapTask(%d, %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.stageId()), BoxesRunTime.boxToInteger((int)this.partitionId())}));
    }

    public ShuffleMapTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, Properties localProperties, byte[] serializedTaskMetrics, Option<Object> jobId, Option<String> appId, Option<String> appAttemptId, boolean isBarrier) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.locs = locs;
        super(stageId, stageAttemptId, partition.index(), localProperties, serializedTaskMetrics, jobId, appId, appAttemptId, isBarrier);
        Logging.$init$(this);
        this.preferredLocs = this.locs() == null ? Nil$.MODULE$ : this.locs().toSet().toSeq();
    }

    public ShuffleMapTask(int partitionId) {
        this(0, 0, null, new Partition(){

            public /* synthetic */ boolean org$apache$spark$Partition$$super$equals(Object x$1) {
                return super.equals(x$1);
            }

            public int hashCode() {
                return Partition.hashCode$(this);
            }

            public boolean equals(Object other) {
                return Partition.equals$(this, other);
            }

            public int index() {
                return 0;
            }
            {
                Partition.$init$(this);
            }
        }, null, new Properties(), null, ShuffleMapTask$.MODULE$.$lessinit$greater$default$8(), ShuffleMapTask$.MODULE$.$lessinit$greater$default$9(), ShuffleMapTask$.MODULE$.$lessinit$greater$default$10(), ShuffleMapTask$.MODULE$.$lessinit$greater$default$11());
    }
}

