/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.spark.scheduler.HighlyCompressedMapStatus$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\n\u0015\u0001Ya\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\u0019\t\u0011]\u0002!\u0011!Q!\naB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006K\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)Q\u0005\u0007\"Aa\t\u0001BA\u0002\u0013%q\t\u0003\u0005W\u0001\t\u0005\r\u0011\"\u0003X\u0011!i\u0006A!A!B\u0013A\u0005\"\u00020\u0001\t\u0013y\u0006\"\u00020\u0001\t#1\u0007\"B4\u0001\t\u0003B\u0007\"B5\u0001\t\u0003R\u0007\"B7\u0001\t\u0003r\u0007\"\u0002;\u0001\t\u0003*xAB>\u0015\u0011\u00031BP\u0002\u0004\u0014)!\u0005a# \u0005\u0007=>!\t!a\u0001\t\u000f\u0005\u0015q\u0002\"\u0001\u0002\b!I\u0011QC\b\u0002\u0002\u0013%\u0011q\u0003\u0002\u001a\u0011&<\u0007\u000e\\=D_6\u0004(/Z:tK\u0012l\u0015\r]*uCR,8O\u0003\u0002\u0016-\u0005I1o\u00195fIVdWM\u001d\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sON!\u0001!H\u0012(!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0011A%J\u0007\u0002)%\u0011a\u0005\u0006\u0002\n\u001b\u0006\u00048\u000b^1ukN\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0005%|'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012a\"\u0012=uKJt\u0017\r\\5{C\ndW-A\u0002m_\u000e\u001c\u0001\u0001\u0005\u00023k5\t1G\u0003\u00025-\u000591\u000f^8sC\u001e,\u0017B\u0001\u001c4\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\f\u0011C\\;n\u001d>tW)\u001c9us\ncwnY6t!\tq\u0012(\u0003\u0002;?\t\u0019\u0011J\u001c;\u0002\u0017\u0015l\u0007\u000f^=CY>\u001c7n\u001d\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fi\tQB]8be&twMY5u[\u0006\u0004\u0018BA!?\u00055\u0011v.\u0019:j]\u001e\u0014\u0015\u000e^7ba\u00069\u0011M^4TSj,\u0007C\u0001\u0010E\u0013\t)uD\u0001\u0003M_:<\u0017A\u00045vO\u0016\u0014En\\2l'&TXm]\u000b\u0002\u0011B!\u0011\n\u0015\u001dT\u001d\tQe\n\u0005\u0002L?5\tAJ\u0003\u0002Na\u00051AH]8pizJ!aT\u0010\u0002\rA\u0013X\rZ3g\u0013\t\t&KA\u0002NCBT!aT\u0010\u0011\u0005y!\u0016BA+ \u0005\u0011\u0011\u0015\u0010^3\u0002%!,x-\u001a\"m_\u000e\\7+\u001b>fg~#S-\u001d\u000b\u00031n\u0003\"AH-\n\u0005i{\"\u0001B+oSRDq\u0001\u0018\u0004\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\nq\u0002[;hK\ncwnY6TSj,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0001\f'm\u00193f!\t!\u0003\u0001C\u00030\u0011\u0001\u0007\u0011\u0007C\u00038\u0011\u0001\u0007\u0001\bC\u0003<\u0011\u0001\u0007A\bC\u0003C\u0011\u0001\u00071\tC\u0003G\u0011\u0001\u0007\u0001\nF\u0001a\u0003!awnY1uS>tW#A\u0019\u0002\u001f\u001d,GoU5{K\u001a{'O\u00117pG.$\"aQ6\t\u000b1\\\u0001\u0019\u0001\u001d\u0002\u0011I,G-^2f\u0013\u0012\fQb\u001e:ji\u0016,\u0005\u0010^3s]\u0006dGC\u0001-p\u0011\u0015\u0001H\u00021\u0001r\u0003\ryW\u000f\u001e\t\u0003QIL!a]\u0015\u0003\u0019=\u0013'.Z2u\u001fV$\b/\u001e;\u0002\u0019I,\u0017\rZ#yi\u0016\u0014h.\u00197\u0015\u0005a3\b\"B<\u000e\u0001\u0004A\u0018AA5o!\tA\u00130\u0003\u0002{S\tYqJ\u00196fGRLe\u000e];u\u0003eA\u0015n\u001a5ms\u000e{W\u000e\u001d:fgN,G-T1q'R\fG/^:\u0011\u0005\u0011z1cA\b\u001e}B\u0011ad`\u0005\u0004\u0003\u0003y\"\u0001D*fe&\fG.\u001b>bE2,G#\u0001?\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0001\fI!a\u0003\t\u000b=\n\u0002\u0019A\u0019\t\u000f\u00055\u0011\u00031\u0001\u0002\u0010\u0005\tRO\\2p[B\u0014Xm]:fINK'0Z:\u0011\ty\t\tbQ\u0005\u0004\u0003'y\"!B!se\u0006L\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b,\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0012Q\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class HighlyCompressedMapStatus
implements MapStatus,
Externalizable {
    private BlockManagerId loc;
    private RoaringBitmap emptyBlocks;
    private long avgSize;
    private Map<Object, Object> hugeBlockSizes;

    public static HighlyCompressedMapStatus apply(BlockManagerId blockManagerId, long[] lArray) {
        return HighlyCompressedMapStatus$.MODULE$.apply(blockManagerId, lArray);
    }

    private Map<Object, Object> hugeBlockSizes() {
        return this.hugeBlockSizes;
    }

    private void hugeBlockSizes_$eq(Map<Object, Object> x$1) {
        this.hugeBlockSizes = x$1;
    }

    @Override
    public BlockManagerId location() {
        return this.loc;
    }

    @Override
    public long getSizeForBlock(int reduceId) {
        long l;
        Predef$.MODULE$.assert(this.hugeBlockSizes() != null);
        if (this.emptyBlocks.contains(reduceId)) {
            l = 0L;
        } else {
            long l2;
            Option option = this.hugeBlockSizes().get((Object)BoxesRunTime.boxToInteger((int)reduceId));
            if (option instanceof Some) {
                Some some = (Some)option;
                byte size = BoxesRunTime.unboxToByte((Object)some.value());
                l2 = MapStatus$.MODULE$.decompressSize(size);
            } else if (None$.MODULE$.equals(option)) {
                l2 = this.avgSize;
            } else {
                throw new MatchError((Object)option);
            }
            l = l2;
        }
        return l;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.loc.writeExternal(out);
            $this.emptyBlocks.writeExternal(out);
            out.writeLong($this.avgSize);
            out.writeInt(this.hugeBlockSizes().size());
            this.hugeBlockSizes().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                HighlyCompressedMapStatus.$anonfun$writeExternal$3(out, kv);
                return BoxedUnit.UNIT;
            });
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.loc = BlockManagerId$.MODULE$.apply(in);
            $this.emptyBlocks = new RoaringBitmap();
            $this.emptyBlocks.readExternal(in);
            $this.avgSize = in.readLong();
            int count = in.readInt();
            ArrayBuffer hugeBlockSizesArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)x$2 -> HighlyCompressedMapStatus.$anonfun$readExternal$3(in, hugeBlockSizesArray, BoxesRunTime.unboxToInt((Object)x$2)));
            this.hugeBlockSizes_$eq((Map<Object, Object>)hugeBlockSizesArray.toMap(Predef$.MODULE$.$conforms()));
        });
    }

    public static final /* synthetic */ void $anonfun$writeExternal$3(ObjectOutput out$2, Tuple2 kv) {
        out$2.writeInt(kv._1$mcI$sp());
        out$2.writeByte(BoxesRunTime.unboxToByte((Object)kv._2()));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$readExternal$3(ObjectInput in$2, ArrayBuffer hugeBlockSizesArray$1, int x$2) {
        int block = in$2.readInt();
        byte size = in$2.readByte();
        return hugeBlockSizesArray$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)block), (Object)BoxesRunTime.boxToByte((byte)size)));
    }

    public HighlyCompressedMapStatus(BlockManagerId loc, int numNonEmptyBlocks, RoaringBitmap emptyBlocks, long avgSize, Map<Object, Object> hugeBlockSizes) {
        this.loc = loc;
        this.emptyBlocks = emptyBlocks;
        this.avgSize = avgSize;
        this.hugeBlockSizes = hugeBlockSizes;
        Predef$.MODULE$.require(loc == null || avgSize > 0L || this.hugeBlockSizes().size() > 0 || numNonEmptyBlocks == 0, (Function0 & Serializable & scala.Serializable)() -> "Average size can only be zero for map stages that produced no output");
    }

    public HighlyCompressedMapStatus() {
        this(null, -1, null, -1L, null);
    }
}

