/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.NettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.OnStart$;
import org.apache.spark.rpc.netty.OnStop$;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteProcessConnected;
import org.apache.spark.rpc.netty.RemoteProcessConnectionError;
import org.apache.spark.rpc.netty.RemoteProcessDisconnected;
import org.apache.spark.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!\u0002\r\u001a\u0001e\u0019\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\t\u0011]\u0002!\u0011!Q\u0001\nMB\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005u!)q\b\u0001C\u0001\u0001\"9A\t\u0001b\u0001\n#)\u0005BB)\u0001A\u0003%a\tC\u0004a\u0001\u0001\u0007I\u0011B1\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\"1A\u000e\u0001Q!\n\tDqA\u001c\u0001A\u0002\u0013%\u0011\rC\u0004p\u0001\u0001\u0007I\u0011\u00029\t\rI\u0004\u0001\u0015)\u0003c\u0011\u001d!\b\u00011A\u0005\nUDq!\u001f\u0001A\u0002\u0013%!\u0010\u0003\u0004}\u0001\u0001\u0006KA\u001e\u0005\u0006}\u0002!\ta \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aa!a\u0006\u0001\t\u0003\t\u0007bBA\r\u0001\u0011E\u00111\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u0019\t\t\u0004\u0001C\u0001k\n)\u0011J\u001c2pq*\u0011!dG\u0001\u0006]\u0016$H/\u001f\u0006\u00039u\t1A\u001d9d\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0018\u000e\u00031R!!L\u000f\u0002\u0011%tG/\u001a:oC2L!a\f\u0017\u0003\u000f1{wmZ5oO\u0006YQM\u001c3q_&tGOU3g\u0007\u0001)\u0012a\r\t\u0003iUj\u0011!G\u0005\u0003me\u00111CT3uif\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001a\fA\"\u001a8ea>Lg\u000e\u001e*fM\u0002\n\u0001\"\u001a8ea>Lg\u000e^\u000b\u0002uA\u00111\bP\u0007\u00027%\u0011Qh\u0007\u0002\f%B\u001cWI\u001c3q_&tG/A\u0005f]\u0012\u0004x.\u001b8uA\u00051A(\u001b8jiz\"2!\u0011\"D!\t!\u0004\u0001C\u00031\u000b\u0001\u00071\u0007C\u00039\u000b\u0001\u0007!(\u0001\u0005nKN\u001c\u0018mZ3t+\u00051\u0005cA$M\u001d6\t\u0001J\u0003\u0002J\u0015\u0006!Q\u000f^5m\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\u00151Kgn[3e\u0019&\u001cH\u000f\u0005\u00025\u001f&\u0011\u0001+\u0007\u0002\r\u0013:\u0014w\u000e_'fgN\fw-Z\u0001\n[\u0016\u001c8/Y4fg\u0002BCaB*^=B\u0011AkW\u0007\u0002+*\u0011akV\u0001\u000bG>t7-\u001e:sK:$(B\u0001-Z\u0003)\tgN\\8uCRLwN\u001c\u0006\u00025\u0006)!.\u0019<bq&\u0011A,\u0016\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013aX\u0001\u0005i\"L7/A\u0004ti>\u0004\b/\u001a3\u0016\u0003\t\u0004\"!J2\n\u0005\u00114#a\u0002\"p_2,\u0017M\\\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0002hUB\u0011Q\u0005[\u0005\u0003S\u001a\u0012A!\u00168ji\"91.CA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005A1\u000f^8qa\u0016$\u0007\u0005\u000b\u0003\u000b'vs\u0016\u0001E3oC\ndWmQ8oGV\u0014(/\u001a8u\u0003Q)g.\u00192mK\u000e{gnY;se\u0016tGo\u0018\u0013fcR\u0011q-\u001d\u0005\bW2\t\t\u00111\u0001c\u0003E)g.\u00192mK\u000e{gnY;se\u0016tG\u000f\t\u0015\u0005\u001bMkf,\u0001\tok6\f5\r^5wKRC'/Z1egV\ta\u000f\u0005\u0002&o&\u0011\u0001P\n\u0002\u0004\u0013:$\u0018\u0001\u00068v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193t?\u0012*\u0017\u000f\u0006\u0002hw\"91nDA\u0001\u0002\u00041\u0018!\u00058v[\u0006\u001bG/\u001b<f)\"\u0014X-\u00193tA!\"\u0001cU/_\u0003\u001d\u0001(o\\2fgN$2aZA\u0001\u0011\u001d\t\u0019!\u0005a\u0001\u0003\u000b\t!\u0002Z5ta\u0006$8\r[3s!\r!\u0014qA\u0005\u0004\u0003\u0013I\"A\u0003#jgB\fGo\u00195fe\u0006!\u0001o\\:u)\r9\u0017q\u0002\u0005\u0007\u0003#\u0011\u0002\u0019\u0001(\u0002\u000f5,7o]1hK\u0006!1\u000f^8q)\u00059\u0017aB5t\u000b6\u0004H/_\u0001\u0007_:$%o\u001c9\u0015\u0007\u001d\fi\u0002\u0003\u0004\u0002\u0012U\u0001\rAT\u0001\u000bg\u00064W\r\\=DC2dG\u0003BA\u0012\u0003_!2aZA\u0013\u0011!\t9C\u0006CA\u0002\u0005%\u0012AB1di&|g\u000e\u0005\u0003&\u0003W9\u0017bAA\u0017M\tAAHY=oC6,g\bC\u00039-\u0001\u0007!(A\nhKRtU/\\!di&4X\r\u00165sK\u0006$7\u000f")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block10: {
            message = ObjectRef.create(null);
            Inbox inbox = this;
            synchronized (inbox) {
                block9: {
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) break block9;
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block9;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    break block10;
                }
                return;
            }
        }
        while (true) {
            this.safelyCall(this.endpoint(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                InboxMessage inboxMessage = (InboxMessage)message$1.elem;
                if (inboxMessage instanceof RpcMessage) {
                    BoxedUnit boxedUnit;
                    RpcMessage rpcMessage = (RpcMessage)inboxMessage;
                    RpcAddress _sender = rpcMessage.senderAddress();
                    Object content = rpcMessage.content();
                    NettyRpcCallContext context = rpcMessage.context();
                    try {
                        boxedUnit = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                            throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                        });
                    }
                    catch (Throwable e) {
                        context.sendFailure(e);
                        throw e;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (inboxMessage instanceof OneWayMessage) {
                    OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
                    RpcAddress _sender = oneWayMessage.senderAddress();
                    Object content = oneWayMessage.content();
                    BoxedUnit boxedUnit = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                        throw new SparkException(new StringBuilder(26).append("Unsupported message ").append((InboxMessage)message$1.elem).append(" from ").append(_sender).toString());
                    });
                } else if (OnStart$.MODULE$.equals(inboxMessage)) {
                    BoxedUnit boxedUnit;
                    this.endpoint().onStart();
                    if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                        Inbox inbox = this;
                        synchronized (inbox) {
                            if (!this.stopped()) {
                                this.enableConcurrent_$eq(true);
                            }
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (OnStop$.MODULE$.equals(inboxMessage)) {
                    int n;
                    Inbox inbox = this;
                    synchronized (inbox) {
                        n = this.numActiveThreads();
                    }
                    int activeThreads = n;
                    Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
                    dispatcher.removeRpcEndpointRef(this.endpoint());
                    this.endpoint().onStop();
                    Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnected) {
                    RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
                    this.endpoint().onConnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessDisconnected) {
                    RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
                    RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
                    this.endpoint().onDisconnected(remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (inboxMessage instanceof RemoteProcessConnectionError) {
                    RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
                    Throwable cause = remoteProcessConnectionError.cause();
                    RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
                    this.endpoint().onNetworkError(cause, remoteAddress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)inboxMessage);
                }
            });
            Inbox inbox = this;
            synchronized (inbox) {
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
            }
        }
    }

    public void post(InboxMessage message) {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (this.stopped()) {
                this.onDrop(message);
                object = BoxedUnit.UNIT;
            } else {
                this.messages().add(message);
                object = BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
    }

    public void stop() {
        Inbox inbox = this;
        synchronized (inbox) {
            Object object;
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                object = BoxesRunTime.boxToBoolean((boolean)this.messages().add(OnStop$.MODULE$));
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.messages().isEmpty();
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        BoxedUnit boxedUnit2;
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit2;
                    } else if (throwable4 != null) {
                        Throwable throwable5 = throwable4;
                        this.dealWithFatalError$1(throwable5);
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        throw throwable3;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                this.dealWithFatalError$1(throwable6);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public synchronized int getNumActiveThreads() {
        return this.numActiveThreads();
    }

    private final void dealWithFatalError$1(Throwable fatal) {
        Inbox inbox = this;
        synchronized (inbox) {
            Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0 & Serializable & scala.Serializable)() -> "The number of active threads should be positive.");
            this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("An error happened while processing message in the inbox for ").append(this.endpointRef()).toString(), fatal);
        throw fatal;
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        Logging.$init$(this);
        this.messages = new LinkedList();
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        Inbox inbox = this;
        synchronized (inbox) {
            this.messages().add(OnStart$.MODULE$);
        }
    }
}

