/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u00055h!\u0002\u000e\u001c\u0001})\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u0005\u0002\u0011)\u0019!C!\u0007\"AA\t\u0001B\u0001B\u0003%Q\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!Q\u0005A!A!\u0002\u00131\u0005\"B&\u0001\t\u0003a\u0005bB+\u0001\u0005\u0004%IA\u0016\u0005\u00079\u0002\u0001\u000b\u0011B,\t\u000fu\u0003!\u0019!C\u0005=\"1!\r\u0001Q\u0001\n}Cqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004l\u0001\u0001\u0006I!\u001a\u0005\nY\u0002\u0001\r\u0011!Q!\n5D\u0011\u0002\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B9\t\u0013Y\u0004\u0001\u0019!A!B\u00139\b\"C?\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005M\u0003\u0001\"\u0011\u0002~!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAu\u0001\u0011\u0005\u00131\u001e\u0002\u001a\u001d\u0016$H/\u001f\"m_\u000e\\GK]1og\u001a,'oU3sm&\u001cWM\u0003\u0002\u001d;\u0005)a.\u001a;us*\u0011adH\u0001\b]\u0016$xo\u001c:l\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7C\u0001\u0001'!\t9\u0003&D\u0001\u001e\u0013\tISD\u0001\u000bCY>\u001c7\u000e\u0016:b]N4WM]*feZL7-Z\u0001\u0005G>tgm\u0001\u0001\u0011\u00055rS\"A\u0010\n\u0005=z\"!C*qCJ\\7i\u001c8g\u0003=\u0019XmY;sSRLX*\u00198bO\u0016\u0014\bCA\u00173\u0013\t\u0019tDA\bTK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s\u0003-\u0011\u0017N\u001c3BI\u0012\u0014Xm]:\u0011\u0005YzdBA\u001c>!\tA4(D\u0001:\u0015\tQ4&\u0001\u0004=e>|GO\u0010\u0006\u0002y\u0005)1oY1mC&\u0011ahO\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?w\u0005A\u0001n\\:u\u001d\u0006lW-F\u00016\u0003%Awn\u001d;OC6,\u0007%A\u0003`a>\u0014H\u000f\u0005\u0002H\u00116\t1(\u0003\u0002Jw\t\u0019\u0011J\u001c;\u0002\u00119,XnQ8sKN\fa\u0001P5oSRtDcB'P!F\u00136\u000b\u0016\t\u0003\u001d\u0002i\u0011a\u0007\u0005\u0006U!\u0001\r\u0001\f\u0005\u0006a!\u0001\r!\r\u0005\u0006i!\u0001\r!\u000e\u0005\u0006\u0005\"\u0001\r!\u000e\u0005\u0006\u000b\"\u0001\rA\u0012\u0005\u0006\u0015\"\u0001\rAR\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A,\u0011\u0005aSV\"A-\u000b\u0005U{\u0012BA.Z\u00059Q\u0015M^1TKJL\u0017\r\\5{KJ\f1b]3sS\u0006d\u0017N_3sA\u0005Y\u0011-\u001e;i\u000b:\f'\r\\3e+\u0005y\u0006CA$a\u0013\t\t7HA\u0004C_>dW-\u00198\u0002\u0019\u0005,H\u000f[#oC\ndW\r\u001a\u0011\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015\u001e\u0003\u0011)H/\u001b7\n\u0005)<'!\u0004+sC:\u001c\bo\u001c:u\u0007>tg-\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\u0002!Q\u0014\u0018M\\:q_J$8i\u001c8uKb$\bCA\u0014o\u0013\tyWD\u0001\tUe\u0006t7\u000f]8si\u000e{g\u000e^3yi\u000611/\u001a:wKJ\u0004\"A\u001d;\u000e\u0003MT!\u0001]\u000f\n\u0005U\u001c(a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\u0002\u001b\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z!\tA80D\u0001z\u0015\tQX$\u0001\u0004dY&,g\u000e^\u0005\u0003yf\u0014a\u0003\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e$bGR|'/_\u0001\u0006CB\u0004\u0018\nZ\u0001\u0005S:LG\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001cA$\u0002\u0004%\u0019\u0011QA\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0013\u0019\u0002\u0019AA\u0006\u0003A\u0011Gn\\2l\t\u0006$\u0018-T1oC\u001e,'\u000fE\u0002(\u0003\u001bI1!a\u0004\u001e\u0005A\u0011En\\2l\t\u0006$\u0018-T1oC\u001e,'/\u0001\u0007de\u0016\fG/Z*feZ,'\u000fF\u0002r\u0003+Aq!a\u0006\u0015\u0001\u0004\tI\"\u0001\u0006c_>$8\u000f\u001e:baN\u0004b!a\u0007\u0002&\u0005-b\u0002BA\u000f\u0003Cq1\u0001OA\u0010\u0013\u0005a\u0014bAA\u0012w\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0014\u0003S\u0011A\u0001T5ti*\u0019\u00111E\u001e\u0011\u0007I\fi#C\u0002\u00020M\u0014\u0001\u0004\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\"p_R\u001cHO]1q\u00039\u0019\b.\u001e4gY\u0016lU\r\u001e:jGN$\"!!\u000e\u0011\t\u0005]\u0012QI\u0007\u0003\u0003sQA!a\u000f\u0002>\u00059Q.\u001a;sS\u000e\u001c(\u0002BA \u0003\u0003\n\u0001bY8eC\"\fG.\u001a\u0006\u0003\u0003\u0007\n1aY8n\u0013\u0011\t9%!\u000f\u0003\u00135+GO]5d'\u0016$\u0018a\u00034fi\u000eD'\t\\8dWN$b\"!\u0001\u0002N\u0005E\u0013QKA-\u0003G\n\u0019\b\u0003\u0004\u0002PY\u0001\r!N\u0001\u0005Q>\u001cH\u000f\u0003\u0004\u0002TY\u0001\rAR\u0001\u0005a>\u0014H\u000f\u0003\u0004\u0002XY\u0001\r!N\u0001\u0007Kb,7-\u00133\t\u000f\u0005mc\u00031\u0001\u0002^\u0005A!\r\\8dW&#7\u000f\u0005\u0003H\u0003?*\u0014bAA1w\t)\u0011I\u001d:bs\"9\u0011Q\r\fA\u0002\u0005\u001d\u0014\u0001\u00037jgR,g.\u001a:\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c\u001e\u0003\u001d\u0019\b.\u001e4gY\u0016LA!!\u001d\u0002l\t)\"\t\\8dW\u001a+Go\u00195j]\u001ed\u0015n\u001d;f]\u0016\u0014\bbBA;-\u0001\u0007\u0011qO\u0001\u0010i\u0016l\u0007OR5mK6\u000bg.Y4feB!\u0011\u0011NA=\u0013\u0011\tY(a\u001b\u0003'\u0011{wO\u001c7pC\u00124\u0015\u000e\\3NC:\fw-\u001a:\u0016\u0003\u0019\u000b1\"\u001e9m_\u0006$'\t\\8dWR\u0001\u00121QAH\u0003'\u000b)*a&\u0002(\u0006]\u0016\u0011\u0019\t\u0007\u0003\u000b\u000bY)!\u0001\u000e\u0005\u0005\u001d%bAAEw\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u00055\u0015q\u0011\u0002\u0007\rV$XO]3\t\r\u0005E\u0005\u00041\u00016\u0003!Awn\u001d;oC6,\u0007BBA*1\u0001\u0007a\t\u0003\u0004\u0002Xa\u0001\r!\u000e\u0005\b\u00033C\u0002\u0019AAN\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003C{\u0012aB:u_J\fw-Z\u0005\u0005\u0003K\u000byJA\u0004CY>\u001c7.\u00133\t\u000f\u0005%\u0006\u00041\u0001\u0002,\u0006I!\r\\8dW\u0012\u000bG/\u0019\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011W\u000f\u0002\r\t,hMZ3s\u0013\u0011\t),a,\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u001d\tI\f\u0007a\u0001\u0003w\u000bQ\u0001\\3wK2\u0004B!!(\u0002>&!\u0011qXAP\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u001d\t\u0019\r\u0007a\u0001\u0003\u000b\f\u0001b\u00197bgN$\u0016m\u001a\u0019\u0005\u0003\u000f\f9\u000e\u0005\u0004\u0002J\u0006=\u00171[\u0007\u0003\u0003\u0017T1!!4<\u0003\u001d\u0011XM\u001a7fGRLA!!5\u0002L\nA1\t\\1tgR\u000bw\r\u0005\u0003\u0002V\u0006]G\u0002\u0001\u0003\r\u00033\f\t-!A\u0001\u0002\u000b\u0005\u00111\u001c\u0002\u0004?\u0012\n\u0014\u0003BAo\u0003G\u00042aRAp\u0013\r\t\to\u000f\u0002\b\u001d>$\b.\u001b8h!\r9\u0015Q]\u0005\u0004\u0003O\\$aA!os\u0006)1\r\\8tKR\u0011\u0011\u0011\u0001")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private final TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    public TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Server created on ").append(this.hostName()).append(":").append($this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()).toString());
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, (Function1 & Serializable & scala.Serializable)port -> this.startService$1(BoxesRunTime.unboxToInt((Object)port), bootstraps), this.conf, this.getClass().getName())._1();
    }

    public MetricSet shuffleMetrics() {
        Predef$.MODULE$.require(this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null && this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null, (Function0 & Serializable & scala.Serializable)() -> "NettyBlockTransferServer is not initialized");
        return new MetricSet(this){
            private final HashMap<String, Metric> allMetrics;
            private final /* synthetic */ NettyBlockTransferService $outer;

            private HashMap<String, Metric> allMetrics() {
                return this.allMetrics;
            }

            public Map<String, Metric> getMetrics() {
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.getAllMetrics().getMetrics());
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getAllMetrics().getMetrics());
                return this.allMetrics();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allMetrics = new HashMap<K, V>();
            }
        };
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager tempFileManager) {
        block3: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Fetch blocks from ").append(host).append(":").append(port).append(" (executor id ").append(execId).append(")").toString());
            try {
                RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId, tempFileManager){
                    private final /* synthetic */ NettyBlockTransferService $outer;
                    private final String host$1;
                    private final int port$1;
                    private final String execId$1;
                    private final DownloadFileManager tempFileManager$1;

                    public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                        TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                        new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, blockIds, listener, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.tempFileManager$1).start();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$1 = host$1;
                        this.port$1 = port$1;
                        this.execId$1 = execId$1;
                        this.tempFileManager$1 = tempFileManager$1;
                    }
                };
                int maxRetries = this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf().maxIORetries();
                if (maxRetries > 0) {
                    new RetryingBlockFetcher(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), blockFetchStarter, blockIds, listener).start();
                    break block3;
                }
                blockFetchStarter.createAndStart(blockIds, listener);
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while beginning fetchBlocks", e);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    listener.onBlockFetchFailure(x$1, (Throwable)e);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        long l;
        Promise result = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean asStream = blockData.size() > BoxesRunTime.unboxToLong((Object)this.conf.get(package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM()));
        RpcResponseCallback callback = new RpcResponseCallback(this, blockId, asStream, result){
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final BlockId blockId$1;
            private final boolean asStream$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Successfully uploaded block ").append($this.blockId$1).append((Object)($this.asStream$1 ? " as stream" : "")).toString());
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$1).append((Object)($this.asStream$1 ? " as stream" : "")).toString(), e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.asStream$1 = asStream$1;
                this.result$1 = result$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSuccess$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$3 ), $anonfun$onFailure$1(org.apache.spark.network.netty.NettyBlockTransferService$$anon$3 )}, serializedLambda);
            }
        };
        if (asStream) {
            ByteBuffer streamHeader = new UploadBlockStream(blockId.name(), metadata).toByteBuffer();
            l = client.uploadStream((ManagedBuffer)new NioManagedBuffer(streamHeader), blockData, callback);
        } else {
            byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
            l = client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.name(), metadata, array).toByteBuffer(), callback);
        }
        return result.future();
    }

    @Override
    public void close() {
        block1: {
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
                this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
            }
            if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory == null) break block1;
            this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
        }
    }

    private final Tuple2 startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores);
    }
}

