/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import java.nio.ByteBuffer;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.ShuffleClient;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.EncryptedManagedBuffer;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ucA\u0002\u0006\f\u0003\u0003i1\u0003C\u0003)\u0001\u0011\u0005!\u0006C\u0003.\u0001\u0019\u0005a\u0006C\u0003;\u0001\u0019\u00051\bC\u0003=\u0001\u0019\u0005Q\bC\u0003B\u0001\u0019\u0005!\tC\u0003O\u0001\u0019\u0005s\nC\u0003e\u0001\u0019\u0005Q\rC\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D\t!\"\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016T!\u0001D\u0007\u0002\u000f9,Go^8sW*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0005\u0003\u0001)i\u0011\u0003CA\u000b\u0019\u001b\u00051\"BA\f\f\u0003\u001d\u0019\b.\u001e4gY\u0016L!!\u0007\f\u0003\u001bMCWO\u001a4mK\u000ec\u0017.\u001a8u!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0002j_*\tq$\u0001\u0003kCZ\f\u0017BA\u0011\u001d\u0005%\u0019En\\:fC\ndW\r\u0005\u0002$M5\tAE\u0003\u0002&\u001b\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002(I\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003-\u0002\"\u0001\f\u0001\u000e\u0003-\tA!\u001b8jiR\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0005+:LG\u000fC\u00037\u0005\u0001\u0007q'\u0001\tcY>\u001c7\u000eR1uC6\u000bg.Y4feB\u0011A\u0006O\u0005\u0003s-\u0011\u0001C\u00117pG.$\u0015\r^1NC:\fw-\u001a:\u0002\u000b\rdwn]3\u0015\u0003=\nA\u0001]8siV\ta\b\u0005\u00021\u007f%\u0011\u0001)\r\u0002\u0004\u0013:$\u0018\u0001\u00035pgRt\u0015-\\3\u0016\u0003\r\u0003\"\u0001R&\u000f\u0005\u0015K\u0005C\u0001$2\u001b\u00059%B\u0001%*\u0003\u0019a$o\\8u}%\u0011!*M\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002Kc\u0005Ya-\u001a;dQ\ncwnY6t)\u001dy\u0003KU*V5~CQ!\u0015\u0004A\u0002\r\u000bA\u0001[8ti\")AH\u0002a\u0001}!)AK\u0002a\u0001\u0007\u00061Q\r_3d\u0013\u0012DQA\u0016\u0004A\u0002]\u000b\u0001B\u00197pG.LEm\u001d\t\u0004aa\u001b\u0015BA-2\u0005\u0015\t%O]1z\u0011\u0015Yf\u00011\u0001]\u0003!a\u0017n\u001d;f]\u0016\u0014\bCA\u000b^\u0013\tqfCA\u000bCY>\u001c7NR3uG\"Lgn\u001a'jgR,g.\u001a:\t\u000b\u00014\u0001\u0019A1\u0002\u001fQ,W\u000e\u001d$jY\u0016l\u0015M\\1hKJ\u0004\"!\u00062\n\u0005\r4\"a\u0005#po:dw.\u00193GS2,W*\u00198bO\u0016\u0014\u0018aC;qY>\fGM\u00117pG.$\"B\u001a7o_BD\u0018\u0011AA\u0006!\r9'nL\u0007\u0002Q*\u0011\u0011.M\u0001\u000bG>t7-\u001e:sK:$\u0018BA6i\u0005\u00191U\u000f^;sK\")Qn\u0002a\u0001\u0007\u0006A\u0001n\\:u]\u0006lW\rC\u0003=\u000f\u0001\u0007a\bC\u0003U\u000f\u0001\u00071\tC\u0003r\u000f\u0001\u0007!/A\u0004cY>\u001c7.\u00133\u0011\u0005M4X\"\u0001;\u000b\u0005Ul\u0011aB:u_J\fw-Z\u0005\u0003oR\u0014qA\u00117pG.LE\rC\u0003z\u000f\u0001\u0007!0A\u0005cY>\u001c7\u000eR1uCB\u00111P`\u0007\u0002y*\u0011QpC\u0001\u0007EV4g-\u001a:\n\u0005}d(!D'b]\u0006<W\r\u001a\"vM\u001a,'\u000fC\u0004\u0002\u0004\u001d\u0001\r!!\u0002\u0002\u000b1,g/\u001a7\u0011\u0007M\f9!C\u0002\u0002\nQ\u0014Ab\u0015;pe\u0006<W\rT3wK2Dq!!\u0004\b\u0001\u0004\ty!\u0001\u0005dY\u0006\u001c8\u000fV1ha\u0011\t\t\"!\t\u0011\r\u0005M\u0011\u0011DA\u000f\u001b\t\t)BC\u0002\u0002\u0018E\nqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u001c\u0005U!\u0001C\"mCN\u001cH+Y4\u0011\t\u0005}\u0011\u0011\u0005\u0007\u0001\t1\t\u0019#a\u0003\u0002\u0002\u0003\u0005)\u0011AA\u0013\u0005\ryF%M\t\u0005\u0003O\ti\u0003E\u00021\u0003SI1!a\u000b2\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001MA\u0018\u0013\r\t\t$\r\u0002\u0004\u0003:L\u0018A\u00044fi\u000eD'\t\\8dWNKhn\u0019\u000b\fu\u0006]\u0012\u0011HA\u001e\u0003{\ty\u0004C\u0003R\u0011\u0001\u00071\tC\u0003=\u0011\u0001\u0007a\bC\u0003U\u0011\u0001\u00071\tC\u0003r\u0011\u0001\u00071\tC\u0003a\u0011\u0001\u0007\u0011-A\bva2|\u0017\r\u001a\"m_\u000e\\7+\u001f8d)=y\u0013QIA$\u0003\u0013\nY%!\u0014\u0002P\u0005E\u0003\"B7\n\u0001\u0004\u0019\u0005\"\u0002\u001f\n\u0001\u0004q\u0004\"\u0002+\n\u0001\u0004\u0019\u0005\"B9\n\u0001\u0004\u0011\b\"B=\n\u0001\u0004Q\bbBA\u0002\u0013\u0001\u0007\u0011Q\u0001\u0005\b\u0003\u001bI\u0001\u0019AA*a\u0011\t)&!\u0017\u0011\r\u0005M\u0011\u0011DA,!\u0011\ty\"!\u0017\u0005\u0019\u0005m\u0013\u0011KA\u0001\u0002\u0003\u0015\t!!\n\u0003\u0007}##\u0007")
public abstract class BlockTransferService
extends ShuffleClient
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract void init(BlockDataManager var1);

    public abstract void close();

    public abstract int port();

    public abstract String hostName();

    public abstract void fetchBlocks(String var1, int var2, String var3, String[] var4, BlockFetchingListener var5, DownloadFileManager var6);

    public abstract Future<BoxedUnit> uploadBlock(String var1, int var2, String var3, BlockId var4, ManagedBuffer var5, StorageLevel var6, ClassTag<?> var7);

    public ManagedBuffer fetchBlockSync(String host, int port, String execId, String blockId, DownloadFileManager tempFileManager) {
        Promise result = Promise$.MODULE$.apply();
        this.fetchBlocks(host, port, execId, (String[])((Object[])new String[]{blockId}), new BlockFetchingListener(null, result){
            private final Promise result$1;

            public void onBlockFetchFailure(String blockId, Throwable exception) {
                this.result$1.failure(exception);
            }

            public void onBlockFetchSuccess(String blockId, ManagedBuffer data) {
                ManagedBuffer managedBuffer = data;
                if (managedBuffer instanceof FileSegmentManagedBuffer) {
                    FileSegmentManagedBuffer fileSegmentManagedBuffer = (FileSegmentManagedBuffer)managedBuffer;
                    this.result$1.success((Object)fileSegmentManagedBuffer);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (managedBuffer instanceof EncryptedManagedBuffer) {
                    EncryptedManagedBuffer encryptedManagedBuffer = (EncryptedManagedBuffer)managedBuffer;
                    this.result$1.success((Object)((Object)encryptedManagedBuffer));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit;
                    try {
                        ByteBuffer ret = ByteBuffer.allocate((int)data.size());
                        ret.put(data.nioByteBuffer());
                        ret.flip();
                        this.result$1.success((Object)new NioManagedBuffer(ret));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable e) {
                        this.result$1.failure(e);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
            }
            {
                this.result$1 = result$1;
            }
        }, tempFileManager);
        return (ManagedBuffer)ThreadUtils$.MODULE$.awaitResult(result.future(), (Duration)Duration$.MODULE$.Inf());
    }

    public void uploadBlockSync(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Future<BoxedUnit> future = this.uploadBlock(hostname, port, execId, blockId, blockData, level, classTag);
        ThreadUtils$.MODULE$.awaitResult(future, (Duration)Duration$.MODULE$.Inf());
    }

    public BlockTransferService() {
        Logging.$init$(this);
    }
}

