/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StaticMemoryManager$;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4Q!\u0006\f\u00011yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0013\u0007\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"B\u001c\u0001\t\u0003A\u0004\"B\u001c\u0001\t\u0003q\u0004bB!\u0001\u0005\u0004%I!\r\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u0016\t\u000b\r\u0003A\u0011I\u0019\t\u000b\u0011\u0003A\u0011I#\t\u000ba\u0003A\u0011I-\t\ru\u0003A\u0011\t\f_\u000f\u0019\u0019g\u0003#\u0001\u0019I\u001a1QC\u0006E\u00011\u0015DQaN\b\u0005\u0002%DqA[\bC\u0002\u0013%1\u000e\u0003\u0004m\u001f\u0001\u0006I\u0001\u000e\u0005\u0006[>!IA\u001c\u0005\u0006a>!I!\u001d\u0002\u0014'R\fG/[2NK6|'/_'b]\u0006<WM\u001d\u0006\u0003/a\ta!\\3n_JL(BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u00051\u0012B\u0001\u0012\u0017\u00055iU-\\8ss6\u000bg.Y4fe\u0006!1m\u001c8g\u0007\u0001\u0001\"AJ\u0014\u000e\u0003aI!\u0001\u000b\r\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001G7bq>s\u0007*Z1q\u000bb,7-\u001e;j_:lU-\\8ssB\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!Aj\u001c8h\u0003Yi\u0017\r_(o\u0011\u0016\f\u0007o\u0015;pe\u0006<W-T3n_JLX#\u0001\u0016\u0002/5\f\u0007p\u00148IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef\u0004\u0013\u0001\u00038v[\u000e{'/Z:\u0011\u0005-*\u0014B\u0001\u001c-\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000beR4\bP\u001f\u0011\u0005\u0001\u0002\u0001\"B\u0012\u0007\u0001\u0004)\u0003\"B\u0015\u0007\u0001\u0004Q\u0003\"\u0002\u0019\u0007\u0001\u0004Q\u0003\"B\u001a\u0007\u0001\u0004!DcA\u001d@\u0001\")1e\u0002a\u0001K!)1g\u0002a\u0001i\u0005yQ.\u0019=V]J|G\u000e\\'f[>\u0014\u00180\u0001\tnCb,fN]8mY6+Wn\u001c:zA\u00059R.\u0019=PM\u001aDU-\u00199Ti>\u0014\u0018mZ3NK6|'/_\u0001\u0015C\u000e\fX/\u001b:f'R|'/Y4f\u001b\u0016lwN]=\u0015\t\u0019K\u0015k\u0015\t\u0003W\u001dK!\u0001\u0013\u0017\u0003\u000f\t{w\u000e\\3b]\")!j\u0003a\u0001\u0017\u00069!\r\\8dW&#\u0007C\u0001'P\u001b\u0005i%B\u0001(\u0019\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001U'\u0003\u000f\tcwnY6JI\")!k\u0003a\u0001U\u0005Aa.^7CsR,7\u000fC\u0003U\u0017\u0001\u0007Q+\u0001\u0006nK6|'/_'pI\u0016\u0004\"\u0001\t,\n\u0005]3\"AC'f[>\u0014\u00180T8eK\u0006\u0019\u0012mY9vSJ,WK\u001c:pY2lU-\\8ssR!aIW.]\u0011\u0015QE\u00021\u0001L\u0011\u0015\u0011F\u00021\u0001+\u0011\u0015!F\u00021\u0001V\u0003Y\t7-];je\u0016,\u00050Z2vi&|g.T3n_JLH\u0003\u0002\u0016`A\nDQAU\u0007A\u0002)BQ!Y\u0007A\u0002)\nQ\u0002^1tW\u0006#H/Z7qi&#\u0007\"\u0002+\u000e\u0001\u0004)\u0016aE*uCRL7-T3n_JLX*\u00198bO\u0016\u0014\bC\u0001\u0011\u0010'\tya\r\u0005\u0002,O&\u0011\u0001\u000e\f\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0011\f\u0001#T%O?6+Uj\u0014*Z?\nKF+R*\u0016\u0003Q\n\u0011#T%O?6+Uj\u0014*Z?\nKF+R*!\u0003M9W\r^'bqN#xN]1hK6+Wn\u001c:z)\tQs\u000eC\u0003$'\u0001\u0007Q%A\u000bhKRl\u0015\r_#yK\u000e,H/[8o\u001b\u0016lwN]=\u0015\u0005)\u0012\b\"B\u0012\u0015\u0001\u0004)\u0003")
public class StaticMemoryManager
extends MemoryManager {
    private final long maxOnHeapStorageMemory;
    private final long maxUnrollMemory;

    @Override
    public long maxOnHeapStorageMemory() {
        return this.maxOnHeapStorageMemory;
    }

    private long maxUnrollMemory() {
        return this.maxUnrollMemory;
    }

    @Override
    public long maxOffHeapStorageMemory() {
        return 0L;
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        boolean bl;
        MemoryMode memoryMode2 = memoryMode;
        MemoryMode memoryMode3 = MemoryMode.OFF_HEAP;
        Predef$.MODULE$.require(memoryMode2 == null ? memoryMode3 != null : !((Object)((Object)memoryMode2)).equals((Object)memoryMode3), (Function0 & java.io.Serializable & Serializable)() -> "StaticMemoryManager does not support off-heap storage memory");
        if (numBytes > this.maxOnHeapStorageMemory()) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(80).append("Will not store ").append(blockId).append(" as the required space (").append(numBytes).append(" bytes) exceeds our ").append("memory limit (").append(this.maxOnHeapStorageMemory()).append(" bytes)").toString());
            bl = false;
        } else {
            bl = this.onHeapStorageMemoryPool().acquireMemory(blockId, numBytes);
        }
        return bl;
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        MemoryMode memoryMode3 = MemoryMode.OFF_HEAP;
        Predef$.MODULE$.require(memoryMode2 == null ? memoryMode3 != null : !((Object)((Object)memoryMode2)).equals((Object)memoryMode3), (Function0 & java.io.Serializable & Serializable)() -> "StaticMemoryManager does not support off-heap unroll memory");
        long currentUnrollMemory = this.onHeapStorageMemoryPool().memoryStore().currentUnrollMemory();
        long freeMemory = this.onHeapStorageMemoryPool().memoryFree();
        long maxNumBytesToFree = package$.MODULE$.max(0L, this.maxUnrollMemory() - currentUnrollMemory - freeMemory);
        long numBytesToFree = package$.MODULE$.max(0L, package$.MODULE$.min(maxNumBytesToFree, numBytes - freeMemory));
        return this.onHeapStorageMemoryPool().acquireMemory(blockId, numBytes, numBytesToFree);
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        long l;
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            l = this.onHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.onHeapExecutionMemoryPool().acquireMemory$default$3(), this.onHeapExecutionMemoryPool().acquireMemory$default$4());
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            l = this.offHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.offHeapExecutionMemoryPool().acquireMemory$default$3(), this.offHeapExecutionMemoryPool().acquireMemory$default$4());
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        return l;
    }

    public StaticMemoryManager(SparkConf conf, long maxOnHeapExecutionMemory, long maxOnHeapStorageMemory, int numCores) {
        this.maxOnHeapStorageMemory = maxOnHeapStorageMemory;
        super(conf, numCores, maxOnHeapStorageMemory, maxOnHeapExecutionMemory);
        this.offHeapExecutionMemoryPool().incrementPoolSize(this.offHeapStorageMemoryPool().poolSize());
        this.offHeapStorageMemoryPool().decrementPoolSize(this.offHeapStorageMemoryPool().poolSize());
        this.maxUnrollMemory = (long)((double)maxOnHeapStorageMemory * conf.getDouble("spark.storage.unrollFraction", 0.2));
    }

    public StaticMemoryManager(SparkConf conf, int numCores) {
        this(conf, StaticMemoryManager$.MODULE$.org$apache$spark$memory$StaticMemoryManager$$getMaxExecutionMemory(conf), StaticMemoryManager$.MODULE$.org$apache$spark$memory$StaticMemoryManager$$getMaxStorageMemory(conf), numCores);
    }
}

