/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;

public final class StaticMemoryManager$ {
    public static StaticMemoryManager$ MODULE$;
    private final int MIN_MEMORY_BYTES;

    static {
        new StaticMemoryManager$();
    }

    private int MIN_MEMORY_BYTES() {
        return this.MIN_MEMORY_BYTES;
    }

    public long org$apache$spark$memory$StaticMemoryManager$$getMaxStorageMemory(SparkConf conf) {
        long systemMaxMemory = conf.getLong("spark.testing.memory", Runtime.getRuntime().maxMemory());
        double memoryFraction = conf.getDouble("spark.storage.memoryFraction", 0.6);
        double safetyFraction = conf.getDouble("spark.storage.safetyFraction", 0.9);
        return (long)((double)systemMaxMemory * memoryFraction * safetyFraction);
    }

    public long org$apache$spark$memory$StaticMemoryManager$$getMaxExecutionMemory(SparkConf conf) {
        long executorMemory;
        long systemMaxMemory = conf.getLong("spark.testing.memory", Runtime.getRuntime().maxMemory());
        if (systemMaxMemory < (long)this.MIN_MEMORY_BYTES()) {
            throw new IllegalArgumentException(new StringBuilder(139).append("System memory ").append(systemMaxMemory).append(" must ").append("be at least ").append(this.MIN_MEMORY_BYTES()).append(". Please increase heap size using the --driver-memory ").append("option or spark.driver.memory in Spark configuration.").toString());
        }
        if (conf.contains("spark.executor.memory") && (executorMemory = conf.getSizeAsBytes("spark.executor.memory")) < (long)this.MIN_MEMORY_BYTES()) {
            throw new IllegalArgumentException(new StringBuilder(151).append("Executor memory ").append(executorMemory).append(" must be at least ").append(this.MIN_MEMORY_BYTES()).append(". Please increase executor memory using the ").append("--executor-memory option or spark.executor.memory in Spark configuration.").toString());
        }
        double memoryFraction = conf.getDouble("spark.shuffle.memoryFraction", 0.2);
        double safetyFraction = conf.getDouble("spark.shuffle.safetyFraction", 0.8);
        return (long)((double)systemMaxMemory * memoryFraction * safetyFraction);
    }

    private StaticMemoryManager$() {
        MODULE$ = this;
        this.MIN_MEMORY_BYTES = 0x2000000;
    }
}

