/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DriverDescription;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.master.DriverState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.deploy.worker.ProcessBuilderLike;
import org.apache.spark.deploy.worker.ProcessBuilderLike$;
import org.apache.spark.deploy.worker.Sleeper;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc!\u0002\u00180\u0001EJ\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!Q1A\u0005\u00025C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t5\u0002\u0011)\u0019!C\u00017\"AA\r\u0001B\u0001B\u0003%A\f\u0003\u0005f\u0001\t\u0015\r\u0011\"\u0001\\\u0011!1\u0007A!A!\u0002\u0013a\u0006\u0002C4\u0001\u0005\u000b\u0007I\u0011\u00015\t\u00115\u0004!\u0011!Q\u0001\n%D\u0001\u0002\r\u0001\u0003\u0006\u0004%\tA\u001c\u0005\tk\u0002\u0011\t\u0011)A\u0005_\"Aa\u000f\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003O\u0011!A\bA!b\u0001\n\u0003I\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u000by\u0004A\u0011A@\t\u0013\u0005U\u0001\u00011A\u0005\n\u0005]\u0001\"CA\u0016\u0001\u0001\u0007I\u0011BA\u0017\u0011!\tI\u0004\u0001Q!\n\u0005e\u0001\"CA\"\u0001\u0001\u0007I\u0011BA#\u0011%\ti\u0005\u0001a\u0001\n\u0013\ty\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0015BA$\u0011)\t9\u0006\u0001a\u0001\n\u0003y\u0013\u0011\f\u0005\u000b\u0003\u0007\u0003\u0001\u0019!C\u0001_\u0005\u0015\u0005\u0002CAE\u0001\u0001\u0006K!a\u0017\t\u0015\u00055\u0005\u00011A\u0005\u0002=\ny\t\u0003\u0006\u0002&\u0002\u0001\r\u0011\"\u00010\u0003OC\u0001\"a+\u0001A\u0003&\u0011\u0011\u0013\u0005\n\u0003_\u0003!\u0019!C\u0005\u0003cC\u0001\"!/\u0001A\u0003%\u00111\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0011\u001d\ty\r\u0001C\u0001\u0003#D\u0011\"!8\u0001\u0001\u0004%I!a8\t\u0013\u0005\u0005\b\u00011A\u0005\n\u0005\r\b\u0002CAt\u0001\u0001\u0006K!a1\t\u0013\u0005%\b\u00011A\u0005\n\u0005-\b\"CA{\u0001\u0001\u0007I\u0011BA|\u0011!\t\u0019\u0010\u0001Q!\n\u00055\b\u0002CA~\u0001\u0011\u0005q&!@\t\u0011\u0005}\b\u0001\"\u00010\u0003{DqA!\u0001\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\u0006\u0001!IAa\u0002\t\u0011\t5\u0001\u0001\"\u00010\u0005\u001fAqAa\u0006\u0001\t\u0013\u0011I\u0002\u0003\u0005\u0003.\u0001!\ta\fB\u0018\u00051!%/\u001b<feJ+hN\\3s\u0015\t\u0001\u0014'\u0001\u0004x_J\\WM\u001d\u0006\u0003eM\na\u0001Z3qY>L(B\u0001\u001b6\u0003\u0015\u0019\b/\u0019:l\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\u0014\u0007\u0001Q\u0004\t\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007N\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u000b\n\u0013q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u0013*k\u0011aM\u0005\u0003\u0017N\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0011\u0011\u0014\u0018N^3s\u0013\u0012,\u0012A\u0014\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EcT\"\u0001*\u000b\u0005M;\u0015A\u0002\u001fs_>$h(\u0003\u0002Vy\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)F(A\u0005ee&4XM]%eA\u00059qo\u001c:l\t&\u0014X#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017AA5p\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\t\u0019KG.Z\u0001\to>\u00148\u000eR5sA\u0005I1\u000f]1sW\"{W.Z\u0001\u000bgB\f'o\u001b%p[\u0016\u0004\u0013A\u00033sSZ,'\u000fR3tGV\t\u0011\u000e\u0005\u0002kW6\t\u0011'\u0003\u0002mc\t\tBI]5wKJ$Um]2sSB$\u0018n\u001c8\u0002\u0017\u0011\u0014\u0018N^3s\t\u0016\u001c8\rI\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!oM\u0001\u0004eB\u001c\u0017B\u0001;r\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fqa^8sW\u0016\u0014\b%A\u0005x_J\\WM]+sY\u0006Qqo\u001c:lKJ,&\u000f\u001c\u0011\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ,\u0012A\u001f\t\u0003\u0013nL!\u0001`\u001a\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\f\u0001c]3dkJLG/_'b]\u0006<WM\u001d\u0011\u0002\rqJg.\u001b;?)I\t\t!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0011\u0007\u0005\r\u0001!D\u00010\u0011\u00151\u0005\u00031\u0001I\u0011\u0015a\u0005\u00031\u0001O\u0011\u0015Q\u0006\u00031\u0001]\u0011\u0015)\u0007\u00031\u0001]\u0011\u00159\u0007\u00031\u0001j\u0011\u0015\u0001\u0004\u00031\u0001p\u0011\u00151\b\u00031\u0001O\u0011\u0015A\b\u00031\u0001{\u0003\u001d\u0001(o\\2fgN,\"!!\u0007\u0011\u000bm\nY\"a\b\n\u0007\u0005uAH\u0001\u0004PaRLwN\u001c\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u00051\u0002\t1\fgnZ\u0005\u0005\u0003S\t\u0019CA\u0004Qe>\u001cWm]:\u0002\u0017A\u0014xnY3tg~#S-\u001d\u000b\u0005\u0003_\t)\u0004E\u0002<\u0003cI1!a\r=\u0005\u0011)f.\u001b;\t\u0013\u0005]\"#!AA\u0002\u0005e\u0011a\u0001=%c\u0005A\u0001O]8dKN\u001c\b\u0005K\u0002\u0014\u0003{\u00012aOA \u0013\r\t\t\u0005\u0010\u0002\tm>d\u0017\r^5mK\u000611.\u001b7mK\u0012,\"!a\u0012\u0011\u0007m\nI%C\u0002\u0002Lq\u0012qAQ8pY\u0016\fg.\u0001\u0006lS2dW\rZ0%KF$B!a\f\u0002R!I\u0011qG\u000b\u0002\u0002\u0003\u0007\u0011qI\u0001\bW&dG.\u001a3!Q\r1\u0012QH\u0001\u000bM&t\u0017\r\\*uCR,WCAA.!\u0015Y\u00141DA/!\u0011\ty&! \u000f\t\u0005\u0005\u0014q\u000f\b\u0005\u0003G\n\u0019H\u0004\u0003\u0002f\u0005Ed\u0002BA4\u0003_rA!!\u001b\u0002n9\u0019\u0011+a\u001b\n\u0003aJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\r\t)(M\u0001\u0007[\u0006\u001cH/\u001a:\n\t\u0005e\u00141P\u0001\f\tJLg/\u001a:Ti\u0006$XMC\u0002\u0002vEJA!a \u0002\u0002\nYAI]5wKJ\u001cF/\u0019;f\u0015\u0011\tI(a\u001f\u0002\u001d\u0019Lg.\u00197Ti\u0006$Xm\u0018\u0013fcR!\u0011qFAD\u0011%\t9\u0004GA\u0001\u0002\u0004\tY&A\u0006gS:\fGn\u0015;bi\u0016\u0004\u0003fA\r\u0002>\u0005qa-\u001b8bY\u0016C8-\u001a9uS>tWCAAI!\u0015Y\u00141DAJ!\u0011\t)*a(\u000f\t\u0005]\u00151\u0014\b\u0004#\u0006e\u0015\"A\u001f\n\u0007\u0005uE(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00161\u0015\u0002\n\u000bb\u001cW\r\u001d;j_:T1!!(=\u0003I1\u0017N\\1m\u000bb\u001cW\r\u001d;j_:|F%Z9\u0015\t\u0005=\u0012\u0011\u0016\u0005\n\u0003oY\u0012\u0011!a\u0001\u0003#\u000bqBZ5oC2,\u0005pY3qi&|g\u000e\t\u0015\u00049\u0005u\u0012a\u0007#S\u0013Z+%k\u0018+F%6Ke*\u0011+F?RKU*R(V)~k5+\u0006\u0002\u00024B\u00191(!.\n\u0007\u0005]FH\u0001\u0003M_:<\u0017\u0001\b#S\u0013Z+%k\u0018+F%6Ke*\u0011+F?RKU*R(V)~k5\u000bI\u0001\tg\u0016$8\t\\8dWR!\u0011qFA`\u0011\u001d\t\tm\ba\u0001\u0003\u0007\faaX2m_\u000e\\\u0007\u0003BAc\u0003\u0017l!!a2\u000b\u0007\u0005%7'\u0001\u0003vi&d\u0017\u0002BAg\u0003\u000f\u0014Qa\u00117pG.\f!b]3u'2,W\r]3s)\u0011\ty#a5\t\u000f\u0005U\u0007\u00051\u0001\u0002X\u0006Aql\u001d7fKB,'\u000f\u0005\u0003\u0002\u0004\u0005e\u0017bAAn_\t91\u000b\\3fa\u0016\u0014\u0018!B2m_\u000e\\WCAAb\u0003%\u0019Gn\\2l?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005\u0015\b\"CA\u001cE\u0005\u0005\t\u0019AAb\u0003\u0019\u0019Gn\\2lA\u000591\u000f\\3fa\u0016\u0014XCAAw%\u0015\tyOOAl\r\u0019\t\tP\n\u0001\u0002n\naAH]3gS:,W.\u001a8u}\u0005A1\u000f\\3fa\u0016\u0014\b%A\u0006tY\u0016,\u0007/\u001a:`I\u0015\fH\u0003BA\u0018\u0003sD\u0011\"a\u000e&\u0003\u0003\u0005\r!!<\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005=\u0012\u0001B6jY2\fac\u0019:fCR,wk\u001c:lS:<G)\u001b:fGR|'/\u001f\u000b\u00029\u0006yAm\\<oY>\fG-V:fe*\u000b'\u000fF\u0002O\u0005\u0013AaAa\u0003+\u0001\u0004a\u0016!\u00033sSZ,'\u000fR5s\u0003M\u0001(/\u001a9be\u0016\fe\u000e\u001a*v]\u0012\u0013\u0018N^3s)\t\u0011\t\u0002E\u0002<\u0005'I1A!\u0006=\u0005\rIe\u000e^\u0001\neVtGI]5wKJ$\u0002B!\u0005\u0003\u001c\t\u0015\"\u0011\u0006\u0005\b\u0005;a\u0003\u0019\u0001B\u0010\u0003\u001d\u0011W/\u001b7eKJ\u0004B!!\t\u0003\"%!!1EA\u0012\u00059\u0001&o\\2fgN\u0014U/\u001b7eKJDaAa\n-\u0001\u0004a\u0016a\u00022bg\u0016$\u0015N\u001d\u0005\b\u0005Wa\u0003\u0019AA$\u0003%\u0019X\u000f]3sm&\u001cX-A\nsk:\u001cu.\\7b]\u0012<\u0016\u000e\u001e5SKR\u0014\u0018\u0010\u0006\u0005\u0003\u0012\tE\"1\bB#\u0011\u001d\u0011\u0019$\fa\u0001\u0005k\tqaY8n[\u0006tG\r\u0005\u0003\u0002\u0004\t]\u0012b\u0001B\u001d_\t\u0011\u0002K]8dKN\u001c()^5mI\u0016\u0014H*[6f\u0011\u001d\u0011i$\fa\u0001\u0005\u007f\t!\"\u001b8ji&\fG.\u001b>f!\u001dY$\u0011IA\u0010\u0003_I1Aa\u0011=\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0003,5\u0002\r!a\u0012")
public class DriverRunner
implements Logging {
    private final SparkConf conf;
    private final String driverId;
    private final File workDir;
    private final File sparkHome;
    private final DriverDescription driverDesc;
    private final RpcEndpointRef worker;
    private final String workerUrl;
    private final SecurityManager securityManager;
    private volatile Option<Process> process;
    private volatile boolean org$apache$spark$deploy$worker$DriverRunner$$killed;
    private volatile Option<Enumeration.Value> finalState;
    private volatile Option<Exception> finalException;
    private final long DRIVER_TERMINATE_TIMEOUT_MS;
    private Clock clock;
    private Sleeper sleeper;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String driverId() {
        return this.driverId;
    }

    public File workDir() {
        return this.workDir;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public DriverDescription driverDesc() {
        return this.driverDesc;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public SecurityManager securityManager() {
        return this.securityManager;
    }

    private Option<Process> process() {
        return this.process;
    }

    private void process_$eq(Option<Process> x$1) {
        this.process = x$1;
    }

    public boolean org$apache$spark$deploy$worker$DriverRunner$$killed() {
        return this.org$apache$spark$deploy$worker$DriverRunner$$killed;
    }

    private void org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(boolean x$1) {
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = x$1;
    }

    public Option<Enumeration.Value> finalState() {
        return this.finalState;
    }

    public void finalState_$eq(Option<Enumeration.Value> x$1) {
        this.finalState = x$1;
    }

    public Option<Exception> finalException() {
        return this.finalException;
    }

    public void finalException_$eq(Option<Exception> x$1) {
        this.finalException = x$1;
    }

    private long DRIVER_TERMINATE_TIMEOUT_MS() {
        return this.DRIVER_TERMINATE_TIMEOUT_MS;
    }

    public void setClock(Clock _clock) {
        this.clock_$eq(_clock);
    }

    public void setSleeper(Sleeper _sleeper) {
        this.sleeper_$eq(_sleeper);
    }

    private Clock clock() {
        return this.clock;
    }

    private void clock_$eq(Clock x$1) {
        this.clock = x$1;
    }

    private Sleeper sleeper() {
        return this.sleeper;
    }

    private void sleeper_$eq(Sleeper x$1) {
        this.sleeper = x$1;
    }

    public void start() {
        new Thread(this){
            private final /* synthetic */ DriverRunner $outer;

            public void run() {
                Object shutdownHook = null;
                try {
                    try {
                        shutdownHook = ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Worker shutting down, killing driver ").append($this.$outer.driverId()).toString());
                            $this.$outer.kill();
                        });
                        int exitCode = this.$outer.prepareAndRunDriver();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)(exitCode == 0 ? new Some((Object)DriverState$.MODULE$.FINISHED()) : (this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed() ? new Some((Object)DriverState$.MODULE$.KILLED()) : new Some((Object)DriverState$.MODULE$.FAILED()))));
                    }
                    catch (Exception e) {
                        this.$outer.kill();
                        this.$outer.finalState_$eq((Option<Enumeration.Value>)new Some((Object)DriverState$.MODULE$.ERROR()));
                        this.$outer.finalException_$eq((Option<Exception>)new Some((Object)e));
                    }
                }
                finally {
                    if (shutdownHook != null) {
                        ShutdownHookManager$.MODULE$.removeShutdownHook(shutdownHook);
                    }
                }
                this.$outer.worker().send(new DeployMessages.DriverStateChanged(this.$outer.driverId(), (Enumeration.Value)this.$outer.finalState().get(), this.$outer.finalException()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(17).append("DriverRunner for ").append($outer.driverId()).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.deploy.worker.DriverRunner$$anon$2 ), $anonfun$run$2(org.apache.spark.deploy.worker.DriverRunner$$anon$2 )}, serializedLambda);
            }
        }.start();
    }

    public void kill() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing driver process!");
        this.org$apache$spark$deploy$worker$DriverRunner$$killed_$eq(true);
        DriverRunner driverRunner = this;
        synchronized (driverRunner) {
            this.process().foreach((Function1 & Serializable & scala.Serializable)p -> {
                DriverRunner.$anonfun$kill$2(this, p);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private File createWorkingDirectory() {
        void var1_1;
        File driverDir = new File(this.workDir(), this.driverId());
        if (!driverDir.exists() && !driverDir.mkdirs()) {
            throw new IOException(new StringBuilder(27).append("Failed to create directory ").append(driverDir).toString());
        }
        return var1_1;
    }

    private String downloadUserJar(File driverDir) {
        String jarFileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new URI(this.driverDesc().jarUrl()).getPath().split("/"))).last();
        File localJarFile = new File(driverDir, jarFileName);
        if (!localJarFile.exists()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Copying user jar ").append(this.driverDesc().jarUrl()).append(" to ").append(localJarFile).toString());
            Utils$.MODULE$.fetchFile(this.driverDesc().jarUrl(), driverDir, this.conf, this.securityManager(), SparkHadoopUtil$.MODULE$.get().newConfiguration(this.conf), System.currentTimeMillis(), false);
            if (!localJarFile.exists()) {
                throw new IOException(new StringBuilder(60).append("Can not find expected jar ").append(jarFileName).append(" which should have been loaded in ").append(driverDir).toString());
            }
        }
        return localJarFile.getAbsolutePath();
    }

    public int prepareAndRunDriver() {
        File driverDir = this.createWorkingDirectory();
        String localJarFilename = this.downloadUserJar(driverDir);
        ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(this.driverDesc().command(), this.securityManager(), this.driverDesc().mem(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables$1((String)argument, localJarFilename), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
        return this.runDriver(builder, driverDir, this.driverDesc().supervise());
    }

    private int runDriver(ProcessBuilder builder, File baseDir, boolean supervise) {
        builder.directory(baseDir);
        return this.runCommandWithRetry(ProcessBuilderLike$.MODULE$.apply(builder), (Function1<Process, BoxedUnit>)(Function1 & Serializable & scala.Serializable)process -> {
            DriverRunner.initialize$1(process, baseDir, builder);
            return BoxedUnit.UNIT;
        }, supervise);
    }

    public int runCommandWithRetry(ProcessBuilderLike command, Function1<Process, BoxedUnit> initialize, boolean supervise) {
        boolean keepTrying;
        IntRef exitCode = IntRef.create((int)-1);
        IntRef waitSeconds = IntRef.create((int)1);
        int successfulRunDuration = 5;
        boolean bl = keepTrying = !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
        while (keepTrying) {
            block7: {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch Command: ").append(command.command().mkString("\"", "\" \"", "\"")).toString());
                DriverRunner driverRunner = this;
                synchronized (driverRunner) {
                    int n;
                    block6: {
                        if (this.org$apache$spark$deploy$worker$DriverRunner$$killed()) {
                            n = exitCode.elem;
                            break block6;
                        }
                        this.process_$eq((Option<Process>)new Some((Object)command.start()));
                        initialize.apply(this.process().get());
                        break block7;
                    }
                    return n;
                }
            }
            long processStart = this.clock().getTimeMillis();
            exitCode.elem = ((Process)this.process().get()).waitFor();
            keepTrying = supervise && exitCode.elem != 0 && !this.org$apache$spark$deploy$worker$DriverRunner$$killed();
            if (!keepTrying) continue;
            if (this.clock().getTimeMillis() - processStart > (long)successfulRunDuration * 1000L) {
                waitSeconds.elem = 1;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Command exited with status ").append(exitCode$1.elem).append(", re-launching after ").append(waitSeconds$1.elem).append(" s.").toString());
            this.sleeper().sleep(waitSeconds.elem);
            waitSeconds.elem *= 2;
        }
        return exitCode.elem;
    }

    public static final /* synthetic */ void $anonfun$kill$2(DriverRunner $this, Process p) {
        block0: {
            Option<Object> exitCode = Utils$.MODULE$.terminateProcess(p, $this.DRIVER_TERMINATE_TIMEOUT_MS());
            if (!exitCode.isEmpty()) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to terminate driver process: ").append(p).append(". This process will likely be orphaned.").toString());
        }
    }

    private final String substituteVariables$1(String argument, String localJarFilename$1) {
        String string = argument;
        String string2 = "{{WORKER_URL}}".equals(string) ? this.workerUrl() : ("{{USER_JAR}}".equals(string) ? localJarFilename$1 : string);
        return string2;
    }

    private static final void initialize$1(Process process, File baseDir$1, ProcessBuilder builder$1) {
        File stdout = new File(baseDir$1, "stdout");
        CommandUtils$.MODULE$.redirectStream(process.getInputStream(), stdout);
        File stderr = new File(baseDir$1, "stderr");
        String formattedCommand = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(builder$1.command()).asScala()).mkString("\"", "\" \"", "\"");
        String header = new StringOps(Predef$.MODULE$.augmentString("Launch Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
        Files.append((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
        CommandUtils$.MODULE$.redirectStream(process.getErrorStream(), stderr);
    }

    public DriverRunner(SparkConf conf, String driverId, File workDir, File sparkHome, DriverDescription driverDesc, RpcEndpointRef worker, String workerUrl, SecurityManager securityManager) {
        this.conf = conf;
        this.driverId = driverId;
        this.workDir = workDir;
        this.sparkHome = sparkHome;
        this.driverDesc = driverDesc;
        this.worker = worker;
        this.workerUrl = workerUrl;
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.process = None$.MODULE$;
        this.org$apache$spark$deploy$worker$DriverRunner$$killed = false;
        this.finalState = None$.MODULE$;
        this.finalException = None$.MODULE$;
        this.DRIVER_TERMINATE_TIMEOUT_MS = conf.getTimeAsMs("spark.worker.driverTerminateTimeout", "10s");
        this.clock = new SystemClock();
        this.sleeper = new Sleeper(this){
            private final /* synthetic */ DriverRunner $outer;

            public void sleep(int seconds) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), seconds).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> {
                    Thread.sleep(1000L);
                    return !$this.$outer.org$apache$spark$deploy$worker$DriverRunner$$killed();
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$sleep$1(org.apache.spark.deploy.worker.DriverRunner$$anon$1 int )}, serializedLambda);
            }
        };
    }
}

