/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.security.HBaseDelegationTokenProvider;
import org.apache.spark.deploy.security.HadoopDelegationTokenProvider;
import org.apache.spark.deploy.security.HadoopFSDelegationTokenProvider;
import org.apache.spark.deploy.security.HiveDelegationTokenProvider;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\t\u0013\u0001Ya\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0011=\u0002!\u0011!Q\u0001\nAB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u00191\u0007\u0001)A\u0005-\"9q\r\u0001b\u0001\n\u0013A\u0007BB5\u0001A\u0003%a\fC\u0004k\u0001\t\u0007I\u0011B6\t\rQ\u0004\u0001\u0015!\u0003m\u0011\u0015i\u0005\u0001\"\u0001v\u0011\u0015A\b\u0001\"\u0003l\u0011\u0015I\b\u0001\"\u0003{\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002\u001e\u0001!\t!a\b\u00039!\u000bGm\\8q\t\u0016dWmZ1uS>tGk\\6f]6\u000bg.Y4fe*\u00111\u0003F\u0001\tg\u0016\u001cWO]5us*\u0011QCF\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c2\u0001A\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0011AeJ\u0007\u0002K)\u0011aEF\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0003%\u0019\b/\u0019:l\u0007>tgm\u0001\u0001\u0011\u00051jS\"\u0001\f\n\u000592\"!C*qCJ\\7i\u001c8g\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003cYj\u0011A\r\u0006\u0003gQ\nAaY8oM*\u0011Q\u0007G\u0001\u0007Q\u0006$wn\u001c9\n\u0005]\u0012$!D\"p]\u001aLw-\u001e:bi&|g.A\u0006gS2,7+_:uK6\u001c\b\u0003\u0002\u0010;aqJ!aO\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001fE\u000f:\u0011aH\u0011\t\u0003\u007f}i\u0011\u0001\u0011\u0006\u0003\u0003*\na\u0001\u0010:p_Rt\u0014BA\" \u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0004'\u0016$(BA\" !\tA5*D\u0001J\u0015\tQE'\u0001\u0002gg&\u0011A*\u0013\u0002\u000b\r&dWmU=ti\u0016l\u0017A\u0002\u001fj]&$h\b\u0006\u0003P#J\u001b\u0006C\u0001)\u0001\u001b\u0005\u0011\u0002\"B\u0015\u0005\u0001\u0004Y\u0003\"B\u0018\u0005\u0001\u0004\u0001\u0004\"\u0002\u001d\u0005\u0001\u0004I\u0014\u0001\t3faJ,7-\u0019;fIB\u0013xN^5eKJ,e.\u00192mK\u0012\u001cuN\u001c4jON,\u0012A\u0016\t\u0004/rsV\"\u0001-\u000b\u0005eS\u0016!C5n[V$\u0018M\u00197f\u0015\tYv$\u0001\u0006d_2dWm\u0019;j_:L!!\u0018-\u0003\t1K7\u000f\u001e\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA\u0001\\1oO*\t1-\u0001\u0003kCZ\f\u0017BA3a\u0005\u0019\u0019FO]5oO\u0006\tC-\u001a9sK\u000e\fG/\u001a3Qe>4\u0018\u000eZ3s\u000b:\f'\r\\3e\u0007>tg-[4tA\u0005)\u0002O]8wS\u0012,'/\u00128bE2,GmQ8oM&<W#\u00010\u0002-A\u0014xN^5eKJ,e.\u00192mK\u0012\u001cuN\u001c4jO\u0002\n\u0001\u0004Z3mK\u001e\fG/[8o)>\\WM\u001c)s_ZLG-\u001a:t+\u0005a\u0007\u0003B\u001fn_FL!A\u001c$\u0003\u00075\u000b\u0007\u000f\u0005\u0002>a&\u0011QM\u0012\t\u0003!JL!a\u001d\n\u0003;!\u000bGm\\8q\t\u0016dWmZ1uS>tGk\\6f]B\u0013xN^5eKJ\f\u0011\u0004Z3mK\u001e\fG/[8o)>\\WM\u001c)s_ZLG-\u001a:tAQ\u0019qJ^<\t\u000b%Z\u0001\u0019A\u0016\t\u000b=Z\u0001\u0019\u0001\u0019\u00027\u001d,G\u000fR3mK\u001e\fG/[8o)>\\WM\u001c)s_ZLG-\u001a:t\u0003I\u0019\u0018MZ3De\u0016\fG/\u001a)s_ZLG-\u001a:\u0015\u0005mt\bc\u0001\u0010}c&\u0011Qp\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f}lA\u00111\u0001\u0002\u0002\u0005A1M]3bi\u00164e\u000e\u0005\u0003\u001f\u0003\u0007\t\u0018bAA\u0003?\tAAHY=oC6,g(\u0001\tjgN+'O^5dK\u0016s\u0017M\u00197fIR!\u00111BA\t!\rq\u0012QB\u0005\u0004\u0003\u001fy\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003'q\u0001\u0019A8\u0002\u0017M,'O^5dK:\u000bW.Z\u0001\"O\u0016$8+\u001a:wS\u000e,G)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000e\u0015:pm&$WM\u001d\u000b\u0004w\u0006e\u0001BBA\u000e\u001f\u0001\u0007q.A\u0004tKJ4\u0018nY3\u0002-=\u0014G/Y5o\t\u0016dWmZ1uS>tGk\\6f]N$b!!\t\u0002(\u0005%\u0002c\u0001\u0010\u0002$%\u0019\u0011QE\u0010\u0003\t1{gn\u001a\u0005\u0006_A\u0001\r\u0001\r\u0005\b\u0003W\u0001\u0002\u0019AA\u0017\u0003\u0015\u0019'/\u001a3t!\u0011\ty#a\r\u000e\u0005\u0005E\"BA\n5\u0013\u0011\t)$!\r\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d")
public class HadoopDelegationTokenManager
implements Logging {
    private final SparkConf sparkConf;
    private final Function1<Configuration, Set<FileSystem>> fileSystems;
    private final List<String> deprecatedProviderEnabledConfigs;
    private final String providerEnabledConfig;
    private final Map<String, HadoopDelegationTokenProvider> delegationTokenProviders;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private List<String> deprecatedProviderEnabledConfigs() {
        return this.deprecatedProviderEnabledConfigs;
    }

    private String providerEnabledConfig() {
        return this.providerEnabledConfig;
    }

    private Map<String, HadoopDelegationTokenProvider> delegationTokenProviders() {
        return this.delegationTokenProviders;
    }

    private Map<String, HadoopDelegationTokenProvider> getDelegationTokenProviders() {
        Seq providers = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HadoopFSDelegationTokenProvider[]{new HadoopFSDelegationTokenProvider(this.fileSystems)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.safeCreateProvider((Function0<HadoopDelegationTokenProvider>)(Function0 & Serializable & scala.Serializable)() -> new HiveDelegationTokenProvider())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.safeCreateProvider((Function0<HadoopDelegationTokenProvider>)(Function0 & Serializable & scala.Serializable)() -> new HBaseDelegationTokenProvider())), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)((TraversableLike)providers.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.isServiceEnabled(p.serviceName())))).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)p.serviceName(), p), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Option<HadoopDelegationTokenProvider> safeCreateProvider(Function0<HadoopDelegationTokenProvider> createFn) {
        Some some;
        try {
            some = new Some(createFn.apply());
        }
        catch (Throwable t) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load built in provider.", t);
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean isServiceEnabled(String serviceName) {
        String key = new StringOps(Predef$.MODULE$.augmentString(this.providerEnabledConfig())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName}));
        this.deprecatedProviderEnabledConfigs().foreach((Function1 & Serializable & scala.Serializable)pattern -> {
            HadoopDelegationTokenManager.$anonfun$isServiceEnabled$1(this, serviceName, key, pattern);
            return BoxedUnit.UNIT;
        });
        boolean isEnabledDeprecated = this.deprecatedProviderEnabledConfigs().forall((Function1 & Serializable & scala.Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegationTokenManager.$anonfun$isServiceEnabled$3(this, serviceName, pattern)));
        return BoxesRunTime.unboxToBoolean((Object)this.sparkConf.getOption(key).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegationTokenManager.$anonfun$isServiceEnabled$6(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> isEnabledDeprecated));
    }

    public Option<HadoopDelegationTokenProvider> getServiceDelegationTokenProvider(String service) {
        return this.delegationTokenProviders().get((Object)service);
    }

    public long obtainDelegationTokens(Configuration hadoopConf, Credentials creds) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.delegationTokenProviders().values().flatMap((Function1 & Serializable & scala.Serializable)provider -> {
            Iterable iterable;
            if (provider.delegationTokensRequired($this.sparkConf, hadoopConf)) {
                iterable = Option$.MODULE$.option2Iterable(provider.obtainDelegationTokens(hadoopConf, $this.sparkConf, creds));
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Service ").append(provider.serviceName()).append(" does not require a token.").append(" Check your configuration to see if security is disabled or not.").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x, y) -> package$.MODULE$.min(x, y)));
    }

    public static final /* synthetic */ void $anonfun$isServiceEnabled$1(HadoopDelegationTokenManager $this, String serviceName$1, String key$1, String pattern) {
        block0: {
            String deprecatedKey = new StringOps(Predef$.MODULE$.augmentString(pattern)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName$1}));
            if (!$this.sparkConf.contains(deprecatedKey)) break block0;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append(deprecatedKey).append(" is deprecated.  Please use ").append(key$1).append(" instead.").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isServiceEnabled$4(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isServiceEnabled$3(HadoopDelegationTokenManager $this, String serviceName$1, String pattern) {
        return BoxesRunTime.unboxToBoolean((Object)$this.sparkConf.getOption(new StringOps(Predef$.MODULE$.augmentString(pattern)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName$1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopDelegationTokenManager.$anonfun$isServiceEnabled$4(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    public static final /* synthetic */ boolean $anonfun$isServiceEnabled$6(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public HadoopDelegationTokenManager(SparkConf sparkConf, Configuration hadoopConf, Function1<Configuration, Set<FileSystem>> fileSystems) {
        this.sparkConf = sparkConf;
        this.fileSystems = fileSystems;
        Logging.$init$(this);
        this.deprecatedProviderEnabledConfigs = new .colon.colon((Object)"spark.yarn.security.tokens.%s.enabled", (List)new .colon.colon((Object)"spark.yarn.security.credentials.%s.enabled", (List)Nil$.MODULE$));
        this.providerEnabledConfig = "spark.security.credentials.%s.enabled";
        this.delegationTokenProviders = this.getDelegationTokenProviders();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Using the following builtin delegation token providers: ").append(this.delegationTokenProviders().keys().mkString(", ")).append(".").toString());
    }

    public HadoopDelegationTokenManager(SparkConf sparkConf, Configuration hadoopConf) {
        this(sparkConf, hadoopConf, (Function1<Configuration, Set<FileSystem>>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<FileSystem> apply(Configuration hadoopConf) {
                return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileSystem[]{FileSystem.get((Configuration)hadoopConf).getHomeDirectory().getFileSystem(hadoopConf)}));
            }
        });
    }
}

