/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.KillSubmissionResponse;
import org.apache.spark.deploy.rest.RestSubmissionClient$;
import org.apache.spark.deploy.rest.RestSubmissionServer$;
import org.apache.spark.deploy.rest.SubmissionStatusResponse;
import org.apache.spark.deploy.rest.SubmitRestConnectionException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException$;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage$;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\ra!\u0002\u0015*\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b5\u0003A\u0011\u0001(\t\u000fI\u0003!\u0019!C\u0005'\"1\u0011\r\u0001Q\u0001\nQCqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u001a\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0001\b\u0001)A\u0005U\")\u0011\u000f\u0001C\u0001e\")1\u0010\u0001C\u0001y\"1q\u0010\u0001C\u0001\u0003\u0003A\u0011\"a\u0004\u0001#\u0003%\t!!\u0005\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003?\u0002A\u0011BA1\u0011!\tI\u0007\u0001C\u0001S\u0005-\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000b<\u0001\"a3*\u0011\u0003i\u0013Q\u001a\u0004\bQ%B\t!LAh\u0011\u0019iU\u0004\"\u0001\u0002R\"I\u00111[\u000fC\u0002\u0013%\u0011Q\u001b\u0005\t\u0003Gl\u0002\u0015!\u0003\u0002X\"I\u0011Q]\u000fC\u0002\u0013%\u0011q\u001d\u0005\t\u0003_l\u0002\u0015!\u0003\u0002j\"I\u0011\u0011_\u000fC\u0002\u0013%\u0011q\u001d\u0005\t\u0003gl\u0002\u0015!\u0003\u0002j\"I\u0011Q_\u000fC\u0002\u0013\u0005\u0011q\u001f\u0005\b\u0003sl\u0002\u0015!\u0003[\u0011!\tY0\bC\u0001S\u0005u(\u0001\u0006*fgR\u001cVOY7jgNLwN\\\"mS\u0016tGO\u0003\u0002+W\u0005!!/Z:u\u0015\taS&\u0001\u0004eKBdw.\u001f\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sON\u0019\u0001\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tYd(D\u0001=\u0015\tiT&\u0001\u0005j]R,'O\\1m\u0013\tyDHA\u0004M_\u001e<\u0017N\\4\u0002\r5\f7\u000f^3s\u0007\u0001\u0001\"a\u0011&\u000f\u0005\u0011C\u0005CA#7\u001b\u00051%BA$B\u0003\u0019a$o\\8u}%\u0011\u0011JN\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002Jm\u00051A(\u001b8jiz\"\"aT)\u0011\u0005A\u0003Q\"A\u0015\t\u000b\u0001\u0013\u0001\u0019\u0001\"\u0002/M,\b\u000f]8si\u0016$W*Y:uKJ\u0004&/\u001a4jq\u0016\u001cX#\u0001+\u0011\u0007UC&,D\u0001W\u0015\t9f'\u0001\u0006d_2dWm\u0019;j_:L!!\u0017,\u0003\u0007M+\u0017\u000f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006!A.\u00198h\u0015\u0005y\u0016\u0001\u00026bm\u0006L!a\u0013/\u00021M,\b\u000f]8si\u0016$W*Y:uKJ\u0004&/\u001a4jq\u0016\u001c\b%A\u0004nCN$XM]:\u0016\u0003\u0011\u00042!N3C\u0013\t1gGA\u0003BeJ\f\u00170\u0001\u0005nCN$XM]:!\u0003-awn\u001d;NCN$XM]:\u0016\u0003)\u00042a\u001b8C\u001b\u0005a'BA7W\u0003\u001diW\u000f^1cY\u0016L!a\u001c7\u0003\u000f!\u000b7\u000f[*fi\u0006aAn\\:u\u001b\u0006\u001cH/\u001a:tA\u0005\u00012M]3bi\u0016\u001cVOY7jgNLwN\u001c\u000b\u0003gZ\u0004\"\u0001\u0015;\n\u0005UL#AG*vE6LGOU3tiB\u0013x\u000e^8d_2\u0014Vm\u001d9p]N,\u0007\"B<\n\u0001\u0004A\u0018a\u0002:fcV,7\u000f\u001e\t\u0003!fL!A_\u0015\u0003/\r\u0013X-\u0019;f'V\u0014W.[:tS>t'+Z9vKN$\u0018AD6jY2\u001cVOY7jgNLwN\u001c\u000b\u0003gvDQA \u0006A\u0002\t\u000bAb];c[&\u001c8/[8o\u0013\u0012\fqC]3rk\u0016\u001cHoU;c[&\u001c8/[8o'R\fG/^:\u0015\u000bM\f\u0019!!\u0002\t\u000by\\\u0001\u0019\u0001\"\t\u0013\u0005\u001d1\u0002%AA\u0002\u0005%\u0011!B9vS\u0016$\bcA\u001b\u0002\f%\u0019\u0011Q\u0002\u001c\u0003\u000f\t{w\u000e\\3b]\u0006\t#/Z9vKN$8+\u001e2nSN\u001c\u0018n\u001c8Ti\u0006$Xo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0003\u0016\u0005\u0003\u0013\t)b\u000b\u0002\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!C;oG\",7m[3e\u0015\r\t\tCN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0013\u00037\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y\u0019wN\\:ueV\u001cGoU;c[&$(+Z9vKN$Hc\u0003=\u0002,\u0005=\u00121GA\u001c\u0003\u0003Ba!!\f\u000e\u0001\u0004\u0011\u0015aC1qaJ+7o\\;sG\u0016Da!!\r\u000e\u0001\u0004\u0011\u0015!C7bS:\u001cE.Y:t\u0011\u0019\t)$\u0004a\u0001I\u00069\u0011\r\u001d9Be\u001e\u001c\bbBA\u001d\u001b\u0001\u0007\u00111H\u0001\u0010gB\f'o\u001b)s_B,'\u000f^5fgB)1)!\u0010C\u0005&\u0019\u0011q\b'\u0003\u00075\u000b\u0007\u000fC\u0004\u0002D5\u0001\r!a\u000f\u0002)\u0015tg/\u001b:p]6,g\u000e\u001e,be&\f'\r\\3t\u0003\r9W\r\u001e\u000b\u0004g\u0006%\u0003bBA&\u001d\u0001\u0007\u0011QJ\u0001\u0004kJd\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005Mc,A\u0002oKRLA!a\u0016\u0002R\t\u0019QK\u0015'\u0002\tA|7\u000f\u001e\u000b\u0004g\u0006u\u0003bBA&\u001f\u0001\u0007\u0011QJ\u0001\ta>\u001cHOS:p]R)1/a\u0019\u0002f!9\u00111\n\tA\u0002\u00055\u0003BBA4!\u0001\u0007!)\u0001\u0003kg>t\u0017\u0001\u0004:fC\u0012\u0014Vm\u001d9p]N,GcA:\u0002n!9\u0011qN\tA\u0002\u0005E\u0014AC2p]:,7\r^5p]B!\u0011qJA:\u0013\u0011\t)(!\u0015\u0003#!#H\u000f]+S\u0019\u000e{gN\\3di&|g.\u0001\u0007hKR\u001cVOY7jiV\u0013H\u000e\u0006\u0003\u0002N\u0005m\u0004\"\u0002!\u0013\u0001\u0004\u0011\u0015AC4fi.KG\u000e\\+sYR1\u0011QJAA\u0003\u0007CQ\u0001Q\nA\u0002\tCQA`\nA\u0002\t\u000bAbZ3u'R\fG/^:Ve2$b!!\u0014\u0002\n\u0006-\u0005\"\u0002!\u0015\u0001\u0004\u0011\u0005\"\u0002@\u0015\u0001\u0004\u0011\u0015AC4fi\n\u000b7/Z+sYR\u0019!)!%\t\u000b\u0001+\u0002\u0019\u0001\"\u0002\u001dY\fG.\u001b3bi\u0016l\u0015m\u001d;feR!\u0011qSAO!\r)\u0014\u0011T\u0005\u0004\u000373$\u0001B+oSRDQ\u0001\u0011\fA\u0002\t\u000baC]3q_J$8+\u001e2nSN\u001c\u0018n\u001c8Ti\u0006$Xo\u001d\u000b\u0005\u0003/\u000b\u0019\u000bC\u0004\u0002&^\u0001\r!a*\u0002\u001dM,(-\\5u%\u0016\u001c\bo\u001c8tKB\u0019\u0001+!+\n\u0007\u0005-\u0016F\u0001\rDe\u0016\fG/Z*vE6L7o]5p]J+7\u000f]8og\u0016\fA\u0003]8mYN+(-\\5tg&|gn\u0015;biV\u001cH\u0003BAL\u0003cCQA \rA\u0002\t\u000b!\u0003[1oI2,'+Z:u%\u0016\u001c\bo\u001c8tKR!\u0011qSA\\\u0011\u0019\tI,\u0007a\u0001g\u0006A!/Z:q_:\u001cX-\u0001\u000fiC:$G.Z+oKb\u0004Xm\u0019;fIJ+7\u000f\u001e*fgB|gn]3\u0015\t\u0005]\u0015q\u0018\u0005\u0007\u0003\u0003T\u0002\u0019A:\u0002\u0015UtW\r\u001f9fGR,G-A\riC:$G.Z\"p]:,7\r^5p]\u0016C8-\u001a9uS>tG\u0003BA\u0005\u0003\u000fDa!!3\u001c\u0001\u0004\u0011\u0015!C7bgR,'/\u0016:m\u0003Q\u0011Vm\u001d;Tk\nl\u0017n]:j_:\u001cE.[3oiB\u0011\u0001+H\n\u0003;Q\"\"!!4\u00025\tc\u0015iQ&M\u0013N#V\tR0T!\u0006\u00136jX#O-~3\u0016IU*\u0016\u0005\u0005]\u0007#BAm\u0003?TVBAAn\u0015\r\tiNV\u0001\nS6lW\u000f^1cY\u0016LA!!9\u0002\\\n\u00191+\u001a;\u00027\tc\u0015iQ&M\u0013N#V\tR0T!\u0006\u00136jX#O-~3\u0016IU*!\u0003u\u0011V\tU(S)~#%+\u0013,F%~\u001bF+\u0011+V'~Ke\nV#S-\u0006cUCAAu!\r)\u00141^\u0005\u0004\u0003[4$aA%oi\u0006q\"+\u0012)P%R{FIU%W\u000bJ{6\u000bV!U+N{\u0016J\u0014+F%Z\u000bE\nI\u0001\u001f%\u0016\u0003vJ\u0015+`\tJKe+\u0012*`'R\u000bE+V*`\u001b\u0006Cv\f\u0016*J\u000bN\u000bqDU#Q\u001fJ#v\f\u0012*J-\u0016\u0013vl\u0015+B)V\u001bv,T!Y?R\u0013\u0016*R*!\u0003A\u0001&k\u0014+P\u0007>cuLV#S'&{e*F\u0001[\u0003E\u0001&k\u0014+P\u0007>cuLV#S'&{e\nI\u0001\u0018M&dG/\u001a:TsN$X-\\#om&\u0014xN\\7f]R$B!a\u000f\u0002\u0000\"9!\u0011A\u0014A\u0002\u0005m\u0012aA3om\u0002")
public class RestSubmissionClient
implements Logging {
    private final String master;
    private final Seq<String> supportedMasterPrefixes;
    private final String[] masters;
    private final HashSet<String> lostMasters;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String PROTOCOL_VERSION() {
        return RestSubmissionClient$.MODULE$.PROTOCOL_VERSION();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<String> supportedMasterPrefixes() {
        return this.supportedMasterPrefixes;
    }

    private String[] masters() {
        return this.masters;
    }

    private HashSet<String> lostMasters() {
        return this.lostMasters;
    }

    public SubmitRestProtocolResponse createSubmission(CreateSubmissionRequest request) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Submitting a request to launch an application in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.masters())).withFilter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$createSubmission$2(handled, m))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            RestSubmissionClient.$anonfun$createSubmission$3(this, response, request, handled, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse killSubmission(String submissionId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Submitting a request to kill submission ").append(submissionId).append(" in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.masters())).withFilter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$killSubmission$2(handled, m))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            RestSubmissionClient.$anonfun$killSubmission$3(this, submissionId, response, handled, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse requestSubmissionStatus(String submissionId, boolean quiet) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Submitting a request for the status of submission ").append(submissionId).append(" in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.masters())).withFilter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$requestSubmissionStatus$2(handled, m))).foreach((Function1 & Serializable & scala.Serializable)m -> {
            RestSubmissionClient.$anonfun$requestSubmissionStatus$3(this, submissionId, response, quiet, handled, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public boolean requestSubmissionStatus$default$2() {
        return false;
    }

    public CreateSubmissionRequest constructSubmitRequest(String appResource, String mainClass, String[] appArgs, Map<String, String> sparkProperties, Map<String, String> environmentVariables) {
        CreateSubmissionRequest message = new CreateSubmissionRequest();
        message.clientSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
        message.appResource_$eq(appResource);
        message.mainClass_$eq(mainClass);
        message.appArgs_$eq(appArgs);
        message.sparkProperties_$eq(sparkProperties);
        message.environmentVariables_$eq(environmentVariables);
        message.validate();
        return message;
    }

    private SubmitRestProtocolResponse get(URL url) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sending GET request to server at ").append(url).append(".").toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        return this.readResponse(conn);
    }

    private SubmitRestProtocolResponse post(URL url) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Sending POST request to server at ").append(url).append(".").toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        return this.readResponse(conn);
    }

    private SubmitRestProtocolResponse postJson(URL url, String json) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Sending POST request to server at ").append(url).append(":\n").append(json).toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        try {
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.write(json.getBytes(StandardCharsets.UTF_8)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
        }
        catch (ConnectException e) {
            throw new SubmitRestConnectionException("Connect Exception when connect to server", e);
        }
        return this.readResponse(conn);
    }

    public SubmitRestProtocolResponse readResponse(HttpURLConnection connection) {
        SubmitRestProtocolResponse submitRestProtocolResponse;
        Future responseFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ErrorResponse errorResponse;
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Some errString = new Some((Object)Source$.MODULE$.fromInputStream(connection.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n"));
                if (responseCode == 500 && !connection.getContentType().contains("application/json")) {
                    throw new SubmitRestProtocolException(new StringBuilder(33).append("Server responded with exception:\n").append(errString).toString(), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Server responded with error:\n").append(errString).toString());
                ErrorResponse error = new ErrorResponse();
                if (responseCode == RestSubmissionServer$.MODULE$.SC_UNKNOWN_PROTOCOL_VERSION()) {
                    error.highestProtocolVersion_$eq(RestSubmissionServer$.MODULE$.PROTOCOL_VERSION());
                }
                error.message_$eq((String)errString.get());
                errorResponse = error;
            } else {
                SubmitRestProtocolResponse submitRestProtocolResponse;
                InputStream dataStream = connection.getInputStream();
                if (dataStream == null) {
                    throw new SubmitRestProtocolException("Server returned empty body", SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                String responseJson = Source$.MODULE$.fromInputStream(dataStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Response from the server:\n").append(responseJson).toString());
                SubmitRestProtocolMessage response = SubmitRestProtocolMessage$.MODULE$.fromJson(responseJson);
                response.validate();
                SubmitRestProtocolMessage submitRestProtocolMessage = response;
                if (submitRestProtocolMessage instanceof ErrorResponse) {
                    ErrorResponse errorResponse2 = (ErrorResponse)submitRestProtocolMessage;
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Server responded with error:\n").append(errorResponse2.message()).toString());
                    submitRestProtocolResponse = errorResponse2;
                } else if (submitRestProtocolMessage instanceof SubmitRestProtocolResponse) {
                    SubmitRestProtocolResponse submitRestProtocolResponse2 = (SubmitRestProtocolResponse)submitRestProtocolMessage;
                    submitRestProtocolResponse = submitRestProtocolResponse2;
                } else {
                    throw new SubmitRestProtocolException(new StringBuilder(49).append("Message received from server was not a response:\n").append(submitRestProtocolMessage.toJson()).toString(), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                errorResponse = submitRestProtocolResponse;
            }
            return errorResponse;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            submitRestProtocolResponse = (SubmitRestProtocolResponse)Await$.MODULE$.result((Awaitable)responseFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof SocketException;
            if (bl) {
                throw new SubmitRestConnectionException("Unable to connect to server", throwable2);
            }
            boolean bl2 = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof SubmitRestProtocolException;
            if (bl2) {
                throw new SubmitRestProtocolException("Malformed response received from server", throwable2);
            }
            if (throwable2 instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable2;
                throw new SubmitRestConnectionException("No response from server", timeoutException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new SparkException("Exception while waiting for response", t);
            }
            throw throwable;
        }
        return submitRestProtocolResponse;
    }

    private URL getSubmitUrl(String master) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(7).append(baseUrl).append("/create").toString());
    }

    private URL getKillUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(6).append(baseUrl).append("/kill/").append(submissionId).toString());
    }

    private URL getStatusUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(8).append(baseUrl).append("/status/").append(submissionId).toString());
    }

    private String getBaseUrl(String master) {
        ObjectRef masterUrl = ObjectRef.create((Object)master);
        this.supportedMasterPrefixes().foreach((Function1 & Serializable & scala.Serializable)prefix -> {
            RestSubmissionClient.$anonfun$getBaseUrl$1(master, masterUrl, prefix);
            return BoxedUnit.UNIT;
        });
        masterUrl.elem = new StringOps(Predef$.MODULE$.augmentString((String)masterUrl.elem)).stripSuffix("/");
        return new StringBuilder(20).append("http://").append((String)masterUrl.elem).append("/").append(RestSubmissionClient$.MODULE$.PROTOCOL_VERSION()).append("/submissions").toString();
    }

    private void validateMaster(String master) {
        boolean valid = this.supportedMasterPrefixes().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)master.startsWith(prefix)));
        if (!valid) {
            throw new IllegalArgumentException(new StringBuilder(81).append("This REST client only supports master URLs that start with one of the following: ").append(this.supportedMasterPrefixes().mkString(",")).toString());
        }
    }

    private void reportSubmissionStatus(CreateSubmissionResponse submitResponse) {
        if (Predef$.MODULE$.Boolean2boolean(submitResponse.success())) {
            String submissionId = submitResponse.submissionId();
            if (submissionId != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Submission successfully created as ").append(submissionId).append(". Polling submission state...").toString());
                this.pollSubmissionStatus(submissionId);
            } else {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Application successfully submitted, but submission ID was not provided!");
            }
        } else {
            String failMessage = (String)Option$.MODULE$.apply((Object)submitResponse.message()).map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(2).append(": ").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Application submission failed").append(failMessage).toString());
        }
    }

    private void pollSubmissionStatus(String submissionId) {
        Object object = new Object();
        try {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_MAX_TRIES()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> RestSubmissionClient.$anonfun$pollSubmissionStatus$1(this, submissionId, object, arg_0)));
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Error: Master did not recognize driver ").append(submissionId).append(".").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void handleRestResponse(SubmitRestProtocolResponse response) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Server responded with ").append(response.messageType()).append(":\n").append(response.toJson()).toString());
    }

    private void handleUnexpectedRestResponse(SubmitRestProtocolResponse unexpected) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error: Server responded with message of unexpected type ").append(unexpected.messageType()).append(".").toString());
    }

    private boolean handleConnectionException(String masterUrl) {
        BoxedUnit boxedUnit;
        if (!this.lostMasters().contains((Object)masterUrl)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Unable to connect to server ").append(masterUrl).append(".").toString());
            boxedUnit = this.lostMasters().$plus$eq((Object)masterUrl);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.lostMasters().size() >= this.masters().length;
    }

    public static final /* synthetic */ boolean $anonfun$createSubmission$2(BooleanRef handled$1, String m) {
        return !handled$1.elem;
    }

    public static final /* synthetic */ void $anonfun$createSubmission$3(RestSubmissionClient $this, ObjectRef response$1, CreateSubmissionRequest request$1, BooleanRef handled$1, String m) {
        block6: {
            $this.validateMaster(m);
            URL url = $this.getSubmitUrl(m);
            try {
                response$1.elem = $this.postJson(url, request$1.toJson());
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$1.elem;
                if (submitRestProtocolResponse instanceof CreateSubmissionResponse) {
                    BoxedUnit boxedUnit;
                    CreateSubmissionResponse createSubmissionResponse = (CreateSubmissionResponse)submitRestProtocolResponse;
                    if (Predef$.MODULE$.Boolean2boolean(createSubmissionResponse.success())) {
                        $this.reportSubmissionStatus(createSubmissionResponse);
                        $this.handleRestResponse(createSubmissionResponse);
                        handled$1.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block6;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$killSubmission$2(BooleanRef handled$2, String m) {
        return !handled$2.elem;
    }

    public static final /* synthetic */ void $anonfun$killSubmission$3(RestSubmissionClient $this, String submissionId$1, ObjectRef response$2, BooleanRef handled$2, String m) {
        block6: {
            $this.validateMaster(m);
            URL url = $this.getKillUrl(m, submissionId$1);
            try {
                response$2.elem = $this.post(url);
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$2.elem;
                if (submitRestProtocolResponse instanceof KillSubmissionResponse) {
                    BoxedUnit boxedUnit;
                    KillSubmissionResponse killSubmissionResponse = (KillSubmissionResponse)submitRestProtocolResponse;
                    if (!Utils$.MODULE$.responseFromBackup(killSubmissionResponse.message())) {
                        $this.handleRestResponse(killSubmissionResponse);
                        handled$2.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block6;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$requestSubmissionStatus$2(BooleanRef handled$3, String m) {
        return !handled$3.elem;
    }

    public static final /* synthetic */ void $anonfun$requestSubmissionStatus$3(RestSubmissionClient $this, String submissionId$2, ObjectRef response$3, boolean quiet$1, BooleanRef handled$3, String m) {
        block5: {
            $this.validateMaster(m);
            URL url = $this.getStatusUrl(m, submissionId$2);
            try {
                SubmissionStatusResponse submissionStatusResponse;
                response$3.elem = $this.get(url);
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$3.elem;
                if (submitRestProtocolResponse instanceof SubmissionStatusResponse && Predef$.MODULE$.Boolean2boolean((submissionStatusResponse = (SubmissionStatusResponse)submitRestProtocolResponse).success())) {
                    if (!quiet$1) {
                        $this.handleRestResponse(submissionStatusResponse);
                    }
                    handled$3.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block5;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getBaseUrl$1(String master$1, ObjectRef masterUrl$1, String prefix) {
        block0: {
            if (!master$1.startsWith(prefix)) break block0;
            masterUrl$1.elem = new StringOps(Predef$.MODULE$.augmentString(master$1)).stripPrefix(prefix);
        }
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$2(String submissionId$4, String state$1) {
        return new StringBuilder(25).append("State of driver ").append(submissionId$4).append(" is now ").append(state$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$3(String submissionId$4) {
        return new StringBuilder(31).append("State of driver ").append(submissionId$4).append(" was not found!").toString();
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$4(String id$1, String hp$1) {
        return new StringBuilder(33).append("Driver is running on worker ").append(id$1).append(" at ").append(hp$1).append(".").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$pollSubmissionStatus$1(RestSubmissionClient $this, String submissionId$4, Object nonLocalReturnKey1$1, int x$2) {
        block5: {
            response = $this.requestSubmissionStatus(submissionId$4, true);
            var9_5 = response;
            if (!(var9_5 instanceof SubmissionStatusResponse)) {
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            var6_7 = var10_6 = (SubmissionStatusResponse)var9_5;
            statusResponse = var6_7;
            if (!Predef$.MODULE$.Boolean2boolean(statusResponse.success())) break block5;
            driverState = Option$.MODULE$.apply((Object)statusResponse.driverState());
            workerId = Option$.MODULE$.apply((Object)statusResponse.workerId());
            workerHostPort = Option$.MODULE$.apply((Object)statusResponse.workerHostPort());
            exception = Option$.MODULE$.apply((Object)statusResponse.message());
            var15_13 = driverState;
            if (var15_13 instanceof Some) {
                var16_14 = (Some)var15_13;
                state = (String)var16_14.value();
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$2(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)submissionId$4, (String)state));
                var5_16 = BoxedUnit.UNIT;
            } else {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$3(java.lang.String ), ()Ljava/lang/String;)((String)submissionId$4));
                var5_17 = BoxedUnit.UNIT;
            }
            var18_18 = new Tuple2((Object)workerId, (Object)workerHostPort);
            if (var18_18 == null) ** GOTO lbl-1000
            var19_19 = (Option)var18_18._1();
            var20_20 = (Option)var18_18._2();
            if (!(var19_19 instanceof Some)) ** GOTO lbl-1000
            var21_21 = (Some)var19_19;
            id = (String)var21_21.value();
            if (var20_20 instanceof Some) {
                var23_23 = (Some)var20_20;
                hp = (String)var23_23.value();
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$4(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)id, (String)hp));
                var4_25 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 3 sources

            {
                var4_26 = BoxedUnit.UNIT;
            }
            exception.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pollSubmissionStatus$5$adapted(org.apache.spark.deploy.rest.RestSubmissionClient java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((RestSubmissionClient)$this));
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        Thread.sleep(RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_INTERVAL());
    }

    public RestSubmissionClient(String master) {
        this.master = master;
        Logging.$init$(this);
        this.supportedMasterPrefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark://", "mesos://"}));
        this.masters = master.startsWith("spark://") ? Utils$.MODULE$.parseStandaloneMasterUrls(master) : (String[])((Object[])new String[]{master});
        this.lostMasters = new HashSet();
    }

    public static final /* synthetic */ Object $anonfun$pollSubmissionStatus$5$adapted(RestSubmissionClient $this, String e) {
        $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e);
        return BoxedUnit.UNIT;
    }
}

