/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a!B\u0006\r\u000111\u0002\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011A\u0012\t\u0011E\u0002!\u0011!Q\u0001\n\u0011B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\ts\u0001\u0011\t\u0011)A\u0005i!)!\b\u0001C\u0001w!)q\b\u0001C!\u0001\")\u0011\u000b\u0001C!%\")A\u000b\u0001C!+\")a\u000f\u0001C\u0005o\"9\u00111\u0002\u0001\u0005\n\u00055!a\u0007$jY\u0016\u001c\u0016p\u001d;f[B+'o]5ti\u0016t7-Z#oO&tWM\u0003\u0002\u000e\u001d\u00051Q.Y:uKJT!a\u0004\t\u0002\r\u0011,\u0007\u000f\\8z\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7c\u0001\u0001\u00187A\u0011\u0001$G\u0007\u0002\u0019%\u0011!\u0004\u0004\u0002\u0012!\u0016\u00148/[:uK:\u001cW-\u00128hS:,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0011\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0011\u001e\u0005\u001daunZ4j]\u001e\f1\u0001Z5s\u0007\u0001)\u0012\u0001\n\t\u0003K9r!A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u0012\u0013A\u0002\u001fs_>$hHC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#&\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017+\u0003\u0011!\u0017N\u001d\u0011\u0002\u0015M,'/[1mSj,'/F\u00015!\t)t'D\u00017\u0015\t\u0011\u0004#\u0003\u00029m\tQ1+\u001a:jC2L'0\u001a:\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qjd\b\u0005\u0002\u0019\u0001!)\u0011%\u0002a\u0001I!)!'\u0002a\u0001i\u00059\u0001/\u001a:tSN$HcA!F\u000fB\u0011!iQ\u0007\u0002U%\u0011AI\u000b\u0002\u0005+:LG\u000fC\u0003G\r\u0001\u0007A%\u0001\u0003oC6,\u0007\"\u0002%\u0007\u0001\u0004I\u0015aA8cUB\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0005Y\u0006twMC\u0001O\u0003\u0011Q\u0017M^1\n\u0005A[%AB(cU\u0016\u001cG/A\u0005v]B,'o]5tiR\u0011\u0011i\u0015\u0005\u0006\r\u001e\u0001\r\u0001J\u0001\u0005e\u0016\fG-\u0006\u0002WGR\u0011q\u000b\u001e\u000b\u000312\u00042!\u00170b\u001d\tQFL\u0004\u0002(7&\t1&\u0003\u0002^U\u00059\u0001/Y2lC\u001e,\u0017BA0a\u0005\r\u0019V-\u001d\u0006\u0003;*\u0002\"AY2\r\u0001\u0011)A\r\u0003b\u0001K\n\tA+\u0005\u0002gSB\u0011!iZ\u0005\u0003Q*\u0012qAT8uQ&tw\r\u0005\u0002CU&\u00111N\u000b\u0002\u0004\u0003:L\bbB7\t\u0003\u0003\u0005\u001dA\\\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA8sC6\t\u0001O\u0003\u0002rU\u00059!/\u001a4mK\u000e$\u0018BA:q\u0005!\u0019E.Y:t)\u0006<\u0007\"B;\t\u0001\u0004!\u0013A\u00029sK\u001aL\u00070A\ttKJL\u0017\r\\5{K&sGo\u001c$jY\u0016$B!\u0011=\u0002\u0002!)\u00110\u0003a\u0001u\u0006!a-\u001b7f!\tYh0D\u0001}\u0015\tiX*\u0001\u0002j_&\u0011q\u0010 \u0002\u0005\r&dW\rC\u0004\u0002\u0004%\u0001\r!!\u0002\u0002\u000bY\fG.^3\u0011\u0007\t\u000b9!C\u0002\u0002\n)\u0012a!\u00118z%\u00164\u0017a\u00053fg\u0016\u0014\u0018.\u00197ju\u00164%o\\7GS2,W\u0003BA\b\u0003+!B!!\u0005\u0002\u001eQ!\u00111CA\f!\r\u0011\u0017Q\u0003\u0003\u0006I*\u0011\r!\u001a\u0005\b\u00033Q\u00019AA\u000e\u0003\u0005i\u0007\u0003B8s\u0003'AQ!\u001f\u0006A\u0002i\u0004")
public class FileSystemPersistenceEngine
extends PersistenceEngine
implements Logging {
    private final String dir;
    private final Serializer serializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String dir() {
        return this.dir;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public void persist(String name, Object obj) {
        this.serializeIntoFile(new File(new StringBuilder(0).append(this.dir()).append(File.separator).append(name).toString()), obj);
    }

    @Override
    public void unpersist(String name) {
        block0: {
            File f = new File(new StringBuilder(0).append(this.dir()).append(File.separator).append(name).toString());
            if (f.delete()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(f.getPath()).toString());
        }
    }

    @Override
    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        File[] files = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(this.dir()).listFiles())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemPersistenceEngine.$anonfun$read$1(prefix, x$1)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)file -> this.deserializeFromFile((File)file, evidence$1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private void serializeIntoFile(File file, Object value) {
        boolean created = file.createNewFile();
        if (!created) {
            throw new IllegalStateException(new StringBuilder(23).append("Could not create file: ").append(file).toString());
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        ObjectRef out = ObjectRef.create(null);
        Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
            out$1.elem = this.serializer().newInstance().serializeStream(fileOut);
            return ((SerializationStream)out$1.elem).writeObject(value, ClassTag$.MODULE$.AnyRef());
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                fileOut.close();
                if ((SerializationStream)out$1.elem == null) break block0;
                ((SerializationStream)out$1.elem).close();
            }
        });
    }

    private <T> T deserializeFromFile(File file, ClassTag<T> m) {
        T t;
        FileInputStream fileIn = new FileInputStream(file);
        DeserializationStream in = null;
        try {
            in = this.serializer().newInstance().deserializeStream(fileIn);
            t = in.readObject(m);
        }
        finally {
            fileIn.close();
            if (in != null) {
                in.close();
            }
        }
        return t;
    }

    public static final /* synthetic */ boolean $anonfun$read$1(String prefix$1, File x$1) {
        return x$1.getName().startsWith(prefix$1);
    }

    public FileSystemPersistenceEngine(String dir, Serializer serializer) {
        this.dir = dir;
        this.serializer = serializer;
        Logging.$init$(this);
        new File(dir).mkdir();
    }
}

