/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.ApplicationStoreInfo;
import org.apache.spark.deploy.history.config$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0016,\tYB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d9\u0007A1A\u0005\n!Da!\u001b\u0001!\u0002\u0013I\u0005b\u00026\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007W\u0002\u0001\u000b\u0011B%\t\u000f1\u0004!\u0019!C\u0005[\"1\u0011\u000f\u0001Q\u0001\n9DqA\u001d\u0001C\u0002\u0013%1\u000f\u0003\u0004~\u0001\u0001\u0006I\u0001\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003t\u0011\u0019y\b\u0001)A\u0005i\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002\u0006!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wBq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u001c\u0002!\t!!(\t\u0013\u0005\u001d\u0006!%A\u0005\u0002\u0005m\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\t)\f\u0001C\u0001\u0003gCq!a.\u0001\t\u0013\tI\fC\u0004\u0002>\u0002!I!a0\t\u0011\u0005\u0015\u0007\u0001\"\u0001,\u0003\u000fDq!!4\u0001\t\u0013\ty\rC\u0004\u0002V\u0002!I!a6\t\u0013\u0005}\u0007!%A\u0005\n\u0005m\u0004\u0002CAq\u0001\u0011\u00051&a9\u0007\u000f\u0005-\u0003\u0001A\u0016\u0002N!I\u0011q\n\u0012\u0003\u0006\u0004%\t\u0001\u001b\u0005\n\u0003#\u0012#\u0011!Q\u0001\n%C\u0011\"a\u0015#\u0005\u000b\u0007I\u0011B7\t\u0013\u0005U#E!A!\u0002\u0013q\u0007BB0#\t\u0003\t9\u0006C\u0004\u0002^\t\"\t!a\u0018\t\u000f\u0005%$\u0005\"\u0001\u0002<\tA\u0002*[:u_JL8+\u001a:wKJ$\u0015n]6NC:\fw-\u001a:\u000b\u00051j\u0013a\u00025jgR|'/\u001f\u0006\u0003]=\na\u0001Z3qY>L(B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aN\u001f\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g!\tq\u0014)D\u0001@\u0015\t\u0001u&\u0001\u0005j]R,'O\\1m\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gN\u001a\t\u0003\u000b\u001ak\u0011aL\u0005\u0003\u000f>\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\tA\fG\u000f\u001b\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b!![8\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0005\r&dW-A\u0004mSN$\u0018N\\4\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016aB6wgR|'/\u001a\u0006\u0003/>\nA!\u001e;jY&\u0011\u0011\f\u0016\u0002\b\u0017Z\u001bFo\u001c:f\u0003\u0015\u0019Gn\\2l!\taV,D\u0001W\u0013\tqfKA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\u0006C\u000e$WM\u001a\t\u0003E\u0002i\u0011a\u000b\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u0011\u0016\u0001\r!\u0013\u0005\u0006#\u0016\u0001\rA\u0015\u0005\u00065\u0016\u0001\raW\u0001\fCB\u00048\u000b^8sK\u0012K'/F\u0001J\u00031\t\u0007\u000f]*u_J,G)\u001b:!\u0003-!X\u000e]*u_J,G)\u001b:\u0002\u0019Ql\u0007o\u0015;pe\u0016$\u0015N\u001d\u0011\u0002\u00115\f\u00070V:bO\u0016,\u0012A\u001c\t\u0003q=L!\u0001]\u001d\u0003\t1{gnZ\u0001\n[\u0006DXk]1hK\u0002\nAbY;se\u0016tG/V:bO\u0016,\u0012\u0001\u001e\t\u0003knl\u0011A\u001e\u0006\u0003ob\fa!\u0019;p[&\u001c'BA={\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003/6K!\u0001 <\u0003\u0015\u0005#x.\\5d\u0019>tw-A\u0007dkJ\u0014XM\u001c;Vg\u0006<W\rI\u0001\u000fG>lW.\u001b;uK\u0012,6/Y4f\u0003=\u0019w.\\7jiR,G-V:bO\u0016\u0004\u0013AB1di&4X-\u0006\u0002\u0002\u0006A9\u0011qAA\t\u0003+qWBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000f5,H/\u00192mK*\u0019\u0011qB\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0014\u0005%!a\u0002%bg\"l\u0015\r\u001d\t\bq\u0005]\u00111DA\u0019\u0013\r\tI\"\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005u\u00111\u0006\b\u0005\u0003?\t9\u0003E\u0002\u0002\"ej!!a\t\u000b\u0007\u0005\u0015R'\u0001\u0004=e>|GOP\u0005\u0004\u0003SI\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0005=\"AB*ue&twMC\u0002\u0002*e\u0002R\u0001OA\u001a\u00037I1!!\u000e:\u0005\u0019y\u0005\u000f^5p]\u00069\u0011m\u0019;jm\u0016\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0011\u0011Q\b\t\u0004q\u0005}\u0012bAA!s\t!QK\\5u\u0003\u0015aW-Y:f)\u0019\t9%a\u001b\u0002pA\u0019\u0011\u0011\n\u0012\u000e\u0003\u0001\u0011Q\u0001T3bg\u0016\u001c\"AI\u001c\u0002\u000fQl\u0007\u000fU1uQ\u0006AA/\u001c9QCRD\u0007%\u0001\u0004mK\u0006\u001cX\rZ\u0001\bY\u0016\f7/\u001a3!)\u0019\t9%!\u0017\u0002\\!1\u0011qJ\u0014A\u0002%Ca!a\u0015(\u0001\u0004q\u0017AB2p[6LG\u000fF\u0003J\u0003C\n)\u0007C\u0004\u0002d!\u0002\r!a\u0007\u0002\u000b\u0005\u0004\b/\u00133\t\u000f\u0005\u001d\u0004\u00061\u0001\u00022\u0005I\u0011\r\u001e;f[B$\u0018\nZ\u0001\te>dGNY1dW\"1\u0011QN\nA\u00029\fA\"\u001a<f]RdunZ*ju\u0016D\u0011\"!\u001d\u0014!\u0003\u0005\r!a\u001d\u0002\u0019%\u001c8i\\7qe\u0016\u001c8/\u001a3\u0011\u0007a\n)(C\u0002\u0002xe\u0012qAQ8pY\u0016\fg.A\bmK\u0006\u001cX\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tiH\u000b\u0003\u0002t\u0005}4FAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0015(\u0001\u0006b]:|G/\u0019;j_:LA!a$\u0002\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0013=\u0004XM\\*u_J,GCBAK\u0003/\u000bI\n\u0005\u00039\u0003gI\u0005bBA2+\u0001\u0007\u00111\u0004\u0005\b\u0003O*\u0002\u0019AA\u0019\u0003\u001d\u0011X\r\\3bg\u0016$\u0002\"!\u0010\u0002 \u0006\u0005\u00161\u0015\u0005\b\u0003G2\u0002\u0019AA\u000e\u0011\u001d\t9G\u0006a\u0001\u0003cA\u0011\"!*\u0017!\u0003\u0005\r!a\u001d\u0002\r\u0011,G.\u001a;f\u0003E\u0011X\r\\3bg\u0016$C-\u001a4bk2$HeM\u0001\u0010CB\u0004(o\u001c=j[\u0006$XmU5{KR)a.!,\u00020\"1\u0011Q\u000e\rA\u00029Dq!!\u001d\u0019\u0001\u0004\t\u0019(\u0001\u0003ge\u0016,G#\u00018\u0002\u0013\r|W.\\5ui\u0016$\u0017a\u00033fY\u0016$Xm\u0015;pe\u0016$B!!\u0010\u0002<\")\u0001j\u0007a\u0001\u0013\u0006AQ.Y6f%>|W\u000e\u0006\u0003\u0002>\u0005\u0005\u0007BBAb9\u0001\u0007a.\u0001\u0003tSj,\u0017\u0001D1qaN#xN]3QCRDG#B%\u0002J\u0006-\u0007bBA2;\u0001\u0007\u00111\u0004\u0005\b\u0003Oj\u0002\u0019AA\u0019\u0003A)\b\u000fZ1uK\u0006\u001b7-Z:t)&lW\r\u0006\u0004\u0002>\u0005E\u00171\u001b\u0005\b\u0003Gr\u0002\u0019AA\u000e\u0011\u001d\t9G\ba\u0001\u0003c\t1\"\u001e9eCR,Wk]1hKR1\u0011QHAm\u0003;Da!a7 \u0001\u0004q\u0017!\u00023fYR\f\u0007\"CA[?A\u0005\t\u0019AA:\u0003U)\b\u000fZ1uKV\u001b\u0018mZ3%I\u00164\u0017-\u001e7uII\naa]5{K>3Gc\u00018\u0002f\")\u0001*\ta\u0001\u0013\u0002")
public class HistoryServerDiskManager
implements Logging {
    private final KVStore listing;
    private final Clock clock;
    private final File appStoreDir;
    private final File tmpStoreDir;
    private final long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    private final AtomicLong currentUsage;
    private final AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    private final HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private File appStoreDir() {
        return this.appStoreDir;
    }

    private File tmpStoreDir() {
        return this.tmpStoreDir;
    }

    public long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    }

    private AtomicLong currentUsage() {
        return this.currentUsage;
    }

    public AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    }

    public HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    }

    public void initialize() {
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(this.sizeOf(this.appStoreDir()), true);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tmpStoreDir().listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$1(x$1)));
        Tuple2 tuple2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.listing.view(ApplicationStoreInfo.class)).asScala()).toSeq().partition((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$2(info)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq existences = (Seq)tuple2._1();
        Seq orphans = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existences, (Object)orphans);
        Tuple2 tuple23 = tuple22;
        Seq existences2 = (Seq)tuple23._1();
        Seq orphans2 = (Seq)tuple23._2();
        orphans2.foreach((Function1 & Serializable & scala.Serializable)info -> {
            this.listing.delete(info.getClass(), (Object)info.path());
            return BoxedUnit.UNIT;
        });
        existences2.foreach((Function1 & Serializable & scala.Serializable)info -> {
            HistoryServerDiskManager.$anonfun$initialize$4(this, info);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Initialized disk manager: ").append("current usage = ").append(Utils$.MODULE$.bytesToString(this.currentUsage().get())).append(", ").append("max usage = ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).toString());
    }

    public Lease lease(long eventLogSize, boolean isCompressed) {
        long needed = this.approximateSize(eventLogSize, isCompressed);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(needed);
        File tmp = Utils$.MODULE$.createTempDir(this.tmpStoreDir().getPath(), "appstore");
        Utils$.MODULE$.chmod700(tmp);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(needed, this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
        long current = this.currentUsage().get();
        if (current > this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Lease of ").append(Utils$.MODULE$.bytesToString(needed)).append(" may cause usage to exceed max ").append("(").append(Utils$.MODULE$.bytesToString(current)).append(" > ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).append(")").toString());
        }
        return new Lease(this, tmp, needed);
    }

    public boolean lease$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Option<File> openStore(String appId, Option<String> attemptId) {
        void var3_6;
        None$ none$;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            None$ none$2;
            File path2 = this.appStorePath(appId, attemptId);
            if (path2.isDirectory()) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)this.sizeOf(path2)));
                none$2 = new Some((Object)path2);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ storePath = none$;
        storePath.foreach((Function1 & Serializable & scala.Serializable)path -> {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(appId, (Option<String>)attemptId);
            return BoxedUnit.UNIT;
        });
        return var3_6;
    }

    public void release(String appId, Option<String> attemptId, boolean delete) {
        Option option;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            option = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().remove((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId));
        }
        Option oldSizeOpt = option;
        oldSizeOpt.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)oldSize -> {
            block2: {
                File path = this.appStorePath(appId, attemptId);
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-oldSize, true);
                if (!path.isDirectory()) break block2;
                if (delete) {
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(path);
                } else {
                    long newSize = this.sizeOf(path);
                    ApplicationStoreInfo qual$1 = (ApplicationStoreInfo)$this.listing.read(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
                    long x$1 = newSize;
                    String x$2 = qual$1.copy$default$1();
                    long x$3 = qual$1.copy$default$2();
                    String x$4 = qual$1.copy$default$3();
                    Option<String> x$5 = qual$1.copy$default$4();
                    ApplicationStoreInfo newInfo = qual$1.copy(x$2, x$3, x$4, x$5, x$1);
                    $this.listing.write((Object)newInfo);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
                }
            }
        });
    }

    public boolean release$default$3() {
        return false;
    }

    public long approximateSize(long eventLogSize, boolean isCompressed) {
        return isCompressed ? eventLogSize * 2L : eventLogSize / 2L;
    }

    public long free() {
        return package$.MODULE$.max(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() - this.currentUsage().get(), 0L);
    }

    public long committed() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get();
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(File path) {
        FileUtils.deleteDirectory((File)path);
        this.listing.delete(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(long size) {
        block2: {
            if (this.free() >= size) break block2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Not enough free space, looking at candidates for deletion...");
            ListBuffer evicted = new ListBuffer();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.listing.view(ApplicationStoreInfo.class).index("lastAccess").closeableIterator(), (Function1 & Serializable & scala.Serializable)iter -> {
                HistoryServerDiskManager.$anonfun$makeRoom$3(this, size, evicted, iter);
                return BoxedUnit.UNIT;
            });
            if (evicted.nonEmpty()) {
                long freed = BoxesRunTime.unboxToLong((Object)((TraversableForwarder)evicted.map((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToLong((long)HistoryServerDiskManager.$anonfun$makeRoom$4(this, info)), ListBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Deleted ").append(evicted.size()).append(" store(s) to free ").append(Utils$.MODULE$.bytesToString(freed)).append(" ").append("(target = ").append(Utils$.MODULE$.bytesToString(size)).append(").").toString());
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unable to free any space to make room for ").append(Utils$.MODULE$.bytesToString(size)).append(".").toString());
            }
        }
    }

    public File appStorePath(String appId, Option<String> attemptId) {
        String fileName = new StringBuilder(4).append(appId).append(attemptId.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(1).append("_").append((String)x$2).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(".ldb").toString();
        return new File(this.appStoreDir(), fileName);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(String appId, Option<String> attemptId) {
        File path = this.appStorePath(appId, attemptId);
        ApplicationStoreInfo info = new ApplicationStoreInfo(path.getAbsolutePath(), this.clock.getTimeMillis(), appId, attemptId, this.sizeOf(path));
        this.listing.write((Object)info);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(long delta, boolean committed) {
        long updatedCommitted;
        long updated = this.currentUsage().addAndGet(delta);
        if (updated < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updated).append(", delta = ").append(delta).append(")").toString());
        }
        if (committed && (updatedCommitted = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().addAndGet(delta)) < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updatedCommitted).append(", delta = ").append(delta).append(")").toString());
        }
    }

    public boolean org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2() {
        return false;
    }

    public long sizeOf(File path) {
        return FileUtils.sizeOf((File)path);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(File x$1) {
        return FileUtils.deleteQuietly((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$2(ApplicationStoreInfo info) {
        return new File(info.path()).exists();
    }

    public static final /* synthetic */ void $anonfun$initialize$4(HistoryServerDiskManager $this, ApplicationStoreInfo info) {
        block0: {
            long fileSize = $this.sizeOf(new File(info.path()));
            if (fileSize == info.size()) break block0;
            long x$1 = fileSize;
            String x$2 = info.copy$default$1();
            long x$3 = info.copy$default$2();
            String x$4 = info.copy$default$3();
            Option<String> x$5 = info.copy$default$4();
            $this.listing.write((Object)info.copy(x$2, x$3, x$4, x$5, x$1));
        }
    }

    public static final /* synthetic */ void $anonfun$makeRoom$3(HistoryServerDiskManager $this, long size$1, ListBuffer evicted$1, KVStoreIterator iter) {
        long needed = size$1;
        while (needed > 0L && iter.hasNext()) {
            boolean bl;
            ApplicationStoreInfo info = (ApplicationStoreInfo)iter.next();
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                bl = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)info.appId()), info.attemptId()));
            }
            boolean isActive = bl;
            if (isActive) continue;
            evicted$1.$plus$eq((Object)info);
            needed -= info.size();
        }
    }

    public static final /* synthetic */ long $anonfun$makeRoom$4(HistoryServerDiskManager $this, ApplicationStoreInfo info) {
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting store for ").append(info.appId()).append("/").append(info.attemptId()).append(".").toString());
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(new File(info.path()));
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-info.size(), true);
        return info.size();
    }

    public HistoryServerDiskManager(SparkConf conf, File path, KVStore listing, Clock clock) {
        this.listing = listing;
        this.clock = clock;
        Logging.$init$(this);
        this.appStoreDir = new File(path, "apps");
        if (!this.appStoreDir().isDirectory() && !this.appStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Failed to create app directory (").append(this.appStoreDir()).append(").").toString());
        }
        this.tmpStoreDir = new File(path, "temp");
        if (!this.tmpStoreDir().isDirectory() && !this.tmpStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Failed to create temp directory (").append(this.tmpStoreDir()).append(").").toString());
        }
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage = BoxesRunTime.unboxToLong((Object)conf.get(config$.MODULE$.MAX_LOCAL_DISK_USAGE()));
        this.currentUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active = new HashMap();
    }

    public class Lease {
        private final File tmpPath;
        private final long leased;
        public final /* synthetic */ HistoryServerDiskManager $outer;

        public File tmpPath() {
            return this.tmpPath;
        }

        private long leased() {
            return this.leased;
        }

        /*
         * WARNING - void declaration
         */
        public File commit(String appId, Option<String> attemptId) {
            void var3_3;
            File dst = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().appStorePath(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                Predef$.MODULE$.require(!this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cannot commit lease for active application ").append(appId).append(" / ").append(attemptId).toString());
                if (dst.isDirectory()) {
                    long size = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-size, true);
                }
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            long newSize = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(this.tmpPath());
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(newSize);
            this.tmpPath().renameTo(dst);
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
            if (this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get() > this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
                String current = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get());
                String max = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage());
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Commit of application ").append(appId).append(" / ").append(attemptId).append(" causes maximum disk usage to be ").append("exceeded (").append(current).append(" > ").append(max).append(")").toString());
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap2 = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap2) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)newSize));
            }
            return var3_3;
        }

        public void rollback() {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            FileUtils.deleteDirectory((File)this.tmpPath());
        }

        public /* synthetic */ HistoryServerDiskManager org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer() {
            return this.$outer;
        }

        public Lease(HistoryServerDiskManager $outer, File tmpPath, long leased) {
            this.tmpPath = tmpPath;
            this.leased = leased;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

