/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.TorrentBroadcast$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.BroadcastBlockId$;
import org.apache.spark.storage.ByteBufferBlockData;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUb!\u0002\u0015*\u0001-\n\u0004\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0013U\u0003!\u0011!Q\u0001\nYK\u0006\u0002\u0003.\u0001\u0005\u0007\u0005\u000b1B.\t\u000b\u0005\u0004A\u0011\u00012\t\u0011!\u0004\u0001R1A\u0005\n%D\u0011B\u001c\u0001A\u0002\u0003\u0007I\u0011B8\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0013I\b\"C@\u0001\u0001\u0004\u0005\t\u0015)\u0003q\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011q\u0002\u0005\f\u0003'\u0001\u0001\u0019!A!B\u0013\t9\u0001C\u0004\u0002\u0018\u0001!I!!\u0007\t\u0013\u0005\u001d\u0002A1A\u0005\n\u0005%\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\u000b\t\u0013\u0005e\u0002A1A\u0005\n\u0005\u0015\u0001\u0002CA\u001e\u0001\u0001\u0006I!a\u0002\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005}\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011!\ti\u0005\u0001Q!\n\u0005\u0005\u0003bCA(\u0001\u0001\u0007\t\u0019!C\u0005\u0003#B1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\!Y\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA*\u0011\u001d\t\t\u0007\u0001C)\u0003GBq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011Q\u0012\u0001\u0005R\u0005=\u0005bBAK\u0001\u0011E\u0013q\u0013\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\tI\u000b\u0001C\u0005\u0003GBq!a+\u0001\t\u0013\ti\u000bC\u0007\u0002:\u0002\u0001\n1!A\u0001\n\u0013\tY,W\u0004\b\u0003{K\u0003\u0012BA`\r\u0019A\u0013\u0006#\u0003\u0002B\"1\u0011M\tC\u0001\u0003\u001bDq!a4#\t\u0003\t\t\u000eC\u0004\u0002x\n\"\t!!?\t\u000f\te!\u0005\"\u0001\u0003\u001c!I!Q\u0005\u0012\u0002\u0002\u0013%!q\u0005\u0002\u0011)>\u0014(/\u001a8u\u0005J|\u0017\rZ2bgRT!AK\u0016\u0002\u0013\t\u0014x.\u00193dCN$(B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0016\u0005IJ4\u0003\u0002\u00014\r2\u00032\u0001N\u001b8\u001b\u0005I\u0013B\u0001\u001c*\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u00029s1\u0001A!\u0002\u001e\u0001\u0005\u0004a$!\u0001+\u0004\u0001E\u0011Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\b\u001d>$\b.\u001b8h!\tqD)\u0003\u0002F\u007f\t\u0019\u0011I\\=\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%[\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005-C%a\u0002'pO\u001eLgn\u001a\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000b!![8\u000b\u0003E\u000bAA[1wC&\u00111K\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004_\nT\u0017AA5e!\tqt+\u0003\u0002Y\u007f\t!Aj\u001c8h\u0013\t)V'\u0001\u0006fm&$WM\\2fIE\u00022\u0001X08\u001b\u0005i&B\u00010@\u0003\u001d\u0011XM\u001a7fGRL!\u0001Y/\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtDcA2gOR\u0011A-\u001a\t\u0004i\u00019\u0004\"\u0002.\u0005\u0001\bY\u0006\"\u0002+\u0005\u0001\u00049\u0004\"B+\u0005\u0001\u00041\u0016AB0wC2,X-F\u00018Q\t)1\u000e\u0005\u0002?Y&\u0011Qn\u0010\u0002\niJ\fgn]5f]R\f\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0016\u0003A\u00042AP9t\u0013\t\u0011xH\u0001\u0004PaRLwN\u001c\t\u0003iZl\u0011!\u001e\u0006\u0003\u001f.J!a^;\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017\u0001F2p[B\u0014Xm]:j_:\u001cu\u000eZ3d?\u0012*\u0017\u000f\u0006\u0002{{B\u0011ah_\u0005\u0003y~\u0012A!\u00168ji\"9apBA\u0001\u0002\u0004\u0001\u0018a\u0001=%c\u0005\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011)\u0005!Y\u0017!\u00032m_\u000e\\7+\u001b>f+\t\t9\u0001E\u0002?\u0003\u0013I1!a\u0003@\u0005\rIe\u000e^\u0001\u000eE2|7m[*ju\u0016|F%Z9\u0015\u0007i\f\t\u0002\u0003\u0005\u007f\u0015\u0005\u0005\t\u0019AA\u0004\u0003)\u0011Gn\\2l'&TX\r\t\u0015\u0003\u0017-\fqa]3u\u0007>tg\rF\u0002{\u00037Aq!!\b\r\u0001\u0004\ty\"\u0001\u0003d_:4\u0007\u0003BA\u0011\u0003Gi\u0011aK\u0005\u0004\u0003KY#!C*qCJ\\7i\u001c8g\u0003-\u0011'o\\1eG\u0006\u001cH/\u00133\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E2&A\u0004ti>\u0014\u0018mZ3\n\t\u0005U\u0012q\u0006\u0002\u0011\u0005J|\u0017\rZ2bgR\u0014En\\2l\u0013\u0012\fAB\u0019:pC\u0012\u001c\u0017m\u001d;JI\u0002\n\u0011B\\;n\u00052|7m[:\u0002\u00159,XN\u00117pG.\u001c\b%A\bdQ\u0016\u001c7n];n\u000b:\f'\r\\3e+\t\t\t\u0005E\u0002?\u0003\u0007J1!!\u0012@\u0005\u001d\u0011un\u001c7fC:\f1c\u00195fG.\u001cX/\\#oC\ndW\rZ0%KF$2A_A&\u0011!q(#!AA\u0002\u0005\u0005\u0013\u0001E2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3!\u0003%\u0019\u0007.Z2lgVl7/\u0006\u0002\u0002TA)a(!\u0016\u0002\b%\u0019\u0011qK \u0003\u000b\u0005\u0013(/Y=\u0002\u001b\rDWmY6tk6\u001cx\fJ3r)\rQ\u0018Q\f\u0005\t}V\t\t\u00111\u0001\u0002T\u0005Q1\r[3dWN,Xn\u001d\u0011\u0002\u0011\u001d,GOV1mk\u0016$\u0012aN\u0001\rG\u0006d7m\u00115fG.\u001cX/\u001c\u000b\u0005\u0003\u000f\tI\u0007C\u0004\u0002la\u0001\r!!\u001c\u0002\u000b\tdwnY6\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dQ\u0003\rq\u0017n\\\u0005\u0005\u0003o\n\tH\u0001\u0006CsR,')\u001e4gKJ\f1b\u001e:ji\u0016\u0014En\\2lgR!\u0011qAA?\u0011\u0019\ty(\u0007a\u0001o\u0005)a/\u00197vK\u0006Q!/Z1e\u00052|7m[:\u0015\u0005\u0005\u0015\u0005#\u0002 \u0002V\u0005\u001d\u0005\u0003BA\u0017\u0003\u0013KA!a#\u00020\tI!\t\\8dW\u0012\u000bG/Y\u0001\fI>,f\u000e]3sg&\u001cH\u000fF\u0002{\u0003#Cq!a%\u001c\u0001\u0004\t\t%\u0001\u0005cY>\u001c7.\u001b8h\u0003%!w\u000eR3tiJ|\u0017\u0010F\u0002{\u00033Cq!a%\u001d\u0001\u0004\t\t%A\u0006xe&$Xm\u00142kK\u000e$Hc\u0001>\u0002 \"9\u0011\u0011U\u000fA\u0002\u0005\r\u0016aA8viB\u0019Q*!*\n\u0007\u0005\u001dfJ\u0001\nPE*,7\r^(viB,Ho\u0015;sK\u0006l\u0017A\u0005:fC\u0012\u0014%o\\1eG\u0006\u001cHO\u00117pG.\f1B]3mK\u0006\u001cX\rT8dWR\u0019!0a,\t\u000f\u0005Ev\u00041\u0001\u00024\u00069!\r\\8dW&#\u0007\u0003BA\u0017\u0003kKA!a.\u00020\t9!\t\\8dW&#\u0017\u0001C:va\u0016\u0014H%\u001b3\u0016\u0003Y\u000b\u0001\u0003V8se\u0016tGO\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0005Q\u00123C\u0002\u0012\u0002D\u001a\u000bI\rE\u0002?\u0003\u000bL1!a2@\u0005\u0019\te.\u001f*fMB\u0019a(a3\n\u0005M{DCAA`\u00039\u0011Gn\\2lS\u001aLxJ\u00196fGR,B!a5\u0002bRQ\u0011Q[Ar\u0003K\f9/!>\u0015\t\u0005]\u0017\u0011\u001c\t\u0006}\u0005U\u0013Q\u000e\u0005\n\u00037$\u0013\u0011!a\u0002\u0003;\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0011av,a8\u0011\u0007a\n\t\u000fB\u0003;I\t\u0007A\b\u0003\u0004UI\u0001\u0007\u0011q\u001c\u0005\b\u0003\u0007!\u0003\u0019AA\u0004\u0011\u001d\tI\u000f\na\u0001\u0003W\f!b]3sS\u0006d\u0017N_3s!\u0011\ti/!=\u000e\u0005\u0005=(bAAuW%!\u00111_Ax\u0005)\u0019VM]5bY&TXM\u001d\u0005\u0006]\u0012\u0002\r\u0001]\u0001\u0011k:\u0014En\\2lS\u001aLxJ\u00196fGR,B!a?\u0003\u0002QA\u0011Q B\u0005\u0005+\u00119\u0002\u0006\u0003\u0002\u0000\n\r\u0001c\u0001\u001d\u0003\u0002\u0011)!(\nb\u0001y!I!QA\u0013\u0002\u0002\u0003\u000f!qA\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003\u0002/`\u0003\u007fDqAa\u0003&\u0001\u0004\u0011i!\u0001\u0004cY>\u001c7n\u001d\t\u0006}\u0005U#q\u0002\t\u0004\u001b\nE\u0011b\u0001B\n\u001d\nY\u0011J\u001c9viN#(/Z1n\u0011\u001d\tI/\na\u0001\u0003WDQA\\\u0013A\u0002A\f\u0011\"\u001e8qKJ\u001c\u0018n\u001d;\u0015\u000fi\u0014iBa\b\u0003$!)QK\na\u0001-\"9!\u0011\u0005\u0014A\u0002\u0005\u0005\u0013\u0001\u0005:f[>4XM\u0012:p[\u0012\u0013\u0018N^3s\u0011\u001d\t\u0019J\na\u0001\u0003\u0003\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0006\t\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)\u0019!q\u0006)\u0002\t1\fgnZ\u0005\u0005\u0005g\u0011iC\u0001\u0004PE*,7\r\u001e")
public class TorrentBroadcast<T>
extends Broadcast<T> {
    private transient T _value;
    private final ClassTag<T> evidence$1;
    private transient Option<CompressionCodec> compressionCodec;
    private transient int blockSize;
    private final BroadcastBlockId broadcastId;
    private final int numBlocks;
    private boolean checksumEnabled;
    private int[] checksums;
    private volatile transient boolean bitmap$trans$0;

    public static <T> T unBlockifyObject(InputStream[] inputStreamArray, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.unBlockifyObject(inputStreamArray, serializer, option, classTag);
    }

    public static <T> ByteBuffer[] blockifyObject(T t, int n, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.blockifyObject(t, n, serializer, option, classTag);
    }

    private /* synthetic */ long super$id() {
        return super.id();
    }

    private T _value$lzycompute() {
        TorrentBroadcast torrentBroadcast = this;
        synchronized (torrentBroadcast) {
            if (!this.bitmap$trans$0) {
                this._value = this.readBroadcastBlock();
                this.bitmap$trans$0 = true;
            }
        }
        return this._value;
    }

    private T _value() {
        return !this.bitmap$trans$0 ? this._value$lzycompute() : this._value;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private void compressionCodec_$eq(Option<CompressionCodec> x$1) {
        this.compressionCodec = x$1;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private void blockSize_$eq(int x$1) {
        this.blockSize = x$1;
    }

    private void setConf(SparkConf conf) {
        this.compressionCodec_$eq((Option<CompressionCodec>)(conf.getBoolean("spark.broadcast.compress", true) ? new Some((Object)CompressionCodec$.MODULE$.createCodec(conf)) : None$.MODULE$));
        this.blockSize_$eq((int)conf.getSizeAsKb("spark.broadcast.blockSize", "4m") * 1024);
        this.checksumEnabled_$eq(conf.getBoolean("spark.broadcast.checksum", true));
    }

    private BroadcastBlockId broadcastId() {
        return this.broadcastId;
    }

    private int numBlocks() {
        return this.numBlocks;
    }

    private boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    private void checksumEnabled_$eq(boolean x$1) {
        this.checksumEnabled = x$1;
    }

    private int[] checksums() {
        return this.checksums;
    }

    private void checksums_$eq(int[] x$1) {
        this.checksums = x$1;
    }

    @Override
    public T getValue() {
        return this._value();
    }

    private int calcChecksum(ByteBuffer block) {
        Adler32 adler = new Adler32();
        if (block.hasArray()) {
            adler.update(block.array(), block.arrayOffset() + block.position(), block.limit() - block.position());
        } else {
            byte[] bytes = new byte[block.remaining()];
            block.duplicate().get(bytes);
            adler.update(bytes);
        }
        return (int)adler.getValue();
    }

    private int writeBlocks(T value) {
        int n;
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        if (!blockManager.putSingle(this.broadcastId(), value, StorageLevel$.MODULE$.MEMORY_AND_DISK(), false, this.evidence$1)) {
            throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
        }
        try {
            ByteBuffer[] blocks = TorrentBroadcast$.MODULE$.blockifyObject(value, this.blockSize(), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), this.evidence$1);
            if (this.checksumEnabled()) {
                this.checksums_$eq(new int[blocks.length]);
            }
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TorrentBroadcast.$anonfun$writeBlocks$1(this, blockManager, x0$1);
                return BoxedUnit.UNIT;
            });
            n = blocks.length;
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Store broadcast ").append(this.broadcastId()).append(" fail, remove all pieces of the broadcast").toString());
            blockManager.removeBroadcast(super.id(), true);
            throw t;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private BlockData[] readBlocks() {
        void var1_1;
        BlockData[] blocks = new BlockData[this.numBlocks()];
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        ((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numBlocks()), (Integral)Numeric.IntIsIntegral$.MODULE$), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
            BroadcastBlockId pieceId = new BroadcastBlockId(this.super$id(), new StringBuilder(5).append("piece").append(pid).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Reading piece ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
            Option<BlockData> option = bm.getLocalBytes(pieceId);
            if (option instanceof Some) {
                BlockData block;
                Some some = (Some)option;
                blocks$1[pid] = block = (BlockData)some.value();
                this.releaseLock(pieceId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                ChunkedByteBuffer b;
                Option<ChunkedByteBuffer> option2 = bm.getRemoteBytes(pieceId);
                if (option2 instanceof Some) {
                    int sum;
                    Some some = (Some)option2;
                    b = (ChunkedByteBuffer)some.value();
                    if (this.checksumEnabled() && (sum = this.calcChecksum(b.chunks()[0])) != this.checksums()[pid]) {
                        throw new SparkException(new StringBuilder(31).append("corrupt remote block ").append(pieceId).append(" of ").append(this.broadcastId()).append(":").append(" ").append(sum).append(" != ").append(this.checksums()[pid]).toString());
                    }
                    if (!bm.putBytes(pieceId, b, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                        throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append(this.broadcastId()).append(" in local BlockManager").toString());
                    }
                } else {
                    if (None$.MODULE$.equals(option2)) {
                        throw new SparkException(new StringBuilder(18).append("Failed to get ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
                    }
                    throw new MatchError(option2);
                }
                blocks$1[pid] = new ByteBufferBlockData(b, true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
        return var1_1;
    }

    @Override
    public void doUnpersist(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), false, blocking);
    }

    @Override
    public void doDestroy(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), true, blocking);
    }

    private void writeObject(ObjectOutputStream out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertValid();
            out.defaultWriteObject();
        });
    }

    private T readBroadcastBlock() {
        return Utils$.MODULE$.tryOrIOException((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            TorrentBroadcast$ torrentBroadcast$ = TorrentBroadcast$.MODULE$;
            synchronized (torrentBroadcast$) {
                ReferenceMap broadcastCache = SparkEnv$.MODULE$.get().broadcastManager().cachedValues();
                object = Option$.MODULE$.apply(broadcastCache.get((Object)this.broadcastId())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    Object object;
                    this.setConf(SparkEnv$.MODULE$.get().conf());
                    BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
                    Option<BlockResult> option = blockManager.getLocalValues(this.broadcastId());
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BlockResult blockResult = (BlockResult)some.value();
                        if (!blockResult.data().hasNext()) {
                            throw new SparkException(new StringBuilder(45).append("Failed to get locally stored broadcast data: ").append(this.broadcastId()).toString());
                        }
                        Object x = blockResult.data().next();
                        this.releaseLock(this.broadcastId());
                        Object object2 = x != null ? broadcastCache.put((Object)this.broadcastId(), x) : BoxedUnit.UNIT;
                        object = x;
                    } else if (None$.MODULE$.equals(option)) {
                        Object t;
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Started reading broadcast variable ").append(this.super$id()).toString());
                        long startTimeMs = System.currentTimeMillis();
                        BlockData[] blocks = this.readBlocks();
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Reading broadcast variable ").append(this.super$id()).append(" took").append(Utils$.MODULE$.getUsedTimeMs(startTimeMs)).toString());
                        try {
                            Object obj = TorrentBroadcast$.MODULE$.unBlockifyObject((InputStream[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toInputStream(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputStream.class))), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), $this.evidence$1);
                            StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                            if (!blockManager.putSingle(this.broadcastId(), obj, storageLevel, false, $this.evidence$1)) {
                                throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
                            }
                            Object object3 = obj != null ? broadcastCache.put((Object)this.broadcastId(), obj) : BoxedUnit.UNIT;
                            t = obj;
                        }
                        finally {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                                x$3.dispose();
                                return BoxedUnit.UNIT;
                            });
                        }
                        object = t;
                    } else {
                        throw new MatchError(option);
                    }
                    return object;
                });
            }
            return object;
        });
    }

    private void releaseLock(BlockId blockId) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        Option option = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskContext taskContext = (TaskContext)some.value();
            taskContext.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
                blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$writeBlocks$1(TorrentBroadcast $this, BlockManager blockManager$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChunkedByteBuffer bytes;
            BroadcastBlockId pieceId;
            ByteBuffer block = (ByteBuffer)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if ($this.checksumEnabled()) {
                $this.checksums()[i] = $this.calcChecksum(block);
            }
            if (!blockManager$1.putBytes(pieceId = new BroadcastBlockId($this.super$id(), new StringBuilder(5).append("piece").append(i).toString()), bytes = new ChunkedByteBuffer(block.duplicate()), StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append($this.broadcastId()).append(" ").append("in local BlockManager").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TorrentBroadcast(T obj, long id, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(id, evidence$1);
        this.setConf(SparkEnv$.MODULE$.get().conf());
        this.broadcastId = new BroadcastBlockId(super.id(), BroadcastBlockId$.MODULE$.apply$default$2());
        this.numBlocks = this.writeBlocks(obj);
        this.checksumEnabled = false;
    }
}

