/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.CleanAccum;
import org.apache.spark.CleanBroadcast;
import org.apache.spark.CleanCheckpoint;
import org.apache.spark.CleanRDD;
import org.apache.spark.CleanShuffle;
import org.apache.spark.CleanerListener;
import org.apache.spark.CleanupTask;
import org.apache.spark.CleanupTaskWeakReference;
import org.apache.spark.ContextCleaner$;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.ReliableRDDCheckpointData$;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.util.AccumulatorContext$;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tec!B\u0017/\u00019\"\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u000f-\u0003!\u0019!C\u0005\u0019\"1\u0001\f\u0001Q\u0001\n5Cq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004d\u0001\u0001\u0006Ia\u0017\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019y\u0007\u0001)A\u0005M\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bB\u0002<\u0001A\u0003%!\u000fC\u0004x\u0001\t\u0007I\u0011\u0002=\t\rq\u0004\u0001\u0015!\u0003z\u0011\u001di\bA1A\u0005\nyDq!!\u0002\u0001A\u0003%q\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011\u0011\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011Q\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\n!I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111\u0004\u0005\t\u0003O\u0001\u0001\u0015)\u0003\u0002\f!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003{\u0001A\u0011AA\u001e\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003k\u0004A\u0011BA\u001e\u0011\u001d\t9\u0010\u0001C\u0001\u0003sDqAa\u0001\u0001\t\u0003\u0011)\u0001C\u0004\u0003\u000e\u0001!\tAa\u0004\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007:qAa\u0013/\u0011\u0013\u0011iE\u0002\u0004.]!%!q\n\u0005\u0007\u000f&\"\tA!\u0015\t\u0013\tM\u0013F1A\u0005\n\tU\u0003\u0002\u0003B,S\u0001\u0006I!a7\u0003\u001d\r{g\u000e^3yi\u000ecW-\u00198fe*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xmE\u0002\u0001km\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 /\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001!>\u0005\u001daunZ4j]\u001e\f!a]2\u0004\u0001A\u0011A)R\u0007\u0002]%\u0011aI\f\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%S\u0005C\u0001#\u0001\u0011\u0015\t%\u00011\u0001D\u0003=\u0011XMZ3sK:\u001cWMQ;gM\u0016\u0014X#A'\u0011\u00079\u001bV+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003vi&d'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u00131aU3u!\t!e+\u0003\u0002X]\tA2\t\\3b]V\u0004H+Y:l/\u0016\f7NU3gKJ,gnY3\u0002!I,g-\u001a:f]\u000e,')\u001e4gKJ\u0004\u0013A\u0004:fM\u0016\u0014XM\\2f#V,W/Z\u000b\u00027B\u0019A,Y\u001b\u000e\u0003uS!AX0\u0002\u0007I,gM\u0003\u0002a#\u0006!A.\u00198h\u0013\t\u0011WL\u0001\bSK\u001a,'/\u001a8dKF+X-^3\u0002\u001fI,g-\u001a:f]\u000e,\u0017+^3vK\u0002\n\u0011\u0002\\5ti\u0016tWM]:\u0016\u0003\u0019\u00042a\u001a6m\u001b\u0005A'BA5P\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003W\"\u0014QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X\r\u0005\u0002E[&\u0011aN\f\u0002\u0010\u00072,\u0017M\\3s\u0019&\u001cH/\u001a8fe\u0006QA.[:uK:,'o\u001d\u0011\u0002\u001d\rdW-\u00198j]\u001e$\u0006N]3bIV\t!\u000f\u0005\u0002ti6\tq,\u0003\u0002v?\n1A\u000b\u001b:fC\u0012\fqb\u00197fC:Lgn\u001a+ie\u0016\fG\rI\u0001\u0012a\u0016\u0014\u0018n\u001c3jG\u001e\u001b5+\u001a:wS\u000e,W#A=\u0011\u0005\u001dT\u0018BA>i\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0013a\u0016\u0014\u0018n\u001c3jG\u001e\u001b5+\u001a:wS\u000e,\u0007%\u0001\nqKJLw\u000eZ5d\u000f\u000eKe\u000e^3sm\u0006dW#A@\u0011\u0007Y\n\t!C\u0002\u0002\u0004]\u0012A\u0001T8oO\u0006\u0019\u0002/\u001a:j_\u0012L7mR\"J]R,'O^1mA\u0005\u0019\"\r\\8dW>s7\t\\3b]V\u0004H+Y:lgV\u0011\u00111\u0002\t\u0004m\u00055\u0011bAA\bo\t9!i\\8mK\u0006t\u0017\u0001\u00062m_\u000e\\wJ\\\"mK\u0006tW\u000f\u001d+bg.\u001c\b%\u0001\u000ecY>\u001c7n\u00148TQV4g\r\\3DY\u0016\fg.\u001e9UCN\\7/A\u000ecY>\u001c7n\u00148TQV4g\r\\3DY\u0016\fg.\u001e9UCN\\7\u000fI\u0001\bgR|\u0007\u000f]3e\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\t\u0005u\u00111\u0005\t\u0004m\u0005}\u0011bAA\u0011o\t!QK\\5u\u0011%\t)\u0003FA\u0001\u0002\u0004\tY!A\u0002yIE\n\u0001b\u001d;paB,G\r\t\u0015\u0004+\u0005-\u0002c\u0001\u001c\u0002.%\u0019\u0011qF\u001c\u0003\u0011Y|G.\u0019;jY\u0016\fa\"\u0019;uC\u000eDG*[:uK:,'\u000f\u0006\u0003\u0002\u001e\u0005U\u0002BBA\u001c-\u0001\u0007A.\u0001\u0005mSN$XM\\3s\u0003\u0015\u0019H/\u0019:u)\t\ti\"\u0001\u0003ti>\u0004\u0018!\u0006:fO&\u001cH/\u001a:S\t\u00123uN]\"mK\u0006tW\u000f\u001d\u000b\u0005\u0003;\t\u0019\u0005C\u0004\u0002Fe\u0001\r!a\u0012\u0002\u0007I$G\r\r\u0003\u0002J\u0005]\u0003CBA&\u0003\u001f\n\u0019&\u0004\u0002\u0002N)\u0019\u0011Q\t\u0018\n\t\u0005E\u0013Q\n\u0002\u0004%\u0012#\u0005\u0003BA+\u0003/b\u0001\u0001\u0002\u0007\u0002Z\u0005\r\u0013\u0011!A\u0001\u0006\u0003\tYFA\u0002`IE\nB!!\u0018\u0002dA\u0019a'a\u0018\n\u0007\u0005\u0005tGA\u0004O_RD\u0017N\\4\u0011\u0007Y\n)'C\u0002\u0002h]\u00121!\u00118z\u0003u\u0011XmZ5ti\u0016\u0014\u0018iY2v[Vd\u0017\r^8s\r>\u00148\t\\3b]V\u0004H\u0003BA\u000f\u0003[Bq!a\u001c\u001b\u0001\u0004\t\t(A\u0001ba\u0019\t\u0019(a \u0002\u0006BA\u0011QOA=\u0003{\n\u0019)\u0004\u0002\u0002x)\u0011\u0001KL\u0005\u0005\u0003w\n9HA\u0007BG\u000e,X.\u001e7bi>\u0014hK\r\t\u0005\u0003+\ny\b\u0002\u0007\u0002\u0002\u00065\u0014\u0011!A\u0001\u0006\u0003\tYFA\u0002`II\u0002B!!\u0016\u0002\u0006\u0012a\u0011qQA7\u0003\u0003\u0005\tQ!\u0001\u0002\\\t\u0019q\fJ\u001a\u00023I,w-[:uKJ\u001c\u0006.\u001e4gY\u00164uN]\"mK\u0006tW\u000f\u001d\u000b\u0005\u0003;\ti\tC\u0004\u0002\u0010n\u0001\r!!%\u0002#MDWO\u001a4mK\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010\r\u0005\u0002\u0014\u0006m\u0015\u0011UAT!%!\u0015QSAM\u0003?\u000b)+C\u0002\u0002\u0018:\u0012\u0011c\u00155vM\u001adW\rR3qK:$WM\\2z!\u0011\t)&a'\u0005\u0019\u0005u\u0015QRA\u0001\u0002\u0003\u0015\t!a\u0017\u0003\u0007}#C\u0007\u0005\u0003\u0002V\u0005\u0005F\u0001DAR\u0003\u001b\u000b\t\u0011!A\u0003\u0002\u0005m#aA0%kA!\u0011QKAT\t1\tI+!$\u0002\u0002\u0003\u0005)\u0011AA.\u0005\ryFEN\u0001\u001ce\u0016<\u0017n\u001d;fe\n\u0013x.\u00193dCN$hi\u001c:DY\u0016\fg.\u001e9\u0016\t\u0005=\u0016\u0011\u0019\u000b\u0005\u0003;\t\t\fC\u0004\u00024r\u0001\r!!.\u0002\u0013\t\u0014x.\u00193dCN$\bCBA\\\u0003w\u000by,\u0004\u0002\u0002:*\u0019\u00111\u0017\u0018\n\t\u0005u\u0016\u0011\u0018\u0002\n\u0005J|\u0017\rZ2bgR\u0004B!!\u0016\u0002B\u00129\u00111\u0019\u000fC\u0002\u0005m#!\u0001+\u0002GI,w-[:uKJ\u0014F\tR\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019$pe\u000ecW-\u00198vaV!\u0011\u0011ZAq)\u0019\ti\"a3\u0002X\"9\u0011QI\u000fA\u0002\u00055\u0007\u0007BAh\u0003'\u0004b!a\u0013\u0002P\u0005E\u0007\u0003BA+\u0003'$A\"!6\u0002L\u0006\u0005\t\u0011!B\u0001\u00037\u00121a\u0018\u00138\u0011\u001d\tI.\ba\u0001\u00037\f\u0001\u0002]1sK:$\u0018\n\u001a\t\u0004m\u0005u\u0017bAApo\t\u0019\u0011J\u001c;\u0005\u000f\u0005\rWD1\u0001\u0002\\\u0005\u0011\"/Z4jgR,'OR8s\u00072,\u0017M\\;q)\u0019\ti\"a:\u0002l\"1\u0011\u0011\u001e\u0010A\u0002U\n\u0001c\u001c2kK\u000e$hi\u001c:DY\u0016\fg.\u001e9\t\u000f\u00055h\u00041\u0001\u0002p\u0006!A/Y:l!\r!\u0015\u0011_\u0005\u0004\u0003gt#aC\"mK\u0006tW\u000f\u001d+bg.\fAb[3fa\u000ecW-\u00198j]\u001e\fA\u0002Z8DY\u0016\fg.\u001e9S\t\u0012#b!!\b\u0002|\u0006}\bbBA\u007fA\u0001\u0007\u00111\\\u0001\u0006e\u0012$\u0017\n\u001a\u0005\b\u0005\u0003\u0001\u0003\u0019AA\u0006\u0003!\u0011Gn\\2lS:<\u0017\u0001\u00053p\u00072,\u0017M\\;q'\",hM\u001a7f)\u0019\tiBa\u0002\u0003\f!9!\u0011B\u0011A\u0002\u0005m\u0017!C:ik\u001a4G.Z%e\u0011\u001d\u0011\t!\ta\u0001\u0003\u0017\t!\u0003Z8DY\u0016\fg.\u001e9Ce>\fGmY1tiR1\u0011Q\u0004B\t\u0005+AaAa\u0005#\u0001\u0004y\u0018a\u00032s_\u0006$7-Y:u\u0013\u0012DqA!\u0001#\u0001\u0004\tY!\u0001\be_\u000ecW-\u00198va\u0006\u001b7-^7\u0015\r\u0005u!1\u0004B\u0010\u0011\u0019\u0011ib\ta\u0001\u007f\u0006)\u0011mY2JI\"9!\u0011A\u0012A\u0002\u0005-\u0011!\u00053p\u00072,\u0017M\\\"iK\u000e\\\u0007o\\5oiR!\u0011Q\u0004B\u0013\u0011\u001d\ti\u0010\na\u0001\u00037\f!C\u00197pG.l\u0015M\\1hKJl\u0015m\u001d;feV\u0011!1\u0006\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)\u0019!\u0011\u0007\u0018\u0002\u000fM$xN]1hK&!!Q\u0007B\u0018\u0005I\u0011En\\2l\u001b\u0006t\u0017mZ3s\u001b\u0006\u001cH/\u001a:\u0002!\t\u0014x.\u00193dCN$X*\u00198bO\u0016\u0014XC\u0001B\u001e!\u0011\t9L!\u0010\n\t\t}\u0012\u0011\u0018\u0002\u0011\u0005J|\u0017\rZ2bgRl\u0015M\\1hKJ\fa#\\1q\u001fV$\b/\u001e;Ue\u0006\u001c7.\u001a:NCN$XM]\u000b\u0003\u0005\u000b\u00022\u0001\u0012B$\u0013\r\u0011IE\f\u0002\u0017\u001b\u0006\u0004x*\u001e;qkR$&/Y2lKJl\u0015m\u001d;fe\u0006q1i\u001c8uKb$8\t\\3b]\u0016\u0014\bC\u0001#*'\tIS\u0007\u0006\u0002\u0003N\u00051\"+\u0012$`#V+U+R0Q\u001f2cu\fV%N\u000b>+F+\u0006\u0002\u0002\\\u00069\"+\u0012$`#V+U+R0Q\u001f2cu\fV%N\u000b>+F\u000b\t")
public class ContextCleaner
implements Logging {
    private final SparkContext sc;
    private final Set<CleanupTaskWeakReference> referenceBuffer;
    private final ReferenceQueue<Object> referenceQueue;
    private final ConcurrentLinkedQueue<CleanerListener> listeners;
    private final Thread cleaningThread;
    private final ScheduledExecutorService periodicGCService;
    private final long periodicGCInterval;
    private final boolean blockOnCleanupTasks;
    private final boolean blockOnShuffleCleanupTasks;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Set<CleanupTaskWeakReference> referenceBuffer() {
        return this.referenceBuffer;
    }

    private ReferenceQueue<Object> referenceQueue() {
        return this.referenceQueue;
    }

    private ConcurrentLinkedQueue<CleanerListener> listeners() {
        return this.listeners;
    }

    private Thread cleaningThread() {
        return this.cleaningThread;
    }

    private ScheduledExecutorService periodicGCService() {
        return this.periodicGCService;
    }

    private long periodicGCInterval() {
        return this.periodicGCInterval;
    }

    private boolean blockOnCleanupTasks() {
        return this.blockOnCleanupTasks;
    }

    private boolean blockOnShuffleCleanupTasks() {
        return this.blockOnShuffleCleanupTasks;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public void attachListener(CleanerListener listener) {
        this.listeners().add(listener);
    }

    public void start() {
        this.cleaningThread().setDaemon(true);
        this.cleaningThread().setName("Spark Context Cleaner");
        this.cleaningThread().start();
        this.periodicGCService().scheduleAtFixedRate(new Runnable(null){

            public void run() {
                System.gc();
            }
        }, this.periodicGCInterval(), this.periodicGCInterval(), TimeUnit.SECONDS);
    }

    public void stop() {
        this.stopped_$eq(true);
        ContextCleaner contextCleaner = this;
        synchronized (contextCleaner) {
            this.cleaningThread().interrupt();
        }
        this.cleaningThread().join();
        this.periodicGCService().shutdown();
    }

    public void registerRDDForCleanup(RDD<?> rdd) {
        this.registerForCleanup(rdd, new CleanRDD(rdd.id()));
    }

    public void registerAccumulatorForCleanup(AccumulatorV2<?, ?> a) {
        this.registerForCleanup(a, new CleanAccum(a.id()));
    }

    public void registerShuffleForCleanup(ShuffleDependency<?, ?, ?> shuffleDependency) {
        this.registerForCleanup(shuffleDependency, new CleanShuffle(shuffleDependency.shuffleId()));
    }

    public <T> void registerBroadcastForCleanup(Broadcast<T> broadcast) {
        this.registerForCleanup(broadcast, new CleanBroadcast(broadcast.id()));
    }

    public <T> void registerRDDCheckpointDataForCleanup(RDD<?> rdd, int parentId) {
        this.registerForCleanup(rdd, new CleanCheckpoint(parentId));
    }

    private void registerForCleanup(Object objectForCleanup, CleanupTask task) {
        this.referenceBuffer().add(new CleanupTaskWeakReference(task, objectForCleanup, this.referenceQueue()));
    }

    public void org$apache$spark$ContextCleaner$$keepCleaning() {
        Utils$.MODULE$.tryOrStopSparkContext(this.sc, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (!this.stopped()) {
                try {
                    Option reference = Option$.MODULE$.apply(this.referenceQueue().remove(ContextCleaner$.MODULE$.org$apache$spark$ContextCleaner$$REF_QUEUE_POLL_TIMEOUT())).map((Function1 & Serializable & scala.Serializable)x$1 -> (CleanupTaskWeakReference)x$1);
                    ContextCleaner contextCleaner = this;
                    synchronized (contextCleaner) {
                        reference.foreach((Function1 & Serializable & scala.Serializable)ref -> {
                            ContextCleaner.$anonfun$keepCleaning$3(this, ref);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InterruptedException && this.stopped()) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable2 instanceof Exception) {
                        Exception exception = (Exception)throwable2;
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error in cleaning thread", exception);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw throwable;
                }
            }
        });
    }

    public void doCleanupRDD(int rddId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Cleaning RDD ").append(rddId).toString());
            this.sc.unpersistRDD(rddId, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.rddCleaned(rddId);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Cleaned RDD ").append(rddId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Error cleaning RDD ").append(rddId).toString(), e);
        }
    }

    public void doCleanupShuffle(int shuffleId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Cleaning shuffle ").append(shuffleId).toString());
            this.mapOutputTrackerMaster().unregisterShuffle(shuffleId);
            this.blockManagerMaster().removeShuffle(shuffleId, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.shuffleCleaned(shuffleId);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Cleaned shuffle ").append(shuffleId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error cleaning shuffle ").append(shuffleId).toString(), e);
        }
    }

    public void doCleanupBroadcast(long broadcastId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Cleaning broadcast ").append(broadcastId).toString());
            this.broadcastManager().unbroadcast(broadcastId, true, blocking);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.broadcastCleaned(broadcastId);
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Cleaned broadcast ").append(broadcastId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Error cleaning broadcast ").append(broadcastId).toString(), e);
        }
    }

    public void doCleanupAccum(long accId, boolean blocking) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Cleaning accumulator ").append(accId).toString());
            AccumulatorContext$.MODULE$.remove(accId);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.accumCleaned(accId);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Cleaned accumulator ").append(accId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Error cleaning accumulator ").append(accId).toString(), e);
        }
    }

    public void doCleanCheckpoint(int rddId) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cleaning rdd checkpoint data ").append(rddId).toString());
            ReliableRDDCheckpointData$.MODULE$.cleanCheckpoint(this.sc, rddId);
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.checkpointCleaned(rddId);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Cleaned rdd checkpoint data ").append(rddId).toString());
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error cleaning rdd checkpoint data ").append(rddId).toString(), e);
        }
    }

    private BlockManagerMaster blockManagerMaster() {
        return this.sc.env().blockManager().master();
    }

    private BroadcastManager broadcastManager() {
        return this.sc.env().broadcastManager();
    }

    private MapOutputTrackerMaster mapOutputTrackerMaster() {
        return (MapOutputTrackerMaster)this.sc.env().mapOutputTracker();
    }

    public static final /* synthetic */ void $anonfun$keepCleaning$3(ContextCleaner $this, CleanupTaskWeakReference ref) {
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Got cleaning task ").append(ref.task()).toString());
        $this.referenceBuffer().remove(ref);
        CleanupTask cleanupTask = ref.task();
        if (cleanupTask instanceof CleanRDD) {
            CleanRDD cleanRDD = (CleanRDD)cleanupTask;
            int rddId = cleanRDD.rddId();
            $this.doCleanupRDD(rddId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanShuffle) {
            CleanShuffle cleanShuffle = (CleanShuffle)cleanupTask;
            int shuffleId = cleanShuffle.shuffleId();
            $this.doCleanupShuffle(shuffleId, $this.blockOnShuffleCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanBroadcast) {
            CleanBroadcast cleanBroadcast = (CleanBroadcast)cleanupTask;
            long broadcastId = cleanBroadcast.broadcastId();
            $this.doCleanupBroadcast(broadcastId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanAccum) {
            CleanAccum cleanAccum = (CleanAccum)cleanupTask;
            long accId = cleanAccum.accId();
            $this.doCleanupAccum(accId, $this.blockOnCleanupTasks());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cleanupTask instanceof CleanCheckpoint) {
            CleanCheckpoint cleanCheckpoint = (CleanCheckpoint)cleanupTask;
            int rddId = cleanCheckpoint.rddId();
            $this.doCleanCheckpoint(rddId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)cleanupTask);
        }
    }

    public ContextCleaner(SparkContext sc) {
        this.sc = sc;
        Logging.$init$(this);
        this.referenceBuffer = Collections.newSetFromMap(new ConcurrentHashMap());
        this.referenceQueue = new ReferenceQueue();
        this.listeners = new ConcurrentLinkedQueue();
        this.cleaningThread = new Thread(this){
            private final /* synthetic */ ContextCleaner $outer;

            public void run() {
                this.$outer.org$apache$spark$ContextCleaner$$keepCleaning();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.periodicGCService = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("context-cleaner-periodic-gc");
        this.periodicGCInterval = sc.conf().getTimeAsSeconds("spark.cleaner.periodicGC.interval", "30min");
        this.blockOnCleanupTasks = sc.conf().getBoolean("spark.cleaner.referenceTracking.blocking", true);
        this.blockOnShuffleCleanupTasks = sc.conf().getBoolean("spark.cleaner.referenceTracking.blocking.shuffle", false);
        this.stopped = false;
    }
}

