/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.ArrayOps;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%b!\u0002\u0014(\u0003\u0003!\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011=\u0003!\u0011!Q\u0001\nAC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\tA\u0002\u0011\u0019\u0011)A\u0006C\")q\r\u0001C\u0001Q\"9q\u000e\u0001b\u0001\n\u0017\u0001\bbBA\n\u0001\u0001\u0006I!\u001d\u0005\n\u0003+\u0001!\u0019!C\u0006\u0003/A\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0004\u0005\n\u0003C\u0001!\u0019!C\t\u0003GAq!!\n\u0001A\u0003%A\nC\u0004\u0002(\u00011\t\"!\u000b\t\u000f\u0005E\u0002A\"\u0005\u00024!9\u00111\b\u0001\u0007\u0012\u0005\r\u0002BCA\u001f\u0001!\u0015\r\u0011\"\u0006\u0002$!9\u0011q\b\u0001\u0007\u0002\u0005\u0005\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\t9\b\u0001C!\u0003sBq!! \u0001\t\u0003\ny\bC\u0004\u0002 \u0002!\t%!)\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0003\u0004A\u0011BAb\u00119\tI\r\u0001I\u0001\u0004\u0003\u0005I\u0011BAf\u0003+<q!!7(\u0011\u0003\tYN\u0002\u0004'O!\u0005\u0011Q\u001c\u0005\u0007Or!\t!a8\t\u0013\u0005\u0005HD1A\u0005\u0002\u0005\r\b\u0002CAx9\u0001\u0006I!!:\t\u000f\u0005EH\u0004\"\u0001\u0002t\"9\u0011\u0011 \u000f\u0005\u0002\u0005m\bb\u0002B\u00019\u0011\u0005!1\u0001\u0005\b\u0005\u001baB\u0011\u0001B\b\u0011\u001d\u0011)\u0002\bC\u0001\u0005/AqA!\b\u001d\t\u0003\u0011yB\u0001\rD_6\u0004\u0018m\u0019;jE2,g)\u001b7f'R\u0014X-Y7M_\u001eT!\u0001K\u0015\u0002\u0013M$(/Z1nS:<'B\u0001\u0016,\u0003%)\u00070Z2vi&|gN\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001!\u0006\u00026\u0005N\u0011\u0001A\u000e\t\u0004oaRT\"A\u0014\n\u0005e:#a\u0004%E\rNkU\r^1eCR\fGj\\4\u0011\u0007mr\u0004)D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0015\t%O]1z!\t\t%\t\u0004\u0001\u0005\u000b\r\u0003!\u0019\u0001#\u0003\u0003Q\u000b\"!\u0012%\u0011\u0005m2\u0015BA$=\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aO%\n\u0005)c$AB!osJ+g-\u0001\nnKR\fG-\u0019;b\u0019><g+\u001a:tS>t\u0007CA\u001eN\u0013\tqEHA\u0002J]R\fAb\u001d9be.\u001cVm]:j_:\u0004\"!\u0015*\u000e\u0003-J!aU\u0016\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\tA\fG\u000f\u001b\t\u0003-vs!aV.\u0011\u0005acT\"A-\u000b\u0005i\u001b\u0014A\u0002\u001fs_>$h(\u0003\u0002]y\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\taF(\u0001\u0006fm&$WM\\2fIE\u00022AY3A\u001b\u0005\u0019'B\u00013=\u0003\u001d\u0011XM\u001a7fGRL!AZ2\u0003\u0011\rc\u0017m]:UC\u001e\fa\u0001P5oSRtD\u0003B5m[:$\"A[6\u0011\u0007]\u0002\u0001\tC\u0003a\u000b\u0001\u000f\u0011\rC\u0003L\u000b\u0001\u0007A\nC\u0003P\u000b\u0001\u0007\u0001\u000bC\u0003U\u000b\u0001\u0007Q+A\u0004g_Jl\u0017\r^:\u0016\u0003E\u00142A\u001d%z\r\u0011\u0019\b\u0001A9\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \n\u0005=,\u0018B\u0001<x\u00055\u0019VM]5bY&T\u0018\r^5p]*\u0011\u00010M\u0001\u0007UN|g\u000eN:\u0011\u0005i\\X\"A<\n\u0005q<(a\u0002$pe6\fGo\u001d\u0005\b}J\u0014\r\u0011\"\u0001\u0000\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0003\u0003\u0003\u00012A_A\u0002\u0013\r\t)a\u001e\u0002\u000b\t\u0006$XMR8s[\u0006$\b\"CA\u0005e\n\u0007I\u0011IA\u0006\u0003%!\u0018\u0010]3IS:$8/\u0006\u0002\u0002\u000eA\u0019!0a\u0004\n\u0007\u0005EqOA\u0005UsB,\u0007*\u001b8ug\u0006Aam\u001c:nCR\u001c\b%\u0001\u0005nC:Lg-Z:u+\t\tI\u0002\u0005\u0003c\u00037\u0001\u0015bAA\u000fG\nAQ*\u00198jM\u0016\u001cH/A\u0005nC:Lg-Z:uA\u0005\u0011R.\u001b8CCR\u001c\u0007.Z:U_J+G/Y5o+\u0005a\u0015aE7j]\n\u000bGo\u00195fgR{'+\u001a;bS:\u0004\u0013A\u00054jY\u0016\u001cE.Z1okB$U\r\\1z\u001bN,\"!a\u000b\u0011\u0007m\ni#C\u0002\u00020q\u0012A\u0001T8oO\u0006!\u0012n\u001d#fY\u0016$\u0018N\\4FqBL'/\u001a3M_\u001e,\"!!\u000e\u0011\u0007m\n9$C\u0002\u0002:q\u0012qAQ8pY\u0016\fg.\u0001\feK\u001a\fW\u000f\u001c;D_6\u0004\u0018m\u0019;J]R,'O^1m\u0003=\u0019w.\u001c9bGRLe\u000e^3sm\u0006d\u0017aC2p[B\f7\r\u001e'pON$B!a\u0011\u0002VA)\u0011QIA(\u0001:!\u0011qIA&\u001d\rA\u0016\u0011J\u0005\u0002{%\u0019\u0011Q\n\u001f\u0002\u000fA\f7m[1hK&!\u0011\u0011KA*\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001bb\u0004bBA,!\u0001\u0007\u00111I\u0001\u0005Y><7/A\u0007cCR\u001c\u0007.\u00133U_B\u000bG\u000f\u001b\u000b\u0005\u0003;\ni\u0007\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0005\u0019\u001c(bAA4_\u00051\u0001.\u00193p_BLA!a\u001b\u0002b\t!\u0001+\u0019;i\u0011\u001d\ty'\u0005a\u0001\u0003W\tqAY1uG\"LE-A\u0007qCRDGk\u001c\"bi\u000eD\u0017\n\u001a\u000b\u0005\u0003W\t)\b\u0003\u0004U%\u0001\u0007\u0011QL\u0001\fSN\u0014\u0015\r^2i\r&dW\r\u0006\u0003\u00026\u0005m\u0004B\u0002+\u0014\u0001\u0004\ti&A\u0005tKJL\u0017\r\\5{KR1\u0011\u0011QAD\u0003\u0017\u00032aOAB\u0013\r\t)\t\u0010\u0002\u0005+:LG\u000f\u0003\u0004\u0002\nR\u0001\rAO\u0001\bY><G)\u0019;b\u0011\u001d\ti\t\u0006a\u0001\u0003\u001f\u000b1a\\;u!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b!![8\u000b\u0005\u0005e\u0015\u0001\u00026bm\u0006LA!!(\u0002\u0014\naq*\u001e;qkR\u001cFO]3b[\u0006YA-Z:fe&\fG.\u001b>f)\rQ\u00141\u0015\u0005\b\u0003K+\u0002\u0019AAT\u0003\tIg\u000e\u0005\u0003\u0002\u0012\u0006%\u0016\u0002BAV\u0003'\u00131\"\u00138qkR\u001cFO]3b[\u0006\u0019\u0011\r\u001a3\u0015\r\u0005U\u0012\u0011WAZ\u0011\u001d\tyG\u0006a\u0001\u0003WAa!a\u0016\u0017\u0001\u0004Q\u0014aB2p[B\f7\r\u001e\u000b\u0007\u0003k\tI,a/\t\u000f\u0005=t\u00031\u0001\u0002,!1\u0011qK\fA\u0002i\n\u0001\"\u00197m\r&dWm\u001d\u000b\u0002u\u0005\u0001B-\u001a7fi\u0016,\u0005\u0010]5sK\u0012dun\u001a\u000b\u0005\u0003\u0003\u000b)\rC\u0004\u0002Hf\u0001\r!a\u000b\u0002\u001d\r,(O]3oi\n\u000bGo\u00195JI\u0006I1/\u001e9fe\u0012:W\r\u001e\u000b\u0005\u0003\u001b\f\u0019\u000e\u0005\u0003<\u0003\u001fT\u0014bAAiy\t1q\n\u001d;j_:Dq!a\u001c\u001b\u0001\u0004\tY#C\u0002\u0002Xb\n1aZ3u\u0003a\u0019u.\u001c9bGRL'\r\\3GS2,7\u000b\u001e:fC6dun\u001a\t\u0003oq\u0019\"\u0001\b%\u0015\u0005\u0005m\u0017aE\"P\u001bB\u000b5\tV0G\u00132+ulU+G\r&CVCAAs!\u0011\t9/!<\u000e\u0005\u0005%(\u0002BAv\u0003/\u000bA\u0001\\1oO&\u0019a,!;\u0002)\r{U\nU!D)~3\u0015\nT#`'V3e)\u0013-!\u0003Y9W\r\u001e\"bi\u000eD\u0017\n\u001a$s_64\u0015\u000e\\3OC6,G\u0003BA\u0016\u0003kDa!a>!\u0001\u0004)\u0016\u0001\u00034jY\u0016t\u0015-\\3\u0002#%\u001c8i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007\u000e\u0006\u0004\u00026\u0005u\u0018q \u0005\b\u0003_\n\u0003\u0019AA\u0016\u0011\u0019\ti$\ta\u0001\u0019\u0006!s-\u001a;WC2LGMQ1uG\",7OQ3g_J,7i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007\u000e\u0006\u0004\u0003\u0006\t\u001d!1\u0002\t\u0007\u0003\u000b\ny%a\u000b\t\u000f\t%!\u00051\u0001\u0002,\u0005\t2m\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007.\u00133\t\r\u0005u\"\u00051\u0001M\u0003I9W\r^!mYZ\u000bG.\u001b3CCR\u001c\u0007.Z:\u0015\r\t\u0015!\u0011\u0003B\n\u0011\u001d\tyg\ta\u0001\u0003WAq!!\u0010$\u0001\u0004\tY#A\u000boKb$8i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007.\u00133\u0015\r\u0005-\"\u0011\u0004B\u000e\u0011\u001d\ty\u0007\na\u0001\u0003WAq!!\u0010%\u0001\u0004\tY#A\u000beKJLg/Z\"p[B\f7\r^%oi\u0016\u0014h/\u00197\u0015\u000b1\u0013\tC!\n\t\r\t\rR\u00051\u0001M\u0003=!WMZ1vYRLe\u000e^3sm\u0006d\u0007B\u0002B\u0014K\u0001\u0007A*\u0001\u000bmCR,7\u000f^\"p[B\f7\r\u001e\"bi\u000eD\u0017\n\u001a")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int n, int n2) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(n, n2);
    }

    public static long nextCompactionBatchId(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(l, l2);
    }

    public static Seq<Object> getAllValidBatches(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(l, l2);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(l, n);
    }

    public static boolean isCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(l, n);
    }

    public static long getBatchIdFromFileName(String string) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(string);
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private /* synthetic */ Option super$get(long batchId) {
        return super.get(batchId);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$))).reverse();
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("intervalValue = ").append(interval$1.elem).append(" not positive value.").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Set the compact interval to ").append(interval$1.elem).append(" ").append("[defaultCompactInterval: ").append(this.defaultCompactInterval()).append("]").toString());
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        return !this.bitmap$0 ? this.compactInterval$lzycompute() : this.compactInterval;
    }

    public abstract Seq<T> compactLogs(Seq<T> var1);

    @Override
    public Path batchIdToPath(long batchId) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? new Path(this.metadataPath(), new StringBuilder(0).append(batchId).append(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX()).toString()) : new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(new StringBuilder(1).append("v").append(this.metadataLogVersion).toString().getBytes(StandardCharsets.UTF_8));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logData)).foreach((Function1 & Serializable & scala.Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        int version = this.parseVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable & scala.Serializable)json -> Serialization$.MODULE$.read(json, this.formats(), this.manifest())).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    private boolean compact(long batchId, T[] logs) {
        Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId, this.compactInterval());
        Seq allLogs = (Seq)((TraversableLike)((GenericTraversableTemplate)validBatches.map((Function1 & Serializable & scala.Serializable)id -> CompactibleFileStreamLog.$anonfun$compact$1(this, batchId, BoxesRunTime.unboxToLong((Object)id)), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(xs)))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logs)), Seq$.MODULE$.canBuildFrom());
        return super.add(batchId, this.compactLogs(allLogs).toArray(this.manifest()));
    }

    public T[] allFiles() {
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)((GenericTraversableTemplate)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).map((Function1 & Serializable & scala.Serializable)id -> CompactibleFileStreamLog.$anonfun$allFiles$3(this, latestId, BoxesRunTime.unboxToLong((Object)id)), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(xs)));
                return (Object[])this.compactLogs(logs).toArray(this.manifest());
            }
            catch (IOException e) {
                latestId.elem = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                super.get(latestId.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw e;
                });
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        block0: {
            if ((long)this.compactInterval() > currentBatchId + 1L - (long)this.minBatchesToRetain()) break block0;
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(minCompactionBatchId).append(" is not a compaction batch").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Current compact batch id = ").append(currentBatchId).append(" ").append("min compaction batch id to delete = ").append(minCompactionBatchId).toString());
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), new PathFilter(null, minCompactionBatchId){
                private final long minCompactionBatchId$1;

                public boolean accept(Path path) {
                    boolean bl;
                    block3: {
                        try {
                            long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                            if (batchId < this.minCompactionBatchId$1) {
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    }
                    return bl;
                }
                {
                    this.minCompactionBatchId$1 = minCompactionBatchId$1;
                }
            }))).foreach((Function1 & Serializable & scala.Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$3(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        out$1.write(Serialization$.MODULE$.write(data, $this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ Object[] $anonfun$compact$1(CompactibleFileStreamLog $this, long batchId$1, long id) {
        return (Object[])$this.super$get(id).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(57).append($this.batchIdToPath(id)).append(" doesn't exist when compacting batch ").append(batchId$1).append(" ").append("(compactInterval: ").append($this.compactInterval()).append(")").toString());
        });
    }

    public static final /* synthetic */ Object[] $anonfun$allFiles$3(CompactibleFileStreamLog $this, LongRef latestId$1, long id) {
        return (Object[])$this.super$get(id).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(46).append($this.batchIdToPath(id)).append(" doesn't exist ").append("(latestId: ").append(latestId$1.elem).append(", compactInterval: ").append($this.compactInterval()).append(")").toString());
        });
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$3(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        block0: {
            if (f.getModificationTime() > expiredTime$1) break block0;
            $this.fileManager().delete(f.getPath());
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

