/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;

public final class RegressionMetricsExample$ {
    public static RegressionMetricsExample$ MODULE$;

    static {
        new RegressionMetricsExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("RegressionMetricsExample").getOrCreate();
        RDD data = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt").rdd().map((Function1 & java.io.Serializable & Serializable)row -> new LabeledPoint(row.getDouble(0), (Vector)row.get(1)), ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
        int numIterations = 100;
        LinearRegressionModel model = LinearRegressionWithSGD$.MODULE$.train(data, numIterations);
        RDD valuesAndPreds = data.map((Function1 & java.io.Serializable & Serializable)point -> {
            double prediction = model.predict(point.features());
            return new Tuple2.mcDD.sp(prediction, point.label());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RegressionMetrics metrics = new RegressionMetrics(valuesAndPreds);
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("MSE = ").append(metrics.meanSquaredError()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(7).append("RMSE = ").append(metrics.rootMeanSquaredError()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("R-squared = ").append(metrics.r2()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("MAE = ").append(metrics.meanAbsoluteError()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Explained variance = ").append(metrics.explainedVariance()).toString());
        spark.stop();
    }

    private RegressionMetricsExample$() {
        MODULE$ = this;
    }
}

