/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class RankingMetricsExample$ {
    public static RankingMetricsExample$ MODULE$;

    static {
        new RankingMetricsExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("RankingMetricsExample").getOrCreate();
        RDD ratings = spark.read().textFile("data/mllib/sample_movielens_data.txt").rdd().map((Function1 & Serializable & scala.Serializable)line -> {
            String[] fields = line.split("::");
            return new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble() - 2.5);
        }, ClassTag$.MODULE$.apply(Rating.class)).cache();
        RDD binarizedRatings = ratings.map((Function1 & Serializable & scala.Serializable)r -> new Rating(r.user(), r.product(), r.rating() > 0.0 ? 1.0 : 0.0), ClassTag$.MODULE$.apply(Rating.class)).cache();
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.user()), ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.product()), ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("Got ").append(numRatings).append(" ratings from ").append(numUsers).append(" users on ").append(numMovies).append(" movies.").toString());
        int numIterations = 10;
        int rank = 10;
        double lambda = 0.01;
        MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, rank, numIterations, lambda);
        RDD userRecommended = model.recommendProductsForUsers(10).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int user = tuple2._1$mcI$sp();
            Rating[] recs = (Rating[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])recs)).map((Function1 & Serializable & scala.Serializable)r -> RankingMetricsExample$.scaledRating$1(r), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class))));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD userMovies = binarizedRatings.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.user()), ClassTag$.MODULE$.Int());
        RDD relevantDocuments = RDD$.MODULE$.rddToPairRDDFunctions(userMovies, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Int$.MODULE$).join(userRecommended).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            Iterable actual = (Iterable)tuple2._1();
            Rating[] predictions = (Rating[])tuple2._2();
            Tuple2 tuple23 = new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.product()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), ((TraversableOnce)((TraversableLike)actual.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RankingMetricsExample$.$anonfun$main$10(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.product()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()));
            return tuple23;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RankingMetrics metrics = new RankingMetrics(relevantDocuments, ClassTag$.MODULE$.Int());
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> Predef$.MODULE$.println((Object)new StringBuilder(16).append("Precision at ").append(k).append(" = ").append(metrics.precisionAt(k)).toString()));
        Predef$.MODULE$.println((Object)new StringBuilder(25).append("Mean average precision = ").append(metrics.meanAveragePrecision()).toString());
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> Predef$.MODULE$.println((Object)new StringBuilder(11).append("NDCG at ").append(k).append(" = ").append(metrics.ndcgAt(k)).toString()));
        RDD allPredictions = model.predict(ratings.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2.mcII.sp(r.user(), r.product()), ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)new Tuple2.mcII.sp(r.user(), r.product()), (Object)BoxesRunTime.boxToDouble((double)r.rating())), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD allRatings = ratings.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)new Tuple2.mcII.sp(r.user(), r.product()), (Object)BoxesRunTime.boxToDouble((double)r.rating())), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD predictionsAndLabels = RDD$.MODULE$.rddToPairRDDFunctions(allPredictions, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(allRatings).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$3;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 != null && tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double predicted = tuple2._1$mcD$sp();
            double actual = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(predicted, actual);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RegressionMetrics regressionMetrics = new RegressionMetrics(predictionsAndLabels);
        Predef$.MODULE$.println((Object)new StringBuilder(7).append("RMSE = ").append(regressionMetrics.rootMeanSquaredError()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("R-squared = ").append(regressionMetrics.r2()).toString());
    }

    private static final Rating scaledRating$1(Rating r) {
        double scaledRating = package$.MODULE$.max(package$.MODULE$.min(r.rating(), 1.0), 0.0);
        return new Rating(r.user(), r.product(), scaledRating);
    }

    public static final /* synthetic */ boolean $anonfun$main$10(Rating x$5) {
        return x$5.rating() > 0.0;
    }

    private RankingMetricsExample$() {
        MODULE$ = this;
    }
}

