/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.PCA;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PCAExample$ {
    public static PCAExample$ MODULE$;

    static {
        new PCAExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("PCAExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/ridge-data/lpsa.data", sc.textFile$default$2()).map((Function1 & Serializable & scala.Serializable)line -> {
            String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split(',');
            return new LabeledPoint(new StringOps(Predef$.MODULE$.augmentString(parts[0])).toDouble(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(parts[1])).split(' '))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)PCAExample$.$anonfun$main$2(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].cache();
        RDD test = splits[1];
        PCAModel pca = new PCA(((LabeledPoint)training.first()).features().size() / 2).fit(data.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.features(), ClassTag$.MODULE$.apply(Vector.class)));
        RDD training_pca = training.map((Function1 & Serializable & scala.Serializable)p -> {
            Vector x$1 = pca.transform(p.features());
            double x$2 = p.copy$default$1();
            return p.copy(x$2, x$1);
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        RDD test_pca = test.map((Function1 & Serializable & scala.Serializable)p -> {
            Vector x$3 = pca.transform(p.features());
            double x$4 = p.copy$default$1();
            return p.copy(x$4, x$3);
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numIterations = 100;
        LinearRegressionModel model = LinearRegressionWithSGD$.MODULE$.train(training, numIterations);
        LinearRegressionModel model_pca = LinearRegressionWithSGD$.MODULE$.train(training_pca, numIterations);
        RDD valuesAndPreds = test.map((Function1 & Serializable & scala.Serializable)point -> {
            double score = model.predict(point.features());
            return new Tuple2.mcDD.sp(score, point.label());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD valuesAndPreds_pca = test_pca.map((Function1 & Serializable & scala.Serializable)point -> {
            double score = model_pca.predict(point.features());
            return new Tuple2.mcDD.sp(score, point.label());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double MSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(valuesAndPreds.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)PCAExample$.$anonfun$main$8(x0$1)), ClassTag$.MODULE$.Double())).mean();
        double MSE_pca = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(valuesAndPreds_pca.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)PCAExample$.$anonfun$main$9(x0$2)), ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Mean Squared Error = ").append(MSE).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(25).append("PCA Mean Squared Error = ").append(MSE_pca).toString());
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$main$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
    }

    public static final /* synthetic */ double $anonfun$main$8(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = package$.MODULE$.pow(v - p, 2.0);
        return d;
    }

    public static final /* synthetic */ double $anonfun$main$9(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = package$.MODULE$.pow(v - p, 2.0);
        return d;
    }

    private PCAExample$() {
        MODULE$ = this;
    }
}

