/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.LinearRegression;
import org.apache.spark.examples.mllib.LinearRegression$;
import org.apache.spark.examples.mllib.LinearRegression$Params$;
import org.apache.spark.examples.mllib.LinearRegression$RegType$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SimpleUpdater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction2;
import scopt.OptionParser;
import scopt.Read$;

public final class LinearRegression$ {
    public static LinearRegression$ MODULE$;

    static {
        new LinearRegression$();
    }

    public void main(String[] args) {
        LinearRegression.Params defaultParams = new LinearRegression.Params(LinearRegression$Params$.MODULE$.apply$default$1(), LinearRegression$Params$.MODULE$.apply$default$2(), LinearRegression$Params$.MODULE$.apply$default$3(), LinearRegression$Params$.MODULE$.apply$default$4(), LinearRegression$Params$.MODULE$.apply$default$5());
        OptionParser<LinearRegression.Params> parser = new OptionParser<LinearRegression.Params>(defaultParams){

            public static final /* synthetic */ LinearRegression.Params $anonfun$new$1(int x, LinearRegression.Params c) {
                int x$1 = x;
                String x$2 = c.copy$default$1();
                double x$3 = c.copy$default$3();
                Enumeration.Value x$4 = c.copy$default$4();
                double x$5 = c.copy$default$5();
                return c.copy(x$2, x$1, x$3, x$4, x$5);
            }

            public static final /* synthetic */ LinearRegression.Params $anonfun$new$2(double x, LinearRegression.Params c) {
                double x$6 = x;
                String x$7 = c.copy$default$1();
                int x$8 = c.copy$default$2();
                Enumeration.Value x$9 = c.copy$default$4();
                double x$10 = c.copy$default$5();
                return c.copy(x$7, x$8, x$6, x$9, x$10);
            }
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegression: an example app for linear regression."}));
                this.opt("numIterations", Read$.MODULE$.intRead()).text("number of iterations").action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("stepSize", Read$.MODULE$.doubleRead()).text(new StringBuilder(28).append("initial step size, default: ").append(defaultParams$1.stepSize()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("regType", Read$.MODULE$.stringRead()).text(new StringBuilder(33).append("regularization type (").append(LinearRegression$RegType$.MODULE$.values().mkString(",")).append("), ").append("default: ").append(defaultParams$1.regType()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Enumeration.Value x$11 = LinearRegression$RegType$.MODULE$.withName((String)x);
                    String x$12 = c.copy$default$1();
                    int x$13 = c.copy$default$2();
                    double x$14 = c.copy$default$3();
                    double x$15 = c.copy$default$5();
                    return c.copy(x$12, x$13, x$14, x$11, x$15);
                });
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringBuilder(35).append("regularization parameter, default: ").append(defaultParams$1.regParam()).toString());
                this.arg("<input>", Read$.MODULE$.stringRead()).required().text("input paths to labeled examples in LIBSVM format").action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5()));
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a synthetic dataset:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.mllib.LinearRegression \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  data/mllib/sample_linear_regression_data.txt\n        ")).stripMargin());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.LinearRegression$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.LinearRegression$Params ), $anonfun$new$3(java.lang.String org.apache.spark.examples.mllib.LinearRegression$Params ), $anonfun$new$4(java.lang.String org.apache.spark.examples.mllib.LinearRegression$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        LinearRegression.Params params = (LinearRegression.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(LinearRegression.Params params) {
        SimpleUpdater simpleUpdater;
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(22).append("LinearRegression with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Logger.getRootLogger().setLevel(Level.WARN);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        RDD[] splits = examples.randomSplit(new double[]{0.8, 0.2}, examples.randomSplit$default$2());
        RDD training = splits[0].cache();
        RDD test = splits[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Training: ").append(numTraining).append(", test: ").append(numTest).append(".").toString());
        examples.unpersist(false);
        Enumeration.Value value = params.regType();
        Enumeration.Value value2 = LinearRegression$RegType$.MODULE$.NONE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            simpleUpdater = new SimpleUpdater();
        } else {
            Enumeration.Value value4 = LinearRegression$RegType$.MODULE$.L1();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                simpleUpdater = new L1Updater();
            } else {
                Enumeration.Value value6 = LinearRegression$RegType$.MODULE$.L2();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    simpleUpdater = new SquaredL2Updater();
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        SimpleUpdater updater = simpleUpdater;
        LinearRegressionWithSGD algorithm = new LinearRegressionWithSGD();
        algorithm.optimizer().setNumIterations(params.numIterations()).setStepSize(params.stepSize()).setUpdater((Updater)updater).setRegParam(params.regParam());
        LinearRegressionModel model = (LinearRegressionModel)algorithm.run(training);
        RDD prediction = model.predict(test.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class)));
        RDD predictionAndLabel = prediction.zip(test.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.label()), ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
        double loss = BoxesRunTime.unboxToDouble((Object)predictionAndLabel.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LinearRegression$.$anonfun$run$3(x0$1)), ClassTag$.MODULE$.Double()).reduce((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 + x$4));
        double rmse = package$.MODULE$.sqrt(loss / (double)numTest);
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Test RMSE = ").append(rmse).append(".").toString());
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$run$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double p = tuple2._1$mcD$sp();
        double l = tuple2._2$mcD$sp();
        double err = p - l;
        double d = err * err;
        return d;
    }

    private LinearRegression$() {
        MODULE$ = this;
    }
}

