/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import java.io.Serializable;
import java.util.Random;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LocalKMeans$ {
    public static LocalKMeans$ MODULE$;
    private final int N;
    private final int R;
    private final int D;
    private final int K;
    private final double convergeDist;
    private final Random rand;

    static {
        new LocalKMeans$();
    }

    public int N() {
        return this.N;
    }

    public int R() {
        return this.R;
    }

    public int D() {
        return this.D;
    }

    public int K() {
        return this.K;
    }

    public double convergeDist() {
        return this.convergeDist;
    }

    public Random rand() {
        return this.rand;
    }

    public DenseVector<Object>[] generateData() {
        return (DenseVector[])Array$.MODULE$.tabulate(this.N(), (Function1 & Serializable & scala.Serializable)i -> this.generatePoint$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(DenseVector.class));
    }

    public int closestPoint(Vector<Object> p, HashMap<Object, Vector<Object>> centers) {
        IntRef bestIndex = IntRef.create((int)0);
        DoubleRef closest = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), centers.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                Vector vCurr = (Vector)centers.apply((Object)BoxesRunTime.boxToInteger((int)i));
                double tempDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)p, (Object)vCurr, squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                if (!(tempDist < closest$1.elem)) break block0;
                closest$1.elem = tempDist;
                bestIndex$1.elem = i;
            }
        });
        return bestIndex.elem;
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of KMeans Clustering and is given as an example!\n        |Please use org.apache.spark.ml.clustering.KMeans\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        this.showWarning();
        DenseVector<Object>[] data = this.generateData();
        HashSet points = new HashSet();
        HashMap kPoints = new HashMap();
        DoubleRef tempDist = DoubleRef.create((double)1.0);
        while (points.size() < this.K()) {
            points.add(data[this.rand().nextInt(this.N())]);
        }
        Iterator iter = points.iterator();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), points.size()).foreach((Function1 & Serializable & scala.Serializable)i -> kPoints.put((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), iter.next()));
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("Initial centers: ").append(kPoints).toString());
        while (tempDist.elem > this.convergeDist()) {
            Tuple2[] closest = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)MODULE$.closestPoint((Vector<Object>)p, (HashMap<Object, Vector<Object>>)kPoints)), (Object)new Tuple2(p, (Object)BoxesRunTime.boxToInteger((int)1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Map mappings = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])closest)).groupBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)x._1$mcI$sp()));
            Map pointStats = (Map)mappings.map((Function1 & Serializable & scala.Serializable)pair -> (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pair._2())).reduceLeft((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                int c1;
                Vector p1;
                int id1;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        Tuple2 tuple24 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        id1 = tuple23._1$mcI$sp();
                        Tuple2 tuple25 = (Tuple2)tuple23._2();
                        if (tuple25 == null) break block2;
                        p1 = (Vector)tuple25._1();
                        c1 = tuple25._2$mcI$sp();
                        if (tuple24 != null && (tuple2 = (Tuple2)tuple24._2()) != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                DenseVector p2 = (DenseVector)tuple2._1();
                int c2 = tuple2._2$mcI$sp();
                Tuple2 tuple26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id1), (Object)new Tuple2(p1.$plus((Object)p2, Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd())), (Object)BoxesRunTime.boxToInteger((int)(c1 + c2))));
                return tuple26;
            }), Map$.MODULE$.canBuildFrom());
            Map newPoints = (Map)pointStats.map((Function1 & Serializable & scala.Serializable)mapping -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp()), ((ImmutableNumericOps)((Tuple2)mapping._2())._1()).$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)((Tuple2)mapping._2())._2$mcI$sp())), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())), Map$.MODULE$.canBuildFrom());
            tempDist.elem = 0.0;
            newPoints.foreach((Function1 & Serializable & scala.Serializable)mapping -> {
                LocalKMeans$.$anonfun$main$7(tempDist, kPoints, mapping);
                return BoxedUnit.UNIT;
            });
            newPoints.foreach((Function1 & Serializable & scala.Serializable)newP -> kPoints.put((Object)BoxesRunTime.boxToInteger((int)newP._1$mcI$sp()), newP._2()));
        }
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Final centers: ").append(kPoints).toString());
    }

    private final DenseVector generatePoint$1(int i) {
        return (DenseVector)DenseVector$.MODULE$.fill(this.D(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> MODULE$.rand().nextDouble() * (double)MODULE$.R(), ClassTag$.MODULE$.Double());
    }

    public static final /* synthetic */ void $anonfun$main$7(DoubleRef tempDist$1, HashMap kPoints$1, Tuple2 mapping) {
        tempDist$1.elem += BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply(kPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp())), mapping._2(), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
    }

    private LocalKMeans$() {
        MODULE$ = this;
        this.N = 1000;
        this.R = 1000;
        this.D = 10;
        this.K = 10;
        this.convergeDist = 0.001;
        this.rand = new Random(42L);
    }
}

