/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mg!B\u0012%\u0001\u0019\u0002\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0011\u001d1\u0007\u00011A\u0005\n\u001dDa!\u001c\u0001!B\u0013Y\u0006b\u00028\u0001\u0001\u0004%I!\u001a\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0011\u0019\u0011\b\u0001)Q\u00057\"91\u000f\u0001b\u0001\n\u0013!\bBB?\u0001A\u0003%Q\u000fC\u0004\u007f\u0001\t\u0007I\u0011B@\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u0003A\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u001bA\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0013\u0005]\u0002\u00011A\u0005\n\u0005e\u0002\u0002CA\u001f\u0001\u0001\u0006K!!\u0007\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA$\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\t)\b\u0001C!\u0003oBq!!\"\u0001\t\u0013\t)\u0005C\u0004\u0002\b\u0002!I!!\u0012\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u0011Q\u0012\u0001\u0005\n\u0005\u0015\u0003bBAH\u0001\u0011%\u0011\u0011\u0013\u0005\b\u0003+\u0003A\u0011BAL\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!!0\u0001\t\u0013\ty\fC\u0004\u0002L\u0002!I!!4\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\nYBj\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM]%na2T!!\n\u0014\u0002\rM,(-\\5u\u0015\t9\u0003&A\u0002lqMT!!\u000b\u0016\u0002\r\u0011,\u0007\u000f\\8z\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0003\u0002\u00012su\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\t1\fgn\u001a\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0004PE*,7\r\u001e\t\u0003umj\u0011\u0001J\u0005\u0003y\u0011\u0012q\u0003T8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:\u0011\u0005y\nU\"A \u000b\u0005\u0001S\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\t{$a\u0002'pO\u001eLgnZ\u0001\u0006CB\u0004\u0018\nZ\u0002\u0001!\t1uJ\u0004\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nR\u0001\u0007yI|w\u000e\u001e \u000b\u00031\u000bQa]2bY\u0006L!AT&\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001d.\u000bA#\\1zE\u0016dunZ4j]\u001eLe\u000e^3sm\u0006d\u0007c\u0001+V/6\t1*\u0003\u0002W\u0017\n1q\n\u001d;j_:\u0004\"\u0001\u0016-\n\u0005e[%\u0001\u0002'p]\u001e\f\u0011c^1ji\u001a{'oQ8na2,G/[8o!\t!F,\u0003\u0002^\u0017\n9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003aC\n\u001c\u0007C\u0001\u001e\u0001\u0011\u0015\u0019E\u00011\u0001F\u0011\u0015\u0011F\u00011\u0001T\u0011\u0015QF\u00011\u0001\\\u00031\u0001x\u000eZ\"p[BdW\r^3e+\u0005Y\u0016\u0001\u00059pI\u000e{W\u000e\u001d7fi\u0016$w\fJ3r)\tA7\u000e\u0005\u0002US&\u0011!n\u0013\u0002\u0005+:LG\u000fC\u0004m\r\u0005\u0005\t\u0019A.\u0002\u0007a$\u0013'A\u0007q_\u0012\u001cu.\u001c9mKR,G\rI\u0001\u0017e\u0016\u001cx.\u001e:dKR{wn\u00147e%\u0016\u001cW-\u001b<fI\u0006Q\"/Z:pkJ\u001cW\rV8p\u001f2$'+Z2fSZ,Gm\u0018\u0013fcR\u0011\u0001.\u001d\u0005\bY&\t\t\u00111\u0001\\\u0003]\u0011Xm]8ve\u000e,Gk\\8PY\u0012\u0014VmY3jm\u0016$\u0007%\u0001\nq_\u0012\u001cu.\u001c9mKR,GMR;ukJ,W#A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018AC2p]\u000e,(O]3oi*\u0011!0N\u0001\u0005kRLG.\u0003\u0002}o\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017a\u00059pI\u000e{W\u000e\u001d7fi\u0016$g)\u001e;ve\u0016\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\t\t\u0001E\u0002w\u0003\u0007I1!!\u0002x\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013a\u00037pOJ+hN\\1cY\u0016,\"!!\u0004\u0011\u0007I\ny!C\u0002\u0002\u0012M\u0012\u0001BU;o]\u0006\u0014G.Z\u0001\rY><'+\u001e8oC\ndW\rI\u0001\u0004a>$WCAA\r!\u0011!V+a\u0007\u0011\t\u0005u\u00111G\u0007\u0003\u0003?QA!!\t\u0002$\u0005)Qn\u001c3fY*!\u0011QEA\u0014\u0003\r\t\u0007/\u001b\u0006\u0005\u0003S\tY#\u0001\u0006lk\n,'O\\3uKNTA!!\f\u00020\u00059a-\u00192sS\u000eD$BAA\u0019\u0003\tIw.\u0003\u0003\u00026\u0005}!a\u0001)pI\u00069\u0001o\u001c3`I\u0015\fHc\u00015\u0002<!AANEA\u0001\u0002\u0004\tI\"\u0001\u0003q_\u0012\u0004\u0013!\u00029iCN,W#A#\u0002\u000bI,7/\u001a;\u0015\u0003!\fQa\u001d;beR\fQ\"\u001a<f]R\u0014VmY3jm\u0016$G#\u00025\u0002N\u0005M\u0004bBA(/\u0001\u0007\u0011\u0011K\u0001\u0007C\u000e$\u0018n\u001c8\u0011\t\u0005M\u0013Q\u000e\b\u0005\u0003+\n9G\u0004\u0003\u0002X\u0005\rd\u0002BA-\u0003CrA!a\u0017\u0002`9\u0019\u0001*!\u0018\n\u0005\u0005E\u0012\u0002BA\u0017\u0003_IA!!\u000b\u0002,%!\u0011QMA\u0014\u0003\u0019\u0019G.[3oi&!\u0011\u0011NA6\u0003\u001d9\u0016\r^2iKJTA!!\u001a\u0002(%!\u0011qNA9\u0005\u0019\t5\r^5p]*!\u0011\u0011NA6\u0011\u001d\t)b\u0006a\u0001\u00037\tqa\u001c8DY>\u001cX\rF\u0002i\u0003sBq!a\u001f\u0019\u0001\u0004\ti(A\u0001f!\u0011\ty(!!\u000e\u0005\u0005-\u0014\u0002BAB\u0003W\u0012\u0011dS;cKJtW\r^3t\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\u0006qAn\\4TQ>\u0014Ho\u0015;biV\u001c\u0018!\u00047pO2{gnZ*uCR,8/\u0001\u0007iCN\u001cu.\u001c9mKR,G\rF\u0001\\\u0003)\u0019Gn\\:f/\u0006$8\r[\u0001\u000fM>\u0014X.\u0019;Q_\u0012\u001cF/\u0019;f)\r)\u00151\u0013\u0005\b\u0003+i\u0002\u0019AA\u000e\u0003E1wN]7biB\u000b\u0017N]:Ck:$G.\u001a\u000b\u0004\u000b\u0006e\u0005bBAN=\u0001\u0007\u0011QT\u0001\u0006a\u0006L'o\u001d\t\u0007\u0003?\u000bI+a,\u000f\t\u0005\u0005\u0016Q\u0015\b\u0004\u0011\u0006\r\u0016\"\u0001'\n\u0007\u0005\u001d6*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0016Q\u0016\u0002\u0004'\u0016\f(bAAT\u0017B)A+!-F\u000b&\u0019\u00111W&\u0003\rQ+\b\u000f\\33\u0003U\u0019wN\u001c;bS:,'o\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:$2!RA]\u0011\u001d\tYl\ba\u0001\u00037\t\u0011\u0001]\u0001\u001bG>tG/Y5oKJ\u001cF/\u0019;vg\u0012+7o\u0019:jaRLwN\u001c\u000b\u0005\u0003;\u000b\t\rC\u0004\u0002D\u0002\u0002\r!!2\u0002\u001f\r|g\u000e^1j]\u0016\u00148\u000b^1ukN\u0004B!!\b\u0002H&!\u0011\u0011ZA\u0010\u0005=\u0019uN\u001c;bS:,'o\u0015;biV\u001c\u0018A\u00034pe6\fG\u000fV5nKR\u0019Q)a4\t\r\u0005E\u0017\u00051\u0001F\u0003\u0011!\u0018.\\3\u0002\u0017]\fGo\u00195PeN#x\u000e\u001d\u000b\u00047\u0006]\u0007BBAmE\u0001\u0007Q)A\u0002t\u0013\u0012\u0004")
public class LoggingPodStatusWatcherImpl
implements LoggingPodStatusWatcher,
Logging {
    private final String appId;
    private final Option<Object> maybeLoggingInterval;
    private final boolean waitForCompletion;
    private boolean podCompleted;
    private boolean resourceTooOldReceived;
    private final CountDownLatch podCompletedFuture;
    private final ScheduledExecutorService scheduler;
    private final Runnable logRunnable;
    private Option<Pod> pod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean podCompleted() {
        return this.podCompleted;
    }

    private void podCompleted_$eq(boolean x$1) {
        this.podCompleted = x$1;
    }

    private boolean resourceTooOldReceived() {
        return this.resourceTooOldReceived;
    }

    private void resourceTooOldReceived_$eq(boolean x$1) {
        this.resourceTooOldReceived = x$1;
    }

    private CountDownLatch podCompletedFuture() {
        return this.podCompletedFuture;
    }

    private ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    private Runnable logRunnable() {
        return this.logRunnable;
    }

    private Option<Pod> pod() {
        return this.pod;
    }

    private void pod_$eq(Option<Pod> x$1) {
        this.pod = x$1;
    }

    private String phase() {
        return (String)this.pod().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getStatus().getPhase()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
    }

    @Override
    public void reset() {
        this.resourceTooOldReceived_$eq(false);
    }

    public void start() {
        this.maybeLoggingInterval.foreach((Function1 & Serializable & scala.Serializable)interval -> LoggingPodStatusWatcherImpl.$anonfun$start$1(this, BoxesRunTime.unboxToLong((Object)interval)));
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        this.pod_$eq((Option<Pod>)Option$.MODULE$.apply((Object)pod));
        Watcher.Action action2 = action;
        boolean bl = Watcher.Action.DELETED.equals(action2) ? true : Watcher.Action.ERROR.equals(action2);
        if (bl) {
            this.closeWatch();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            this.logLongStatus();
            if (this.hasCompleted()) {
                this.closeWatch();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void onClose(KubernetesClientException e) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Stopping watching application ").append($this.appId).append(" with last-observed phase ").append(this.phase()).toString());
        if (e != null && e.getCode() == 410) {
            this.resourceTooOldReceived_$eq(true);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Got HTTP Gone code, resource version changed in k8s api: ").append(e).toString());
        } else {
            this.closeWatch();
        }
    }

    public void org$apache$spark$deploy$k8s$submit$LoggingPodStatusWatcherImpl$$logShortStatus() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application status for ").append($this.appId).append(" (phase: ").append(this.phase()).append(")").toString());
    }

    private void logLongStatus() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("State changed, new state: ").append(this.pod().map((Function1 & Serializable & scala.Serializable)pod -> this.formatPodState((Pod)pod)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasCompleted() {
        String string = this.phase();
        String string2 = "Succeeded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = this.phase();
        String string4 = "Failed";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private void closeWatch() {
        this.podCompletedFuture().countDown();
        this.scheduler().shutdown();
        this.podCompleted_$eq(true);
    }

    private String formatPodState(Pod pod) {
        Seq details = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"pod name", (Object)pod.getMetadata().getName()), new Tuple2((Object)"namespace", (Object)pod.getMetadata().getNamespace()), new Tuple2((Object)"labels", (Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pod.getMetadata().getLabels()).asScala()).mkString(", ")), new Tuple2((Object)"pod uid", (Object)pod.getMetadata().getUid()), new Tuple2((Object)"creation time", (Object)this.formatTime(pod.getMetadata().getCreationTimestamp())), new Tuple2((Object)"service account name", (Object)pod.getSpec().getServiceAccountName()), new Tuple2((Object)"volumes", (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")), new Tuple2((Object)"node name", (Object)pod.getSpec().getNodeName()), new Tuple2((Object)"start time", (Object)this.formatTime(pod.getStatus().getStartTime())), new Tuple2((Object)"container images", (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getImage(), Buffer$.MODULE$.canBuildFrom())).mkString(", ")), new Tuple2((Object)"phase", (Object)pod.getStatus().getPhase()), new Tuple2((Object)"status", (Object)pod.getStatus().getContainerStatuses().toString())}));
        return this.formatPairsBundle((Seq<Tuple2<String, String>>)details);
    }

    private String formatPairsBundle(Seq<Tuple2<String, String>> pairs) {
        return ((TraversableOnce)pairs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(5).append("\n\t ").append(k).append(": ").append(Option$.MODULE$.apply((Object)v).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LoggingPodStatusWatcherImpl.$anonfun$formatPairsBundle$2(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A")).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("");
    }

    private String containersDescription(Pod p) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)status -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container name", (Object)status.getName()), new Tuple2((Object)"Container image", (Object)status.getImage())}))).$plus$plus(this.containerStatusDescription((ContainerStatus)status), Seq$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)pairs -> this.formatPairsBundle((Seq<Tuple2<String, String>>)pairs), Buffer$.MODULE$.canBuildFrom())).mkString("\n\n");
    }

    private Seq<Tuple2<String, String>> containerStatusDescription(ContainerStatus containerStatus) {
        ContainerState state = containerStatus.getState();
        return (Seq)Option$.MODULE$.apply((Object)state.getRunning()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)state.getTerminated())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)state.getWaiting())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            KubernetesResource kubernetesResource = x0$1;
            if (kubernetesResource instanceof ContainerStateRunning) {
                ContainerStateRunning containerStateRunning = (ContainerStateRunning)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Running"), new Tuple2((Object)"Container started at", (Object)this.formatTime(containerStateRunning.getStartedAt()))}));
            } else if (kubernetesResource instanceof ContainerStateWaiting) {
                ContainerStateWaiting containerStateWaiting = (ContainerStateWaiting)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Waiting"), new Tuple2((Object)"Pending reason", (Object)containerStateWaiting.getReason())}));
            } else if (kubernetesResource instanceof ContainerStateTerminated) {
                ContainerStateTerminated containerStateTerminated = (ContainerStateTerminated)kubernetesResource;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"Terminated"), new Tuple2((Object)"Exit code", (Object)containerStateTerminated.getExitCode().toString())}));
            } else {
                throw new SparkException(new StringBuilder(34).append("Unexpected container status type ").append(kubernetesResource.getClass()).append(".").toString());
            }
            return seq;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Container state", (Object)"N/A")})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String formatTime(String time) {
        if (time == null) {
            String string = time;
            String string2 = "";
            if (string == null) {
                if (string2 == null) return "N/A";
            } else if (string.equals(string2)) return "N/A";
        }
        String string = time;
        return string;
    }

    @Override
    public boolean watchOrStop(String sId) {
        boolean bl;
        if (this.waitForCompletion) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Waiting for application ").append($this.appId).append(" with submission ID ").append(sId).append(" to finish...").toString());
            Option<Object> interval = this.maybeLoggingInterval;
            LoggingPodStatusWatcherImpl loggingPodStatusWatcherImpl = this;
            synchronized (loggingPodStatusWatcherImpl) {
                while (!this.podCompleted() && !this.resourceTooOldReceived()) {
                    this.wait(BoxesRunTime.unboxToLong((Object)interval.get()));
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application status for ").append($this.appId).append(" (phase: ").append(this.phase()).append(")").toString());
                }
            }
            if (this.podCompleted()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)this.pod().map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(27).append("Container final statuses:\n\n").append(this.containersDescription((Pod)p)).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "No containers were found in the driver pod."));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Application ").append($this.appId).append(" with submission ID ").append(sId).append(" finished").toString());
            }
            bl = this.podCompleted();
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Deployed Spark application ").append($this.appId).append(" with submission ID ").append(sId).append(" into Kubernetes").toString());
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ ScheduledFuture $anonfun$start$1(LoggingPodStatusWatcherImpl $this, long interval) {
        return $this.scheduler().scheduleAtFixedRate($this.logRunnable(), 0L, interval, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ boolean $anonfun$formatPairsBundle$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public LoggingPodStatusWatcherImpl(String appId, Option<Object> maybeLoggingInterval, boolean waitForCompletion) {
        this.appId = appId;
        this.maybeLoggingInterval = maybeLoggingInterval;
        this.waitForCompletion = waitForCompletion;
        Logging.$init$((Logging)this);
        this.podCompleted = false;
        this.resourceTooOldReceived = false;
        this.podCompletedFuture = new CountDownLatch(1);
        this.scheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("logging-pod-status-watcher");
        this.logRunnable = new Runnable(this){
            private final /* synthetic */ LoggingPodStatusWatcherImpl $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$k8s$submit$LoggingPodStatusWatcherImpl$$logShortStatus();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.pod = Option$.MODULE$.empty();
    }
}

