/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.optimize.CubicLineSearch;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderException;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u000f\t)2\u000b\u001e:p]\u001e<v\u000e\u001c4f\u0019&tWmU3be\u000eD'BA\u0002\u0005\u0003!y\u0007\u000f^5nSj,'\"A\u0003\u0002\r\t\u0014X-\u001a>f\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!aD\"vE&\u001cG*\u001b8f'\u0016\f'o\u00195\t\u00115\u0001!\u0011!Q\u0001\n9\t1\"\\1y5>|W.\u0013;feB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t\u0019\u0011J\u001c;\t\u0011U\u0001!\u0011!Q\u0001\n9\t\u0011#\\1y\u0019&tWmU3be\u000eD\u0017\n^3s\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\u0019\u0011DG\u000e\u0011\u0005%\u0001\u0001\"B\u0007\u0017\u0001\u0004q\u0001\"B\u000b\u0017\u0001\u0004q\u0001bB\u000f\u0001\u0005\u0004%\tAH\u0001\u0003GF*\u0012a\b\t\u0003\u001f\u0001J!!\t\t\u0003\r\u0011{WO\u00197f\u0011\u0019\u0019\u0003\u0001)A\u0005?\u0005\u00191-\r\u0011\t\u000f\u0015\u0002!\u0019!C\u0001=\u0005\u00111M\r\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\u0002\u0007\r\u0014\u0004\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0005nS:LW.\u001b>f)\ry2\u0006\r\u0005\u0006Y!\u0002\r!L\u0001\u0002MB\u0019\u0011BL\u0010\n\u0005=\u0012!\u0001\u0004#jM\u001a4UO\\2uS>t\u0007bB\u0019)!\u0003\u0005\raH\u0001\u0005S:LG\u000fC\u00034\u0001\u0011\u0005A'A\tnS:LW.\u001b>f/&$\bNQ8v]\u0012$BaH\u001b7o!)AF\ra\u0001[!9\u0011G\rI\u0001\u0002\u0004y\u0002b\u0002\u001d3!\u0003\u0005\raH\u0001\u0006E>,h\u000e\u001a\u0005\bu\u0001\t\n\u0011\"\u0011<\u0003Ii\u0017N\\5nSj,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003qR#aH\u001f,\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u0013Ut7\r[3dW\u0016$'BA\"\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u000b\u0002\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d9\u0005!%A\u0005\u0002m\n1$\\5oS6L'0Z,ji\"\u0014u.\u001e8eI\u0011,g-Y;mi\u0012\u0012\u0004bB%\u0001#\u0003%\taO\u0001\u001c[&t\u0017.\\5{K^KG\u000f\u001b\"pk:$G\u0005Z3gCVdG\u000fJ\u001a")
public class StrongWolfeLineSearch
extends CubicLineSearch {
    private final int maxZoomIter;
    private final int maxLineSearchIter;
    private final double c1;
    private final double c2;

    public double c1() {
        return this.c1;
    }

    public double c2() {
        return this.c2;
    }

    @Override
    public double minimize(DiffFunction<Object> f, double init) {
        return this.minimizeWithBound(f, init, Double.POSITIVE_INFINITY);
    }

    @Override
    public double minimize$default$2() {
        return 1.0;
    }

    public double minimizeWithBound(DiffFunction<Object> f, double init, double bound) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(init <= bound, (Function0 & Serializable & scala.Serializable)() -> "init value should <= bound");
            DoubleRef t = DoubleRef.create((double)init);
            ObjectRef low = ObjectRef.create((Object)this.phi$1(0.0, f));
            double fval = ((CubicLineSearch.Bracket)low.elem).fval();
            double dd = ((CubicLineSearch.Bracket)low.elem).dd();
            if (dd > 0.0) {
                throw new FirstOrderException("Line search invoked with non-descent direction: " + dd);
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxLineSearchIter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                CubicLineSearch.Bracket c = this.phi$1(t$2.elem, f);
                if (Double.isInfinite(c.fval()) || Double.isNaN(c.fval())) {
                    t$2.elem /= 2.0;
                    this.logger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered bad values in function evaluation. Decreasing step size to " + t$2.elem);
                } else {
                    if (c.fval() > fval + this.c1() * t$2.elem * dd || c.fval() >= ((CubicLineSearch.Bracket)low$1.elem).fval() && i > 0) {
                        this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Line search t: " + t$2.elem + " fval: " + c.fval() + " cdd: " + c.dd());
                        throw new NonLocalReturnControl.mcD.sp(object, this.zoom$1((CubicLineSearch.Bracket)low$1.elem, c, f, fval, dd));
                    }
                    if (package$.MODULE$.abs(c.dd()) <= this.c2() * package$.MODULE$.abs(dd)) {
                        throw new NonLocalReturnControl.mcD.sp(object, c.t());
                    }
                    if (c.dd() >= 0.0) {
                        this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Line search t: " + t$2.elem + " fval: " + c.fval() + " rhs: " + (fval + this.c1() * t$2.elem * dd) + " cdd: " + c.dd());
                        throw new NonLocalReturnControl.mcD.sp(object, this.zoom$1(c, (CubicLineSearch.Bracket)low$1.elem, f, fval, dd));
                    }
                    low$1.elem = c;
                    if (t$2.elem == bound) {
                        this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Reach bound, satisfy sufficent decrease condition, but not curvature condition satisfied.");
                        throw new NonLocalReturnControl.mcD.sp(object, bound);
                    }
                    t$2.elem *= 1.5;
                    if (t$2.elem > bound) {
                        t$2.elem = bound;
                    }
                    this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sufficent Decrease condition but not curvature condition satisfied. Increased t to: " + t$2.elem);
                }
            });
            throw new FirstOrderException("Line search failed");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcD$sp();
        }
    }

    public double minimizeWithBound$default$2() {
        return 1.0;
    }

    public double minimizeWithBound$default$3() {
        return 1.0;
    }

    private final CubicLineSearch.Bracket phi$1(double t, DiffFunction f$1) {
        Tuple2<Object, Double> tuple2 = f$1.calculate(BoxesRunTime.boxToDouble((double)t));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double pval = tuple2._1$mcD$sp();
        double pdd = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(pval, pdd);
        Tuple2.mcDD.sp sp3 = sp2;
        double pval2 = sp3._1$mcD$sp();
        double pdd2 = sp3._2$mcD$sp();
        return new CubicLineSearch.Bracket(this, t, pdd2, pval2);
    }

    private final double zoom$1(CubicLineSearch.Bracket linit, CubicLineSearch.Bracket rinit, DiffFunction f$1, double fval$1, double dd$1) {
        Object object = new Object();
        try {
            ObjectRef low = ObjectRef.create((Object)linit);
            ObjectRef hi = ObjectRef.create((Object)rinit);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxZoomIter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                double t = ((CubicLineSearch.Bracket)low$2.elem).t() > ((CubicLineSearch.Bracket)hi$1.elem).t() ? this.interp((CubicLineSearch.Bracket)hi$1.elem, (CubicLineSearch.Bracket)low$2.elem) : this.interp((CubicLineSearch.Bracket)low$2.elem, (CubicLineSearch.Bracket)hi$1.elem);
                CubicLineSearch.Bracket c = this.phi$1(t, f$1);
                this.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Line search t: " + t + " fval: " + c.fval() + " rhs: " + (fval$1 + this.c1() * c.t() * dd$1) + " cdd: " + c.dd());
                if (c.fval() > fval$1 + this.c1() * c.t() * dd$1 || c.fval() >= ((CubicLineSearch.Bracket)low$2.elem).fval()) {
                    hi$1.elem = c;
                    this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "hi=c");
                } else {
                    if (package$.MODULE$.abs(c.dd()) <= this.c2() * package$.MODULE$.abs(dd$1)) {
                        throw new NonLocalReturnControl.mcD.sp(object, c.t());
                    }
                    if (c.dd() * (((CubicLineSearch.Bracket)hi$1.elem).t() - ((CubicLineSearch.Bracket)low$2.elem).t()) >= 0.0) {
                        this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "flipping");
                        hi$1.elem = (CubicLineSearch.Bracket)low$2.elem;
                    }
                    this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "low=c");
                    low$2.elem = c;
                }
            });
            throw new FirstOrderException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Line search zoom failed"})).s((Seq)Nil$.MODULE$));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcD$sp();
        }
    }

    public StrongWolfeLineSearch(int maxZoomIter, int maxLineSearchIter) {
        this.maxZoomIter = maxZoomIter;
        this.maxLineSearchIter = maxLineSearchIter;
        this.c1 = 1.0E-4;
        this.c2 = 0.9;
    }
}

