/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;

public final class YarnAllocator$ {
    public static YarnAllocator$ MODULE$;
    private final String MEM_REGEX;
    private final Pattern PMEM_EXCEEDED_PATTERN;
    private final Pattern VMEM_EXCEEDED_PATTERN;
    private final int VMEM_EXCEEDED_EXIT_CODE;
    private final int PMEM_EXCEEDED_EXIT_CODE;
    private final Set<Object> NOT_APP_AND_SYSTEM_FAULT_EXIT_STATUS;

    static {
        new YarnAllocator$();
    }

    public Clock $lessinit$greater$default$10() {
        return new SystemClock();
    }

    public String MEM_REGEX() {
        return this.MEM_REGEX;
    }

    public Pattern PMEM_EXCEEDED_PATTERN() {
        return this.PMEM_EXCEEDED_PATTERN;
    }

    public Pattern VMEM_EXCEEDED_PATTERN() {
        return this.VMEM_EXCEEDED_PATTERN;
    }

    public int VMEM_EXCEEDED_EXIT_CODE() {
        return this.VMEM_EXCEEDED_EXIT_CODE;
    }

    public int PMEM_EXCEEDED_EXIT_CODE() {
        return this.PMEM_EXCEEDED_EXIT_CODE;
    }

    public String memLimitExceededLogMessage(String diagnostics, Pattern pattern) {
        Matcher matcher = pattern.matcher(diagnostics);
        String diag = matcher.find() ? new StringBuilder(2).append(" ").append(matcher.group()).append(".").toString() : "";
        return new StringBuilder(178).append("Container killed by YARN for exceeding memory limits. ").append(diag).append(" ").append("Consider boosting spark.yarn.executor.memoryOverhead or ").append("disabling yarn.nodemanager.vmem-check-enabled because of YARN-4714.").toString();
    }

    public Set<Object> NOT_APP_AND_SYSTEM_FAULT_EXIT_STATUS() {
        return this.NOT_APP_AND_SYSTEM_FAULT_EXIT_STATUS;
    }

    private YarnAllocator$() {
        MODULE$ = this;
        this.MEM_REGEX = "[0-9.]+ [KMG]B";
        this.PMEM_EXCEEDED_PATTERN = Pattern.compile(new StringBuilder(25).append(this.MEM_REGEX()).append(" of ").append(this.MEM_REGEX()).append(" physical memory used").toString());
        this.VMEM_EXCEEDED_PATTERN = Pattern.compile(new StringBuilder(24).append(this.MEM_REGEX()).append(" of ").append(this.MEM_REGEX()).append(" virtual memory used").toString());
        this.VMEM_EXCEEDED_EXIT_CODE = -103;
        this.PMEM_EXCEEDED_EXIT_CODE = -104;
        this.NOT_APP_AND_SYSTEM_FAULT_EXIT_STATUS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-106, -105, -107, -100, -101}));
    }
}

