/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichLong$;
import spire.algebra.EuclideanRing;
import spire.algebra.Field;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Order;
import spire.algebra.OrderedRingIsSigned;
import spire.algebra.Signed;
import spire.algebra.Signed$;
import spire.algebra.Trig;
import spire.implicits$;
import spire.std.package$bigDecimal$;
import spire.syntax.LiteralIntAdditiveSemigroupOps$;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public final byte abs(byte n) {
        return (byte)Math.abs(n);
    }

    public final short abs(short n) {
        return (short)Math.abs(n);
    }

    public final int abs(int n) {
        return Math.abs(n);
    }

    public final long abs(long n) {
        return Math.abs(n);
    }

    public final float abs(float n) {
        return Math.abs(n);
    }

    public final double abs(double n) {
        return Math.abs(n);
    }

    public final <A> A abs(A a, Signed<A> ev) {
        return ev.abs(a);
    }

    public final float ceil(float n) {
        return (float)Math.ceil(n);
    }

    public final double ceil(double n) {
        return Math.ceil(n);
    }

    public final BigDecimal ceil(BigDecimal n) {
        return n.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING());
    }

    public final <A> A ceil(A a, IsReal<A> ev) {
        return ev.ceil(a);
    }

    public BigInt choose(long n, long k) {
        if (n < 0L || k < 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n=", ", k=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)k)})));
        }
        if (k == 0L || k == n) {
            return scala.package$.MODULE$.BigInt().apply(1);
        }
        if (k > n) {
            return scala.package$.MODULE$.BigInt().apply(0);
        }
        if (n - k > k) {
            return this.choose(n, n - k);
        }
        if ((n - k & 1L) == 1L) {
            return this.loop$1(k + 1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)).$div(this.fact(n - k));
        }
        return this.loop$1(k + 1L, n, scala.package$.MODULE$.BigInt().apply(1)).$div(this.fact(n - k));
    }

    public BigInt fact(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong((long)n)).toString());
        }
        if (n == 0L) {
            return scala.package$.MODULE$.BigInt().apply(1);
        }
        if ((n & 1L) == 1L) {
            return this.loop$2(1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n));
        }
        return this.loop$2(2L, n - 1L, scala.package$.MODULE$.BigInt().apply(n));
    }

    public BigInt fib(long n) {
        int i;
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong((long)n)).toString());
        }
        for (i = 63; (n >>> i & 1L) == 0L && i >= 0; --i) {
        }
        return this.loop$3(scala.package$.MODULE$.BigInt().apply(1), scala.package$.MODULE$.BigInt().apply(0), i, n);
    }

    public final float floor(float n) {
        return (float)Math.floor(n);
    }

    public final double floor(double n) {
        return Math.floor(n);
    }

    public final BigDecimal floor(BigDecimal n) {
        return n.setScale(0, BigDecimal.RoundingMode$.MODULE$.FLOOR());
    }

    public final <A> A floor(A a, IsReal<A> ev) {
        return ev.floor(a);
    }

    public final float round(float a) {
        if (Math.abs(a) >= 1.6777216E7f) {
            return a;
        }
        return Math.round(a);
    }

    public final double round(double a) {
        if (Math.abs(a) >= 4.503599627370496E15) {
            return a;
        }
        return Math.round(a);
    }

    public final BigDecimal round(BigDecimal a) {
        return a.setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
    }

    public final <A> A round(A a, IsReal<A> ev) {
        return ev.round(a);
    }

    public final double exp(double n) {
        return Math.exp(n);
    }

    public final BigDecimal exp(int k, int precision) {
        MathContext mc = new MathContext(precision + 1, RoundingMode.HALF_UP);
        int i = 2;
        BigInt num = scala.package$.MODULE$.BigInt().apply(2);
        BigInt denom = scala.package$.MODULE$.BigInt().apply(1);
        BigInt limit = scala.package$.MODULE$.BigInt().apply(10).pow(precision);
        while (denom.$less((Object)limit)) {
            denom = denom.$times(BigInt$.MODULE$.int2bigInt(i));
            num = num.$times(BigInt$.MODULE$.int2bigInt(i)).$plus(scala.package$.MODULE$.BigInt().apply(1));
            ++i;
        }
        BigDecimal sum = scala.package$.MODULE$.BigDecimal().apply(num, mc).$div(scala.package$.MODULE$.BigDecimal().apply(denom, mc));
        return sum.setScale(precision - sum.precision() + sum.scale(), BigDecimal.RoundingMode$.MODULE$.FLOOR()).pow(k);
    }

    public final BigDecimal exp(BigDecimal k) {
        if (k.signum() == 0) {
            return scala.package$.MODULE$.BigDecimal().apply(1);
        }
        if (k.signum() == -1) {
            return scala.package$.MODULE$.BigDecimal().apply(1).$div(this.exp(k.unary_$minus()));
        }
        BigDecimal whole = k.setScale(0, BigDecimal.RoundingMode$.MODULE$.FLOOR());
        if (whole.signum() > 1) {
            BigDecimal part = this.exp(scala.package$.MODULE$.BigDecimal().apply(1).$plus(k.$minus(whole).$div(whole)));
            return this.power$1(scala.package$.MODULE$.BigDecimal().apply(1), part, whole.toBigInt());
        }
        k.mc().getPrecision();
        BigDecimal r = this.doit$1(k.mc().getPrecision() + 3, 1000, k);
        return new BigDecimal(r.bigDecimal(), k.mc());
    }

    public final <A> A exp(A a, Trig<A> t) {
        return t.exp(a);
    }

    public final double log(double n) {
        return Math.log(n);
    }

    public final double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public final BigDecimal log(BigDecimal n) {
        int scale = n.mc().getPrecision();
        if (n.signum() < 1) {
            throw new IllegalArgumentException("argument <= 0");
        }
        Tuple2 tuple2 = this.rescale$1(n, 0);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n2 = tuple2._2$mcI$sp();
        Object object = tuple2._1();
        BigDecimal x = (BigDecimal)object;
        return this.ln$1(x, scale).$times(scala.package$.MODULE$.BigDecimal().apply(2).pow(n2)).setScale(scale, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
    }

    public BigDecimal log(BigDecimal n, int base) {
        return this.log(n).$div(this.log(scala.package$.MODULE$.BigDecimal().apply(base)));
    }

    public final <A> A log(A a, Trig<A> t) {
        return t.log(a);
    }

    public final <A> A log(A a, int base, Field<A> f, Trig<A> t) {
        return f.div(t.log(a), t.log(f.fromInt(base)));
    }

    public final BigDecimal pow(BigDecimal base, BigDecimal exponent) {
        if (exponent.abs().$less$eq((Object)BigDecimal$.MODULE$.int2bigDecimal(99999999)) && exponent.isWhole()) {
            return base.pow(exponent.toInt());
        }
        return this.exp(this.log(base).$times(exponent));
    }

    public final BigInt pow(BigInt base, BigInt ex) {
        if (ex.signum() < 0) {
            if (base.signum() == 0) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            if (BoxesRunTime.equalsNumObject((Number)base, (Object)BoxesRunTime.boxToInteger((int)1))) {
                return base;
            }
            if (BoxesRunTime.equalsNumObject((Number)base, (Object)BoxesRunTime.boxToInteger((int)-1))) {
                if (ex.testBit(0)) {
                    return scala.package$.MODULE$.BigInt().apply(1);
                }
                return base;
            }
            return scala.package$.MODULE$.BigInt().apply(0);
        }
        if (ex.isValidInt()) {
            return base.pow(ex.toInt());
        }
        return this.bigIntPow$1(scala.package$.MODULE$.BigInt().apply(1), base, ex);
    }

    public final long pow(long base, long exponent) {
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            if (base == 1L) {
                return 1L;
            }
            if (base == -1L) {
                if ((exponent & 1L) == 0L) {
                    return -1L;
                }
                return 1L;
            }
            return 0L;
        }
        return this.longPow$1(1L, base, exponent);
    }

    public final double pow(double base, double exponent) {
        return Math.pow(base, exponent);
    }

    public final long gcd(long _x, long _y) {
        if (_x == 0L) {
            return Math.abs(_y);
        }
        if (_x == 1L) {
            return 1L;
        }
        if (_y == 0L) {
            return Math.abs(_x);
        }
        if (_y == 1L) {
            return 1L;
        }
        int xz = Long.numberOfTrailingZeros(_x);
        long x = Math.abs(_x >> xz);
        int yz = Long.numberOfTrailingZeros(_y);
        long y = Math.abs(_y >> yz);
        while (x != y) {
            if (x > y) {
                x -= y;
                x >>= Long.numberOfTrailingZeros(x);
                continue;
            }
            y -= x;
            y >>= Long.numberOfTrailingZeros(y);
        }
        if (xz < yz) {
            return x << xz;
        }
        return x << yz;
    }

    public final BigInt gcd(BigInt a, BigInt b) {
        return a.gcd(b);
    }

    public final <A> A gcd(A x, A y, EuclideanRing<A> ev) {
        return ev.gcd(x, y);
    }

    public final <A> A gcd(Seq<A> xs, EuclideanRing<A> ev) {
        return (A)xs.foldLeft(ev.zero(), (Function2 & Serializable & scala.Serializable)(x, y) -> this.gcd(y, x, ev));
    }

    public final <A> A gcd(A x, A y, A z, Seq<A> rest, EuclideanRing<A> ev) {
        return this.gcd(this.gcd(this.gcd(x, y, ev), z, ev), this.gcd(rest, ev), ev);
    }

    public final long lcm(long x, long y) {
        return x / this.gcd(x, y) * y;
    }

    public final BigInt lcm(BigInt a, BigInt b) {
        return a.$div(a.gcd(b)).$times(b);
    }

    public final <A> A lcm(A x, A y, EuclideanRing<A> ev) {
        return ev.lcm(x, y);
    }

    public final byte min(byte x, byte y) {
        return (byte)Math.min(x, y);
    }

    public final short min(short x, short y) {
        return (short)Math.min(x, y);
    }

    public final int min(int x, int y) {
        return Math.min(x, y);
    }

    public final long min(long x, long y) {
        return Math.min(x, y);
    }

    public final float min(float x, float y) {
        return Math.min(x, y);
    }

    public final double min(double x, double y) {
        return Math.min(x, y);
    }

    public final <A> A min(A x, A y, Order<A> ev) {
        return ev.min(x, y);
    }

    public final byte max(byte x, byte y) {
        return (byte)Math.max(x, y);
    }

    public final short max(short x, short y) {
        return (short)Math.max(x, y);
    }

    public final int max(int x, int y) {
        return Math.max(x, y);
    }

    public final long max(long x, long y) {
        return Math.max(x, y);
    }

    public final float max(float x, float y) {
        return Math.max(x, y);
    }

    public final double max(double x, double y) {
        return Math.max(x, y);
    }

    public final <A> A max(A x, A y, Order<A> ev) {
        return ev.max(x, y);
    }

    public final double signum(double x) {
        return Math.signum(x);
    }

    public final float signum(float x) {
        return Math.signum(x);
    }

    public final <A> int signum(A a, Signed<A> ev) {
        return ev.signum(a);
    }

    public final double sqrt(double x) {
        return Math.sqrt(x);
    }

    public final <A> A sqrt(A a, NRoot<A> ev) {
        return ev.sqrt(a);
    }

    public final double e() {
        return Math.E;
    }

    public final <A> A e(Trig<A> ev) {
        return ev.e();
    }

    public final double pi() {
        return Math.PI;
    }

    public final <A> A pi(Trig<A> ev) {
        return ev.pi();
    }

    public final <A> A sin(A a, Trig<A> ev) {
        return ev.sin(a);
    }

    public final <A> A cos(A a, Trig<A> ev) {
        return ev.cos(a);
    }

    public final <A> A tan(A a, Trig<A> ev) {
        return ev.tan(a);
    }

    public final <A> A asin(A a, Trig<A> ev) {
        return ev.asin(a);
    }

    public final <A> A acos(A a, Trig<A> ev) {
        return ev.acos(a);
    }

    public final <A> A atan(A a, Trig<A> ev) {
        return ev.atan(a);
    }

    public final <A> A atan2(A y, A x, Trig<A> ev) {
        return ev.atan2(y, x);
    }

    public final <A> A sinh(A x, Trig<A> ev) {
        return ev.sinh(x);
    }

    public final <A> A cosh(A x, Trig<A> ev) {
        return ev.cosh(x);
    }

    public final <A> A tanh(A x, Trig<A> ev) {
        return ev.tanh(x);
    }

    public final double cbrt(double x) {
        return Math.cbrt(x);
    }

    public final double copySign(double m, double s) {
        return Math.copySign(m, s);
    }

    public final float copySign(float m, float s) {
        return Math.copySign(m, s);
    }

    public final double cosh(double x) {
        return Math.cosh(x);
    }

    public final double expm1(double x) {
        return Math.expm1(x);
    }

    public final int getExponent(double x) {
        return Math.getExponent(x);
    }

    public final int getExponent(float x) {
        return Math.getExponent(x);
    }

    public final double IEEEremainder(double x, double d) {
        return Math.IEEEremainder(x, d);
    }

    public final double log10(double x) {
        return Math.log10(x);
    }

    public final double log1p(double x) {
        return Math.log1p(x);
    }

    public final double nextAfter(double x, double y) {
        return Math.nextAfter(x, y);
    }

    public final float nextAfter(float x, float y) {
        return Math.nextAfter(x, (double)y);
    }

    public final double nextUp(double x) {
        return Math.nextUp(x);
    }

    public final float nextUp(float x) {
        return Math.nextUp(x);
    }

    public final double random() {
        return Math.random();
    }

    public final double rint(double x) {
        return Math.rint(x);
    }

    public final double scalb(double d, int s) {
        return Math.scalb(d, s);
    }

    public final float scalb(float d, int s) {
        return Math.scalb(d, s);
    }

    public final double toDegrees(double a) {
        return Math.toDegrees(a);
    }

    public final double toRadians(double a) {
        return Math.toRadians(a);
    }

    public final double ulp(double x) {
        return Math.ulp(x);
    }

    public final double ulp(float x) {
        return Math.ulp(x);
    }

    public final <A> A hypot(A x, A y, Field<A> f, NRoot<A> n, Order<A> o) {
        if (o.gt(x, y)) {
            if (Signed$.MODULE$ == null) {
                throw null;
            }
            return f.times(new OrderedRingIsSigned<A>(o, f).abs(x), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(y, x), 2), f)));
        }
        if (Signed$.MODULE$ == null) {
            throw null;
        }
        return f.times(new OrderedRingIsSigned<A>(o, f).abs(y), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(x, y), 2), f)));
    }

    public boolean anyIsZero(Object n) {
        ScalaNumericConversions scalaNumericConversions;
        boolean bl = BoxesRunTime.equals((Object)n, (Object)BoxesRunTime.boxToInteger((int)0)) ? true : (n instanceof ScalaNumericConversions ? (scalaNumericConversions = (ScalaNumericConversions)n).isValidInt() && scalaNumericConversions.toInt() == 0 : false);
        return bl;
    }

    public double anyToDouble(Object n) {
        double d;
        if (n instanceof Byte) {
            d = BoxesRunTime.unboxToByte((Object)n);
        } else if (n instanceof Short) {
            d = BoxesRunTime.unboxToShort((Object)n);
        } else if (n instanceof Character) {
            d = BoxesRunTime.unboxToChar((Object)n);
        } else if (n instanceof Integer) {
            d = BoxesRunTime.unboxToInt((Object)n);
        } else if (n instanceof Long) {
            d = BoxesRunTime.unboxToLong((Object)n);
        } else if (n instanceof Float) {
            d = BoxesRunTime.unboxToFloat((Object)n);
        } else if (n instanceof Double) {
            d = BoxesRunTime.unboxToDouble((Object)n);
        } else if (n instanceof ScalaNumericConversions) {
            d = ((ScalaNumericConversions)n).toDouble();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return d;
    }

    public long anyToLong(Object n) {
        long l;
        if (n instanceof Byte) {
            l = BoxesRunTime.unboxToByte((Object)n);
        } else if (n instanceof Short) {
            l = BoxesRunTime.unboxToShort((Object)n);
        } else if (n instanceof Character) {
            l = BoxesRunTime.unboxToChar((Object)n);
        } else if (n instanceof Integer) {
            l = BoxesRunTime.unboxToInt((Object)n);
        } else if (n instanceof Long) {
            l = BoxesRunTime.unboxToLong((Object)n);
        } else if (n instanceof Float) {
            l = (long)BoxesRunTime.unboxToFloat((Object)n);
        } else if (n instanceof Double) {
            l = (long)BoxesRunTime.unboxToDouble((Object)n);
        } else if (n instanceof ScalaNumericConversions) {
            l = ((ScalaNumericConversions)n).toLong();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return l;
    }

    public boolean anyIsWhole(Object n) {
        boolean bl;
        if (n instanceof Byte) {
            bl = true;
        } else if (n instanceof Short) {
            bl = true;
        } else if (n instanceof Character) {
            bl = true;
        } else if (n instanceof Integer) {
            bl = true;
        } else if (n instanceof Long) {
            bl = true;
        } else if (n instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)n);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bl = RichFloat$.MODULE$.isWhole$extension(f);
        } else if (n instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)n);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bl = RichDouble$.MODULE$.isWhole$extension(d);
        } else if (n instanceof ScalaNumericConversions) {
            bl = ((ScalaNumericConversions)n).isWhole();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return bl;
    }

    public boolean anyIsValidInt(Object n) {
        boolean bl;
        if (n instanceof Byte) {
            bl = true;
        } else if (n instanceof Short) {
            bl = true;
        } else if (n instanceof Character) {
            bl = true;
        } else if (n instanceof Integer) {
            bl = true;
        } else if (n instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)n);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bl = RichLong$.MODULE$.isValidInt$extension(l);
        } else if (n instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)n);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bl = RichFloat$.MODULE$.isValidInt$extension(f);
        } else if (n instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)n);
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            bl = RichDouble$.MODULE$.isValidInt$extension(d);
        } else if (n instanceof ScalaNumericConversions) {
            bl = ((ScalaNumericConversions)n).isValidInt();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return bl;
    }

    public final double e$mDc$sp(Trig<Object> ev) {
        return ev.e$mcD$sp();
    }

    public final float e$mFc$sp(Trig<Object> ev) {
        return ev.e$mcF$sp();
    }

    public final double pi$mDc$sp(Trig<Object> ev) {
        return ev.pi$mcD$sp();
    }

    public final float pi$mFc$sp(Trig<Object> ev) {
        return ev.pi$mcF$sp();
    }

    public final double sin$mDc$sp(double a, Trig<Object> ev) {
        return ev.sin$mcD$sp(a);
    }

    public final float sin$mFc$sp(float a, Trig<Object> ev) {
        return ev.sin$mcF$sp(a);
    }

    public final double cos$mDc$sp(double a, Trig<Object> ev) {
        return ev.cos$mcD$sp(a);
    }

    public final float cos$mFc$sp(float a, Trig<Object> ev) {
        return ev.cos$mcF$sp(a);
    }

    public final double tan$mDc$sp(double a, Trig<Object> ev) {
        return ev.tan$mcD$sp(a);
    }

    public final float tan$mFc$sp(float a, Trig<Object> ev) {
        return ev.tan$mcF$sp(a);
    }

    public final double asin$mDc$sp(double a, Trig<Object> ev) {
        return ev.asin$mcD$sp(a);
    }

    public final float asin$mFc$sp(float a, Trig<Object> ev) {
        return ev.asin$mcF$sp(a);
    }

    public final double acos$mDc$sp(double a, Trig<Object> ev) {
        return ev.acos$mcD$sp(a);
    }

    public final float acos$mFc$sp(float a, Trig<Object> ev) {
        return ev.acos$mcF$sp(a);
    }

    public final double atan$mDc$sp(double a, Trig<Object> ev) {
        return ev.atan$mcD$sp(a);
    }

    public final float atan$mFc$sp(float a, Trig<Object> ev) {
        return ev.atan$mcF$sp(a);
    }

    public final double atan2$mDc$sp(double y, double x, Trig<Object> ev) {
        return ev.atan2$mcD$sp(y, x);
    }

    public final float atan2$mFc$sp(float y, float x, Trig<Object> ev) {
        return ev.atan2$mcF$sp(y, x);
    }

    public final double sinh$mDc$sp(double x, Trig<Object> ev) {
        return ev.sinh$mcD$sp(x);
    }

    public final float sinh$mFc$sp(float x, Trig<Object> ev) {
        return ev.sinh$mcF$sp(x);
    }

    public final double cosh$mDc$sp(double x, Trig<Object> ev) {
        return ev.cosh$mcD$sp(x);
    }

    public final float cosh$mFc$sp(float x, Trig<Object> ev) {
        return ev.cosh$mcF$sp(x);
    }

    public final double tanh$mDc$sp(double x, Trig<Object> ev) {
        return ev.tanh$mcD$sp(x);
    }

    public final float tanh$mFc$sp(float x, Trig<Object> ev) {
        return ev.tanh$mcF$sp(x);
    }

    public final double hypot$mDc$sp(double x, double y, Field<Object> f, NRoot<Object> n, Order<Object> o) {
        if (o.gt$mcD$sp(x, y)) {
            if (Signed$.MODULE$ == null) {
                throw null;
            }
            return f.times$mcD$sp(new OrderedRingIsSigned<Object>(o, f).abs$mcD$sp(x), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble((double)f.pow$mcD$sp(f.div$mcD$sp(y, x), 2)), f))));
        }
        if (Signed$.MODULE$ == null) {
            throw null;
        }
        return f.times$mcD$sp(new OrderedRingIsSigned<Object>(o, f).abs$mcD$sp(y), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble((double)f.pow$mcD$sp(f.div$mcD$sp(x, y), 2)), f))));
    }

    public final float hypot$mFc$sp(float x, float y, Field<Object> f, NRoot<Object> n, Order<Object> o) {
        if (o.gt$mcF$sp(x, y)) {
            if (Signed$.MODULE$ == null) {
                throw null;
            }
            return f.times$mcF$sp(new OrderedRingIsSigned<Object>(o, f).abs$mcF$sp(x), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat((float)f.pow$mcF$sp(f.div$mcF$sp(y, x), 2)), f))));
        }
        if (Signed$.MODULE$ == null) {
            throw null;
        }
        return f.times$mcF$sp(new OrderedRingIsSigned<Object>(o, f).abs$mcF$sp(y), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat((float)f.pow$mcF$sp(f.div$mcF$sp(x, y), 2)), f))));
    }

    private final BigInt loop$1(long lo, long hi, BigInt prod) {
        while (lo <= hi) {
            prod = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod);
            --hi;
            ++lo;
        }
        return prod;
    }

    private final BigInt loop$2(long lo, long hi, BigInt prod) {
        while (lo <= hi) {
            prod = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod);
            --hi;
            ++lo;
        }
        return prod;
    }

    private final BigInt loop$3(BigInt a, BigInt b, int i, long n$1) {
        while (true) {
            BigInt c = a.$plus(b);
            if (i < 0) {
                return b;
            }
            if ((n$1 >>> i & 1L) == 1L) {
                BigInt bigInt = a.$plus(c).$times(b);
                --i;
                b = b.$times(b).$plus(c.$times(c));
                a = bigInt;
                continue;
            }
            BigInt bigInt = a.$times(a).$plus(b.$times(b));
            --i;
            b = a.$plus(c).$times(b);
            a = bigInt;
        }
    }

    private final BigDecimal power$1(BigDecimal result, BigDecimal base, BigInt exponent) {
        while (exponent.signum() != 0) {
            if (exponent.testBit(0)) {
                BigDecimal bigDecimal = result.$times(base);
                exponent = exponent.$greater$greater(1);
                base = base.$times(base);
                result = bigDecimal;
                continue;
            }
            exponent = exponent.$greater$greater(1);
            base = base.$times(base);
        }
        return result;
    }

    private final BigDecimal doit$1(int precision, int leeway, BigDecimal k$1) {
        while (true) {
            MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
            int i = 2;
            BigDecimal sum = scala.package$.MODULE$.BigDecimal().apply(1, mc).$plus(k$1);
            BigDecimal factorial = scala.package$.MODULE$.BigDecimal().apply(2, mc);
            BigDecimal kpow = k$1.$times(k$1);
            BigDecimal term = kpow.$div(factorial).setScale(precision, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
            while (term.signum() != 0 && i < leeway) {
                sum = sum.$plus(term);
                factorial = factorial.$times(BigDecimal$.MODULE$.int2bigDecimal(++i));
                kpow = kpow.$times(k$1);
                term = kpow.$div(factorial).setScale(precision, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
            }
            if (i <= leeway) {
                return sum.setScale(k$1.mc().getPrecision() - sum.precision() + sum.scale(), BigDecimal.RoundingMode$.MODULE$.FLOOR());
            }
            leeway *= 1000;
            precision += 3;
        }
    }

    private final BigDecimal loop$4(BigDecimal x, BigDecimal n$2, BigDecimal limit$1) {
        BigDecimal xp;
        BigDecimal term;
        while ((term = (xp = this.exp(x)).$minus(n$2).$div(xp)).$greater((Object)limit$1)) {
            x = x.$minus(term);
        }
        return x.$minus(term);
    }

    private final BigDecimal ln$1(BigDecimal n, int scale$1) {
        int scale2 = scale$1 + 1;
        BigDecimal limit = scala.package$.MODULE$.BigDecimal().apply(5).$times(scala.package$.MODULE$.BigDecimal().apply(10).pow(-scale2));
        return this.loop$4(n.setScale(scale2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()), n, limit).setScale(scale$1, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
    }

    private final Tuple2 rescale$1(BigDecimal x, int n) {
        while (!x.$less((Object)BigDecimal$.MODULE$.int2bigDecimal(64))) {
            ++n;
            x = package$bigDecimal$.MODULE$.BigDecimalAlgebra().sqrt(x);
        }
        return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)n));
    }

    private final BigInt bigIntPow$1(BigInt t, BigInt b, BigInt e) {
        while (e.signum() != 0) {
            if (e.testBit(0)) {
                BigInt bigInt = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = bigInt;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final long longPow$1(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>= (int)1L;
            b *= b;
        }
        return t;
    }

    private package$() {
        MODULE$ = this;
    }
}

