/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler.rate;

import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.scheduler.rate.PIDRateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import scala.Serializable;

public final class RateEstimator$
implements Serializable {
    public static RateEstimator$ MODULE$;

    static {
        new RateEstimator$();
    }

    public RateEstimator create(SparkConf conf, Duration batchInterval) {
        String string = conf.get("spark.streaming.backpressure.rateEstimator", "pid");
        if (!"pid".equals(string)) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Unknown rate estimator: ").append(string).toString());
        }
        double proportional = conf.getDouble("spark.streaming.backpressure.pid.proportional", 1.0);
        double integral = conf.getDouble("spark.streaming.backpressure.pid.integral", 0.2);
        double derived = conf.getDouble("spark.streaming.backpressure.pid.derived", 0.0);
        double minRate = conf.getDouble("spark.streaming.backpressure.pid.minRate", 100.0);
        PIDRateEstimator pIDRateEstimator = new PIDRateEstimator(batchInterval.milliseconds(), proportional, integral, derived, minRate);
        return pIDRateEstimator;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RateEstimator$() {
        MODULE$ = this;
    }
}

