/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointWriter;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.api.python.PythonDStream$;
import org.apache.spark.streaming.scheduler.ClearCheckpointData;
import org.apache.spark.streaming.scheduler.ClearMetadata;
import org.apache.spark.streaming.scheduler.DoCheckpoint;
import org.apache.spark.streaming.scheduler.GenerateJobs;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobGeneratorEvent;
import org.apache.spark.streaming.scheduler.JobScheduler;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobSet$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u0011#\u0001\u0011b\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b}\u0002A\u0011\u0001!\t\u000f\r\u0003!\u0019!C\u0005\t\"1\u0011\n\u0001Q\u0001\n\u0015CqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u00191\u0006\u0001)A\u0005'\"9q\u000b\u0001b\u0001\n\u0003A\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011B1\t\r\u001d\u0004\u0001\u0015!\u0003c\u0011!A\u0007\u0001#b\u0001\n\u0013I\u0007\u0002C7\u0001\u0011\u000b\u0007I\u0011\u00028\t\u000fI\u0004\u0001\u0019!C\u0005g\"9!\u0010\u0001a\u0001\n\u0013Y\bbBA\u0002\u0001\u0001\u0006K\u0001\u001e\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0005\u0003\u000fA\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u0011\u0005U\u0001\u0001)Q\u0005\u0003\u0013Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003{\u0001A\u0011BA\r\u0011\u001d\ty\u0004\u0001C\u0005\u00033Aq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002H\u0001!I!!\u0013\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA.\u0001\u0011%\u0011Q\f\u0002\r\u0015>\u0014w)\u001a8fe\u0006$xN\u001d\u0006\u0003G\u0011\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u00152\u0013!C:ue\u0016\fW.\u001b8h\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7c\u0001\u0001.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0014\u0002\u0011%tG/\u001a:oC2L!\u0001O\u001b\u0003\u000f1{wmZ5oO\u0006a!n\u001c2TG\",G-\u001e7fe\u000e\u0001\u0001C\u0001\u001f>\u001b\u0005\u0011\u0013B\u0001 #\u00051QuNY*dQ\u0016$W\u000f\\3s\u0003\u0019a\u0014N\\5u}Q\u0011\u0011I\u0011\t\u0003y\u0001AQ!\u000f\u0002A\u0002m\n1a]:d+\u0005)\u0005C\u0001$H\u001b\u0005!\u0013B\u0001%%\u0005A\u0019FO]3b[&twmQ8oi\u0016DH/\u0001\u0003tg\u000e\u0004\u0013\u0001B2p]\u001a,\u0012\u0001\u0014\t\u0003\u001b:k\u0011AJ\u0005\u0003\u001f\u001a\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0016\u0003M\u0003\"A\u0012+\n\u0005U##\u0001\u0004#TiJ,\u0017-\\$sCBD\u0017AB4sCBD\u0007%A\u0003dY>\u001c7.F\u0001Z!\tQV,D\u0001\\\u0015\taf%\u0001\u0003vi&d\u0017B\u00010\\\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005)A/[7feV\t!\r\u0005\u0002dK6\tAM\u0003\u0002]I%\u0011a\r\u001a\u0002\u000f%\u0016\u001cWO\u001d:j]\u001e$\u0016.\\3s\u0003\u0019!\u0018.\\3sA\u0005\u00012\u000f[8vY\u0012\u001c\u0005.Z2la>Lg\u000e^\u000b\u0002UB\u0011af[\u0005\u0003Y>\u0012qAQ8pY\u0016\fg.\u0001\tdQ\u0016\u001c7\u000e]8j]R<&/\u001b;feV\tq\u000e\u0005\u0002Ga&\u0011\u0011\u000f\n\u0002\u0011\u0007\",7m\u001b9pS:$xK]5uKJ\f\u0011\"\u001a<f]Rdun\u001c9\u0016\u0003Q\u00042AW;x\u0013\t18LA\u0005Fm\u0016tG\u000fT8paB\u0011A\b_\u0005\u0003s\n\u0012\u0011CS8c\u000f\u0016tWM]1u_J,e/\u001a8u\u00035)g/\u001a8u\u0019>|\u0007o\u0018\u0013fcR\u0011Ap \t\u0003]uL!A`\u0018\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003\u0001\u0012\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u0015\u00154XM\u001c;M_>\u0004\b%\u0001\nmCN$\bK]8dKN\u001cX\r\u001a\"bi\u000eDWCAA\u0005!\r1\u00151B\u0005\u0004\u0003\u001b!#\u0001\u0002+j[\u0016\fa\u0003\\1tiB\u0013xnY3tg\u0016$')\u0019;dQ~#S-\u001d\u000b\u0004y\u0006M\u0001\"CA\u0001'\u0005\u0005\t\u0019AA\u0005\u0003Ma\u0017m\u001d;Qe>\u001cWm]:fI\n\u000bGo\u00195!\u0003\u0015\u0019H/\u0019:u)\u0005a\u0018\u0001B:u_B$2\u0001`A\u0010\u0011\u0019\t\tC\u0006a\u0001U\u0006\u0019\u0002O]8dKN\u001c(+Z2fSZ,G\rR1uC\u0006\trN\u001c\"bi\u000eD7i\\7qY\u0016$\u0018n\u001c8\u0015\u0007q\f9\u0003C\u0004\u0002*]\u0001\r!!\u0003\u0002\tQLW.Z\u0001\u0017_:\u001c\u0005.Z2la>Lg\u000e^\"p[BdW\r^5p]R)A0a\f\u00022!9\u0011\u0011\u0006\rA\u0002\u0005%\u0001BBA\u001a1\u0001\u0007!.\u0001\rdY\u0016\f'o\u00115fG.\u0004x.\u001b8u\t\u0006$\u0018\rT1uKJ\fA\u0002\u001d:pG\u0016\u001c8/\u0012<f]R$2\u0001`A\u001d\u0011\u0019\tY$\u0007a\u0001o\u0006)QM^3oi\u0006q1\u000f^1si\u001aK'o\u001d;US6,\u0017a\u0002:fgR\f'\u000f^\u0001\rO\u0016tWM]1uK*{'m\u001d\u000b\u0004y\u0006\u0015\u0003bBA\u00159\u0001\u0007\u0011\u0011B\u0001\u000eG2,\u0017M]'fi\u0006$\u0017\r^1\u0015\u0007q\fY\u0005C\u0004\u0002*u\u0001\r!!\u0003\u0002'\rdW-\u0019:DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0015\u0007q\f\t\u0006C\u0004\u0002*y\u0001\r!!\u0003\u0002\u0019\u0011|7\t[3dWB|\u0017N\u001c;\u0015\u000bq\f9&!\u0017\t\u000f\u0005%r\u00041\u0001\u0002\n!1\u00111G\u0010A\u0002)\fq#\\1sW\n\u000bGo\u00195Gk2d\u0017\u0010\u0015:pG\u0016\u001c8/\u001a3\u0015\u0007q\fy\u0006C\u0004\u0002*\u0001\u0002\r!!\u0003")
public class JobGenerator
implements Logging {
    private boolean shouldCheckpoint;
    private CheckpointWriter checkpointWriter;
    public final JobScheduler org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler;
    private final StreamingContext ssc;
    private final SparkConf conf;
    private final DStreamGraph graph;
    private final Clock clock;
    private final RecurringTimer timer;
    private EventLoop<JobGeneratorEvent> eventLoop;
    private Time lastProcessedBatch;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StreamingContext ssc() {
        return this.ssc;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private DStreamGraph graph() {
        return this.graph;
    }

    public Clock clock() {
        return this.clock;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    private boolean shouldCheckpoint$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.shouldCheckpoint = this.ssc().checkpointDuration() != null && this.ssc().checkpointDir() != null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.shouldCheckpoint;
    }

    private boolean shouldCheckpoint() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldCheckpoint$lzycompute() : this.shouldCheckpoint;
    }

    private CheckpointWriter checkpointWriter$lzycompute() {
        JobGenerator jobGenerator = this;
        synchronized (jobGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.checkpointWriter = this.shouldCheckpoint() ? new CheckpointWriter(this, this.ssc().conf(), this.ssc().checkpointDir(), this.ssc().sparkContext().hadoopConfiguration()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.checkpointWriter;
    }

    private CheckpointWriter checkpointWriter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.checkpointWriter$lzycompute() : this.checkpointWriter;
    }

    private EventLoop<JobGeneratorEvent> eventLoop() {
        return this.eventLoop;
    }

    private void eventLoop_$eq(EventLoop<JobGeneratorEvent> x$1) {
        this.eventLoop = x$1;
    }

    private Time lastProcessedBatch() {
        return this.lastProcessedBatch;
    }

    private void lastProcessedBatch_$eq(Time x$1) {
        this.lastProcessedBatch = x$1;
    }

    public synchronized void start() {
        if (this.eventLoop() != null) {
            return;
        }
        this.checkpointWriter();
        this.eventLoop_$eq(new EventLoop<JobGeneratorEvent>(this){
            private final /* synthetic */ JobGenerator $outer;

            public void onReceive(JobGeneratorEvent event) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(event);
            }

            public void onError(Throwable e) {
                this.$outer.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError("Error in job generator", e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("JobGenerator");
            }
        });
        this.eventLoop().start();
        if (this.ssc().isCheckpointPresent()) {
            this.restart();
        } else {
            this.startFirstTime();
        }
    }

    public synchronized void stop(boolean processReceivedData) {
        if (this.eventLoop() == null) {
            return;
        }
        if (processReceivedData) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping JobGenerator gracefully");
            long timeWhenStopStarted = System.currentTimeMillis();
            long stopTimeoutMs = this.conf().getTimeAsMs("spark.streaming.gracefulStopTimeout", new StringBuilder(2).append(10L * this.ssc().graph().batchDuration().milliseconds()).append("ms").toString());
            int pollTime = 100;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for all received blocks to be consumed for job generation");
            while (!this.hasTimedOut$1(timeWhenStopStarted, stopTimeoutMs) && this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().hasUnallocatedBlocks()) {
                Thread.sleep(pollTime);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waited for all received blocks to be consumed for job generation");
            long stopTime = this.timer().stop(false);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped generation timer");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for jobs to be processed and checkpoints to be written");
            while (!this.hasTimedOut$1(timeWhenStopStarted, stopTimeoutMs) && !this.haveAllBatchesBeenProcessed$1(stopTime)) {
                Thread.sleep(pollTime);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waited for jobs to be processed and checkpoints to be written");
            this.graph().stop();
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping JobGenerator immediately");
            this.timer().stop(true);
            this.graph().stop();
        }
        this.eventLoop().stop();
        if (this.shouldCheckpoint()) {
            this.checkpointWriter().stop();
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped JobGenerator");
    }

    public void onBatchCompletion(Time time) {
        this.eventLoop().post((Object)new ClearMetadata(time));
    }

    public void onCheckpointCompletion(Time time, boolean clearCheckpointDataLater) {
        block0: {
            if (!clearCheckpointDataLater) break block0;
            this.eventLoop().post((Object)new ClearCheckpointData(time));
        }
    }

    public void org$apache$spark$streaming$scheduler$JobGenerator$$processEvent(JobGeneratorEvent event) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Got event ").append(event).toString());
        JobGeneratorEvent jobGeneratorEvent = event;
        if (jobGeneratorEvent instanceof GenerateJobs) {
            GenerateJobs generateJobs = (GenerateJobs)jobGeneratorEvent;
            Time time = generateJobs.time();
            this.generateJobs(time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobGeneratorEvent instanceof ClearMetadata) {
            ClearMetadata clearMetadata = (ClearMetadata)jobGeneratorEvent;
            Time time = clearMetadata.time();
            this.clearMetadata(time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobGeneratorEvent instanceof DoCheckpoint) {
            DoCheckpoint doCheckpoint = (DoCheckpoint)jobGeneratorEvent;
            Time time = doCheckpoint.time();
            boolean clearCheckpointDataLater = doCheckpoint.clearCheckpointDataLater();
            this.doCheckpoint(time, clearCheckpointDataLater);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jobGeneratorEvent instanceof ClearCheckpointData) {
            ClearCheckpointData clearCheckpointData = (ClearCheckpointData)jobGeneratorEvent;
            Time time = clearCheckpointData.time();
            this.clearCheckpointData(time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jobGeneratorEvent);
        }
    }

    private void startFirstTime() {
        Time startTime = new Time(this.timer().getStartTime());
        this.graph().start(startTime.$minus(this.graph().batchDuration()));
        this.timer().start(startTime.milliseconds());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Started JobGenerator at ").append(startTime).toString());
    }

    private void restart() {
        if (this.clock() instanceof ManualClock) {
            long lastTime = this.ssc().initialCheckpoint().checkpointTime().milliseconds();
            long jumpTime = this.ssc().sc().conf().getLong("spark.streaming.manualClock.jump", 0L);
            ((ManualClock)this.clock()).setTime(lastTime + jumpTime);
        }
        Duration batchDuration = this.ssc().graph().batchDuration();
        Time checkpointTime = this.ssc().initialCheckpoint().checkpointTime();
        Time restartTime = new Time(this.timer().getRestartTime(this.graph().zeroTime().milliseconds()));
        Seq<Time> downTimes = checkpointTime.until(restartTime, batchDuration);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Batches during down time (").append(downTimes.size()).append(" batches): ").append(downTimes.mkString(", ")).toString());
        Time[] pendingTimes = (Time[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ssc().initialCheckpoint().pendingTimes())).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Batches pending processing (").append(pendingTimes.length).append(" batches): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pendingTimes)).mkString(", ")).toString());
        Time[] timesToReschedule = (Time[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pendingTimes)).$plus$plus(downTimes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Time.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.$less(restartTime))))).distinct())).sorted(Time$.MODULE$.ordering());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Batches to reschedule (").append(timesToReschedule.length).append(" batches): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timesToReschedule)).mkString(", ")).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timesToReschedule)).foreach((Function1 & Serializable & scala.Serializable)time -> {
            JobGenerator.$anonfun$restart$5(this, time);
            return BoxedUnit.UNIT;
        });
        this.timer().start(restartTime.milliseconds());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Restarted JobGenerator at ").append(restartTime).toString());
    }

    private void generateJobs(Time time) {
        this.ssc().sparkContext().setLocalProperty(RDD$.MODULE$.CHECKPOINT_ALL_MARKED_ANCESTORS(), "true");
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().allocateBlocksToBatch(time);
            return this.graph().generateJobs(time);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq jobs = (Seq)success.value();
            Map<Object, StreamInputInfo> streamIdToInputInfos = this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().getInfo(time);
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, (Seq<Job>)jobs, streamIdToInputInfos));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.reportError(new StringBuilder(31).append("Error generating jobs for time ").append(time).toString(), e);
            PythonDStream$.MODULE$.stopStreamingContextIfPythonProcessIsDead(e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        this.eventLoop().post((Object)new DoCheckpoint(time, false));
    }

    private void clearMetadata(Time time) {
        this.ssc().graph().clearMetadata(time);
        if (this.shouldCheckpoint()) {
            this.eventLoop().post((Object)new DoCheckpoint(time, true));
        } else {
            Duration maxRememberDuration = this.graph().getMaxInputStreamRememberDuration();
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldBlocksAndBatches(time.$minus(maxRememberDuration));
            this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().cleanup(time.$minus(maxRememberDuration));
            this.markBatchFullyProcessed(time);
        }
    }

    private void clearCheckpointData(Time time) {
        this.ssc().graph().clearCheckpointData(time);
        Duration maxRememberDuration = this.graph().getMaxInputStreamRememberDuration();
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().cleanupOldBlocksAndBatches(time.$minus(maxRememberDuration));
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.inputInfoTracker().cleanup(time.$minus(maxRememberDuration));
        this.markBatchFullyProcessed(time);
    }

    private void doCheckpoint(Time time, boolean clearCheckpointDataLater) {
        block1: {
            block0: {
                if (!this.shouldCheckpoint() || !time.$minus(this.graph().zeroTime()).isMultipleOf(this.ssc().checkpointDuration())) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Checkpointing graph for time ").append(time).toString());
                this.ssc().graph().updateCheckpointData(time);
                this.checkpointWriter().write(new Checkpoint(this.ssc(), time), clearCheckpointDataLater);
                break block1;
            }
            if (!clearCheckpointDataLater) break block1;
            this.markBatchFullyProcessed(time);
        }
    }

    private void markBatchFullyProcessed(Time time) {
        this.lastProcessedBatch_$eq(time);
    }

    private static final Clock liftedTree1$1(String clockClass$1) {
        Clock clock;
        try {
            clock = (Clock)Utils$.MODULE$.classForName(clockClass$1).newInstance();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof ClassNotFoundException) || !clockClass$1.startsWith("org.apache.spark.streaming")) {
                throw throwable;
            }
            String newClockClass = clockClass$1.replace("org.apache.spark.streaming", "org.apache.spark");
            Clock clock2 = (Clock)Utils$.MODULE$.classForName(newClockClass).newInstance();
            clock = clock2;
        }
        return clock;
    }

    private final boolean hasTimedOut$1(long timeWhenStopStarted$1, long stopTimeoutMs$1) {
        boolean timedOut;
        block0: {
            boolean bl = timedOut = System.currentTimeMillis() - timeWhenStopStarted$1 > stopTimeoutMs$1;
            if (!timedOut) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Timed out while stopping the job generator (timeout = ").append(stopTimeoutMs$1).append(")").toString());
        }
        return timedOut;
    }

    private final boolean haveAllBatchesBeenProcessed$1(long stopTime$1) {
        return this.lastProcessedBatch() != null && this.lastProcessedBatch().milliseconds() == stopTime$1;
    }

    public static final /* synthetic */ void $anonfun$restart$5(JobGenerator $this, Time time) {
        $this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.receiverTracker().allocateBlocksToBatch(time);
        $this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler.submitJobSet(new JobSet(time, $this.graph().generateJobs(time), JobSet$.MODULE$.apply$default$3()));
    }

    public JobGenerator(JobScheduler jobScheduler) {
        this.org$apache$spark$streaming$scheduler$JobGenerator$$jobScheduler = jobScheduler;
        Logging.$init$((Logging)this);
        this.ssc = jobScheduler.ssc();
        this.conf = this.ssc().conf();
        this.graph = this.ssc().graph();
        String clockClass = this.ssc().sc().conf().get("spark.streaming.clock", "org.apache.spark.util.SystemClock");
        this.clock = JobGenerator.liftedTree1$1(clockClass);
        this.timer = new RecurringTimer(this.clock(), this.ssc().graph().batchDuration().milliseconds(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)longTime -> this.eventLoop().post((Object)new GenerateJobs(new Time(longTime))), "JobGenerator");
        this.eventLoop = null;
        this.lastProcessedBatch = null;
    }
}

