/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasId;
import org.spark_project.dmg.pmml.Indexable;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="Item", namespace="http://www.dmg.org/PMML-4_2")
public class Item
extends PMMLObject
implements HasExtensions,
HasId,
Indexable<String> {
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlAttribute(name="value", required=true)
    private String value;
    @XmlAttribute(name="mappedValue")
    private String mappedValue;
    @XmlAttribute(name="weight")
    private Double weight;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;

    public Item() {
    }

    public Item(String id, String value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Item setId(String id) {
        this.id = id;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Item setValue(String value) {
        this.value = value;
        return this;
    }

    public String getMappedValue() {
        return this.mappedValue;
    }

    public Item setMappedValue(String mappedValue) {
        this.mappedValue = mappedValue;
        return this;
    }

    public Double getWeight() {
        return this.weight;
    }

    public Item setWeight(Double weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Item addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

