/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Annotation;
import org.spark_project.dmg.pmml.Application;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Timestamp;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.jpmml.schema.Optional;
import org.spark_project.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "application", "annotations", "timestamp"})
@XmlRootElement(name="Header", namespace="http://www.dmg.org/PMML-4_2")
public class Header
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="copyright")
    @Optional(value=Version.PMML_4_1)
    private String copyright;
    @XmlAttribute(name="description")
    private String description;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Application", namespace="http://www.dmg.org/PMML-4_2")
    private Application application;
    @XmlElement(name="Annotation", namespace="http://www.dmg.org/PMML-4_2")
    private List<Annotation> annotations;
    @XmlElement(name="Timestamp", namespace="http://www.dmg.org/PMML-4_2")
    private Timestamp timestamp;

    public String getCopyright() {
        return this.copyright;
    }

    public Header setCopyright(String copyright) {
        this.copyright = copyright;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Header setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Application getApplication() {
        return this.application;
    }

    public Header setApplication(Application application) {
        this.application = application;
        return this;
    }

    public List<Annotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<Annotation>();
        }
        return this.annotations;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Header setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Header addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasAnnotations() {
        return this.annotations != null && this.annotations.size() > 0;
    }

    public Header addAnnotations(Annotation ... annotations) {
        this.getAnnotations().addAll(Arrays.asList(annotations));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getApplication());
            }
            if (status == VisitorAction.CONTINUE && this.hasAnnotations()) {
                status = PMMLObject.traverse(visitor, this.getAnnotations());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getTimestamp());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

