/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.EnsembleCombiningStrategy$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$SaveLoadV1_0$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.json4s.JsonAST;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ClassTag$;

public final class GradientBoostedTreesModel$
implements Loader<GradientBoostedTreesModel>,
scala.Serializable {
    public static GradientBoostedTreesModel$ MODULE$;

    static {
        new GradientBoostedTreesModel$();
    }

    @DeveloperApi
    public RDD<Tuple2<Object, Object>> computeInitialPredictionAndError(RDD<LabeledPoint> data, double initTreeWeight, DecisionTreeModel initTree, Loss loss) {
        return data.map((Function1 & Serializable & scala.Serializable)lp -> {
            double pred = initTreeWeight * initTree.predict(lp.features());
            double error = loss.computeError(pred, lp.label());
            return new Tuple2.mcDD.sp(pred, error);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @DeveloperApi
    public RDD<Tuple2<Object, Object>> updatePredictionError(RDD<LabeledPoint> data, RDD<Tuple2<Object, Object>> predictionAndError, double treeWeight, DecisionTreeModel tree, Loss loss) {
        RDD qual$1 = data.zip(predictionAndError, ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            LabeledPoint lp;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    lp = (LabeledPoint)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double pred = tuple2._1$mcD$sp();
            double newPred = pred + tree.predict(lp.features()) * treeWeight;
            double newError = loss.computeError(newPred, lp.label());
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(newPred, newError);
            return sp2;
        });
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD newPredError = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        return newPredError;
    }

    public String formatVersion() {
        return TreeEnsembleModel$SaveLoadV1_0$.MODULE$.thisFormatVersion();
    }

    @Override
    public GradientBoostedTreesModel load(SparkContext sc, String path) {
        JsonAST.JValue jsonMetadata;
        block5: {
            String classNameV1_0;
            String version;
            String loadedClassName;
            block4: {
                Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                String loadedClassName2 = (String)tuple3._1();
                String version2 = (String)tuple3._2();
                JsonAST.JValue jsonMetadata2 = (JsonAST.JValue)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)loadedClassName2, (Object)version2, (Object)jsonMetadata2);
                Tuple3 tuple33 = tuple32;
                loadedClassName = (String)tuple33._1();
                version = (String)tuple33._2();
                jsonMetadata = (JsonAST.JValue)tuple33._3();
                classNameV1_0 = GradientBoostedTreesModel$SaveLoadV1_0$.MODULE$.thisClassName();
                Tuple2 tuple2 = new Tuple2((Object)loadedClassName, (Object)version);
                if (tuple2 == null) break block4;
                String className = (String)tuple2._1();
                String string = (String)tuple2._2();
                if (!"1.0".equals(string)) break block4;
                String string2 = className;
                String string3 = classNameV1_0;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) break block5;
            }
            throw new Exception(new StringBuilder(116).append("GradientBoostedTreesModel.load did not recognize model").append(" with (className, format version): (").append(loadedClassName).append(", ").append(version).append(").  Supported:\n").append("  (").append(classNameV1_0).append(", 1.0)").toString());
        }
        TreeEnsembleModel.SaveLoadV1_0.Metadata metadata = TreeEnsembleModel$SaveLoadV1_0$.MODULE$.readMetadata(jsonMetadata);
        String string = metadata.combiningStrategy();
        String string4 = EnsembleCombiningStrategy$.MODULE$.Sum().toString();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string4) : string4 != null));
        DecisionTreeModel[] trees = TreeEnsembleModel$SaveLoadV1_0$.MODULE$.loadTrees(sc, path, metadata.treeAlgo());
        GradientBoostedTreesModel gradientBoostedTreesModel = new GradientBoostedTreesModel(Algo$.MODULE$.fromString(metadata.algo()), trees, metadata.treeWeights());
        return gradientBoostedTreesModel;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GradientBoostedTreesModel$() {
        MODULE$ = this;
    }
}

