/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impurity;

import org.apache.spark.mllib.tree.impurity.ImpurityCalculator$;
import scala.Double$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4a!\u0005\n\u0002\u0002aq\u0002\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\t\u0011E\u0002!\u0011!Q\u0001\n-BQA\r\u0001\u0005\u0002MBQa\u000e\u0001\u0007\u0002aBQ!\u000f\u0001\u0007\u0002iBQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005\u0002\u0001CQA\u0011\u0001\u0007\u0002\rCQa\u0012\u0001\u0007\u0002!CQ!\u0013\u0001\u0005\u0002)CQ!\u0014\u0001\u0005\u00129;a\u0001\u0016\n\t\u0002a)fAB\t\u0013\u0011\u0003Ab\u000bC\u00033\u001b\u0011\u0005q\u000bC\u0003Y\u001b\u0011\u0005\u0011\fC\u0004h\u001b\u0005\u0005I\u0011\u00025\u0003%%k\u0007/\u001e:jif\u001c\u0015\r\\2vY\u0006$xN\u001d\u0006\u0003'Q\t\u0001\"[7qkJLG/\u001f\u0006\u0003+Y\tA\u0001\u001e:fK*\u0011q\u0003G\u0001\u0006[2d\u0017N\u0019\u0006\u00033i\tQa\u001d9be.T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sON\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t\u0001c%\u0003\u0002(C\ta1+\u001a:jC2L'0\u00192mK\u0006)1\u000f^1ug\u000e\u0001Q#A\u0016\u0011\u0007\u0001bc&\u0003\u0002.C\t)\u0011I\u001d:bsB\u0011\u0001eL\u0005\u0003a\u0005\u0012a\u0001R8vE2,\u0017AB:uCR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003IAQ\u0001K\u0002A\u0002-\nAaY8qsV\tA'A\u0005dC2\u001cW\u000f\\1uKR\ta&A\u0002bI\u0012$\"\u0001N\u001f\t\u000by2\u0001\u0019\u0001\u001b\u0002\u000b=$\b.\u001a:\u0002\u0011M,(\r\u001e:bGR$\"\u0001N!\t\u000by:\u0001\u0019\u0001\u001b\u0002\u000b\r|WO\u001c;\u0016\u0003\u0011\u0003\"\u0001I#\n\u0005\u0019\u000b#\u0001\u0002'p]\u001e\fq\u0001\u001d:fI&\u001cG/F\u0001/\u0003\u0011\u0001(o\u001c2\u0015\u00059Z\u0005\"\u0002'\u000b\u0001\u0004q\u0013!\u00027bE\u0016d\u0017AG5oI\u0016DxJ\u001a'be\u001e,7\u000f^!se\u0006LX\t\\3nK:$HCA(S!\t\u0001\u0003+\u0003\u0002RC\t\u0019\u0011J\u001c;\t\u000bM[\u0001\u0019A\u0016\u0002\u000b\u0005\u0014(/Y=\u0002%%k\u0007/\u001e:jif\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003k5\u00192!D\u0010&)\u0005)\u0016!D4fi\u000e\u000bGnY;mCR|'\u000fF\u000255\u001aDQaE\bA\u0002m\u0003\"\u0001X2\u000f\u0005u\u000b\u0007C\u00010\"\u001b\u0005y&B\u00011*\u0003\u0019a$o\\8u}%\u0011!-I\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002cC!)\u0001f\u0004a\u0001W\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0011a\u0017M\\4\u000b\u00039\fAA[1wC&\u0011\u0001o\u001b\u0002\u0007\u001f\nTWm\u0019;")
public abstract class ImpurityCalculator
implements Serializable {
    private final double[] stats;

    public static ImpurityCalculator getCalculator(String string, double[] dArray) {
        return ImpurityCalculator$.MODULE$.getCalculator(string, dArray);
    }

    public double[] stats() {
        return this.stats;
    }

    public abstract ImpurityCalculator copy();

    public abstract double calculate();

    public ImpurityCalculator add(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(95).append("Two ImpurityCalculator instances cannot be added with different counts sizes.").append("  Sizes are ").append(this.stats().length).append(" and ").append(other.stats().length).append(".").toString());
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] + other.stats()[i];
        }
        return this;
    }

    public ImpurityCalculator subtract(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(100).append("Two ImpurityCalculator instances cannot be subtracted with different counts sizes.").append("  Sizes are ").append(this.stats().length).append(" and ").append(other.stats().length).append(".").toString());
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] - other.stats()[i];
        }
        return this;
    }

    public abstract long count();

    public abstract double predict();

    public double prob(double label) {
        return -1.0;
    }

    public int indexOfLargestArrayElement(double[] array) {
        Tuple3 result = (Tuple3)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(array)).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> ImpurityCalculator.$anonfun$indexOfLargestArrayElement$1(x0$1, BoxesRunTime.unboxToDouble((Object)x1$1)));
        if (BoxesRunTime.unboxToInt((Object)result._1()) < 0) {
            throw new RuntimeException("ImpurityCalculator internal error: indexOfLargestArrayElement failed");
        }
        return BoxesRunTime.unboxToInt((Object)result._1());
    }

    public static final /* synthetic */ Tuple3 $anonfun$indexOfLargestArrayElement$1(Tuple3 x0$1, double x1$1) {
        double currentValue;
        Tuple3 tuple3;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToDouble((double)x1$1));
                if (tuple2 == null) break block2;
                tuple3 = (Tuple3)tuple2._1();
                currentValue = tuple2._2$mcD$sp();
                if (tuple3 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        int maxIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
        double maxValue = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        int currentIndex = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = currentValue > maxValue ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)currentIndex), (Object)BoxesRunTime.boxToDouble((double)currentValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1))) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxIndex), (Object)BoxesRunTime.boxToDouble((double)maxValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1)));
        return tuple32;
    }

    public ImpurityCalculator(double[] stats) {
        this.stats = stats;
    }
}

